<?php
/*--------------------------------------------------------------------------------------*\
*|	Script Manager																		*|
*|	By			::	Parmeet Singh														*|
*|	Web-Site	::	http://www.phpwiz.net												*|
*|	Email		::	parmeet@phpwiz.net													*|
*|																						*|
*|	--------------------------------------------										*|
*|																						*|
*|	You are not allowed to distribute this script in any way.							*|
*|	This script is the property of Parmeet Singh.										*|
*|	You may not remove the copyright information unless you have special permission		*|
*|	from Parmeet Singh.																	*|
\*--------------------------------------------------------------------------------------*/


/*----- Start Exec_Time class */

class Exec_Time
{
	// Finds out the startime time
	function startime( ) {
		global $startime;

		$mtime 		= microtime( );
		$mtime 		= explode( " " , $mtime );
		$mtime 		= $mtime[1] + $mtime[0];
		$startime 	= $mtime;

		return $startime;
	}

	// Finds out the end time
	function endtime( ) {
		global $startime , $totaltime;

		$mtime		= microtime( );
		$mtime		= explode( " " , $mtime );
		$mtime		= $mtime[1] + $mtime[0];
		$endtime	= $mtime;
		$totaltime	= ( $endtime - $startime );
		$totaltime	= round( $totaltime , 4 );

		return $totaltime;
	}

}

/*----- End Exec_Time class */

/*----- Start Functions class */

class Functions {

	function parse( $template ,$toparse = array(),$lang_f = "" ) {
		GLOBAL $phpwiz;

		$fp       = fopen( "{$phpwiz->vars['tmpl_dir']}$template.php" , "r" );
		$contents = fread( $fp , filesize( "{$phpwiz->vars['tmpl_dir']}$template.php" ) );
		fclose( $fp );

		if($lang_f	!=	"") {
			$lang	=	$phpwiz->Func->load_lang($lang_f);

			//$contents	=	preg_replace("#{pw.lang.(.+?)}#ei","\$lang['\\1']",$contents);

			foreach($lang as $k => $v) {
				$contents	=	str_replace("{pw.lang.$k}",$v,$contents);
			}
		}

		$contents	=	str_replace("{pw.vars.img}",$phpwiz->vars['imageurl'],$contents);
		$contents	=	strtr($contents,$toparse);

		/*foreach ( $toparse as $key => $value ) {
			$contents = str_replace( $key , $value , $contents );
		}*/
		return $contents;
 	}

	function in()
	{
		global $phpwiz,$HTTP_GET_VARS,$HTTP_POST_VARS;

		if(!isset($HTTP_GET_VARS) && !isset($HTTP_POST_VARS)) {
			return "";
		}

		$REQUEST	=	array_merge($HTTP_GET_VARS,$HTTP_POST_VARS);

		if($phpwiz->vars['html'] == 1) {
			$parse	=	0;
		}
		else {
			$parse	=	1;
		}

		$in	=	array();

		foreach($REQUEST as $field => $value) {
			if($parse == 1)
			{
				$in[$field]	=	htmlspecialchars($REQUEST[$field], ENT_QUOTES);
				$in[$field]	=	stripslashes($in[$field]);
			}
			else
			{
				$in[$field]	=	$REQUEST[$field];
				$in[$field]	=	stripslashes($in[$field]);
			}

		}

		if($in["lang"] == "") {
			$in["lang"]	=	0;
		}

		if($in["skin"] == "") {
			$in["skin"]	=	0;
		}

		return $in;
	}

	function redirect($msg,$link) {
		global $phpwiz;

		$lang	=	$this->load_lang("redirects");

		echo $this->parse("redirect",array(	"{bgcolor}"	=>	$phpwiz->vars['bgcolor'],
											"{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
											"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
											"{baseurl}"	=>	$phpwiz->base_url,
											"{msg}"		=>	$lang[$msg],
											"{link}"	=>	$link),"redirects");
		exit;
	}

	function check_ext($file) {

		$ext_array		=	explode( "." , $file );
		$ex				=	$ext_array[count($ext_array) - 1];
		$ex				=	strtolower($ex);

		if($ex == "txt") {
			return true;
		}
		else {
			return false;
		}
	}

	function load_lang($lang_file) {
		global $phpwiz,$root_path;

		require($root_path . "lang/{$phpwiz->lang}/{$lang_file}.php");

		return $lang;
	}

	function dropdown($name,$a = array(),$s = "") {
		$m	=	"<select name='$name'>\n";

		if(is_array($a)) {
			foreach($a as $k => $v) {
				if($v == $s) {
					$m .= "<option value='$v' selected>$k</option>\n";
				}
				else {
					$m	.=	"<option value='$v'>$k</option>\n";
				}
			}
		}
		else {
			return false;
		}

		$m	.=	"</select>\n";

		return $m;
	}

	function server_load() {
		if(file_exists('/proc/loadavg')) {
			if($load	=	@fopen('/proc/loadavg','r')) {
				$content	=	@fread($load,6);
				@fclose($load);

				$avg	=	explode(" ", $content);

				$server_load	=	trim($avg[0]);

				return $server_load;
    		}
    		else {
				return "";
    		}
    	}
		else {
    		return "";
		}
	}

	function process_stats() {
		global $phpwiz,$root_path,$Exec;

		$phpwiz->sql->select("pw_tutorials","COUNT(sid) as mid,SUM(views) as vi","open = 1");
		$fetch	=	$phpwiz->sql->fetch();

		if($this->server_load() != "") {
			require($root_path."lang/{$phpwiz->lang}/stats.php");
			$load	=	"&nbsp;|&nbsp; {$lang['load']}: ".$phpwiz->Func->server_load()."&nbsp;";
		}
		else {
			$load	=	"";
		}

		$stats	=	$this->parse("stats",array(	"{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
												"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
												"{exec_time}"	=>	$Exec->endtime(),
												"{num_queries}"	=>	$phpwiz->sql->q_num(),
												"{tuts}"		=>	$fetch->mid,
												"{views}"		=>	$fetch->vi,
												"{load}"		=>	$load,),"stats");

		return $stats;
	}

	function build_links($data) {
		global $phpwiz;

		if(empty($data)) {
			return "";
		}

		$i		=	0;
		$links	=	"Pages({$data[1]}) :: <a href='{$phpwiz->base_url}&{$data[2]}1'>&laquo;</a>&nbsp;";

		while($i < $data[1]) {
			$i++;
			$d		=	$data[2] . $i;
			if($i == $data[3]) {
				$links	.=	"{$i} | ";
			}
			else {
				$links	.=	"<a href='{$phpwiz->base_url}&{$d}'>{$i}</a> | ";
			}
		}

		$links	.=	"<a href='{$phpwiz->base_url}&{$data[2]}{$data[1]}'>&raquo;</a>";

		return $links;
	}

}

/*----- End Functions class */

/*----- Start Print class */
class Output {
	var $output	=	"";
	var $title	=	"";
	var $nav	=	"";

	function _wrapper($content = "") {
		global $phpwiz,$Exec;

		if($this->title == "") {
			$this->title	=	$phpwiz->vars['title'];
		}

		if($this->nav == "") {
			$this->nav	=	"<a href='$phpwiz->base_url'>{$phpwiz->vars['title']}</a>";
		}

		$top	=	$phpwiz->Func->parse("top_bar",array(	"{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
															"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
															"{base_url}"	=>	$phpwiz->base_url),"misc");


		if($phpwiz->vars['add']) {
			$add	=	$phpwiz->Func->parse( "add_show" ,array("{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
																"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
																"{base_url}"	=>	$phpwiz->base_url),"misc");
		}
		else {
			$add	=	"";
		}

		$phpwiz->sql->select("pw_langs","*","open = 1","lname ASC");

		if($phpwiz->sql->count() > 0) {
			while($r = $phpwiz->sql->fetch()) {
				$lang[$r->lname]	=	$r->lid;
			}

			$langs	=	$phpwiz->Func->parse("choose",array("{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
															"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
															"{base_url}"	=>	$phpwiz->base_url,
															"{langs}"		=>	$phpwiz->Func->dropdown("lang",$lang,$phpwiz->lang)),"lang");
		}
		else {
			$langs	=	"";
		}

		$stats	=	$phpwiz->Func->process_stats();

		$echo	=	$phpwiz->Func->parse( "wrapper" , array("{css}"			=>	"default",
															"{title}"		=>	$this->title,
															"{bgcolor}"		=>	$phpwiz->vars['bgcolor'],
															"{tblwidth}"	=>	$phpwiz->vars['tbl_width'],
															"{tblbg}"		=>	$phpwiz->vars['tbl_color'],
															"{nav}"			=>	$this->nav,
															"{content}"		=>	$this->output,
															"{version}"		=>	$phpwiz->vars['version'],
															"{top_bar}"		=>	$top,
															"{add}"			=>	$add,
															"{langs}"		=>	$langs,
															"{imageurl}"	=>	$phpwiz->vars['imageurl'],
															"{stats}"		=>	$stats,));

		if( $phpwiz->vars['gzip'] == 1 ) {
			ob_start("ob_gzhandler");
		}

		echo $echo;
		exit;
	}

	function error($error = "") {
		global $phpwiz;

		$lang	=	$phpwiz->Func->load_lang("errors");

		$this->nav	=	"<a href='$phpwiz->base_url'>{$phpwiz->vars['title']}</a> -> ";

		$this->title	=	$phpwiz->vars['title'] . "- ";
		$this->output	=	$phpwiz->Func->parse( "error" , array("{error}"	=>	$lang[$error]),"misc");

		$this->_wrapper();
		die;
	}

	function out($content = "") {
		global $phpwiz;

		if(is_array($content)) {
			$this->output = $content[0];

			$this->nav	=	"<a href='$phpwiz->base_url'>{$phpwiz->vars['title']}</a>";

			if(is_array($content[1])) {
				foreach($content[1] as $k => $v) {
					$this->nav	.=	" &raquo; <a href='$phpwiz->base_url$v'>$k</a>";
				}
			}

		}
		else{
			$this->output	=	$content;
		}

		$this->_wrapper();
	}
}
/*----- End Print class */

?>