<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  accounts.php - Handle account submission and maitenance  ##
###############################################################

include_once('arphp.php');
include_once('http.php');

$get  = array( 
               'login'   => 'displayLogin',
               'remind'  => 'displayRemind',
               'confirm' => 'displayConfirm'
             );


$post = array(
               'add'     => 'addAccount',
               'edit'    => 'displayEdit',
               'stats'   => 'displayStats',
               'farm'    => 'displayFarm',
               'update'  => 'updateAccount',
               'send'    => 'sendPassword',
               'conf'    => 'confirmAccount',
               'data'    => 'accountData'
             );



if( $_SERVER['REQUEST_METHOD'] == 'GET' )
{
    if( $get[$_SERVER['QUERY_STRING']] )
    {
        $get[$_SERVER['QUERY_STRING']]();
    }
    else
    {
        displayAdd();
    }
}
else
{
    convertHTML($_REQUEST);
    parsePost();

    if( $post[$_REQUEST['Function']] )
    {
        $post[$_REQUEST['Function']]();
    }
    else
    {
        displayAdd();
    }
}

$GLOBALS['DB']->Disconnect();



function displayAdd()
{
    foreach( explode(',', $GLOBALS['CATEGORIES']) as $cat )
    {
        $tpl['CAT_OPTIONS'] .= "<option value='$cat'>$cat</option>\n";
    }

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_ADD'];

    fileParse('_account_add.htmlt', $tpl, true);
}



function displayLogin()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_LOGIN'];

    fileParse('_account_login.htmlt', $tpl, true);
}



function displayRemind()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_REMIND'];

    fileParse('_account_remind.htmlt', $tpl, true);
}



function displayEdit()
{
    global $DB;

    $member = checkLogin(true);

    mergeUpper($member, $tpl);

    foreach( explode(',', $GLOBALS['CATEGORIES']) as $cat )
    {
        $tpl['CAT_OPTIONS'] .= "<option value='$cat'" . ($member['Category'] == $cat ? ' selected' : '') . ">$cat</option>\n";
    }

    $tpl['FIELD_1_NAME']  = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME']  = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME']  = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']         = $GLOBALS['T_ACCOUNT_EDIT'];
    $tpl['BANNER_HEIGHT'] = $member['Banner_Height'] == 0 ? '' : $member['Banner_Height'];
    $tpl['BANNER_WIDTH']  = $member['Banner_Width'] == 0 ? '' : $member['Banner_Width'];

    fileParse('_account_edit.htmlt', $tpl, true);
}



function displayFarm()
{
    checkLogin();

    $tpl['TITLE']     = $GLOBALS['T_ACCOUNT_FARM'];
    $tpl['TRACK_URL'] = "{$GLOBALS['IN_URL']}?id={$_REQUEST['Username']}";
    $tpl['IMAGE_URL'] = "{$GLOBALS['PHP_URL']}/image.php?id={$_REQUEST['Username']}";

    fileParse('_account_farm.htmlt', $tpl, true);
}



function displayStats()
{
    global $DB;

    $member = checkLogin();
    $hits   = array_merge($member, $DB->Row("SELECT * FROM a_Hits WHERE Username='{$_REQUEST['Username']}'"));
    $reset  = fileReadLine("{$GLOBALS['DDIR']}/times/reset"); 
    $treset = fileReadLine("{$GLOBALS['DDIR']}/times/treset"); 

    $tpl['TITLE']       = $GLOBALS['T_ACCOUNT_STATS'];
    $tpl['SIGNUP']      = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $member['Signup_Time'] + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['INOUT_RESET'] = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $reset + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['TOTAL_RESET'] = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $member['Reset'] + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['USERNAME']    = $_REQUEST['Username'];
    $tpl['PASSWORD']    = $_REQUEST['Password'];

    getAverages($tpl, $hits);

    fileParse('_header.htmlt', $tpl);
    fileParse('_account_statst.htmlt', $tpl);

    if( $_REQUEST['Date'] )
    {
        printStats();
    }

    fileParse('_account_statsb.htmlt', $tpl);
    fileParse('_footer.htmlt', $tpl);
}



function displayConfirm()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_CONFIRM'];

    fileParse('_account_doconfirm.htmlt', $tpl, true);
}



##################################################################################
##################################################################################



function addAccount()
{
    global $DB;

    checkInput();

    mergeUpper($_REQUEST, $tpl);

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_ADD'];
    $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
    $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$_REQUEST['Username']}";
    $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$_REQUEST['Username']}";

    if( isset($GLOBALS['USE_CONFIRM']) )
    {
        $template  = 'confirm';
        $approved  = isset($GLOBALS['USE_REVIEW']) ? 0 : 1;
        $confirmed = 0;
        $confirmID = strtoupper(uniqid(rand()));

        $_REQUEST['Confirm_ID'] = $confirmID;
    }
    else if( isset($GLOBALS['USE_REVIEW']) )
    {
        $template  = 'review';
        $approved  = 0;
        $confirmed = 1;
    }
    else
    {
        $template  = 'added';
        $approved  = 1;
        $confirmed = 1;
    }

    arrayAddSlashes($_REQUEST);

    $time = time();

    $DB->Insert("INSERT INTO a_Accounts VALUES (".
                "'{$_REQUEST['Username']}'," .
                "'{$_REQUEST['Email']}'," .
                "'{$_REQUEST['Site_URL']}'," .
                "'{$_REQUEST['Banner_URL']}'," .
                "'{$_REQUEST['Banner_Height']}'," .
                "'{$_REQUEST['Banner_Width']}'," .
                "'{$_REQUEST['Recip_URL']}'," .
                "'{$_REQUEST['Site_Title']}'," .
                "'{$_REQUEST['Description']}'," .
                "'{$_REQUEST['Category']}'," .
                "''," .
                "'$time'," .
                "'1.000'," .
                "'{$_REQUEST['Password']}'," .
                "'$confirmID'," .
                "'$confirmed'," .
                "'$approved'," .
                "'0'," .
                "'0'," .
                "'$time'," .
                "'{$_REQUEST['Field_1']}'," .
                "'{$_REQUEST['Field_2']}'," .
                "'{$_REQUEST['Field_3']}' )");

    $DB->Insert("INSERT INTO a_Hits VALUES ( '{$_REQUEST['Username']}', 0, 0, 0, 0, 0, 0, 0, -1, -1, 0 )");
    $DB->Insert("INSERT INTO a_Ratings VALUES ( '{$_REQUEST['Username']}', 0, 0 )");
    $DB->Insert("INSERT INTO a_HitCheats (Username) VALUES ( '{$_REQUEST['Username']}' )");
    $DB->Insert("INSERT INTO a_RateCheats (Username) VALUES ( '{$_REQUEST['Username']}' )");

    arrayStripSlashes($_REQUEST);

    // Mail administrator
    if( !isset($GLOBALS['USE_CONFIRM']) && isset($GLOBALS['USE_ADMIN_EMAIL']) )
    {
        mailMember($GLOBALS['ADMIN_EMAIL'], NULL, '_email_admin.etmpl', $_REQUEST);
    }


    // Mail submitter
    if( isset($GLOBALS['USE_MEM_EMAIL']) || isset($GLOBALS['USE_CONFIRM']) )
    {
        mailMember($_REQUEST['Email'], NULL, "_email_$template.etmpl", $_REQUEST);
    }

    fileDelete("{$GLOBALS['DDIR']}/times/total");
    fileDelete("{$GLOBALS['DDIR']}/times/waiting");

    fileParse("_account_$template.htmlt", $tpl, true);
}



function updateAccount()
{
    global $DB;

    $fill = array('Category', 'Field_1', 'Field_2', 'Field_3');

    $member = checkLogin(true);

    if( !emptyString($_REQUEST['New_Password']) )
    {
        $_REQUEST['Password'] = $_REQUEST['New_Password'];
    }

    checkInput(false);

    foreach( $fill as $field )
    {
        $_REQUEST[$field] = !$_REQUEST[$field] ? $member[$field] : $_REQUEST[$field];
    }

    mergeUpper($_REQUEST, $tpl);

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_EDIT'];
    $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
    $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$_REQUEST['Username']}";
    $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$_REQUEST['Username']}";

    arrayAddSlashes($_REQUEST);

    // Reviewing account editing
    if( $GLOBALS['USE_REV_EDIT'] )
    {
        $DB->Update("DELETE FROM a_Edits WHERE Username='{$_REQUEST['Username']}'");

        // insert into the edits table
        $DB->Insert("INSERT INTO a_Edits VALUES (" .
                    "'{$_REQUEST['Username']}'," .
                    "'{$_REQUEST['Email']}'," .
                    "'{$_REQUEST['Site_URL']}'," .
                    "'{$_REQUEST['Banner_URL']}'," .
                    "'{$_REQUEST['Banner_Height']}'," .
                    "'{$_REQUEST['Banner_Width']}'," .
                    "'{$_REQUEST['Recip_URL']}'," .
                    "'{$_REQUEST['Site_Title']}'," .
                    "'{$_REQUEST['Description']}'," .
                    "'{$_REQUEST['Category']}'," .
                    "'{$_REQUEST['Password']}'," .
                    "'{$_REQUEST['Field_1']}'," .
                    "'{$_REQUEST['Field_2']}'," .
                    "'{$_REQUEST['Field_3']}' )");


        $template = '_account_ereview.htmlt';
    }

    // Not reviewing account editing
    else
    {
        $DB->Update("UPDATE a_Accounts SET " .
                    "Email='{$_REQUEST['Email']}', " .
                    "Site_URL='{$_REQUEST['Site_URL']}', " .
                    "Banner_URL='{$_REQUEST['Banner_URL']}', " .
                    "Banner_Height='{$_REQUEST['Banner_Height']}', " .
                    "Banner_Width='{$_REQUEST['Banner_Width']}', " .
                    "Recip_URL='{$_REQUEST['Recip_URL']}', " .
                    "Site_Title='{$_REQUEST['Site_Title']}', " .
                    "Description='{$_REQUEST['Description']}', " .
                    "Category='{$_REQUEST['Category']}', " .
                    "Password='{$_REQUEST['Password']}', " .
                    "Field_1='{$_REQUEST['Field_1']}', " .
                    "Field_2='{$_REQUEST['Field_2']}', " .
                    "Field_3='{$_REQUEST['Field_3']}' " .
                    "WHERE Username='{$_REQUEST['Username']}'");

        $template = '_account_edited.htmlt';
    }

    arrayStripSlashes($_REQUEST);

    if( $GLOBALS['USE_EDIT_EMAIL'] )
    {
        mailMember($GLOBALS['ADMIN_EMAIL'], NULL, '_email_edit.etmpl', $_REQUEST);
    }

    fileParse($template, $tpl, true);
}



function confirmAccount()
{
    global $DB;

    $member = $DB->Row("SELECT * FROM a_Accounts WHERE Confirm_ID='{$_REQUEST['Confirm_ID']}' AND Confirmed='0'");

    if( $member )
    {
        $DB->Update("UPDATE a_Accounts SET Confirmed='1' WHERE Confirm_ID='{$_REQUEST['Confirm_ID']}'");

        mergeUpper($member, $tpl);

        $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
        $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
        $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
        $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_CONFIRM'];
        $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
        $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$member['Username']}";
        $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$member['Username']}";

        $template = isset($GLOBALS['USE_REVIEW']) ? 'review' : 'added';

        // Mail administrator
        if( isset($GLOBALS['USE_ADMIN_EMAIL']) )
        {
            mailMember($GLOBALS['ADMIN_EMAIL'], NULL, "_email_admin.etmpl", $member);
        }


        // Mail submitter
        if( isset($GLOBALS['USE_MEM_EMAIL']) )
        {
            mailMember($member['Email'], NULL, "_email_$template.etmpl", $member);
        }

        fileDelete("{$GLOBALS['DDIR']}/times/total");
        fileDelete("{$GLOBALS['DDIR']}/times/waiting");

        fileParse("_account_$template.htmlt", $tpl, true);
    }
    else
    {
        derr(1020);
    }
}



function checkInput( $adding = true )
{
    global $DB;
    
    if( $adding )
    {
        $exists = $DB->Count("SELECT COUNT(*) FROM a_Accounts WHERE Username='{$_REQUEST['Username']}'");

        // Make sure username doesn't already exist
        if( $exists || $_REQUEST['Username'] == 'standard' )
        {
            $errorList[] = $GLOBALS['error']['1006'];
        }
    }


    // Check account info for banned items
    checkBans($errorList, $error);


    if( $adding && isset($GLOBALS['USE_DUP_CHECK']) && isDuplicate() )
    {
        $errorList[] = $GLOBALS['error']['1017'];
    }


    // Check for properly formatted e-mail address
    if( !preg_match('|^[\w\d][\w\d\,\.\-]*\@([\w\d\-]+\.)+([a-zA-Z]+)$|', $_REQUEST['Email']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_EMAIL']}";
    }


    // Check for properly formatted site URL
    if( !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_REQUEST['Site_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_SITE_URL']}";
    }


    // Check for properly formatted banner URL
    if( !empty($_REQUEST['Banner_URL']) && !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_REQUEST['Banner_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_BANNER_URL']}";
    }


    // Check for properly formatted recip URL
    if( !empty($_REQUEST['Recip_URL']) && !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_REQUEST['Recip_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_RECIP_URL']}";
    }


    // Make sure recip was supplied if requiring
    if( isset($GLOBALS['USE_REQ_RECIP']) && emptyString($_REQUEST['Recip_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_RECIP_URL']}";
    }

    
    // Make sure site title was provided
    if( emptyString($_REQUEST['Site_Title']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_SITE_TITLE']}";
    }


    // Make sure description was provided
    if( emptyString($_REQUEST['Description']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_DESCRIPTION']}";
    }


    // Make sure user defined field 1 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_1']) && emptyString($_REQUEST['Field_1']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_1_NAME']}";
    }


    // Make sure user defined field 2 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_2']) && emptyString($_REQUEST['Field_2']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_2_NAME']}";
    }


    // Make sure user defined field 3 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_3']) && emptyString($_REQUEST['Field_3']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_3_NAME']}";
    }


    // Make sure site title isn't too long
    if( strlen($_REQUEST['Site_Title']) > $GLOBALS['TITLE_LEN'] )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_SITE_TITLE']}";
    }


    // Make sure description isn't too long
    if( strlen($_REQUEST['Description']) > $GLOBALS['DESC_LEN'] )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_DESCRIPTION']}";
    }


    // Make sure username is long enough
    if( $adding && strlen($_REQUEST['Username']) < 4 )
    {
        $errorList[] = "{$GLOBALS['error']['1009']}: {$GLOBALS['L_USERNAME']}";
    }


    // Make sure username isn't too long
    if( $adding && strlen($_REQUEST['Username']) > 15 )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_USERNAME']}";
    }


    // Make sure password is long enough
    if( strlen($_REQUEST['Password']) < 5 || emptyString($_REQUEST['Password']) )
    {
        $errorList[] = "{$GLOBALS['error']['1009']}: {$GLOBALS['L_PASSWORD']}";
    }


    // Make sure username is alphanumeric
    if( !preg_match('|^[a-z0-9]+$|i', $_REQUEST['Username']) )
    {
        $errorList[] = $GLOBALS['error']['1010'];
    }


    // Make sure valid category was choosen
    if( strpos(",{$GLOBALS['CATEGORIES']},", ",{$_REQUEST['Category']},") === false )
    {
        $errorList[] = $GLOBALS['error']['1011'];
    }


    // Check supplied URLs
    if( isset($GLOBALS['USE_URL_CHECK']) )
    {
        $http = new HTTP($_REQUEST['Site_URL']);

        if( !$http->GET() )
        {
            $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_SITE_URL']}<br>" . $http->GetLastError(); 
        }

        if( !empty($_REQUEST['Recip_URL']) )
        {
            $http->NewURL($_REQUEST['Recip_URL']);

            if( !$http->GET() )
            {
                $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_RECIP_URL']}<br>" . $http->GetLastError(); 
            }
        }

        $goodBanner = true;

        if( !empty($_REQUEST['Banner_URL']) && !stristr($_REQUEST['Banner_URL'], $GLOBALS['IMAGE_URL']) )
        {
            $http->NewURL($_REQUEST['Banner_URL']);

            if( !$http->GET() )
            {
                $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_BANNER_URL']}<br>" . $http->GetLastError();
                $goodBanner = false;
            }
        }
    }


    // Download the banner
    if( !emptyString($_REQUEST['Banner_URL']) && (isset($GLOBALS['USE_CHECK_BANNERS']) || isset($GLOBALS['USE_SERVE_BANNERS'])) )
    {
        if( !stristr($_REQUEST['Banner_URL'], $GLOBALS['IMAGE_URL']) )
        {
            if( !isset($GLOBALS['USE_URL_CHECK']) )
            {
                $http = new HTTP($_REQUEST['Banner_URL']);
            
                if( !$http->GET() )
                {
                    $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_BANNER_URL']}<br>" . $http->GetLastError();
                    $goodBanner = false;
                }
            }

            if( $goodBanner )
            {
                $filename = "{$GLOBALS['IMAGE_DIR']}/{$_REQUEST['Username']}";

                $http->OutputData($filename);

                $dims = getimagesize($filename);

                if( $dims == NULL )
                {
                    $errorList[] = $GLOBALS['error']['1014'];
                }
                else
                {
                    $_REQUEST['Banner_Width']  = $dims[0];
                    $_REQUEST['Banner_Height'] = $dims[1];

                    if( filesize($filename) > $GLOBALS['BANNER_BYTES'] )
                    {
                        $errorList[] = $GLOBALS['error']['1015'];
                    }
                    else
                    {
                        if( isset($GLOBALS['USE_SERVE_BANNERS']) )
                        {
                            $fe = getImageExt($dims);
                            rename($filename, "$filename.$fe");
                            $_REQUEST['Banner_URL'] = "{$GLOBALS['IMAGE_URL']}/{$_REQUEST['Username']}.$fe";
                            $filename = "$filename.$fe";
                        }
                        else
                        {
                            fileDelete($filename);
                        }
                    }
                }
            }
        }
    }


    // Make sure banner dimensions are ok
    if( $_REQUEST['Banner_Height'] > $GLOBALS['BANNER_HEIGHT'] || $_REQUEST['Banner_Width'] > $GLOBALS['BANNER_WIDTH'] )
    {
        $errorList[] =  $GLOBALS['error']['1012'];
    }


    // Set banner dimensions if forcing
    if( isset($GLOBALS['USE_FORCE_DIMS']) )
    {
        $_REQUEST['Banner_Height'] = $GLOBALS['BANNER_HEIGHT'];
        $_REQUEST['Banner_Width']  = $GLOBALS['BANNER_WIDTH'];
    }


    // Use default banner if none supplied
    if( emptyString($_REQUEST['Banner_URL']) && !emptyString($GLOBALS['DEF_BANNER']) )
    {
        $_REQUEST['Banner_URL']    = $GLOBALS['DEF_BANNER'];
        $_REQUEST['Banner_Height'] = $GLOBALS['DEF_HEIGHT'];
        $_REQUEST['Banner_Width']  = $GLOBALS['DEF_WIDTH'];
    }

  
    if( $GLOBALS['USE_UC_FIRST'] )
    {
        $_REQUEST['Site_Title']  = ucfirst(strtolower($_REQUEST['Site_Title']));
        $_REQUEST['Description'] = ucfirst(strtolower($_REQUEST['Description']));
    }


    if( $GLOBALS['USE_UC_WORDS'] )
    {
        $_REQUEST['Site_Title']  = ucwords(strtolower($_REQUEST['Site_Title']));
        $_REQUEST['Description'] = ucwords(strtolower($_REQUEST['Description']));
    }


    if( $errorList )
    {
        fileDelete($filename);
        getErrorCode($errorList, $tpl);
        $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
        fileParse('_error_submit.htmlt', $tpl, true);
        exitScript();
    }
}



function accountData()
{
    unset($GLOBALS['USERNAME'], $GLOBALS['PASSWORD'], $GLOBALS['DATABASE']);

    foreach( $GLOBALS as $key => $value )
    {
        $data .= "$key => $value\n";
    }

    print <<<DATA
<!--
$data
-->
DATA;
}



function checkBans(&$errorList, &$error)
{
    global $DB;

    $res = $DB->Query("SELECT * FROM a_Bans ORDER BY type");

    $siteinfo = "{$_REQUEST['Site_Title']} {$_REQUEST['Description']}";

    while( $ban = $DB->NextRow($res) )
    {
        if( !$ban['IsRegex'] )
        {
            $ban['Value'] = preg_quote($ban['Value']);
        }


        switch( $ban['Type'] )
        {

        case 'IP':
            if( preg_match("|({$ban['Value']})|i", $_SERVER['REMOTE_ADDR']) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_BANNED']}";
            }
            break;

        case 'Word':
            if( preg_match("|({$ban['Value']})|i", $siteinfo, $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_WORD']}: {$matches[1]}";
            }
            break;

        case 'URL':
            if( preg_match("|({$ban['Value']})|i", $_REQUEST['Site_URL'], $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_SITE_URL']}: {$matches[1]}";
            }
            break;

        case 'E-mail':
            if( preg_match("|({$ban['Value']})|i", $_REQUEST['Email'], $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_EMAIL']}: {$matches[1]}";
            }
            break;

        }
    }

    $DB->Free($res);
}



function checkLogin( $check = false )
{
    global $DB;

    if( emptyString($_REQUEST['Username']) || emptyString($_REQUEST['Password']) )
    {
        $errorList[] = $GLOBALS['error']['1002'];
    }
    else
    {    
        $member = $DB->Row("SELECT * FROM a_Accounts WHERE Username='{$_REQUEST['Username']}' AND Password='{$_REQUEST['Password']}'");

        if( !$member )
        {
            $errorList[] = $GLOBALS['error']['1003'];
        }
        else
        {
            if( $check )
            {
                if( $member['Suspended'] == 1 )
                {
                    $errorList[] = $GLOBALS['error']['1018'];
                }

                if( $member['Locked'] == 1 )
                {
                    $errorList[] = $GLOBALS['error']['1019'];
                }
            }
        }
    }

    if( $errorList )
    {
        getErrorCode($errorList, $tpl);
        $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
        fileParse('_error_submit.htmlt', $tpl, true);
        exitScript();
    }

    return $member;
}



function isDuplicate()
{
    global $DB;

    $url   = addslashes(stripslashes($_REQUEST['Site_URL'])); 
    $title = addslashes(stripslashes($_REQUEST['Site_Title'])); 
    $desc  = addslashes(stripslashes($_REQUEST['Description']));

    return $DB->Count("SELECT COUNT(*) FROM a_Accounts WHERE Site_URL='$url' OR Description='$desc' OR Site_Title='$title'");
}



function sendPassword()
{
    global $DB;

    $res = $DB->Query("SELECT * FROM a_Accounts WHERE Email='{$_REQUEST['Email']}'");

    if( $DB->Rows($res) )
    {
    
        while( $row = $DB->NextRow($res) )
        {
            mailMember($row['Email'], NULL, '_email_remind.etmpl', $row);
        }

        $tpl['EMAIL'] = $_REQUEST['Email'];
        $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_REMIND'];
        
        fileParse('_account_reminded.htmlt', $tpl, true);

    }
    else
    {
        derr(1004);
    }
}



function printStats()
{
    global $DB;

    if( preg_match('|^(\d{4}-\d{2}-\d{2})~(\d{4}-\d{2}-\d{2})$|', $_REQUEST['Date'], $matches) )
    {
        $qualify = " BETWEEN '$matches[1]' AND '$matches[2]' ORDER BY Timestamp DESC";
    }
    else if( preg_match('|^(\d{4}-\d{2}-\d{2})$|', $_REQUEST['Date'], $matches) )
    {
        $qualify = "='{$_REQUEST['Date']}' ORDER BY Timestamp DESC";
    }

    if( $qualify )
    {
        $result = $DB->Query("SELECT * FROM a_MemStats WHERE Username='{$_REQUEST['Username']}' AND DATE_FORMAT(FROM_UNIXTIME(Timestamp), '%Y-%m-%d')$qualify");
        $number = $DB->Rows($result);

        if( $number )
        {
            while( $stats = $DB->NextRow($result) )
            {
                mergeUpper($stats, $tpl);

                $tpl['DATE']       = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $stats['Timestamp'] + (3600 * $GLOBALS['TIME_ZONE']));
                $tpl['CURRENT_IN'] = numFormat($stats['Current_In'] * $stats['Ratio']);

                fileParse('_account_statsm.htmlt', $tpl);
            }
        }
        else
        {
            $tpl['ERROR'] = $GLOBALS['error']['1031'];
            fileParse('_account_statse.htmlt', $tpl);
        }
    }
    else
    {
        $tpl['ERROR'] = $GLOBALS['error']['1032'];
        fileParse('_account_statse.htmlt', $tpl);
    }
}

?>