<?PHP


$table['a_Accounts'] =   'CREATE TABLE a_Accounts (' .
                         'Username        CHAR(16)    NOT NULL,' .
                         'Email           CHAR(128)   NOT NULL,' .
                         'Site_URL        CHAR(255)   NOT NULL,' .
                         'Banner_URL      CHAR(255)   NOT NULL,' .
                         'Banner_Height   INT,' .
                         'Banner_Width    INT,' .
                         'Recip_URL       CHAR(255)   NOT NULL,' .
                         'Site_Title      CHAR(255)   NOT NULL,' .
                         'Description     CHAR(255)   NOT NULL,' .
                         'Category        CHAR(128)   NOT NULL,' .
                         'Icons           CHAR(128)   NOT NULL,' .
                         'Signup_Time     INT         NOT NULL,' .
                         'Ratio           FLOAT       NOT NULL,' .
                         'Password        CHAR(32)    NOT NULL,' .
                         'Confirm_ID      CHAR(64)    NOT NULL,' .
                         'Confirmed       CHAR(1)     NOT NULL   DEFAULT "1",' .
                         'Approved        CHAR(1)     NOT NULL   DEFAULT "1",' .
                         'Suspended       CHAR(1)     NOT NULL   DEFAULT "0",' .
                         'Locked          CHAR(1)     NOT NULL   DEFAULT "0",' .
                         'Reset           INT         NOT NULL,' .
                         'Field_1         CHAR(255)   NOT NULL,' .
                         'Field_2         CHAR(255)   NOT NULL,' .
                         'Field_3         CHAR(255)   NOT NULL,' .
                         'PRIMARY KEY ( Username ),' .
                         'INDEX ( Category ),' .
                         'INDEX ( Confirm_ID ) )';



$table['a_AdminStats'] = 'CREATE TABLE a_AdminStats (' .
                         'Timestamp   INT      NOT NULL,' .
                         'Period      INT      NOT NULL,' .
                         'Period_In   BIGINT   NOT NULL,' .
                         'Period_Out  BIGINT   NOT NULL,' .
                         'Active      INT      NOT NULL,' .
                         'Top_Ranked  CHAR(16) NOT NULL,' .
                         'PRIMARY KEY ( Timestamp ) )';



$table['a_BannedIPs'] =  'CREATE TABLE a_BannedIPs (' .
                         'IP_Address   CHAR(16)   NOT NULL,' .
                         'PRIMARY KEY( IP_Address ) )';



$table['a_Bans'] =       'CREATE TABLE a_Bans (' . 
                         'Type    CHAR(12)   NOT NULL,' .
                         'Value   CHAR(255)  NOT NULL,' .
                         'IsRegex CHAR(1)    NOT NULL  DEFAULT "0",' .
                         'PRIMARY KEY ( Type, Value ) )';



$table['a_Comments'] =   'CREATE TABLE a_Comments (' .
                         'ID        INT       NOT NULL   AUTO_INCREMENT,' .
                         'Username  CHAR(16)  NOT NULL,' .
                         'Timestamp INT       NOT NULL,' .
                         'IP        CHAR(32)  NOT NULL,' .
                         'Email     CHAR(128) NOT NULL,' .
                         'Name      CHAR(128) NOT NULL,' .
                         'Rating    INT       NOT NULL,' .
                         'Comment   TEXT      NOT NULL,' .
                         'PRIMARY KEY ( ID, Username ) )';



$table['a_Hits'] =       'CREATE TABLE a_Hits (' .
                         'Username       CHAR(16)   NOT NULL,' .
                         'Current_In     BIGINT     NOT NULL,' .
                         'Current_Out    BIGINT     NOT NULL,' .
                         'Total_In       BIGINT     NOT NULL,' .
                         'Total_Out      BIGINT     NOT NULL,' .
                         'Prev_In        BIGINT     NOT NULL,' .
                         'Prev_Out       BIGINT     NOT NULL,' .
                         'Prev_Sort      FLOAT      NOT NULL,' .
                         'Prev_ORank     INT        NOT NULL,' .
                         'Prev_CRank     INT        NOT NULL,' .
                         'Inactive       INT        NOT NULL,' .
                         'PRIMARY KEY ( Username ) )';



$table['a_Edits'] =      'CREATE TABLE a_Edits (' .
                         'Username        CHAR(16)    NOT NULL,' .
                         'Email           CHAR(128)   NOT NULL,' .
                         'Site_URL        CHAR(255)   NOT NULL,' .
                         'Banner_URL      CHAR(255)   NOT NULL,' .
                         'Banner_Height   INT,' .
                         'Banner_Width    INT,' .
                         'Recip_URL       CHAR(255)   NOT NULL,' .
                         'Site_Title      CHAR(255)   NOT NULL,' .
                         'Description     CHAR(255)   NOT NULL,' .
                         'Category        CHAR(128)   NOT NULL,' .
                         'Password        CHAR(32)    NOT NULL,' .
                         'Field_1         CHAR(255)   NOT NULL,' .
                         'Field_2         CHAR(255)   NOT NULL,' .
                         'Field_3         CHAR(255)   NOT NULL,' .
                         'PRIMARY KEY ( Username ) )';



$table['a_Ranks'] =      'CREATE TABLE a_Ranks  (' .
                         'Username       CHAR(16)    NOT NULL,' .
                         'Overall_Rank   INT         NOT NULL,' .
                         'Category_Rank  INT         NOT NULL  AUTO_INCREMENT,' .
                         'Sort_Value     FLOAT       NOT NULL,' .
                         'Current_In     BIGINT      NOT NULL,' .
                         'Current_Out    BIGINT      NOT NULL,' .
                         'Total_In       BIGINT      NOT NULL,' .
                         'Total_Out      BIGINT      NOT NULL,' .
                         'Prev_In        BIGINT      NOT NULL,' .
                         'Prev_Out       BIGINT      NOT NULL,' .
                         'Prev_Sort      FLOAT       NOT NULL,' .
                         'Prev_ORank     INT         NOT NULL,' .
                         'Prev_CRank     INT         NOT NULL,' .
                         'Inactive       INT         NOT NULL,' .
                         'Num_Ratings    BIGINT      NOT NULL,' .
                         'Rating_Total   BIGINT      NOT NULL,' .
                         'Site_URL       CHAR(255)   NOT NULL,' .
                         'Banner_URL     CHAR(255)   NOT NULL,' .
                         'Banner_Height  INT,' .
                         'Banner_Width   INT,' .
                         'Site_Title     CHAR(255)   NOT NULL,' .
                         'Description    CHAR(255)   NOT NULL,' .
                         'Category       CHAR(128)   NOT NULL,' .
                         'Icons          CHAR(128)   NOT NULL,' .
                         'Signup_Time    INT         NOT NULL,' .
                         'Ratio          FLOAT       NOT NULL,' .
                         'Reset          INT         NOT NULL,' .
                         'Field_1        CHAR(255)   NOT NULL,' .
                         'Field_2        CHAR(255)   NOT NULL,' .
                         'Field_3        CHAR(255)   NOT NULL,' .
                         'PRIMARY KEY( Category, Category_Rank ),' .
                         'UNIQUE INDEX ( Overall_Rank ),' .
                         'UNIQUE INDEX ( Username ) )';



$table['a_QuickRanks'] = 'CREATE TABLE a_QuickRanks (' .
                         'Username       CHAR(16)  NOT NULL,' .
                         'Overall_Rank   INT       NOT NULL,' .
                         'Category_Rank  INT       NOT NULL,' .
                         'PRIMARY KEY( Username ) )';



$table['a_Ratings'] =    'CREATE TABLE a_Ratings (' .
                         'Username      CHAR(16)    NOT NULL,' .
                         'Num_Ratings   BIGINT      NOT NULL,' .
                         'Rating_Total  BIGINT      NOT NULL,' .
                         'PRIMARY KEY ( Username ) ) ';



$table['a_HitIPs'] =     'CREATE TABLE a_HitIPs (' .
                         'Username     CHAR(16)  NOT NULL,' .
                         'IP_Address   CHAR(16)  NOT NULL,' .
                         'PRIMARY KEY ( Username, IP_Address ) )';



$table['a_RateIPs'] =    'CREATE TABLE a_RateIPs (' .
                         'Username     CHAR(16)  NOT NULL,' . 
                         'IP_Address   CHAR(16)  NOT NULL,' .
                         'PRIMARY KEY ( Username, IP_Address ) )';



$table['a_HitCheats'] =  'CREATE TABLE a_HitCheats (' .
                         'Username    CHAR(16)   NOT NULL,' .
                         'IP_Address  INT        NOT NULL  DEFAULT "0",' .
                         'Cookie      INT        NOT NULL  DEFAULT "0",' .
                         'Bad_Session INT        NOT NULL  DEFAULT "0",' .
                         'Exp_Session INT        NOT NULL  DEFAULT "0",' .
                         'Proxy       INT        NOT NULL  DEFAULT "0",' .
                         'Referrer    INT        NOT NULL  DEFAULT "0",' .
                         'Browser     INT        NOT NULL  DEFAULT "0",' .
                         'Banned_IP   INT        NOT NULL  DEFAULT "0",' .
                         'PRIMARY KEY ( Username ) )';



$table['a_RateCheats'] = 'CREATE TABLE a_RateCheats (' .
                         'Username   CHAR(16)   NOT NULL,' .
                         'IP_Address INT        NOT NULL  DEFAULT "0",' .
                         'Cookie     INT        NOT NULL  DEFAULT "0",' .
                         'Session    INT        NOT NULL  DEFAULT "0",' .
                         'Proxy      INT        NOT NULL  DEFAULT "0",' .
                         'Referrer   INT        NOT NULL  DEFAULT "0",' .
                         'Browser    INT        NOT NULL  DEFAULT "0",' .
                         'No_Cookies INT        NOT NULL  DEFAULT "0",' .
                         'Banned_IP  INT        NOT NULL  DEFAULT "0",' .
                         'PRIMARY KEY ( Username ) )';



$table['a_MemStats'] =   'CREATE TABLE a_MemStats (' .
                         'Username       CHAR(16)   NOT NULL,' .
                         'Timestamp      INT        NOT NULL,' .
                         'Current_In     BIGINT     NOT NULL,' .
                         'Current_Out    BIGINT     NOT NULL,' .
                         'Total_In       BIGINT     NOT NULL,' .
                         'Total_Out      BIGINT     NOT NULL,' .
                         'Overall_Rank   INT        NOT NULL,' .
                         'Category_Rank  INT        NOT NULL,' .
                         'Ratio          FLOAT      NOT NULL,' .
                         'PRIMARY KEY ( Username, Timestamp ) )';

$table['a_Sessions'] =   'CREATE TABLE a_Sessions (' .
                         'Session CHAR(32) NOT NULL,' .
                         'PRIMARY KEY ( Session ) )';
?>