<?

/***************************************************************************
 freeForum @soft.ZoneO.net
 Copyright (C) 2005-2007 ZoneO-soft, Butchu (email butchu with domain zoneo.net)
 with significant contributions from C. Iancu (iancu_ctin with domain yahoo.com)

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/
 
///////////////////////////////////////////////////////////////////////////
// Function: buildpagelist
// Description: Builds a list of pages with link to pages other that the current one
// Parameters:
//      $link: the link to add the page number to
//      $page: current page
//      $npages: number of pages
///////////////////////////////////////////////////////////////////////////
function buildpagelist($url, $page, $npages) {
$str = " ";
for ($i=1;$i<=min(3,$npages);$i++) {
	if ($page == $i) {
		$str .= "<strong>$i</strong> ";
	} else {
		$str .= "<a href=\"${url}$i\" class=\"basic\">$i</a> ";
	}
}
if ($page > 7) $str .= " ... ";
for ($i=max(4,$page-2);$i<=min($npages,$page+2);$i++) {
	if ($page == $i) {
		$str .= "<strong>$i</strong> ";
	} else {
		$str .= "<a href=\"${url}$i\" class=\"basic\">$i</a> ";
	}
}
if ($page < $npages -6) $str .= " ... ";
for ($i=max(($npages-2),$page+4);$i<=$npages;$i++) {
	if ($page == $i) {
		$str .= "<strong>$i</strong> ";
	} else {
		$str .= "<a href=\"${url}$i\" class=\"basic\">$i</a> ";
	}
}
return $str;
}

///////////////////////////////////////////////////////////////////////////
// Function: echoerror
// Description: Displays an error message
// Parameters:
//      $error: the message
///////////////////////////////////////////////////////////////////////////
function echoerror($error) {
global $template;
$output = str_replace("{errormessage}", $error, $template['error']);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: abouttext
// Description: Displays the about message
// Parameters:
///////////////////////////////////////////////////////////////////////////
function abouttext() {
global $thispage;
global $admin;
global $template;
echo operations("$thispage",'about');
echo $template['about'];
}

///////////////////////////////////////////////////////////////////////////
// Function: editform
// Description: Displays the form to edit a post
// Parameters:
//      id: post id
// 11/2005: added a replacement to keep the category id in navigation
///////////////////////////////////////////////////////////////////////////
function editform($id) {
global $thispage;
global $admin;
global $template;
global $cat;
// Only admin can do that
if (!$admin) return;
// Get info about the message
$message = getthreadinfo ($id);
$subject = $message['subject'];
$name = $message['author'];
$email = $message['email'];
$text = stripslashes($message['message']);
$time = $message['started'];
$thiscat = $message['category'];
$categorylist = categorylist();
$catname = $categorylist[$thiscat];
// Get category form, we will only use it if we have a top message (parent=-1)
$formcategories = formcategories($thiscat,0,$admin,0);
// Form
if ($message['parent'] != -1) {
	echo operations("$thispage",'editpost',$message['parent']);
	$parentthread = $message['parent'];
} else {
	echo operations("$thispage",'editpost',$id);
	$parentthread = $id;
}
$output = str_replace("{linkthispage}", "$thispage", $template['edit_post']);
$output = str_replace("{name}", replace_comment("entryform",$name), $output);
$output = str_replace("{email}", replace_comment("entryform",$email), $output);
$output = str_replace("{time}", $time, $output);
$output = str_replace("{subject}", replace_comment("entryform",$subject), $output);
if ($message['parent'] == -1) {
	$output = str_replace("{categoryform}", $formcategories, $output);
} else {
	$catname = "<input type='hidden' name='cat' value='{cat}'> $catname";
	$output = str_replace("{categoryform}", $catname, $output);
	$output = str_replace("{cat}", $cat, $output);
}
$output = str_replace("{posttext}", replace_comment("edit",$text,0), $output);
$output = str_replace("{postid}", $id, $output);
$output = str_replace("{fullthreadtxt}", threadforpost($parentthread), $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: threadforpost
// Description: Returns a thread, without any link to display within an answer
//    form
// Argument: threadid
// Created: 02/2007
///////////////////////////////////////////////////////////////////////////
function threadforpost($thread) {
global $thispage;
global $admin;
global $template;
global $cat;
$threadinfo = getthreadinfo($thread);
$threadcomments = getthreadcomments($thread);
$commenttext = messageTextNoLink($thread, $threadinfo['author'], $threadinfo['subject'], $threadinfo['started'], $threadinfo['message']);
foreach($threadcomments  as $comment) {
	$commenttext .= messageTextNoLink($comment['id'], $comment['author'], $comment['subject'], $comment['started'], $comment['message']);
}
return $commenttext;
}


///////////////////////////////////////////////////////////////////////////
// Arguments: subject, author, email, text, parent post, 
//     preview: 1 if you want a preview, 0 otherwise
//     quote: if you want to include a quote from a previous message, send
//            the message ID, 0 otherwise
//     error: error message. If needed
// 11/2005: added a replacement to keep the category id
///////////////////////////////////////////////////////////////////////////
function answerform($subject,$name,$email,$text,$parent,$preview,$quote,$error="") {
global $thispage;
global $template;
global $cat;
if (get_magic_quotes_gpc()) {
	$name = stripslashes($name);
	$subject = stripslashes($subject);
	$email = stripslashes($email);
	$text = stripslashes($text);
}
$name = replace_comment("entryform",replace_comment("add",$name,false));
$subject = replace_comment("entryform",replace_comment("add",$subject,false));
$email = replace_comment("entryform",replace_comment("add",$email,false));
// Headings
echo operations("$thispage",'newcomment',$parent);
// Error
if ($error != "") {
	echo "<div class=\"warning\">$error</div>\n";
}
// Pulling out info
$threadinfo = getthreadinfo($parent);
if ($subject == "") $subject = "Re: ".$threadinfo['subject'];
// Preview
if ($preview==1) {
	echo $template['preview_head'];
	$output = str_replace("{messagename}", "", $template['message']);
	$output = str_replace("{subject}", $subject, $output);
	$output = str_replace("{author}",  $name, $output);
	$output = str_replace("{message}", replace_comment("show", replace_comment("add",$text,true)), $output);
	$output = str_replace("{date}", date("m/d/Y g:ia"), $output);
	$output = str_replace("{foot}", "", $output);
	$output = str_replace("{links}", "", $output);
	echo $output;
}
// Actual post edit
if ($quote != 0) {
	$quoteinfo = getthreadinfo($quote);
	$text = "[quote=".replace_comment("edit",$quoteinfo['author'])."]".replace_comment("edit", stripslashes($quoteinfo['message']),false)."[/quote]".$text;
}
$output = str_replace("{linkthispage}", "$thispage", $template['new_post']);
$output = str_replace("{threadauthor}", replace_comment("entryform",$threadinfo['author']), $output);
$output = str_replace("{threadsubject}", replace_comment("entryform",$threadinfo['subject']), $output);
$output = str_replace("{threadstartdate}", date("m/d/Y g:ia",$threadinfo['started']), $output);
$output = str_replace("{parent}", $parent, $output);
$output = str_replace("{cat}", $cat, $output);
$output = str_replace("{name}", $name, $output);
$output = str_replace("{email}", $email, $output);
$output = str_replace("{subject}", $subject, $output);
$output = str_replace("{posttext}", $text, $output);
$output = str_replace("{fullthreadtxt}", threadforpost($parent), $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: threadform
// Description: Form to add a new thread
// Arguments: subject, author, email, text, category, 
//     preview: 1 if you want a preview, 0 otherwise
//     error: error message. If needed
///////////////////////////////////////////////////////////////////////////
function threadform($subject,$name,$email,$text,$cat,$preview,$error = "") {
global $thispage;
global $admin;
global $template;
if (get_magic_quotes_gpc()) {
	$name = stripslashes($name);
	$subject = stripslashes($subject);
	$email = stripslashes($email);
	$text = stripslashes($text);
}
$name = replace_comment("entryform",replace_comment("add",$name,false));
$subject = replace_comment("entryform",replace_comment("add",$subject,false));
$email = replace_comment("entryform",replace_comment("add",$email,false));
// Heading 
echo operations("$thispage",'newthread');
// Error
if ($error != "") {
	echo "<div class=\"warning\">$error</div>\n";
}
// Preview
if ($preview==1) {
	echo $template['preview_head'];
	$output = str_replace("{messagename}", "", $template['message']);
	$output = str_replace("{subject}", $subject, $output);
	$output = str_replace("{author}", $name, $output);
	$output = str_replace("{message}", replace_comment("show", replace_comment("add",$text,true)), $output);
	$output = str_replace("{date}", date("m/d/Y g:ia"), $output);
	$output = str_replace("{foot}", "", $output);
	$output = str_replace("{links}", "", $output);
	echo $output;
}
// Actual form
$output = str_replace("{linkthispage}", "$thispage", $template['new_thread']);
$output = str_replace("{name}", $name, $output);
$output = str_replace("{email}", $email, $output);
$output = str_replace("{subject}", $subject, $output);
$output = str_replace("{formcategories}", formcategories($cat,0,$admin,0), $output);
$output = str_replace("{posttext}", $text, $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: login
// Description: Form to login
// Arguments: username, password, error (if there is one)
// Created: 02/2006, by Constantin Iancu
// Changed 03/2007: added the error parameter
///////////////////////////////////////////////////////////////////////////
function login($username,$password,$error="") {
global $thispage;
global $admin;
global $template;
// Heading 
echo operations("$thispage",'adminarea');
// Error
if ($error != "") {
	echo "<div class=\"warning\">$error</div>\n";
}
// Display login form
echo $template['admin-mode'];
$output = str_replace("{linkthispage}", "$thispage", $template['login']);
echo $output;
// Actual form
}

///////////////////////////////////////////////////////////////////////////
// Function: echolatestthread
// Description: returns the latest thread, for inclusion somewhere else on the site
// Argument: 
//     - $forumURL: URL of the forum 
// Created 01/2006
///////////////////////////////////////////////////////////////////////////
function echolatestthread($forumURL) {
global $template;

$thread = getlatestthread();
$output = $template['latest_thread'];
$output = str_replace("{threadlink}", "${forumURL}?mode=thread&amp;thread=".$thread['id'], $output);
$output = str_replace("{subject}", replace_comment("entryform",$thread['subject']), $output);
$output = str_replace("{author}", replace_comment("entryform",$thread['author']), $output);
$output = str_replace("{date}", date("m/d/Y g:ia",$thread['started']), $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: echolatestpost
// Description: returns the latest post, for inclusion somewhere else on the site
// Argument: 
//     - $forumURL: URL of the forum 
// Created 01/2006
///////////////////////////////////////////////////////////////////////////
function echolatestpost($forumURL) {
global $template;

$thread = getlatestpost();
$output = $template['latest_post'];
$output = str_replace("{postlink}", "${forumURL}?mode=thread&amp;thread=".$thread['thread']."#".$thread['id'], $output);
$output = str_replace("{subject}", replace_comment("entryform",$thread['subject']), $output);
$output = str_replace("{author}", replace_comment("entryform",$thread['author']), $output);
$output = str_replace("{date}", date("m/d/Y g:ia",$thread['date']), $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: echothreadlist
// Description: List all available threads
// Argument: category, page number
// 11/2005: include category in link to display thread
// 11/2005: you can add a central note (text between the navigation and the thread list)
// 02/2006: replacement of {linkadmin} for new template
///////////////////////////////////////////////////////////////////////////
function echothreadlist($cat, $sort, $page=1) {
global $thispage;
global $admin;
global $template;
global $centralnote;

// Get the list of thread, big array with, for each thread: title, first post date, author, nanswers, last answer date, last answer name
$threadlist = getthreadlist ($page,$cat,$sort);
$npages = getnpagesthread($cat);
$formcategories = formcategories($cat,1,1,1);
$categories = categorylist();
// Headings
echo operations("$thispage",'threadlist');
// Building list of threads
$even = 0;
$nthread=0;
$echolist = "";
foreach($threadlist  as $thread) {
	$nthread += 1;
	if ($nthread%2 == 1) {
		$output = $template['thread_even'];
	} else {
		$output = $template['thread_odd'];
	}
	$output = str_replace("{threadlink}", "${thispage}mode=thread&amp;cat=$cat&amp;thread=".$thread['id'], $output);
	$output = str_replace("{subject}", replace_comment("entryform",$thread['subject']), $output);
	$output = str_replace("{categoryname}", $categories[$thread['category']], $output);
	$output = str_replace("{nposts}", $thread['nposts'], $output);
	$output = str_replace("{author}", replace_comment("entryform",$thread['author']), $output);
	$output = str_replace("{startdate}", date("m/d/Y g:ia",$thread['started']), $output);
	$output = str_replace("{lastpostauthor}", replace_comment("entryform",$thread['lastpostauthor']), $output);
	$output = str_replace("{lastpostdate}", date("m/d/Y g:ia",$thread['lastpost']), $output);
	$echolist .= $output;
}
if ($nthread==0) { $echolist = $template['thread_none'];}
// Building a page list
$pagelist = buildpagelist("${thispage}sort=$sort&amp;page=", $page, $npages);
// Actual output
$output = $template['thread_list'];
$output = str_replace("{page}", $page, $output);
$output = str_replace("{npages}", $npages, $output);
$output = str_replace("{pagelist}", $pagelist, $output);
$output = str_replace("{centralnote}", $centralnote, $output);
$output = str_replace("{nthread}", getnthreads($cat), $output);
$output = str_replace("{npost}", getnmessages($cat), $output);
$last = lastpostinfoall();
$output = str_replace("{lastpostauthor}", replace_comment("entryform",$last['author']), $output);
$output = str_replace("{lastpostdate}", date("m/d/Y g:ia",$last['date']), $output);
$output = str_replace("{latestthreadlink}", "${thispage}sort=thread&amp;cat=$cat", $output);
$output = str_replace("{latestpostlink}", "${thispage}sort=post&amp;cat=$cat", $output);
$output = str_replace("{npostlink}", "${thispage}sort=nposts&amp;cat=$cat", $output);
$output = str_replace("{formcategories}", formcategories($cat,1,1,1), $output);
$output = str_replace("{forumtable}", $echolist, $output);
$output = str_replace("{linkadmin}", "${thispage}mode=adminarea", $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function messageText
///////////////////////////////////////////////////////////////////////////
function messageText($id, $author, $subject, $time, $text, $thread, $email, $ip) {
global $thispage;
global $admin;
global $demo;
global $notindemomodejs;
global $template;
global $cat;

$output = $template['message'];
$foot = $template['links_message'];
$output = str_replace("{messagename}", $id, $output);
$output = str_replace("{author}", replace_comment("entryform",$author), $output);
$output = str_replace("{subject}", replace_comment("entryform",$subject), $output);
$output = str_replace("{date}", date("m/d/Y g:ia",$time), $output);
$output = str_replace("{message}", replace_comment("show", $text, false), $output);
$foot = str_replace("{replythreadlink}","${thispage}mode=answer&amp;cat=$cat&amp;thread=$thread", $foot);
$foot = str_replace("{quotelink}","${thispage}mode=answer&amp;cat=$cat&amp;thread=$thread&amp;quote=$id", $foot);
if (($admin) && (!$demo)) {
	$output = str_replace("{email}", $email, $output);
	$output = str_replace("{ip}", $ip, $output);
	$output = str_replace("{ipbanlink}","${thispage}mode=banip&amp;ip=$ip", $output);
	$foot = str_replace("{editlink}","${thispage}mode=edit&amp;cat=$cat&amp;thread=$thread&amp;quote=$id", $foot);
	$foot = str_replace("{deletelink}","${thispage}mode=delete&amp;cat=$cat&amp;thread=$thread&amp;quote=$id", $foot);
} elseif (($admin) && ($demo)) {
	$output = str_replace("{ipbanlink}","javascript:alert('$notindemomodejs')", $output);
	$foot = str_replace("{editlink}","javascript:alert('$notindemomodejs')", $foot);
	$foot = str_replace("{deletelink}","javascript:alert('$notindemomodejs')", $foot);
}
$output = str_replace("{foot}", $foot, $output);
return $output;
}

///////////////////////////////////////////////////////////////////////////
// Function messageTextNoLink
//   returns the body of a message with no link whatsoever (used in previews)
///////////////////////////////////////////////////////////////////////////
function messageTextNoLink($id, $author, $subject, $time, $text) {
global $template, $admin;

if ($admin) {
	$output = $template['messagesimple'];
} else {
	$output = $template['message'];
}
$output = str_replace("{messagename}", $id, $output);
$output = str_replace("{author}", replace_comment("entryform",$author), $output);
$output = str_replace("{subject}", replace_comment("entryform",$subject), $output);
$output = str_replace("{date}", date("m/d/Y g:ia",$time), $output);
$output = str_replace("{message}", replace_comment("show", $text, false), $output);
$output = str_replace("{foot}", "", $output);
return $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: echothread
// Description: Displays a thread
// Argument: threadid
// 11/2005: you can add a central note (text between the first and other messages of the list)
///////////////////////////////////////////////////////////////////////////
function echothread($thread,$page=1) {
global $thispage;
global $admin;
global $template;
global $centralnote;
global $cat;
// Get the list of thread info
$threadinfo = getthreadinfo ($thread);
// Set the category to the thread category (used in link to create new thread)
// $cat = $threadinfo['category'];
// Get commments
$threadcomments = getthreadcomments($thread,$page);
// Get number of pages
$npages = getnpagescomments($thread);
$pagelist = buildpagelist("${thispage}mode=thread&amp;thread=$thread&amp;page=", $page, $npages);
// Headings
echo operations("$thispage",'thread',$thread);
// Building comment lists
$commenttext = "";
foreach($threadcomments  as $comment) {
	$commenttext .= messageText($comment['id'], $comment['author'], $comment['subject'], $comment['started'], $comment['message'], $thread, $comment['email'], $comment['ip']);
}
// Building the actual thread
$output = $template['thread'];
$output = str_replace("{page}", $page, $output);
$output = str_replace("{npages}", $npages, $output);
$output = str_replace("{pagelist}", $pagelist, $output);
$output = str_replace("{subject}", replace_comment("entryform",$threadinfo['subject']), $output);
$output = str_replace("{author}", replace_comment("entryform",$threadinfo['author']), $output);
$output = str_replace("{startdate}", date("m/d/Y g:ia",$threadinfo['started']), $output);
$output = str_replace("{centralnote}", $centralnote, $output);
$output = str_replace("{comments}", $commenttext, $output);
$post = messageText($thread, $threadinfo['author'], $threadinfo['subject'], $threadinfo['started'], $threadinfo['message'], $thread, $threadinfo['email'], $threadinfo['ip']);
$output = str_replace("{message}", $post, $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: really delete
// Description: Asks for confirmation before deleting messages or thread
// 11/2005: Added the cat parameter so you stay in the same category after deletion
///////////////////////////////////////////////////////////////////////////
function reallydelete($thread,$threadid) {
global $thispage;
global $template;
global $cat;
$threadinfo = getthreadinfo ($threadid);
$commentstxt = "";
if (getnchildren($threadid)>0) {
	// Get commments
	$threadcomments = getthreadcomments($threadid);
	foreach ($threadcomments as $comment) {
		$output =  str_replace("{subject}", $comment['subject'], $template['delete-comment']);
		$output =  str_replace("{author}", $comment['author'], $output);
		$commentstxt .= $output;
	}
}
$output =  str_replace("{subject}", $threadinfo['subject'], $template['delete']);
$output =  str_replace("{cat}", $cat, $output);
$output =  str_replace("{author}", $threadinfo['author'], $output);
$output =  str_replace("{message}", replace_comment("show",$threadinfo['message'],false), $output);
$output =  str_replace("{linkthispage}", "$thispage", $output);
$output =  str_replace("{threadid}", $thread, $output);
$output =  str_replace("{postid}", $threadid, $output);
$output =  str_replace("{comments}", $commentstxt, $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: listipbanform
// Description: Displays a list of banned IP's with the option to remove the ban
///////////////////////////////////////////////////////////////////////////
function listipbanform() {
global $thispage;
global $admin;
global $demo;
global $notindemomodejs;
global $template;
if (!$admin) {return;}
$ban = listbannedIP();
echo operations("$thispage",'ipban');
$banlist = "";
$i = 0;
foreach ($ban as $ip => $count){
	$i++;
	if($i%2 == 1) {
		$output = $template['ipbanform-even'];
	} else {
		$output = $template['ipbanform-odd'];
	}
	$output = str_replace("{ip}", $ip, $output);
	$output = str_replace("{count}", $count, $output);
	if (!$demo) {
		$output = str_replace("{removelink}", "${thispage}mode=removeipban&amp;ip=$ip", $output);
	} else {
		$output = str_replace("{removelink}", "javascript:alert('$notindemomodejs')", $output);
	}
	$banlist .= $output;
}
if($i == 0){ $banlist = $template['ipbanform-none'];}
$output = str_replace("{iplist}", $banlist, $template['ipbanform']);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: export
// Description: Form to export and restore data
///////////////////////////////////////////////////////////////////////////
function exportform() {
global $thisdirlink;
global $thispage;
global $admin;
global $demo;
global $template;
if ((!$admin) && ($demo)) {return;}
echo operations("$thispage",'export');
$output = str_replace("{exportlink}", "$thisdirlink/export.php", $template['exportform']);
$output = str_replace("{linkthispage}", $thispage, $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: echoRestoreSQL
// Description: restoration of database, writes out information along the way
///////////////////////////////////////////////////////////////////////////
function echoRestoreSQL($file) {
global $thisdirlink;
global $thispage;
global $admin;
global $demo;
global $template;
global $path;
global $Failed, $Worked;
if ((!$admin) && ($demo)) {return;}
echo operations("$thispage",'restore');
$output = $template['restoreSQL'];
$output = str_replace("{npostsbefore}", getnmessages(0), $output);
$output = str_replace("{nthreadsbefore}", getnthreads(0), $output);
$last = lastpostinfoall();
$output = str_replace("{lastpostbefore}", date("m/d/Y g:ia", $last['date']) , $output);
$last = firstpostinfoall();
$output = str_replace("{firstpostbefore}", date("m/d/Y g:ia", $last['date']), $output);
$statusunpack = $Failed;
$statusclear = $Failed;
$statuscategories = $Failed;
$statusposts = $Failed;
$status = 1;
$extract = extractArchive($file);
if ($extract['status'] == 0) {
	$status = 0;
	$statusunpack = $Failed.": ".$status['error'];
} else {
	$statusunpack = $Worked;
}
if ($status) {
	 $test = emptyDB();
	 if ($test != 1) {
		$statusclear = $Failed.": ".$test;
		$status = 0;
	} else {
		$statusclear = $Worked;
	}
}
if ($status) {
	$test = restoreCategories($extract);
	if ($test != 1) {
		$statuscategories = $Failed.": ".$test;
		$status = 0;
	} else {
		$statuscategories = $Worked;
	}
}
if ($status) {
	$test = restorePosts($extract);
	if ($test != 1) {
		$statusposts = $Failed.": ".$test;
		$status = 0;
	} else {
		$statusposts = $Worked;
	}
}
$output = str_replace("{statusunpack}",$statusunpack,$output);
$output = str_replace("{statusclear}",$statusclear,$output);
$output = str_replace("{statuscategories}",$statuscategories,$output);
$output = str_replace("{statusposts}",$statusposts,$output);
$output = str_replace("{npostsafter}", getnmessages(0), $output);
$output = str_replace("{nthreadsafter}", getnthreads(0), $output);
$last = lastpostinfoall();
$output = str_replace("{lastpostafter}", date("m/d/Y g:ia", $last['date']) , $output);
$last = firstpostinfoall();
$output = str_replace("{firstpostafter}", date("m/d/Y g:ia", $last['date']), $output);
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: manage category form
// Description: Displays a list of categories, with possibility to change
//     them
///////////////////////////////////////////////////////////////////////////
function managecategoryform() {
global $thispage;
global $admin;
global $demo;
global $notindemomodejs;
global $template;
if (!$admin) {return;}
$categories = categoryarray();
echo operations("$thispage",'editcat');
$catllist = "";
$i = 0;
foreach ($categories as $cat){
	$i++;
	if($i%2 == 1) {
		$even = 1;
	} else {
		$odd = 0;
	}
	if (!$demo) {
		$catlist .= categoryformline($even, $cat['public'], "${thispage}mode=changecatmode&amp;cat=", $cat['id'], $cat['name'], "$thispage", $cat['nthreads'], $cat['nposts']);
	} else {
		$catlist .= categoryformline($even, $cat['public'], "${thispage}mode=changecatmode&amp;cat=", $cat['id'], $cat['name'], "$thispage", $cat['nthreads'], $cat['nposts'], $demo);
	}
}
if (!$demo) {
	$output = str_replace("{categorylist}",$catlist, $template['categoryform']);
	$output = str_replace("{linkthispage}", "$thispage", $output);
	$output = str_replace("{linkdelete}", "${thispage}mode=deletecat&cat=", $output);
} else {
	$output = str_replace("{categorylist}",$catlist, $template['categoryform']);
	$output = str_replace("{linkthispage}", "$thispage", $output);
	$output = str_replace("{linkdelete}", "javascript:alert('$notindemomodejs')", $output);

}
echo $output;
}

///////////////////////////////////////////////////////////////////////////
// Function: echoSearchResults
// Description: Displays results of a search
///////////////////////////////////////////////////////////////////////////
function echoSearchResults($search,$page) {
global $thispage;
global $admin;
global $nsearchresultsperpage;
global $template;

echo operations("$thispage",'searchRes',$search);
$results = searchresults($search,$page);
$npages = npagessearchresults($search);
$categories = categorylist();
$search = stripslashes($search);
$pagelist = buildpagelist("${thispage}mode=search&amp;search=$search&amp;page=", $page, $npages);
$resstring = "";
$i = 0;
foreach ($results as $res){
	$i++;
	$n = ($page-1)*$nsearchresultsperpage+$i;
	if($i%2 == 1) {
		$output = $template['search-results-even'];
	} else {
		$output = $template['search-results-odd'];
	}
	$output = str_replace("{n}", $n, $output);
	$output = str_replace("{linkcategory}", "${thispage}cat=".$res['category'], $output);
	$output = str_replace("{linkthread}", "${thispage}mode=thread&amp;thread=".$res['thread'], $output);
	$output = str_replace("{linkpost}", "${thispage}mode=thread&amp;thread=".$res['thread']."#".$res['id'], $output);
	$output = str_replace("{categoryname}",$categories[$res['category']], $output);
	$output = str_replace("{threadname}", $res['threadtitle'], $output);
	$output = str_replace("{postname}", $res['subject'], $output);
	$output = str_replace("{author}", $res['author'], $output);
	$output = str_replace("{date}", date("m/d/Y g:ia",$res['date']), $output);
	$resstring .= $output;
}
if ($i == 0) {
	$resstring = $template['search-results-none'];
}
$output = str_replace("{search}", $search, $template['search-results']);
$output = str_replace("{page}", $page, $output);
$output = str_replace("{npages}", $npages, $output);
$output = str_replace("{pagelist}", $pagelist, $output);
$output = str_replace("{searchresults}", $resstring, $output);
echo $output;
}
