<?PHP
/**
*    
* By The Name Of ALLAH
*
*  :    
* @Author : Nawaf Amin Bakr Hariri
*
*  
* @Version : 1.0
*
*   : 1425/10/18
* @Date : 30/11/2004
*
*   : al3mlaq@gawab.com
* @E-mail : al3mlaq@gawab.com
*
*        
* @Copyright : PHP4ARAB.org
*/

require_once 'arabicTools.class.php';

Class HjriCalendar extends ArabicTools
{
    var $day;
    var $month;
    var $monthName;
    var $year;
    var $totalDays;
    var $diffHoures;
    var $diffDays;
    var $time;
    var $calendar = array();

    /**
    *  
    *          
    * @   :    $_houres         
    * @   :    $_days              ,    +   - 
    * @   :    $_totalDays       
                                                      29    30
                                                    29    ,  
    */
    function HjriCalendar($_houres, $_days, $_totalDays)
    {
        $this->diffHoures = $_houres;
        $this->diffDays   = $_days;
        $this->time       = time();
        $this->_differnt();

        $this->day       = $this->arabicDate('hj:d', $this->time);
        $this->month     = $this->arabicDate('hj:m', $this->time);
        $this->monthName = $this->arabicDate('hj:F', $this->time);
        $this->year      = $this->arabicDate('hj:Y', $this->time);

        $this->_findTotalDays();
        $this->_realTotalDays($_totalDays);

        $this->_generateCalendar();
    }

    /**
    *           
    */
    function _findFirstDay()
    {
        $geoFirstDay  = $this->dateHejri2Geo('1/'.$this->month.'/'.$this->year);
        $geoFirstDay  = explode('-', $geoFirstDay);
        $hjriFirstDay = $this->arabicDate('hj:w', strtotime($geoFirstDay[1].'/'.$geoFirstDay[0].'/'.$geoFirstDay[2]));

        return $this->_hjriDayNumber($hjriFirstDay);
    }

    /**
    *         
    */
    function _findTotalDays()
    {
        $this->totalDays = 29;
        do {
            $lastDay = $this->dateHejri2Geo($this->totalDays.'/'.$this->month.'/'.$this->year);
            $lastDay = explode('-', $lastDay);
            $firstDayInNextMonth = $this->arabicDate('hj:m', strtotime($lastDay[1].'/'.$lastDay[0].'/'.$lastDay[2]));
            $this->totalDays++;
        } while ($firstDayInNextMonth != ($this->month+1));
        $this->totalDays -= 2;
    }

    /**
    *       
    */
    function _differnt()
    {
        if (ereg("-", $this->diffHoures)) {
            $hours = split("-", $this->diffHoures);
            $this->time = $this->time - ($hours[1]*60*60);
        }
        else {
            $hours = split("\+", $this->diffHoures);
            $this->time = $this->time + ($hours[1]*60*60);
        }

        if (ereg("-", $this->diffDays)) {
            $days = split("-", $this->diffDays);
            $this->time = $this->time + ($days[1]*24*60*60);
        }
        else {
            $days = split("\+", $this->diffDays);
            $this->time = $this->time - ($days[1]*24*60*60);
        }
    }

    /**
    *           
    */
    function _move()
    {
        if (ereg("-", $this->diffDays)) {
            $days = split("-", $this->diffDays);
            if ($this->_findFirstDay() > $days[1]) $move = $this->_findFirstDay() - $days[1];
            else if ($this->_findFirstDay() == $days[1]) $move = 7;
            else $move = ($this->_findFirstDay()+7) - $days[1];

        } else {
            $days = split("\+", $this->diffDays);
            $move = $this->_findFirstDay() + $days[1];
        }

        return $move;
    }

    /**
    *       
    */
    function _realTotalDays($total)
    {
        if ((intval($total) == 29) && ($this->totalDays == 30)) {
            $this->totalDays = 29;
        } else if ((intval($total) == 30) && ($this->totalDays == 29)) {
            $this->totalDays = 30;
        }
    }

    /**
    *      
    */
    function _generateCalendar()
    {
        $r=1;
        for ($i=1; $i<=42; $i++) {
            if (($i >= $this->_move()) && ($i < ($this->totalDays+$this->_move()))) {
                $this->calendar[$i]=$r; $r++;
            } else {
                $this->calendar[$i]=0;
            }
        }
    }

    /**
    *        
    * @   :    $_template          
    * @  :    $_font              
    * @  :    $_size         
    */
    function printCalendar($_template, $_font, $_size)
    {
        $c=1;
        $_HtmlCalendar = '';
        for ($row=1; $row<=6; $row++) {
            $_HtmlCalendar .= "<tr>";
            for ($col=1; $col<=7; $col++) {
                if ($this->calendar[$c] == 0) {
                    $_HtmlCalendar .= "<td> </td>"; $c++;
                } else if ($this->calendar[$c] == $this->day) {
                    $_HtmlCalendar .= "<td align='center' style='border: 1px solid #CCC; background-color: #E4E4E4; font-family: {$_font}; font-size: {$_size};'><b>{$this->calendar[$c]}</b></td>"; $c++;
                } else {
                    $_HtmlCalendar .= "<td align='center' style='font-family: {$_font}; font-size: {$_size};'>{$this->calendar[$c]}</td>"; $c++;
                }
            }
            $_HtmlCalendar .= "</tr>";
        }

        $handle = fopen($_template, "r");
        $html = fread($handle, filesize($_template));
        fclose($handle);
        $html = preg_replace("/\+month\+/i", $this->monthName, $html);
        $html = preg_replace("/\+calendar\+/i", $_HtmlCalendar, $html);

        Echo $html;
    }

    /**
    *              
    */
    function _hjriDayNumber($num)
    {
        switch ($num) {
            case 0: return 2;
            case 1: return 3;
            case 2: return 4;
            case 3: return 5;
            case 4: return 6;
            case 5: return 7;
            case 6: return (int)1;
        }
    }

}//END-CLASS

?>
