<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: stamp.php,v $ - $Revision: 1.0 $');
define('NO_REGISTER_GLOBALS', 1);


// ########################## REQUIRE BACK-END ############################
require_once('./global.php');


if (!can_administer('canadminforums'))
{
        print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action($_REQUEST['do'] . iif($_REQUEST['stampid'] != 0, " stampid = $_REQUEST[stampid]"));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
print_cp_header($vbphrase['stamps_manager']);




if (empty($_REQUEST['do']))
{
        $_REQUEST['do'] = 'modify';
}
// ###################### Start add #######################
if ($_REQUEST['do'] =="add")
{
         print_form_header("stamp","insert",$vbphrase['stamps_manager']);
         print_table_header($vbphrase['add_stamp']);
         print_input_row("<b>$vbphrase[stamp_name]</b>","title",$vbphrase['stamp']);
         print_input_row("<b>$vbphrase[stamp_color]</b>","color","black");
         print_input_row("<b>$vbphrase[stamp_icon]</b>","icon","images/stamps/");
         print_input_row("<b>$vbphrase[stamp_pic_url]</b>","url","images/stamps/");
         print_submit_row();
}

// ###################### Start insert #######################
if ($_POST['do'] =="insert")
{
        $db->query_write("INSERT INTO " . TABLE_PREFIX . "stamps (stampid,title,icon,url,color) VALUES(NULL,'".addslashes($_POST['title'])."','".addslashes(htmlspecialchars($_POST['icon']))."','".addslashes(htmlspecialchars($_POST['url']))."','".addslashes(htmlspecialchars($_POST['color']))."')");
        print_cp_message($vbphrase['stamp_added'], "stamp.php?do=modify");
}
// ###################### Start edit #######################
if ($_REQUEST['do'] == "edit")
{
          $stamps=$db->query_first("SELECT * FROM " . TABLE_PREFIX . "stamps WHERE stampid=".intval($_REQUEST['stampid'])."");
          print_form_header("stamp","doupdate",$vbphrase['stamps_manager']);
          construct_hidden_code("stampid",intval($_REQUEST['stampid']));
          print_table_header($vbphrase['modify_stamps']);
          print_input_row("<b>$vbphrase[stamp_name]</b>","title",$stamps[title]);
          print_input_row("<b>$vbphrase[stamp_color]</b>","color",$stamps[color]);
          print_input_row("<b>$vbphrase[stamp_icon]</b>","icon",$stamps[icon]);
          print_input_row("<b>$vbphrase[stamp_pic_url]</b>","url",$stamps[url]);
          print_submit_row();

}

// ###################### Start do update #######################
if ($_POST['do'] == "doupdate")
{
          $db->query_write("UPDATE " . TABLE_PREFIX . "stamps set title='".addslashes($_POST['title'])."',icon='".addslashes(htmlspecialchars($_POST['icon']))."',url='".addslashes(htmlspecialchars($_POST['url']))."',color='".addslashes(htmlspecialchars($_POST['color']))."' WHERE stampid=".intval($_POST['stampid'])."");
          print_cp_message($vbphrase['stamp_updated'], "stamp.php?do=modify");
}
// ###################### Start Remove #######################
if ($_REQUEST['do'] == "remove")
{
    global $vbphrase;
    $item = $db->query_first("SELECT title as title FROM " . TABLE_PREFIX . "stamps WHERE stampid =".intval($_REQUEST['stampid']));
    echo "<p>&nbsp;</p><p>&nbsp;</p>";
    print_form_header("stamp","kill",$vbphrase['stamps_manager']);
    construct_hidden_code('stampid', $_REQUEST['stampid']);
    print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $item['title']));
    print_description_row("
    <blockquote><br />
    " . construct_phrase($vbphrase['del_stamp'], $item['title'], $_REQUEST['stampid'],'') . "
    <br /></blockquote>\n\t");
    print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ###################### Start Kill #######################

if ($_REQUEST['do'] == "kill")
{
    $db->query_write("DELETE FROM " . TABLE_PREFIX . "stamps WHERE stampid=".intval($_REQUEST['stampid'])."");
    $db->query_write("UPDATE " . TABLE_PREFIX . "thread SET stampid='0' WHERE stampid=".intval($_REQUEST['stampid'])."");
    print_cp_message($vbphrase['stamp_deleted'], "stamp.php?do=modify");
}

// ###################### Start modify #######################
if ($_REQUEST['do'] == "modify") {

$stamps=$db->query_read("SELECT * FROM " . TABLE_PREFIX . "stamps ORDER BY stampid");

print_table_start();
print_table_header($vbphrase['modify_stamps'],4);
$header = array();
$header[]=$vbphrase['stamp_name'];
$header[]=$vbphrase['stamp_icon'];
$header[]=$vbphrase['stamp_pic'];
$header[]="";
print_cells_row($header, 1, 0, 1);
$cell = array();
while ($stamp=$db->fetch_array($stamps))
{
       $cell[] = "<font color=$stamp[color] size='5'><b>$stamp[title]</b></font>";
       $cell[] = "<img width='20' height='20' border=0 src='../".$stamp[icon]."'>";
       $cell[] = "<img width='120' height='120' border=0 src='../".$stamp[url]."'>";
       $cell[] = iif($stamp[stampid] > '0',construct_link_code("<b>$vbphrase[edit]</b>","stamp.php?do=edit&stampid=$stamp[stampid]"),'').
       iif($stamp[stampid] > '4',construct_link_code("<b>$vbphrase[delete]</b>","stamp.php?do=remove&stampid=$stamp[stampid]"),'');
       print_cells_row($cell, 0, 0, 1);
       unset($cell);
       $cell = array();
}
print_table_footer();
}

###################### show ########################
if ($_REQUEST['do'] == "show")
{
$stampsloop = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "stamps");
while ($stamplop = $db->fetch_array($stampsloop))
{
       $stampfind = $db->query("SELECT threadid FROM " . TABLE_PREFIX . "thread WHERE stampid = " . $stamplop[stampid] ." LIMIT 1");
       if($db->fetch_array($stampfind))
       {
                $stamped = $db->query("SELECT * FROM " . TABLE_PREFIX . "thread WHERE stampid = " . $stamplop[stampid] ." ORDER by stampid DESC");
                print_table_start();
                print_table_header($stamplop['title'],8);
                $header = array();
                $header[] = $vbphrase['stamp_icon'];
                $header[] = $vbphrase['thread'];
                $header[] = $vbphrase['replies'];
                $header[] = $vbphrase['views'];
                $header[] = $vbphrase['last_post'];
                $header[] = $vbphrase['info'];
                $header[] = "";
                print_cells_row($header, 1, 0, 1);
                $cell = array();
                while ($stampedlist = $db->fetch_array($stamped))
                {
                        $cell[] = "<b><a dir=rtl title='$stamplop[title]' ><img src=../$stamplop[icon] border=0 /></a></b>";
                        $cell[] = "<b><a dir=rtl href=../showthread.php?t=$stampedlist[threadid] title='$vbphrase[thread_starter]: $stampedlist[postusername]' target='_blank'><font size='2'>$stampedlist[title]</font></a></b>";
                        $cell[] = "<b><a dir=rtl><font size='2'>$stampedlist[replycount]</font></a></b>";
                        $cell[] = "<b><a dir=rtl><font size='2'>$stampedlist[views]</font></a></b>";
                        $cell[] = "<b><font size=2>" . vbdate($vbulletin->options['dateformat'], $stampedlist['lastpost'],1).'  '.vbdate($vbulletin->options['timeformat'], $stampedlist['lastpost']). "<br /><a dir=rtl href=../member.php?find=lastposter&t=$stampedlist[threadid] target=_blank>$stampedlist[lastposter]</font></a> <a href=../showthread.php?goto=newpost&t=$stampedlist[threadid] target=_blank><img src=../images/buttons/lastpost.gif title='$vbphrase[go_to_last_post]' border=0 /></b>";
                        $cell[] = "<b><font size=2>" . construct_phrase($vbphrase[stamp_date_x_by_x],vbdate($vbulletin->options['dateformat'], $stampedlist['stamptime'],1).' '.vbdate($vbulletin->options['timeformat'], $stampedlist['stamptime']),$stampedlist[stampby]) . " " .iif($stampedlist['stampdays'] > '0',construct_phrase($vbphrase[to_x_days],$stampedlist['stampdays'])) . "</font></b>";
                        $cell[] = "<b><a href=stamp.php?do=delstamp&id=$stampedlist[threadid]>$vbphrase[removestamp]</a></b>";
                        print_cells_row($cell, 0, 0, 1, 1, 0, 1);
                        unset($cell);
                        $cell = array();
                }
                print_table_footer();
       }
       else
       {
                print_table_start();
                print_table_header($stamplop['title'],1);
                $cella = array();
                $cella[] = "<b>$vbphrase[folder_is_currently_empty]</b>";
                print_cells_row($cella, 0, 0, 1, 1, 0, 1);
                unset($cella);
                $cella = array();
                print_table_footer();
       }
}
}

elseif ($_REQUEST['do'] == "delstamp")
{
     $db->query_write("
          UPDATE " . TABLE_PREFIX . "thread
          SET stampid = '0', stampdays = '0', stamptime = '0', stampby = '0'
          WHERE threadid = ".intval($_REQUEST['id'])."
          LIMIT 1
          ");

     print_cp_message($vbphrase['stamp_deleted'], "stamp.php?do=show");
}


###################### |show ########################

print_cp_footer();

?>