<?php
/***************************************************************************
 *
 *	 PROJECT: eSyndiCat Link Management Software
 *	 VERSION: 1.5 (Free Release)
 *	 LISENSE: GNU GPL (http://www.opensource.org/licenses/gpl-license.html)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation.
 *
 *   Link to eSyndiCat.com can not be removed from the software pages without
 *	 permission of eSyndiCat respective owners. It is the only requirement
 *	 for using this software.
 *
 *   Copyright 2005-2006 eSyndiCat Software Development Ltd.
 *   http://www.esyndicat.com/
 *
 ***************************************************************************/

define('NUM_NAVIG_PAGES', $gDirConfig['num_navig_pages']);
define('NUM_CATEG_COLS', $gDirConfig['num_categories_cols']);
define('NUM_SUBCATS', $gDirConfig['subcats_display']);

$gDirLayout = new DirLayout;

class DirLayout
{
	/**
	* Returns HTML code for breadcrumb display
	*
	* @param int $aCategory category id
	* @param arr $aAdditional additional elements for breadcrumb
	* @param bool $aFull if TRUE latest element is a link
	*
	* @return str
	*/
	function print_breadcrumb($aCategory, $aAdditional = '', $aFull = FALSE)
	{
		global $gDirDb;
		global $gDirConfig;
		global $gDirLang;

		$out = '<div class="breadcrumb">';

		if ($aCategory > 0)
		{
			$gDirDb->getBreadcrumb($aCategory, $breadcrumb);
			$breadcrumb = array_reverse($breadcrumb);
		}

		$url = "{$gDirConfig['base']}{$gDirConfig['dir']}";
		$out .= "<a href=\"{$url}\">{$gDirConfig['site']}</a>";
	
		if ($breadcrumb)
		{
			$cnt = 1;
			$size = count($breadcrumb);
			foreach($breadcrumb as $item)
			{
				$caption = $item['title'];	
				if (($size == $cnt) && !$aFull)
				{
					$out .= "&nbsp;&#187;&nbsp;<strong>{$caption}</strong>";
				}
				else
				{
					$url = "{$gDirConfig['base']}{$gDirConfig['dir']}{$item['path']}/";
					$out .= "&nbsp;&#187;&nbsp;<a href=\"{$url}\">{$caption}</a>";
				}
				$cnt++;
			}
		}
		/** if there are additional elements displays after breadcrumb to category **/
		if ($aAdditional)
		{
			$size = count($aAdditional);
			foreach($aAdditional as $item)
			{
				$caption = $item['caption'];
				if ($value['url'] && !$size)
				{
					$url = "{$gDirConfig['base']}{$gDirConfig['dir']}{$value['url']}";
					$out .= "&nbsp;&#187;&nbsp;<a href=\"{$url}\">{$caption}</a>";
				}
				else
				{
					$out .= "&nbsp;&#187;&nbsp;<strong>{$caption}</strong>";
				}
			}
		}
		
		$out .= '</div>';

		return $out;
	}

	/**
	* Returns HTML code for categories display
	*
	* @param arr $aCategories categories to be displayed
	* @param int $aCols number of columns
	* @param int $aSubcategories number of subcategories to be displayed
	*
	* @return str
	*/
	function print_categories($aCategories = '', $aCols = NUM_CATEG_COLS, $aSubcategories = NUM_SUBCATS)
	{
		global $gDirPage;
		global $gDirConfig;

		if ($aCategories)
		{
			$out = '<div class="categories">';
	
			$cnt = 0;
			$row = 1;
			foreach($aCategories as $key=>$value)
			{
				$cnt++;
				$url = "{$gDirConfig['base']}{$gDirConfig['dir']}{$value['path']}/";
				$cause = '';
				if ($gDirConfig['num_links_display'])
				{
					$cause = ' ('.(int)$value['num_links'].')';					
				}
			
				$crossed = $value['crossed'] ? '@' : '';

				if ($aSubcategories)
				{
					$subcats = '';
					if ($value['subcategories'])
					{
						$subcats = "<div class=\"subcategories\">";
						$cnt2 = 1;
						foreach ($value['subcategories'] as $key2=>$value2)
						{
							$min = (count($value['subcategories']) < $aSubcategories) ? count($value['subcategories']) : $aSubcategories;
							$divid = ($cnt2 < $min) ? ', ' : '';
							$subcats .= "<a href=\"{$gDirConfig['base']}{$gDirConfig['dir']}{$value2['path']}/\">{$value2['title']}</a>{$divid}";
							$cnt2++;
						}
						$subcats .= "</div>";
					}
				}

				if (!($cnt%$aCols) || ($cnt == count($aCategories)))
				{
					$out .= '<div class="last">';
					$out .= "<div class=\"categ\"><a href=\"{$url}\">".htmlspecialchars($value['title'])."</a>{$crossed}{$cause}</div>";
					$out .= $subcats;
					$out .= '</div>';
					if ($row < (count($aCategories) / (int)$aCols))
					{
						$out .= '<div class="divider"></div>';
					}
					$row++;
				}
				else
				{
					$out .= '<div class="col">';
					$out .= "<div class=\"categ\"><a href=\"{$url}\">".htmlspecialchars($value['title'])."</a>{$crossed}{$cause}</div>";
					$out .= $subcats;
					$out .= '</div>';
				}
			}
			$out .= '<div class="divider"></div>';
			$out .= '</div>';

			
			return $out;
		}
	}

	/**
	* Returns HTML code for menu display
	*
	* @param int $aCategory category id
	*
	* @return str
	*/
	function print_menu($aCategory = 0)
	{
		global $gDirConfig;
		global $gDirLang;
		global $gTab;
	
		$menu['home']['caption'] = $gDirLang['home'];
		$menu['home']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}";
		$menu['search']['caption'] = $gDirLang['search'];
		$menu['search']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}search.php";
		$menu['new-links']['caption'] = $gDirLang['new_links'];
		$menu['new-links']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}new-links.html";
		$menu['top-links']['caption'] = $gDirLang['top_links'];
		$menu['top-links']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}top-links.html";
		$menu['popular-links']['caption'] = $gDirLang['popular_links'];
		$menu['popular-links']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}popular-links.html";
		if ($aCategory)
		{
			$menu['suggest-link']['caption'] = $gDirLang['suggest_link'];
			$menu['suggest-link']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}suggest-link.php?id={$aCategory}";
			$menu['suggest-category']['caption'] = $gDirLang['suggest_category'];
			$menu['suggest-category']['url'] = "{$gDirConfig['base']}{$gDirConfig['dir']}suggest-category.php?id={$aCategory}";
		}
	
		foreach ($menu as $key => $value)
		{
			$url = $value['url'];
			$caption = $value['caption'];
		
			if ($key == $gTab)
			{
				if (($gTab == 'home') && ($aCategory == 0))
				{
					$out .= "<li class=\"active\" {$style}>{$caption}</li>";
				}
				elseif ($key != 'home')
				{
					$out .= "<li class=\"active\" {$style}>{$caption}</li>";
				}
				else
				{
					$out .= "<li><a href=\"{$url}\"{$cause}>{$caption}</a></li>";
				}
			}
			else
			{
				if (($key == 'suggest-link') || ($key == 'suggest-category'))
				{
					$cause = ' rel="nofollow"';
				}
				$out .= "<li><a href=\"{$url}\"{$cause}>{$caption}</a></li>";
			}
			$cnt++;
		}

		return $out;
	}

	/**
	* Returns HTML code for adsense display
	*/
	function print_adsense()
	{
		global $gDirConfig;
	
		if ($gDirConfig['adsense'])
		{
			return $adsense = "<div class=\"adsense\">".stripslashes($gDirConfig['adsense_text'])."</div>";
		}
	}

	/**
	* Prints out google pagerank indicator
	*
	* @param int $aPageRank url pagerank
	*
	* @return str
	*/
	function print_pagerank($aPageRank)
	{
		global $gDirConfig;

		if ($gDirConfig['pagerank'])
		{
			$percent = $aPageRank * 10;
			$out = "<div class=\"pagerank\" title=\"Pagerank: {$aPageRank}\">";
			$out .= "<div class=\"inner-pagerank\" style=\"padding-left: {$percent}%; width: 0;\">";
			$out .= "<img src=\"{$gDirConfig['base']}{$gDirConfig['dir']}{$gDirConfig['templates']}{$gDirConfig['tmpl']}/img/sp.gif\" alt=\"\" />";
			$out .= "</div>";
			$out .= "</div>";
		}
		
		return $out;
	}
	
	/**
	* Prints out thumbshots.org preview thumb
	*
	* @param int $aUrl link url
	*
	* @return str
	*/
	function print_thumbshot($aUrl)
	{
		global $gDirConfig;

		if ($gDirConfig['thumbshot'])
		{
			$out = "Preview by Thumbshots.org<div class=\"preview\"><img src=\"http://open.thumbshots.org/image.pxf?url={$aUrl}\" alt=\"\" /></div>";
		}
		return $out;
	}

	/**
	* Prints out Alexa rank graph
	*
	* @param str $aUrl link url
	*
	* @return str
	*/
	function print_alexa($aUrl)
	{
		global $gDirConfig;

		if ($gDirConfig['alexa'])
		{
			$out = "<script type=\"text/javascript\" src=\"http://xsltcache.alexa.com/traffic_graph/js/g/a/3m?&amp;u={$aUrl}\"></script>";
		}
		return $out;
	}
}
?>
