<?
/****************************************************************************
This script was developed by Indigo Scripts .
Title: Indigo Whois
Version: 1.8
Homepage: www.indigoscripts.com
Copyright 2005 Indigo Scripts and its owners.
All rights reserved.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

USAGE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/

/*
	To Require the user to enter a randomly generated "security" code for each lookup
	set $Secure = true;

	This works by generating a random code each time the lookup form is displayed,
	storing it in a session variable, displaying an image containing the code and asking
	the user to enter the code displayed when they submit the lookup form. The code they
	enter is then compared with the generated code and if they match, then the lookup is done.

	Its purpose is to stop people from abusing your whois lookup script through scripting
	100's or 1000's of lookups per minute, and possibly getting you banned for excessive 
	lookups.

	You MUST uncomment the code "session_start();" code for this to work.

	You MUST upload the "secureimage.php" file to your document root (so it can be 
	accessed at http://www.yoursite.com/secureimage.php). This is the file that
	generates the image.

	Your server MUST have the php gd image module active for this to work.

	You MUST make sure that the $m_font variable contains the FULL path to the ttf font
	used to create the image. By default, a font should be included with this script and this
	variable should already be set for you.
	
	Additional options (font, size, number of characters, whether to use lower and upper
	case characters, and settings for the extra paranoid can be modified by editing the
	variables at the top of the "secureimagecode.class.php" file.

*/

/* you line below must be uncommented if using the secure code image option */
session_start();

$Secure = true;

/* 
	Whois lookup result caching.
	Set $CacheLifetime to a positive integer to cache the results of each lookup 
	that number of minutes.

	When caching is turned on, the script stores the whois data obtained from each
	lookup for the specified number of minutes. If a user tries to lookup the domain
	within the cache lifetime, the stored data is displayed instead of the script looking
	up the domain again.

	The benefits of this are less usage of your server's resources and bandwidth, as well
	as less queries to the whois servers.

	The folder /whois/cache MUST have the correct permissions for the script to create files in it.

*/

$CacheLifetime = 0;

/*
	"Cleaning" whois output. Removes extraneous text from the whois result.
	This will only make a difference for results from whois servers
	that the /whois/config.txt file contains a cleanup setting for.

	Possible options for $Clean are:

	$Clean = 'off'; Display the whois data "as-is".
	$Clean = 'on'; Always remove extraneous text from the whois result.
	$Clean = 'optional'; Allow the user to turn cleaning on or off via a checkbox.

*/

$Clean = 'optional';

/*
	Hi-lighting specific rows in the whois data, eg. expiration date, status, etc.
	This only hilights the results if the /whois/config.txt file contains hilite 
	settings for that whois server.

	Possible values for $Hilite are:

	$Hilite = 'off'; No hilighting.
	$Hilite = 'on'; Always hilight results.
	$Hilite = 'optional'; Let the user check a checkbox if they want to use hi-lighting.

*/

$Hilite = 'optional';

/*
	Check authorative server for .com & .net domains.

	Set $Auth = true; to check the authoriative whois server for domains in the com and net extension.

	Set $OnlyShowAuth = true; to only display the result from the authoritative server, not the registry server
	in cases where it is available.

*/

$Auth = true;
$OnlyShowAuth = false;

/*
	Tld options:

	Limit the tlds that the script will do whois lookups for by setting the $Tlds variable
	to a comma separated list of tlds to accept, eg. $Tlds = 'com,net,org'.

	Setting $Tlds = '' will result in the script looking up all the tlds
	defined in the /whois/config.txt file.

	Set $ListTlds = true; to list the tlds supported underneath the form.

	Set $TldOptions = true; to let the user select the tld to lookup from
	a drop-down <select> menu.

	Set $AlphabeticalTlds = true; to display the tlds alphabetically.
	If $AlphabeticalTlds = false; then the tlds will be listed in the order they are
	contained in the /whois/config.txt file, or in the order they are listed in the $Tlds variable.

*/

$Tlds = '';

$ListTlds = false;

$TldOptions = true;

$AlphabeticalTlds = false;

/*
	Text, messages, and other stuff that is displayed.

	Add the following variables to this script along with your custom messages to
	override the defaults in the whois.inc.php file.

	// The label that appears on the whois lookup form submit button
	$SubmitLabel = 'Lookup Domain';

	// The instructions displayed below the whois lookup form
	$Instructions = 'Enter a domain and click "lookup"';

	// Message displayed asking users to enter the security code (only displayed if $Secure = true)
	$SecurityMessage = 'Enter the 4 digit code.';

	// Text that says what server the lookup was from. The value {server} will be replaced by the actual server name.
	$ServerText = 'whois lookup at {server}...';

	// Message displayed if the domain name is available. The values {domain}, {sld}, {tld} will be replaced.
	$AvailableMessage = '{domain} is <span style="color: green;">Available.</span>';

	// Message displayed if the domain name is registered. The values {domain}, {sld}, {tld} will be replaced.
	$RegisteredMessage = '{domain} is <span style="color: red;">Registered.</span>';

	// Error message displayed if the user submits the form without entering the correct security code (if required)
	$SecurityError = 'For security purposes you MUST enter the 4-digit code shown above.';

	// Error message displayed if the whois lookup fails.
	$LookupError = 'Sorry, an error occurred.';

	// Error message displayed if the user enters an unsupported tld
	$TldError = 'Sorry, {tld} is not supported.';

	// Error message displayed if an error occurs during the lookup
	$LookupError = 'An error occurred with the whois lookup.';

	// Heading text displayed above the form...
	$HeadingText = 'Whois Lookup';

*/

// Message displayed if the domain name is available. The values {domain}, {sld}, {tld} will be replaced.
$AvailableMessage = '{domain} is <span style="color: green;">Available.</span>';

// Message displayed if the domain name is registered. The values {domain}, {sld}, {tld} will be replaced.
$RegisteredMessage = '{domain} is <span style="color: red;">Registered.</span>';

$SubmitLabel = '>>';

/*

	$OnlyShowAvailability

	Set to true to only display the domain status (no whois data)

	If setting this to true, you should also set $Auth (described above) to false
	because there is no point doing the additional lookup if you're not displaying the
	whois data

	For the same reason, you should also set $Hilite = "off"; and $Clean = "off",
	as if you are not displaying the whois data, there is not point giving your site user
	the option to hilight or clean it :)

*/

$OnlyShowAvailability = false;

/* 
	You can set the default domain name sld and tld to display when the page is first displayed.

	$DefaultSld = 'domain'; // NOTE: should just be the sld, no extension
	$DefaultTld = 'com';	// NOTE: No . at the beginning of the tld.

*/

$DefaultSld = 'domain';
$DefaultTld = 'com';

?>
<!-- beginning of html page header - replace the html below with your own -->
<html>
<head>
<title>Whois Lookup</title>

<!-- 
	links in the css stylesheet used to set the design of the whois lookup form and whois result
	see the file styles.css for comments on what each style affects.
-->
<link rel="stylesheet" type="text/css" href="style.css" />

</head>
<body style="font-family: verdana, arial; font-size: 10pt; margin-top: 100px;">

<!-- end of the html page header, back to php to include the whois file... -->
<?php

/*
	The line below includes the whois.inc.php script which does everything else for us,
	including generating the whois lookup form, displaying the secure code image if required,
	doing the whois lookup and displaying the result. Isn't that nice of it.
*/

require_once(dirname(__FILE__).'/whois.inc.php');

?>
<!-- beginning of html page footer - replace the html below with your own -->
</body>
</html>
<!-- end of page. You can stop reading now. You don't really have much choice in the matter =) -->