<?
/****************************************************************************
This script was developed by Indigo Scripts .
Title: Indigo Whois
Version: 1.8
Homepage: www.indigoscripts.com
Copyright 2005 Indigo Scripts and its owners.
All rights reserved.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

USAGE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

More Info About The Licence At http://www.gnu.org/copyleft/gpl.html
****************************************************************************/


/***********************************************
	Section 1 - Initialization...
************************************************/

/*
	include the whois class file. You can use this class directly in your scripts if you want
	more control...
*/

require_once(dirname(__FILE__).'/whois.class.php');

/* create a new whois object */

$whois = new Whois();

/*
	initialize any of the variables that we use. 
	You can set any of these values in the script that includes this one to override
	the values below.
*/

if( !isset($Hilite) ) $Hilite = 'no';	// hilight fields in the whois output (eg. status, nameservers, etc)
if( !isset($Clean) ) $Clean = 'no';	// "clean" the whois output of extraneous text
if( !isset($Auth) ) $Auth = true;	// check the authoritative whois server for com & net
if( !isset($OnlyShowAuth) ) $OnlyShowAuth = false;	// if checking authoritative, should we ignore the registry whois?
if( !isset($Secure) ) $Secure = false;	// generate a security code for each whois lookup
if( !isset($ListTlds) ) $ListTlds = false;	// list the supported tlds underneath the lookup form
if( !isset($TldOptions) ) $TldOptions = false;	// let the user select the tld from a drop-down list
if( !isset($AlphabeticalTlds) ) $AlphabeticalTlds = false;	// list tlds alphabetically?
if( !isset($Tlds) ) $Tlds = '';	// limit the tlds supported to those in a comma separated list eg 'com,net,org'
if( !isset($DefaultTld) ) $DefaultTld = 'com';	// the default tld to use / display in the form
if( !isset($DefaultSld) ) $DefaultSld = 'domain';	// the default sld to display in the form
if( !isset($CacheLifetime ) ) $CacheLifetime = 0; // the length of time in minutes to cache whois lookup results
if( !isset($OnlyShowAvailability) ) $OnlyShowAvailability = false;	// only show availability, no whois data

/*
	initialize any messages to display that aren't already set in the script that includes this one
*/

if( !isset($SubmitLabel) ) $SubmitLabel = 'Check Domain';	// the submit button label for the whois form

if( !isset($Instructions) ){		// instructions displayed under the form - differ slightly if the user can choose the tld
	if( $TldOptions ){
		$Instructions = 'Enter a domain name and select a tld from the box above.';
	}else{
		$Instructions = 'Enter a domain name including extension in the box above.';
	}
}

if( !isset($SecurityError) ){	// error message displayed if the user doesn't enter the security code when required
	$SecurityError = 'For security reasons, you MUST enter the 4 digit code shown above.';
}

if( !isset($LookupError) ){	// error message displayed if a whois lookup query fails
	$LookupError = 'Sorry, an error occurred.';
}

if( !isset($SecurityMessage) ){	// message displayed below the form when a security code is required
	$SecurityMessage = 'For security purposes, please also enter the 4 digit code.';
}

if( !isset($TldError) ){	// message displayed if the user enters a tld that is not supported
	$TldError = 'Sorry, that tld is not supported.';
}

if( !isset($HeadingText) ){ // displayed above the form - could replace with a logo image or the name of your site
	$HeadingText = 'Whois Lookup';
}

/*
	Set any variables in the Whois class that have been set in the script that includes this one.
*/

$whois->SetCacheLifetime($CacheLifetime);

if( isset($AvailableMessage) ){	// the message displayed when $whois->GetStatusText() is called and the domain is available
	$whois->SetAvailableMessage($AvailableMessage);
}

if( isset($RegisteredMessage) ){ // message displayed when $whois->GetStatusText() is called and the domain is registered
	$whois->SetRegisteredMessage($RegisteredMessage);
}

if( isset($ServerText) ){	// message displayed when $whois->GetServerText() is called - {server} is replaced by the server name
	$whois->SetServerText($ServerText);
}

if( isset($Auth) && $Auth == true ){ // tell the script whether to lookup com & net at the authoratitive server
	$whois->m_redirectauth = true;
}

/*
	Security code image
	if we are using a secure image code, include the class and create a secureimagecode object for later use
*/

if( $Secure ){

	require_once(dirname(__FILE__).'/secureimagecode.class.php');

	$secure = new secureimagecode();
}

/*
	limit the tlds to use (if set in the script that includes this one)
	$Tlds should be in the form 'com,net,org' where the tlds are the ones to use.
*/

if(  $Tlds != '') $whois->SetTlds($Tlds);

/*
	Initialize some variables used in the rest of the script
*/

$tld = $DefaultTld;	// the tld
$sld = $DefaultSld;	// the sld
$domain = '';	// this will be displayed as the value of the domain <input> in the form - it is set later on
$nocode = false;	// will be set to true later if the user submits the form without a correct security code (if required)
$dolookup = false;	// set later if the lookup form has been submitted with a valid domain / tld.

/*
	Determine whether to automatically clean whois output. If $Clean = 'optional', checks if the user wants this.
*/

switch( $Clean ){
	case 'yes': $s_clean = true; break;
	case 'optional': $w_clean = isset($_REQUEST['clean']) ? true : false; break;
	default: $w_clean = false; break;
}

/*
	Determine whether to hilight certain rows of the whois output. If $Hilite = 'optional', checks if the user wants this.
*/

switch( $Hilite ){
	case 'yes': $w_hilite = true; break;
	case 'optional': $w_hilite = isset($_REQUEST['hilite']) ? true : false; break;
	default: $w_hilite = false; break;
}

/*
	Check if the user has submitted the lookup form
*/

if( isset($_REQUEST['lookup']) && isset($_REQUEST['domain'])){

	$dn = trim($_REQUEST['domain']);

	if( $dn != '' ){

		// separate the sld and tld, checking for a submitted tld if $TldOptions = true
		$dot = strpos($dn, '.');
		if( $dot !== false ){
			$sld = substr($dn, 0, $dot);
			$tld = substr($dn, $dot+1);
		}else{
			$sld = $dn;
			if( $TldOptions && isset($_REQUEST['tld']) ) $tld = trim($_REQUEST['tld']);
		}

		$domain = $sld.'.'.$tld;

		if( $whois->ValidDomain($domain) ){ // check that it is a valid domain
			$dolookup = true;

			if( $Secure ){	// if we are using a secure code, check the user has entered it correctly
				if( !$secure->CheckCode($_REQUEST['code']) ){
					$nocode = true;
					$ErrorMessage = $SecurityError;
					$dolookup = false;
				}
			}
		}else{
			$ErrorMessage = $TldError;
		}
	}
}

/*
	Set the domain variable to the correct value (either with or without tld) for later output in the form
*/

if( $TldOptions ){
	$domain = $sld;
}else{
	$domain = $sld.'.'.$tld;
}

/***********************************************
	Section 2 - Display the whois lookup form

	Depending on what options have been set in the calling script, the form may contain
	various messages, a drop-down box to select the tld, and checkboxes.

************************************************/

?>
<div class="Positioner">
<br />
<form id="whoisform" name="whoisform" style="margin: 0px;" action="<?php echo $_SERVER['SCRIPT_NAME'];?>" method="get">
<div class="Form">
<div class="Heading"><?php echo $HeadingText;?></div>
<?php
?>
<input type="text" name="domain" class="Domain" value="<?php echo $domain;?>" onFocus="this.select();" />
<?php
	if( $TldOptions){	// if listing tlds as a <select> box
?><b>.</b> <select class="tld" name="tld"><?php echo $whois->TldOptions($tld,$AlphabeticalTlds);?></select><?php
	}
	if( $Secure ){ // should we get the user to enter a security code?
		$secure->GenerateCode();
?>
	<input type="text" class="SecureCode" name="code" />
	<img align="absmiddle" src="secureimage.php" class="SecureImage" />
<?php
	}
?>
<input type="submit" name="lookup" value="<?php echo $SubmitLabel;?>" class="Submit" />
<div class="Info">
<?php
	if( $Clean == 'optional' ){ // if cleaning is optional, give the user the option...
?>
<input type="checkbox" name="clean" value="1" <?php if( $s_clean ) echo 'CHECKED';?> />
<b>Clean Whois output?</b>
<?php
	}
	if( $Hilite == 'optional' ){ // if whois output hilighting is optional, give the user the option...
?>
<input type="checkbox" name="hilite" value="1" <?php if( $w_hilite ) echo 'CHECKED';?> />
<b>Hilight Important Fields?</b>
<?php
	}
	if( $Hilite == 'optional' || $Clean == 'optional' ) echo '<br />';
	echo $Instructions;
if( $ListTlds){	// list all supported tlds.
	echo '<br />Supported Tlds: '.join(', ', $whois->GetTlds($AlphabeticalTlds)).'.';
}
if( $Secure ){	// display the message about the security code
	echo "<br />".$SecurityMessage."<br />";
}
?>
</div>
<?php
	if( isset($ErrorMessage ) ){ 	// display any error messages...
?><div class="Error"><?php echo $ErrorMessage;?></div><?php
	}
?>
</div>
</form>
<!-- 
	a little bit of javascript that sets the keyboard focus to either the domain field,
	or the security code field if the user has just submitted the form without entering
	the correct value.
-->
<script language="JavaScript" type="text/javascript">
<!--
document.forms['whoisform'].<?php echo $nocode == true ? 'code' : 'domain';?>.focus();
//-->
</script>
<?php

/***********************************************
	Section 3 - Do the whois lookup
************************************************/

if( $dolookup == true ){ // form submitted, all ok

	if( $whois->Lookup($sld.'.'.$tld) ){ // do the lookup
?>
<div class="Results">
<table style="border: 0px;" align="center">
<tr>
<td style="font-size: 10pt; font-family: verdana, arial;">
<div class="Status">
<?php 
	echo $whois->GetStatusText(); // display the domain's status 
?>
</div>
<?php
		/*
			Display the whois data, formatting it for display as html
			We pass the values for cleaning and hilighting whois output to the GetData() function.
			The number argument passed to the GetData() and GetServerText() functions indicates
			which lookup result we want for com and net domains where there may be an additional result
			from the authoratitive server.
		*/

		if( !$OnlyShowAvailability ){

			$data = $whois->GetData(0, $Clean, $Hilite);
			if( $whois->GetServerCount() == 2 ){
				if( $OnlyShowAuth ){
					$output = '<div class="Server">'.$whois->GetServerText(1).'</div>'."\n";
					$output .='<div class="Data">'.nl2br($whois->GetData(1, $s_clean, $w_hilite)).'</div>'."\n";
				}else{
					$output = '<div class="Server">'.$whois->GetServerText(1).'</div>'."\n";
					$output .='<div class="Data">'.nl2br($whois->GetData(1, $s_clean, $w_hilite)).'</div>'."\n";
					$output .= '<div class="Server">'.$whois->GetServerText(0).'</div>'."\n";
					$output .='<div class="Data">'.nl2br($whois->GetData(0, $s_clean, $w_hilite)).'</div>'."\n";
				}
			}else{
				$output = '<div class="Server">'.$whois->GetServerText(0).'</div>'."\n";
				$output .='<div class="Data">'.nl2br($whois->GetData(0, $s_clean, $w_hilite)).'</div>'."\n";
			}
			echo $output;
		}
	}else{
			// an error occurred with the whois lookup...
?>
<div class="Error">
<?php echo $LookupError;?>
</div>
<?php
	}
?>
</td>
</tr>
</table>
<?php
}

// and thats it :)

?>
<div style="margin-top: 30px; text-align: center; font-size: 10px; color: #aaaaaa;">Powered by <a style="color: #aaaaaa; text-decoration: none;" target="_blank" href="http://aero77.com/">WhoisPHP</a></div>
</div>