<?php

// vbadvanced module which list the most recently reviewed entries in the database, naming the artist rather than the reviewer

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

$query = "
	SELECT
		lrate.ltime AS lwhenrated, lrate.linkvote AS linkvote,
		links.linkid AS linkid, links.linkname AS linkname, links.linkstatus AS linkstatus,
		links.linkuserid AS linkuserid, links.linkusername AS linkusername,
		ltoc.catid AS catid,
		lcat.catname AS linkcatname
	FROM ".THIS_TABLE."linksrate AS lrate
	LEFT JOIN ".THIS_TABLE."linkslink AS links
	ON lrate.linkid=links.linkid
	LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
	ON lrate.linkid=ltoc.linkid
	LEFT JOIN ".THIS_TABLE."linkscat AS lcat
	ON ltoc.catid=lcat.catid
	ORDER BY lrate.ltime DESC
	LIMIT ".intval($mod_options["portal_ldm_newly_reviewed_showentries"])."
	";

$links = "";
$asb = $vbulletin->db->query_read($query);
while ($rec = $vbulletin->db->fetch_array($asb)) {
	$linkid = $rec['linkid'];
	$catid = $rec['catid'];
	$linkname = $rec['linkname'];
	$linkuserid = $rec['linkuserid'];
	$linkusername = $rec['linkusername'];
	$linkcatname = $rec['linkcatname'];
	$linkstatus = $rec['linkstatus'];
	$linkurllink = get_url_atag(-1, $catid, $linkid, $linkname);
	$linkvote = iif($rec['linkvote'], $rec['linkvote'], 0);
	$linkhits = '<img src="'.$stylevar['imgdir_rating'].'/rating_'.$linkvote.'.gif" alt="'.$linkvote.' *" />';
	eval("\$links .= \"".fetch_template("adv_portal_custom_ldm_newly_reviewed_one")."\";");
}

$collapseobj_custom_ldm_newly_reviewed = $vbcollapse['collapseobj_custom_ldm_newly_reviewed'];
$collapseimg_custom_ldm_newly_reviewed = $vbcollapse['collapseimg_custom_ldm_newly_reviewed'];
eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template('adv_portal_custom_ldm_newly_reviewed') . '";');

?>
