<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

// ------------------------ Per Site Definitions ------------------------------

function ldm_flashsites() {

	return array(

"DailyMotion" => array(
	"pattern" => "#(http://www.dailymotion.com/swf/[A-Za-z0-9]+)#i",
	"replace" => "$1",
	"iconpattern" => "#www.dailymotion.com/swf#",
	"icon" => "dailymotion",
	"recordhitnow" => 1,
	"template" => '

<embed src="$url" style="height:{$player_height}px; width:{$player_width}px;" type="application/x-shockwave-flash" />

',
	),

"Google" => array(
	"pattern" => "#http://video.google.com/videoplay\?docid=([-\d]+)#i",
	"replace" => "http://video.google.com/googleplayer.swf?docid=$1",
	"iconpattern" => "#video.google.com/videoplay#",
	"icon" => "google",
	"recordhitnow" => 1,
	"template" => '

<object width="$player_width" height="$player_height" type="application/x-shockwave-flash" data="$url">
	<param name="movie" value="$url" />
	<param name="wmode" value="transparent" />
<embed
	movie="$url"
	wmode="transparent"
	width="$player_width"
	height="$player_height"
	data="$url"
	align="middle"
	bgcolor="#000000"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	playerMode="normal"
	autoPlay="true"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
	<em><strong>ERROR:</strong> If you can see this, then the site is down or Flash is not installed.</em>
</object>

',
	),

"IFilm" => array(
	"pattern" => "#http://www.ifilm.com/video/([-\d]+)#i",
	"replace" => "$1",
	"iconpattern" => "#www.ifilm.com/video#",
	"icon" => "ifilm",
	"recordhitnow" => 1,
	"template" => '

<object
type="application/x-shockwave-flash"
data="http://www.ifilm.com/flash/product/ihp/player.swf"
width="$player_width"
height="$player_height" >
<param name="movie" value="http://www.ifilm.com/flash/product/ihp/loader.swf" />
<param name="width" value="$player_width" />
<param name="height" value="$player_height" />
<param name="bgcolor" value="000000" />
<param name="AllowScriptAccess" value="true" />
<param name="quality" value="high" />
<param name="allowFullScreen" value="true" />
<param name="flashvars"
value="cpath=http://www.ifilm.com/flash/container.swf&amp;tr=true&amp;baseURL=&amp;ip=true&amp;flvbaseclip=$url&amp;pre=true;it=18;dcmt=text/xml;sz=$player_widthx$player_height;srcco=1658;vidid=$url;cxtchan=;collid=;tile=3;envid=www;!c=mat1;video=full;&amp;nviews=0&amp;ifilm_session=" />
<em><strong>ERROR:</strong> If you can see this, then the site is down or Flash is not installed.</em>
</object>

',
	),

"MetaCafe" => array(
	"pattern" => "#http://www.metacafe.com/watch/([-\d]+)#i",
	"replace" => "http://www.metacafe.com/f/fp_embed.swf?itemID=$1",
	"iconpattern" => "#www.metacafe.com/watch#",
	"icon" => "metacafe",
	"recordhitnow" => 1,
	"template" => '

<embed src="$url" style="height:{$player_height}px; width:{$player_width}px;" />

',
	),

"MySpace" => array(
	"pattern" => "#http://vids.myspace.com/index.cfm\?fuseaction=vids.individual&videoID=([0-9]+)#i",
	"replace" => "$1",
	"iconpattern" => "#vids.myspace.com/index.cfm#",
	"icon" => "myspace",
	"recordhitnow" => 1,
	"template" => '

<embed src="http://lads.myspace.com/videos/vplayer.swf?m=$url" height={$player_height} width={$player_width} />

',
	),

"PutFile" => array(
	"pattern" => "#http://media.putfile.com/.+#i",
	"templatefunc" => "ldm_FlashSite_PutFile",
	"iconpattern" => "#media.putfile.com/#",
	"icon" => "flv",
	"recordhitnow" => 1,
	),

"Sharkle" => array(
	"pattern" => "#http://www.sharkle.com/video/\d+#i",
	"templatefunc" => "ldm_FlashSite_sharkle",
	"iconpattern" => "#www.sharkle.com/video#",
	"icon" => "flv",
	"recordhitnow" => 1,
	),

"StreetFire" => array(
	"pattern" => "#http://videos.streetfire.net/video/([-a-zA-Z0-9]+)\.htm#i",
	"replace" => "$1",
	"iconpattern" => "#videos.streetfire.net/video#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://videos.streetfire.net/vidiac.swf"
	FlashVars="video=$url"
	quality="high"
	bgcolor="#ffffff"
	width="$player_width"
	height="$player_height"
	name="ePlayer"
	align="middle"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />

',
	),

"ThatVideoSite" => array(
	"pattern" => "#http://www.thatvideosite.com/video/\d+#i",
	"templatefunc" => "ldm_FlashSite_thatvideosite",
	"iconpattern" => "#www.thatvideosite.com/video#",
	"icon" => "flv",
	"recordhitnow" => 1,
	),

"Veoh" => array(
	"pattern" => "#http://www.veoh.com/videos/([a-z0-9]*)#i",
	"replace" => "$1",
	"iconpattern" => "#www.veoh.com/videos#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://www.veoh.com/videodetails.swf?permalinkId=$url&id=1&player=videodetails&videoAutoPlay=0"
	width="$player_width"
	height="$player_height"
	bgcolor="#000000"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />

',
	),

"Videac" => array(
	"pattern" => "#http://www.vidiac.com/.+/([-a-zA-Z0-9]+).htm#i",
	"replace" => "$1",
	"iconpattern" => "#www.vidiac.com/#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<embed
src="http://www.vidiac.com/vidiac.swf"
FlashVars="video=$url"
quality="high"
bgcolor="#ffffff"
width="$player_width"
height="$player_height"
name="ePlayer"
align="middle"
allowScriptAccess="sameDomain"
type="application/x-shockwave-flash"
pluginspage="http://www.macromedia.com/go/getflashplayer" />

',
	),

"VSocial" => array(
	"pattern" => "#http://www.vsocial.com/video/\?d=([-\d]+)#i",
	"replace" => "http://static.vsocial.com/flash/ups.swf?d=$1&a=1",
	"iconpattern" => "#www.vsocial.com/video#",
	"icon" => "vsocial",
	"recordhitnow" => 1,
	"template" => '

<embed src="$url" style="height:{$player_height}px; width:{$player_width}px;" />

',
	),

"YouTube" => array(
	"pattern" => "#http://(www.youtube|youtube)\.com/watch\?v=([\w-]+)#i",
	"replace" => "http://www.youtube.com/v/$2",
	"iconpattern" => "#www.youtube.com/watch#",
	"icon" => "youtube",
	"recordhitnow" => 1,
	"template" => '

<object
width="$player_width"
height="$player_height"
type="application/x-shockwave-flash"
data="$url">
	<param name="movie" value="$url" />
	<param name="wmode" value="transparent" />
<embed
	movie="$url"
	wmode="transparent"
	width="$player_width"
	height="$player_height"
	data="$url"
	align="middle"
	bgcolor="#000000"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	playerMode="normal"
	autoPlay="true"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
	<em><strong>ERROR:</strong> If you can see this, then the site is down or you don"t have Flash installed.</em>
</object>

',
	),

// keep this at the end ---- Picks up other Flash files and play them through Jeroen Wijering's player ----------------

"GeneralFlash" => array(
	"pattern" => "#(.*\.flv)$#i",
	"replace" => "$1",
	"iconpattern" => "#.*\.flv#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="getid3/flvplayer.swf"
	width="$player_width"
	height="$player_height"
	bgcolor="#FFFFFF"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer"
	flashvars="file=$url&showdigits=true&autostart=true" />

',
	),

// keep this at the end -----------------------------------

	);

}

function ldm_FlashSite_thatvideosite($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetchpage($linkurl);
	if (preg_match("#(<embed src='http://thatvideosite.voxcdn.com/.*?</embed>)#i", $content, $match)) {
		return $match[1];
	}
}

function ldm_FlashSite_PutFile($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetchpage($linkurl);

	if (preg_match("#(<embed type=\"application/x-mplayer2\" .*?</embed>)#is", $content, $match)) {
		return preg_replace("/\"/", "\\\"", $match[1]);
	}

	if (preg_match("#(<object type=\"application/x-shockwave-flash\" .*?</object>)#is", $content, $match)) {
		$object = $match[1];
		$object = preg_replace("#includes/FlowPlayer#", "http://media.putfile.com/includes/FlowPlayer", $object);
		return preg_replace("/\"/", "\\\"", $object);
	}
}

function ldm_FlashSite_sharkle($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetchpage($linkurl);

	if (preg_match("#(<embed.*?http://www.sharkle.com/externalPlayer.*?</embed>)#i", $content, $match)) {
		return $match[1];
	}
}

// ------------------------ General Code --------------------------------------

function ldm_FlashSite_id($playerid, $linkid, $linkurl, $filetype) {

	$flashsites = ldm_flashsites();

	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['pattern'], $linkurl)) {
			return $playerid;
		}
	}

	return -1;
}

function ldm_FlashSite_bit($playerid, $linkid, $linkurl) {
	global $ldm_players, $LINK_OK;

	$flashsites = ldm_flashsites();

	$url = "";
	$template = "";

	$recordhitnow = 0;
	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['pattern'], $linkurl)) {
			if ($thissite['templatefunc']) {
				$templatefunc = $thissite['templatefunc'];
				$template = $templatefunc($linkurl);
				$recordhitnow = $thissite['recordhitnow'];
				break;
			}
			elseif ($thissite['replace']) {
				$url = preg_replace($thissite['pattern'], $thissite['replace'], $linkurl);
				$template = str_replace("\\'", "'", addslashes($thissite['template']));
				$recordhitnow = $thissite['recordhitnow'];
				break;
			}
		}
	}

// Set up required environment
	$thisplayer = $ldm_players[$playerid];
	$thisplayer_vars = iif(isset($thisplayer['vars']),$thisplayer['vars'],"");
	foreach ($thisplayer["vars"] as $thisvar=>$thisval) {
		${$thisvar} = $thisval;
	}

	if ($recordhitnow) {
		$hit = record_hit($linkid, $linkurl, $LINK_OK); // currently do not try to track bandwidth
	}

	eval("\$playerbit_player = \"$template\";");

	return $playerbit_player;

}

function ldm_FlashSite_typebit($linkurl) {
	$flashsites = ldm_flashsites();

	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['iconpattern'], $linkurl)) {
			return $thissite['icon'];
		}
	}

	return "";
}
?>