/*======================================================================*\
|| Javascript functions used in LDM                              ||
\*======================================================================*/

/**
* Hide all 'object_N' except the k-th 
*
* @param	string	Object prefix
* @param	int		Object to display
* @param	int		Total number of objects to scan
*/

function ldm_show(object, k, n) {
	for (var i=1; i <= n; i++) {
		obj = fetch_object(object+i);
		if (i==k) {
			obj.style.display = '';
		}
		else {
			obj.style.display = 'none';
		}
	}
}

/**
* Restrict textbox to maxlen characters 
*
* @param	string	Field name
* @param	int		Maximum length of text
*/

function ldm_textLimit(field, maxlen) {
	if (field.value.length > maxlen) {
		field.value = field.value.substring(0, maxlen);
	}
}

/**
* Force field to contain only valid DOI characters 
*
* @param	string	Field name
*/

function ldm_textDOI(field) {
	field.value = field.value.replace(/[^a-zA-Z0-9-_]+/g, "");
}

/**
* Create a popup window pointing to given url 
*
* @param	string	URL
*/

function ldm_popup(URL) {
	window.open(URL, 'player', 'width=$links_defaults[musicbox_standalone_width],height=$links_defaults[musicbox_standalone_height],toolbar=no,personalbar=no,location=no,directories=no,statusbar=no,menubar=no,status=no,resizable=yes,left=60,screenX=60,top=100,screenY=100');
}

/**
* Resize textbox to be given size 
*
* @param	int		Rows
* @param	int		columns
* @param	string	Field id
*/

function ldm_resize_area(rows, cols, id) {
	var area = fetch_object(id);
	if (typeof area.orig_rows == 'undefined') {
		area.orig_rows = area.rows;
		area.orig_cols = area.cols;
	}

	var newrows = area.rows + rows;
	var newcols = area.cols + cols;

	if (newrows >= area.orig_rows && newcols >= area.orig_cols) {
		area.rows = newrows;
		area.cols = newcols;
	}

	return false;
}

/**
* Set height and width attributes for object id 
*
* @param	int		Height
* @param	int		Width
* @param	string	Field id
*/

function ldm_size_style(height, width, id) {
	var myobj = fetch_object(id);
	myobj.style.height = height;
	myobj.style.width = width;
	return false;
}

/**
* Trap and disable enter key
*
*/

function ldm_noenter() {
	return !(window.event && window.event.keyCode == 13);
}

/**
* Set all fields within form object called X_revert to the current value of the form's allbox 
*
* @param	string	Form object
*/

function ldm_toggle_all_revert(formobj)
{
	setto = formobj.allbox.checked;
	is_revert = "";
	for (var i =0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		elm_re = new RegExp("^.+_revert$");
		is_revert = elm.name.replace(elm_re, 'revert');
		if (is_revert == "revert")
		{
			elm.checked = setto;
		}
	}
}

/**
* Set form field with given id to the inverse of the given settingId 
*
* @param	string	Field to set
* @param	string	Field to read
*/

function ldm_flip_field(fieldid, settingid)
{
	setto = document.getElementById(settingid).checked;
	document.getElementById(fieldid).disabled = !setto;
}

/**
* When two values match, enable field with given settingid 
*
* @param	?		Value 1
* @param	?		Value 2
* @param	string	Field id
*/

function ldm_enable_onequal(selectvalue, matchvalue, settingid)
{
	if (selectvalue == matchvalue)
	{
		settingid.disabled = false;
	}
	else {
		settingid.disabled = true;
	}
}

if (location.search.substring(1)=="focuswin") {
	window.focus();
}

