<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Main command function
/* ===========================================================================*/

if ($adminset == "bandwidth") {

	$navbits[""] = $vbphrase['ll_menu_admband'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$admin_settings = $vbulletin->db->query_first("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	if ($admin_settings['setting']) {
		$bandwidth = unserialize($admin_settings['setting']);
	}

	cache_LDMusergroup();

	foreach ($ldm_usergroup_cache as $usergroupid => $title) {
		if (!isset($bandwidth[$usergroupid]['bytesdaily']))  $bandwidth[$usergroupid]['bytesdaily']    = 0;
		if (!isset($bandwidth[$usergroupid]['bytesenable'])) $bandwidth[$usergroupid]['bytesenable']   = 0;
		if (!isset($bandwidth[$usergroupid]['filesdaily']))  $bandwidth[$usergroupid]['filesdaily']    = 0;
		if (!isset($bandwidth[$usergroupid]['filesenable'])) $bandwidth[$usergroupid]['filesenable']   = 0;
		if (!isset($bandwidth[$usergroupid]['carryforward'])) $bandwidth[$usergroupid]['carryforward'] = 1;
		if (!isset($bandwidth[$usergroupid]['uploadlimit'])) $bandwidth[$usergroupid]['uploadlimit'] = 0;
		$bandwidth[$usergroupid]['bytes'] = encode_bytes(decode_bytes($bandwidth[$usergroupid]['bytesdaily'])*$bandwidth[$usergroupid]['carryforward']);
		$bandwidth[$usergroupid]['files'] = $bandwidth[$usergroupid]['filesdaily'] * $bandwidth[$usergroupid]['carryforward'];
		$bandwidth[$usergroupid]['uploadlimit'] = encode_bytes(decode_bytes($bandwidth[$usergroupid]['uploadlimit']));
		if (!isset($bandwidth[$usergroupid]['uploadenable'])) $bandwidth[$usergroupid]['uploadenable']   = 0;
	}

	$bandwidthbit = "";
	foreach ($ldm_usergroup_cache as $usergroupid => $title) {
		$band =& $bandwidth[$usergroupid];
		$fileschecked = iif($band['filesenable'],'checked="checked"', '');
		$byteschecked = iif($band['bytesenable'],'checked="checked"', '');
		$uploadchecked = iif($band['uploadenable'],'checked="checked"', '');
		eval('$bandwidthbit .= "' . fetch_template('links_admin_bandwidth') . '";');
	}

	$time0 = TIMENOW;
	$time24 = $time0 - 24*60*60;
	$usage = array();
	$totusage = array();
	$totusage['fileshit'] = $totusage['byteshit'] =0;
	$asb = $vbulletin->db->query_read("
		SELECT username, userid, bytes
		FROM ".THIS_TABLE."linksdownloads
		WHERE usertime>'".$time24."'
		AND linkid>0
		ORDER BY username
		");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$totusage['fileshit'] += 1;
		$usage[$myrow['userid']]['fileshit'] += 1;
		$totusage['byteshit'] += $myrow['bytes'];
		$usage[$myrow['userid']]['byteshit'] += $myrow['bytes'];
		$usage[$myrow['userid']]['username'] = $myrow['username'];
	}

	$usagebit = "";
	foreach ($usage AS $userid=>$user) {
		$thisfiles = $user['fileshit'];
		$thisbytes = format_bytes($user['byteshit'], 2);
		$thisuser = unhtmlentities($user['username']);
		eval('$usagebit .= "' . fetch_template('links_admin_bandwidthuse') . '";');
	}
	$totusage['byteshit'] = format_bytes($totusage['byteshit'], 2);

	$uploadsbit = "";
	$asb = $vbulletin->db->query_read("
		SELECT linkusername, linkuserid, COUNT(linksize) AS linkuploads, SUM(linksize) AS linkuploadsize
		FROM ".THIS_TABLE."linkslink
		WHERE linkstatus=".$LINK_UPLOAD."
		GROUP BY linkusername
		ORDER BY linkusername
		");
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$totusage['filesupload'] += $myrow['linkuploads'];
		$totusage['bytesupload'] += $myrow['linkuploadsize'];
		$myrow['linkuploadsize'] = format_bytes($myrow['linkuploadsize'], 2);
		eval('$uploadsbit .= "' . fetch_template('links_admin_bandwidthuploads') . '";');
	}
	$totusage['bytesupload'] = format_bytes($totusage['bytesupload'], 2);
}


/* ===========================================================================*/
// Follow-up Action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["dobandwidth"])) {

	$vbulletin->input->clean_array_gpc('p', array(
		'bytes' => TYPE_ARRAY_STR,
		'bytesenable' => TYPE_ARRAY_INT,
		'carryforward' => TYPE_ARRAY_INT,
		'files' => TYPE_ARRAY_STR,
		'filesenable' => TYPE_ARRAY_INT,
		'uploadlimit' => TYPE_ARRAY_STR,
		'uploadenable' => TYPE_ARRAY_INT,
	));

	$admin_settings = $vbulletin->db->query_first("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	if ($admin_settings['setting']) {
		$bandwidth = unserialize($admin_settings['setting']);
	}

	cache_LDMusergroup();

	foreach ($ldm_usergroup_cache as $k=>$v) {

		if (!isset($bandwidth[$k]['carryforward'])) {
			$bandwidth[$k]['carryforward']	= 1;
		}
		if (isset($vbulletin->GPC['carryforward'][$k])) {
			$bandwidth[$k]['carryforward']	= max($vbulletin->GPC['carryforward'][$k], 1);
		}

		if (!isset($bandwidth[$k]['bytesdaily'])) {
			$bandwidth[$k]['bytesdaily']	= 0;
		}
		if (isset($vbulletin->GPC['bytes'][$k])) {
			$this_bytes = decode_bytes($vbulletin->GPC['bytes'][$k]);
			if (this_bytes<0) {
				eval(standard_error(construct_phrase($vbphrase['ll_error_decodebytes'], $v)));
			}
			$bandwidth[$k]['bytesdaily']	= max($this_bytes/$bandwidth[$k]['carryforward'], 0);
		}

		if (!isset($bandwidth[$k]['bytesenable'])) {
			$bandwidth[$k]['bytesenable']	= 0;
		}
		if (isset($vbulletin->GPC['bytesenable'][$k])) {
			$bandwidth[$k]['bytesenable']	= $vbulletin->GPC['bytesenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['bytesenable'] = 0;
		}

		if (!isset($bandwidth[$k]['filesdaily'])) {
			$bandwidth[$k]['filesdaily']	= 0;
		}
		if (isset($vbulletin->GPC['files'][$k])) {
			$bandwidth[$k]['filesdaily']	= max($vbulletin->GPC['files'][$k]/$bandwidth[$k]['carryforward'], 0);
		}

		if (!isset($bandwidth[$k]['filesenable'])) {
			$bandwidth[$k]['filesenable']	= 0;
		}
		if (isset($vbulletin->GPC['filesenable'][$k])) {
			$bandwidth[$k]['filesenable']	= $vbulletin->GPC['filesenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['filesenable'] = 0;
		}

		if (!isset($bandwidth[$k]['uploadlimit'])) {
			$bandwidth[$k]['uploadlimit']	= 0;
		}
		if (isset($vbulletin->GPC['uploadlimit'][$k])) {
			$this_bytes = decode_bytes($vbulletin->GPC['uploadlimit'][$k]);
			if (this_bytes<0) {
				eval(standard_error(construct_phrase($vbphrase['ll_error_decodebytes'], $v)));
			}
			$bandwidth[$k]['uploadlimit']	= max($this_bytes, 0);
		}

		if (!isset($bandwidth[$k]['uploadenable'])) {
			$bandwidth[$k]['uploadenable']	= 0;
		}
		if (isset($vbulletin->GPC['uploadenable'][$k])) {
			$bandwidth[$k]['uploadenable']	= $vbulletin->GPC['uploadenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['uploadenable'] = 0;
		}

	}

	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksadmin
		SET
			setting='".$vbulletin->db->escape_string(serialize($bandwidth))."'
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	$url = $ADMIN_SCRIPT.".php?set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	exit;

}

?>