<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

function parent_dir($pdir) {
	if (preg_match(":(.+)/[^/]*:", $pdir, $matches)) {
		return $matches[1];
	}
	else {
		return "/";
	}
}

/* ===========================================================================*/
// Directory scan
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["doscan"])) {

	$url = $ADMIN_SCRIPT.".php?action=admin&amp;set=categories";

	if (isset($_REQUEST['cancel'])) {
		eval(print_standard_redirect($vbphrase['ll_redirect'],0));
		exit;
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_INT,
		'dir' => TYPE_STR,
		'state' => TYPE_INT,
		'start' => TYPE_INT,
		'scanfilename' => TYPE_ARRAY_INT
	));

	$catid = $vbulletin->GPC['catid'];
	$monitor_dir = iif($vbulletin->GPC['dir'], $vbulletin->GPC['dir'], '/');
	$state = iif($vbulletin->GPC['state'], $vbulletin->GPC['state'], 0);

	$navbits = array();
	$navbits[LINKS_SCRIPT.".php"] = $master_title;
	$this_navigation_title = $navbits[$ADMIN_SCRIPT.".php"] = $vbphrase['ll_links_administration'];
	$navbits[$url] = $vbphrase['ll_menu_admcats'];
	$navbits[""] = $vbphrase['ll_scansite'].' ['.$linkscat[$catid]["catname_clean"].']';
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	if (!isset($linkscat[$catid]['catid'])) {
		eval(standard_error($vbphrase['ll_error_category'].' '.$catid.
			' <a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
		exit;
	}

	eval("\$output = \"".fetch_template('links_header')."\";");

	$fulldir = cleanto_fopen($monitor_dir);
	$ignore = array();

	if ($file_handle = @fopen(mk_file_name($fulldir,"ignore.dat"), 'r')) {
		while (!feof ($file_handle)) {
			$line = trim(fgets($file_handle, 4096));
			if ($line != '') {
				$ignore[$line] = 1;
			}
		}
		fclose ($file_handle);
	}


	switch ($state) {

// First pass through - present user the list of what's available
	case 0:

		if (!($dir_handle = @opendir($fulldir))) {
			eval(standard_error($vbphrase['ll_error_openfail'].' '.$monitor_dir.' ('.$fulldir.')'.
				'<br /><br /><a href="'.$url.'"><b>'.$vbphrase['ll_return'].'</b></a>'));
			exit;
		}

	    $d_list = array();
	    $f_list = array();
	    $skipped = array();

		$pdir = $monitor_dir;
		while (1) {
			$d_list[] = $pdir;
			if (!$pdir or $pdir == '/') break;
			$pdir = parent_dir($pdir);
		}

	    while (false !== ($file = readdir($dir_handle))) {
	    	$child_dir = mk_file_name($fulldir, $file);
			if (is_dir($child_dir)) {
				if ($file != '.' and $file != '..') {
					$d_list[] = mk_file_name($monitor_dir, $file);
				}
			}
			else {
				if ($file{0} != '.') { // never show filenames starting '.'
					$type = strtolower(substr(strrchr($file, "."), 1));
					if (get_mimetype($type)) {
						$f_list[] = $file;
					}
					else {
						$skipped[$type] += 1;
					}
				}
			}
		}
		closedir($dir_handle);
		sort($d_list);
		sort($f_list);

		$links = array();
		if (count($f_list)) {
			$fl = $f_list;
			foreach ($fl as $k=>$flk) {
				$fl[$k] = str_replace("'", "\\'", $flk);
				$fl[$k] = "'".mk_file_name($monitor_dir, $fl[$k])."'";
			}
			$fl = implode(',', $fl);
			$asb = $vbulletin->db->query_read("
				SELECT linkid, linkurl
				FROM ".THIS_TABLE."linkslink
				WHERE linkurl IN (".$fl.")
			");
			while ($data = $vbulletin->db->fetch_array($asb)) {
				$links[$data["linkurl"]] = $data["linkid"];
			}
		}

	    $dir_menu = "";
	    foreach ($d_list as $thisdir) {
			$selected = iif($thisdir==$monitor_dir, 'selected="selected"', '');
			$dir_menu .= '<option value="'.$thisdir.'" '.$selected.'>'.htmlentities($thisdir)."</option>\n";
		}

	   	eval("\$table = \"".fetch_template('links_admin_scan_start')."\";");
		$table_hid = $table_omt = $table_set = "";

	    foreach ($f_list as $file) {
			$this_one = mk_file_name($monitor_dir,$file);
			$setting = $file;
			$settingvalue = preg_replace(':":', '\\"', mk_file_name($monitor_dir, $file)); // nb not addslashes()
			$check_hid = $check_set = $check_omi = $setstyle = $explain = '';
			if (isset($ignore[$file])) {
				$check_hid = 'checked="checked"';
				$text = $vbphrase['ll_scan_ignore'];
				eval("\$table_hid .= \"".fetch_template('links_admin_scan_one')."\";");
			}
			elseif (isset($links[$this_one])) {
				$check_omi = 'checked="checked"';
				$text = $vbphrase['ll_scan_old'];
				$setstyle = "alt2";
				eval("\$table_omi .= \"".fetch_template('links_admin_scan_one')."\";");
			}
			else {
				$check_set = 'checked="checked"';
				$text = "";
				eval("\$table_set .= \"".fetch_template('links_admin_scan_one')."\";");
			}
		}

		$table = $table.$table_set.$table_omi.$table_hid;

		$hidden_setting = "";
		$state = 1;
		$endmessage = "";
		foreach ($skipped as $type=>$numf) {
			$endmessage .= $type.' ['.$numf.'] ';
		}
		if ($endmessage) {
			$endmessage = $vbphrase['ll_scan_ignmime'].$endmessage;
		}
		eval("\$table .= \"".fetch_template('links_admin_scan_end')."\";");
		$output .= $table;
		break;

// user has already selected, so start processing
	case 1:

		require_once(DIR . '/includes/local_links_misc.php');
		require_once(DIR . '/includes/functions_misc.php');
		$start_time = microtime();
		$max_time = ini_get('max_execution_time');
		$PERCYCLE = iif(!$max_time, 10, min($max_time*0.8, 20)); // seconds cpu time per pass (cost is in creating possible thumbnails)

		$start = iif ($vbulletin->GPC_exists['start'], $vbulletin->GPC['start'], 1);
		$files = $vbulletin->GPC['scanfilename'];
		$element = 0;
		$process = 1;
		$nproc   = 0;

	   	eval("\$table = \"".fetch_template('links_admin_scan_start')."\";");

		$auto_forumid = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $links_defaults['default_forumid'];
		$auto_username = $links_defaults['autocreate_username'] ? $links_defaults['autocreate_username'] :
			$links_defaults['sync_username'] ? $links_defaults['sync_username'] : $vbulletin->userinfo['username'];
		$auto_userid = $links_defaults['autocreate_userid']>0 ? $links_defaults['autocreate_userid'] :
			$links_defaults['sync_userid']>0 ? $links_defaults['sync_userid'] : $vbulletin->userinfo['userid'];

		foreach ($files as $linkurl=>$this_setting) {

			$element += 1;

			switch ($process) {

			case 1: // not yet started inserting, perhaps already done so last time round
				if ($element<$start) {
					$hidden_setting = '<input type="hidden" name="scanfilename['.$linkurl.']" value="'.$this_setting.'" />';
					$setting = construct_phrase($vbphrase['ll_scan_status_processed'],$linkurl);
				   	eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;
				}
				$process = 2;

			case 2: // now we're inserting
				$linkurl = stripslashes($linkurl);
				$hidden_setting = '<input type="hidden" name="scanfilename['.$linkurl.']" value="'.$this_setting.'" />';
				switch ($this_setting) {
				case -1:
					$setting = construct_phrase($vbphrase['ll_scan_status_ignored'],$linkurl);
				   	eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;

				case 0:
					$setting = construct_phrase($vbphrase['ll_scan_status_omitted'],$linkurl);
				   	eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");
					break;

				case 1:
					$statuscheck = $LINK_OK;
					$filesize = size_url($linkurl);
					$file = array();
					get_file_info($linkurl, $file);
					$linkuser = $vbulletin->userinfo['username'];
					$linkuserid = $vbulletin->userinfo['userid']; 
					$linkdesc	= $file['linkdesc'];
					$linkname	= $file['linkname'];
					$linkimg	= $file['linkimg'];
					$linkimgthumb	= $file['imgthumb'];
					$linkimgthumbsize = $file['imgthumbsize'];
		 			$linkdate	= TIMENOW;
					$linkfile = '';
					$linkdoi = '';
					$linkreviewfreq = 0;
					$linkdups = 1;
					$pforum = $links_defaults['default_forumid'];
					$imgstatuscheck = 0;
	 				$moderate = $LINK_ACCEPTED;

					($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

					list ($insert_status, $linkid) =
						create_ldm_entry($linkuser, $linkuserid, $linkname, $linkdoi, $linkurl, $linkfile, $linkimg,
							$linkdesc, $pforum, $filesize, $statuscheck, $imgstatuscheck,
							$linkimgthumb, $linkimgthumbsize, $moderate, $linkreviewfreq, $linkdate, $linkdups);


					if ($linkid) {
						insert_link_in_ldm_category($linkid, array($catid));
					}

// Be very careful about enabling this - it may run riot with your forums....
					if ($links_defaults['autocreate_active'] and
						$links_defaults['autocreate_active_sync'] and
						$auto_forumid>0) {

						require_once(DIR . '/includes/local_links_forumsinterface.php');
						$viewcatid = $catid;
						list($error, $message) = ldm_announce_in_forum(
							$auto_forumid,
							$links_defaults['autocreate_both_ways'],
							$linkid,
							$catid,
							$linkname,
							$linkdesc,
							(in_array(strtolower(substr(strrchr(basename($linkimg), "."), 1)), array("jpg", "gif", "png")) ? $linkimg : ""),
							$auto_username,
							$auto_userid
							);
					}

					($hook = vBulletinHook::fetch_hook('ldm_sync_link_inserted')) ? eval($hook) : false;

					$setting = construct_phrase($vbphrase['ll_scan_status_inserted'],$linkurl, $linkid);
				   	eval("\$table .= \"".fetch_template('links_admin_scan_line')."\";");

					if (fetch_microtime_difference($start_time)>$PERCYCLE) {
						$process = 3;
						$start = $element+1;
					}
					break;

				}
				break;

			case 3: // we've processed all we can manage in this cycle
				$setting = $linkurl;
				$settingvalue = $linkurl;
				$check_hid = $check_set = $check_omi = '';
				switch ($this_setting) {
				case -1:
					$check_hid = 'checked="checked"';
					break;
				case 0:
					$check_omi = 'checked="checked"';
					break;
				case 1:
					$check_set = 'checked="checked"';
				}
				eval("\$table .= \"".fetch_template('links_admin_scan_one')."\";");
				break;

			}

		}

// scan complete, what state did we leave it in?
		switch ($process) {

		case 1:
		case 2:
// everything complete, so deal with the 'ignore.dat' file
			$state = 2;
			foreach ($files as $linkurl=>$this_setting) {
				if (isset($ignore[$linkurl])) {
					if ($this_setting>=0) {
						unset($ignore[$linkurl]);
					}
				}
				elseif ($this_setting<0) {
					$ignore[$linkurl] = 1;
				}
			}
			if ($file_handle = @fopen(mk_file_name($fulldir,"ignore.dat"), 'w')) {
				foreach ($ignore as $key=>$this_ignore) {
					if (preg_match("/(.*\/)(.*)/", trim($key), $matches)) {
						fwrite($file_handle, $matches[2]."\r\n");
					}
				}
				fclose ($file_handle);
			}

			$hidden_setting = "";
			break;

		case 3:
// at least one more pass required
			break;

		}
		eval("\$table .= \"".fetch_template('links_admin_scan_end')."\";");
		$output .= $table;

	}

	eval("\$output .= \"".fetch_template('links_footer')."\";");
	print_output($output);
	exit;

}

?>