<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Create New Thread
*
* @param	str		Thread title
* @param	str		First post text
* @param	int		Forum in which to post
* @param	str		Username under which to post
* @param	int		Userid under which to post
* @param	&array	New post data structure
* @return	bool	Success/failure
*/

function ldm_create_thread($title, $message, $forumid, $username, $userid, &$newpost) {
	global $vbulletin, $vbphrase, $forumperms;

	$foruminfo = verify_id('forum', $forumid, 0, 1);
	if (!$foruminfo['forumid'] or !$foruminfo['allowposting'] or !$foruminfo['cancontainthreads'] or $foruminfo['link']) {
		return 0;
	}

	$forumperms = fetch_permissions($forumid);
	if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canpostnew'])) {
		return 0;
	}

	$errors = array();
	$newpost = array();

	$newpost['title']		= $title;
	$newpost['message']		= $message;
	$newpost['signature']	= '0';
	$newpost['parseurl']	= '1';
	$newpost['emailupdate']	= '9999';

	$poststarttime = TIMENOW;
	$newpost['posthash']	= md5($poststarttime . $vbulletin->userinfo['userid'] . $vbulletin->userinfo['salt']);

	$newpost['disablesmilies'] = 0;
	$newpost['folderid']	= 0;
	$newpost['rating']		= 0;
	$newpost['preview']		= 0;

	$cache_username = $vbulletin->userinfo['username'];
	$cache_userid = $vbulletin->userinfo['userid'];

	$vbulletin->userinfo['username'] = $userid ? $username : $vbphrase['guest'];
	$vbulletin->userinfo['userid'] = $userid;

	$cache_maxchars = $vbulletin->options['titlemaxchars'];
	$vbulletin->options['titlemaxchars'] = 0;

	if (!function_exists('build_new_post')) {
		require_once(DIR . '/includes/functions_newpost.php');
	}
	build_new_post('thread', $foruminfo, array(), array(), $newpost, $errors);

	$vbulletin->options['titlemaxchars'] = $cache_maxchars;

	$vbulletin->userinfo['username'] = $cache_username;
	$vbulletin->userinfo['userid'] = $cache_userid;

	$newpost['errors'] = $errors;
	return (count($newpost['errors']) ? 0 : 1);

}

/**
* Append post in thread
*
* @param	str		Post title
* @param	str		Post text
* @param	str		Thread rating
* @param	int		Forum in which to post
* @param	int		Thread in which to post
* @param	str		Username under which to post
* @param	int		Userid under which to post
* @param	&array	New post data structure
* @return	bool	Success/failure
*/

function ldm_append_post($title, $message, $rating, $forumid, $threadid, $username, $userid, &$newpost) {
	global $vbulletin, $vbphrase, $forumperms;

	$foruminfo = verify_id('forum', $forumid, 0, 1);
	if (!$foruminfo['forumid'] or !$foruminfo['allowposting'] or !$foruminfo['cancontainthreads'] or $foruminfo['link']) {
		return 0;
	}

	$forumperms = fetch_permissions($forumid);
	if (!($forumperms & $vbulletin->bf_ugp_forumpermissions['canpostnew'])) {
		return 0;
	}

	$threadinfo = verify_id('thread', $threadid, 0, 1);
	if (!isset($threadinfo['lastpostid'])) {
		return 0;
	}

	$errors = array();
	$newpost = array();

	$newpost['title']		= $title;
	$newpost['message']		= $message;
	$newpost['signature']	= '0';
	$newpost['rating']		= $rating;
	$newpost['parseurl']	= '1';
	$newpost['emailupdate'] = '9999';

	$postinfo = verify_id('post', $threadinfo['lastpostid'], 0, 1);

	$cache_username = $vbulletin->userinfo['username'];
	$cache_userid = $vbulletin->userinfo['userid'];

	$vbulletin->userinfo['username'] = $userid ? $username : $vbphrase['guest'];
	$vbulletin->userinfo['userid'] = $userid;

	$cache_maxchars = $vbulletin->options['titlemaxchars'];
	$vbulletin->options['titlemaxchars'] = 0;

	if (!function_exists('build_new_post')) {
		require_once(DIR . '/includes/functions_newpost.php');
	}
	build_new_post('post', $foruminfo, $threadinfo, $postinfo, $newpost, $errors);

	$vbulletin->options['titlemaxchars'] = $cache_maxchars;

	$vbulletin->userinfo['username'] = $cache_username;
	$vbulletin->userinfo['userid'] = $cache_userid;

	$newpost['errors'] = $errors;
	return (count($newpost['errors']) ? 0 : 1);

}

/**
* Announce a new entry in a forum
*
* @param	int		Forum in which to post
* @param	int		Create link one way or both ways
* @param	int		Entry linkid
* @param	int		Entry catid
* @param	str		Entry title
* @param	str		Entry description
* @param	str		Entry image url
* @param	str		Username under which to post
* @param	int		Userid under which to post
* @return	array	Success/failure, error message if any
*/

function ldm_announce_in_forum($forumid, $bothways, $linkid, $linkcatid, $linkname, $linkdesc, $linkimg, $username="", $userid=0) {
	global $vbulletin, $vbphrase;
	global $linkscat, $links_defaults;

	if ($forumid<=0) {
		return array(0, "");
	}

	$master_title = htmlspecialchars_uni(
		$links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']
			);
	$gotolink = mk_file_name($vbulletin->options['bburl'], LINKS_SCRIPT.'.php?linkid='.$linkid.'&catid='.$linkcatid);

	if (!$username) {
		$username = $vbulletin->userinfo['username'];
	}
	if (!$userid) {
		$userid = $vbulletin->userinfo['userid'];
	}

	$imglink = "";
	if ($linkimg) {
		$imgInfo = ldm_parse_url($linkimg);
		if (in_array(strtolower(substr(strrchr($imgInfo['path'], "."), 1)), array("jpg", "gif", "png"))) {
			if ($imgInfo['scheme']) {
				$imglink = '[img]'.$linkimg.'[/img]';
			}
			elseif (!$links_defaults['local_file_root']) {
				$imglink = '[img]'.mk_file_name($vbulletin->options['homeurl'], $links_defaults['local_file_root_prefix'], $linkimg).'[/img]';
			}
		}
	}

	$dateadded = ldm_date($vbulletin->options['dateformat'], TIMENOW);
	$catname = $linkscat["$linkcatid"]["catname_clean"];
	$thread_title = construct_phrase($vbphrase['ldm_thread_create_title'], $linkname, $catname, $dateadded);
	$thread_message = construct_phrase($vbphrase['ldm_thread_create_body'], $linkname, $linkdesc, $gotolink, $master_title, $imglink);

	$newpost = array();
	$create_thread = ldm_create_thread($thread_title, $thread_message, $forumid, $username, $userid, $newpost);

	if ($create_thread) {

		$ft = $vbulletin->db->query_first("
			SELECT forumid, title
			FROM ". TABLE_PREFIX . "forum
			WHERE forumid='".$forumid."'
			LIMIT 1
		");

		if ($bothways and $newpost['threadid']) {
			$link = $vbulletin->db->query_first("
				SELECT linkdesc
				FROM ". THIS_TABLE . "linkslink
				WHERE linkid='".$linkid."'
			");
			$text = construct_phrase($vbphrase['ldm_thread_create_relink'], $link['linkdesc'], $newpost['threadid']);
			$vbulletin->db->query_write("
				UPDATE ". THIS_TABLE . "linkslink
				SET
					linkdesc = '".$vbulletin->db->escape_string($text)."',
					linkthread = '".$newpost['threadid']."'
				WHERE linkid='".$linkid."'
			");
		}

		$message = construct_phrase($vbphrase['ldm_accepted_and_thread_created'], $ft['title']);
		return array(1, $message);

	}
	else {

		$errorlist = "";
		if (count($newpost['errors'])) {
			foreach ($newpost['errors'] as $thiserror) {
				$errorlist .= $thiserror.'<br />';
			}
		}
		$message = construct_phrase($vbphrase['ldm_accepted_but_thread_not_created'], $ft['title'], $errorlist);
		return array(0, $message);

	}
}

/**
* Automagically make/unmake category into a sub-forum link of forumid
*
* @param	int		Action parameter
* @param	int		Category id
* @param	int		Forum in which to create new subforum
* @param	str		Name of new forum
* @return	int		New forumid if successful, 0 otherwise
*/

function ldm_insert_cat_in_forum($autolink, $catid, $forumid, $forumname="") {
	global $vbulletin;
	global $LINKS_SCRIPT, $SEARCH_SCRIPT, $ADMIN_SCRIPT, $ACTION_SCRIPT, $RESIZE_SCRIPT;

	require_once(DIR . '/includes/functions_misc.php');
	require_once(DIR . '/includes/adminfunctions_forums.php');
	require_once(DIR . '/includes/adminfunctions.php');

	$asb = $vbulletin->db->query_read("
		SELECT * FROM " . THIS_TABLE . "linkscat
		WHERE catid = " . $catid ."
		LIMIT 1
	");
	if (!$vbulletin->db->num_rows($asb)) return(-1);
	$myrow=$vbulletin->db->fetch_array($asb);
	$vbulletin->db->free_result($asb);

	$forum_visible = iif($autolink==2, 1, 0);

// Three situations, depending on value of autolink:
// =  1: create a new link forum, hidden on forumjump
// =  2: create a new link forum, visible on forumjump
// = -1: remove an existing link forum
// = -2: keep an existing link but perhaps change the name and the forum: this is the tricky case

	$catforumlink = $myrow['catforumlink'];
	if ($autolink==(-2) and $catforumlink > 0) { // keep an existing link

// always update title
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "forum
			SET title='" . $vbulletin->db->escape_string($forumname) . "',
			    description='" . $vbulletin->db->escape_string($myrow['catdesc']) . "'
			WHERE forumid = ".$catforumlink."
		");
		build_forum_permissions();

// check if parent has changed and return if no change
		$foruminfo = $vbulletin->db->query_first("
			SELECT parentid, options FROM " . TABLE_PREFIX . "forum
			WHERE forumid = ".$catforumlink."
		");
		if ($foruminfo['parentid'] == $forumid) {
			return($catforumlink);
		}

		$forum_visible = $foruminfo['options'] & $options['showonforumjump'];

	}

	if (($autolink==(-1) or $autolink==(-2)) and $catforumlink > 0) { // remove existing forum link
		$vbulletin->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "forum
			WHERE forumid = ".$catforumlink."
		");
		build_forum_child_lists($myrow['catforum']);
		build_forum_permissions();

		$vbulletin->db->query_write("
			UPDATE " . THIS_TABLE . "linkscat
			SET catforumlink='0'
			WHERE catid = '" . $catid ."'
		");
		$myrow['catforumlink'] = 0;
	}

	if ($autolink==(1) or $autolink==(2) or $autolink==(-2)) { // create new subforum link

		if ($myrow['catforum']>0 and forumid_is_valid($myrow['catforum'])) {
			$options = array();
			$options['cancontainthreads'] = 1;
			$options['active'] = 1;
			$options['showonforumjump'] = $forum_visible;

			$forum = array();
			$forum['options'] = convert_array_to_bits($options, $vbulletin->bf_misc_forumoptions);

			$forum['daysprune'] = -1;
			$forum['displayorder'] = 1;

			$forum['title'] = $vbulletin->db->escape_string($forumname);
			$forum['title_clean'] = htmlspecialchars_uni(strip_tags($forum['title']), false);
			$forum['description'] = $myrow['catdesc'];
			$forum['link'] = $LINKS_SCRIPT.'.php?catid='.$catid;
			$forum['parentid'] = $forumid;

			$parentlist = fetch_forum_parentlist($forum['parentid']);

			$condition = '';
			if ($myrow['catforumlink'] !=0) {
				$condition = ' WHERE forumid=' . $myrow['catforumlink'] .' ';
			}
			$makeforum = fetch_query_sql($forum, 'forum', $condition);

			$vbulletin->db->query_write($makeforum);
			$new_forumid = $vbulletin->db->insert_id();

			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "forum
				SET parentlist='" . $vbulletin->db->escape_string("$new_forumid,$parentlist") . "',
				childlist = '".$new_forumid.",-1'
				WHERE forumid = ".$new_forumid."
			");

			build_forum_child_lists($forum['parentid']);
			build_forum_permissions();

			$vbulletin->db->query_write("
				UPDATE " . THIS_TABLE . "linkscat
				SET catforumlink='" . $vbulletin->db->escape_string("$new_forumid") . "'
				WHERE catid = '" . $catid ."'
			");

			return($new_forumid);
		}

	}

	return(0);

}

?>