<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Build the settings bit for given category parent list
*
* @param	int		Category parent
* @param	array	Category parents
* @param	int		All settings/over-ridable settings
* @param	int		Include an update button in the displayed form
* @return	str		Form bit
*/

function build_settings($thiscatid, $parentlist, $showall=0, $includeupdate=0) {
	global $vbulletin, $stylevar, $vbphrase, $forumjump, $vbcollapse;
	global $ldm_linkbitcache, $ldm_catbitcache, $linkscat, $ldm_usergroup_cache;
	global $DEFAULT_FORUMID, $LINKS_SCRIPT;
	global $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD;

	$cat_choice = explode(',', $thiscatid.','.$parentlist);

	$doupdate = iif($includeupdate,"dosettings","");
	$query = "SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE sequence<=".ADMIN_SETTINGS_END."
		".iif(!$showall,"AND canoverride='1'","")."
		ORDER BY sequence
		";
	$asb = $vbulletin->db->query_read($query);

	$open = 0;
	while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
		if ($admin_settings["rowtype"]=="title") {
			$open = $admin_settings["sequence"];
		}
		if (!$open) {
			continue;
		}
		if (in_array($admin_settings["catid"], $cat_choice)) {
			$master_settings[$admin_settings["settingname"]][$admin_settings["catid"]] = $admin_settings;
		}
		if ($thiscatid<0 and $admin_settings["catid"]>0) {
			$master_settings[$admin_settings["settingname"]]['catconfig'][] = $admin_settings["catid"];
		}
		if ($admin_settings["rowtype"]=="close") {
			$open = 0;
		}
	}

	$open = 0;
	$linkssettings = "";

	foreach ($master_settings as $this_set) {

		unset($admin_settings);
		$adminboxstyle = $UNKNOWN;
		$revert = "";

		foreach ($cat_choice as $catid) {
			if (isset($this_set[$catid])) {
				$admin_settings = $this_set[$catid];
				if ($thiscatid<0) {
					$adminboxstyle = $STANDARD;
					if ($admin_settings["canoverride"]) {
						$adminboxstyle = $CUSTOM;
						if (isset($this_set['catconfig'])) {
							$configs = array();
							foreach ($this_set['catconfig'] as $ts) {
								$configs[] = "<a href='".$LINKS_SCRIPT.".php?action=editcat&amp;catid=".
									$ts."' title='".$vbphrase['ll_editcat'].
									' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
							}
							$revert = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
								'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
								$vbphrase['ll_revert_cats'];
						}
						else {
							$revert = construct_phrase($vbphrase['ll_admin_can_customise'],$vbphrase['ll_none']);
						}
					}
				}
				elseif ($catid==$thiscatid) {
					$adminboxstyle = $CUSTOM;
					$revert = $vbphrase['ll_customised'].
						'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
						$vbphrase['ll_revert'];
				}
				elseif ($catid<0) {
					$adminboxstyle = $STANDARD;
				}
				else {
					$adminboxstyle = $INHERIT;
					$revert = $vbphrase['ll_inherit'];
				}
				break;
			}
		}

		if (!isset($admin_settings)) { // should not happen
			ldm_general_failure($vbphrase['ll_error_critical_settings'].' '.$thiscatid.iif($parentlist,", ".$parentlist, ""));
			exit;
		}

		$setting_remove = "";

		if ($admin_settings["rowtype"] == "title") {
			if ($open) {
				eval("\$linkssettings .= \"".fetch_template('links_admin_setting_foot')."\";");
			}
			$title = iif(isset($vbphrase[$admin_settings["setting"]]), $vbphrase[$admin_settings["setting"]], $admin_settings["setting"]);
			$settingname = $admin_settings["settingname"];
			$help = "";
			if (isset($vbphrase['ll_HELP_'.$settingname])) {
				$help = $vbphrase['ll_HELP_'.$settingname];
			}
			$a_set = "adminset_".$settingname;
			if ($admin_settings["adminid"]>=ADMIN_ADDON_START and $admin_settings["adminid"]<=ADMIN_ADDON_END) {
				$setting_remove = $settingname;
			}
			eval("\$linkssettings .= \"".fetch_template('links_admin_setting_title')."\";");
			$open = $admin_settings["sequence"];
			continue;
		}

		if ($admin_settings["rowtype"] == "close") {
			if ($open) {
				if ($open>=ADMIN_ADDON_START and $open<=ADMIN_ADDON_END and $thiscatid<0) {
					$addons .= '<span class="smallfont">
						<input type="hidden" name="remove_start[]" value="'.$open.'" />
						<input type="hidden" name="remove_end[]" value="'.$admin_settings["sequence"].'" />
						<input type="checkbox" name="remove_do[]" value="'.$open.'" />'.$vbphrase['ll_admin_delete_addonset'].
						'</span>';
				}
				eval("\$linkssettings .= \"".fetch_template('links_admin_setting_foot')."\";");
				$addons = "";
			}
			$open = 0;
			continue;
		}

		if ($admin_settings["rowtype"] == "break") {
			if ($open) {
				$dobreak = 1;
				eval("\$linkssettings .= \"".fetch_template('links_admin_setting_foot')."\";");
				$dobreak = 0;
			}
			$open = 0;
			continue;
		}

		if (!$open) {
			continue;
		}

		if (!$admin_settings["rowtitle"]) {
			$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
		}
		else {
			$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
		}

		eval("\$linkssettings .= \"".fetch_template('links_admin_onesetting_start')."\";");

		switch ($admin_settings["rowtype"]) {
		case "forum":

			if (preg_match("/(<option value=\"\d.*?<.option>.*)<\/optgroup/is", $forumjump, $local_forumjump) == 1) {
				$local_forumjump[1] = '<option value="'.$DEFAULT_FORUMID.'" >' . $vbphrase['ll_none'] . '</option>' . $local_forumjump[1];
				$local_select = $admin_settings["setting"]>0 ? $admin_settings["setting"] : $DEFAULT_FORUMID;
				$local_forumjump[1] = preg_replace("/class=\".*?\"/", "", $local_forumjump[1]);
				$local_forumjump[1] = preg_replace("/option (value=\"".$local_select."\")/", "option selected=\"selected\" $1", $local_forumjump[1]);
				$setting =
					'<div class="smallfont">' .
					'<select class="select" name="'.$admin_settings["settingname"].'[]" style="width:200px">' . $local_forumjump[1] . '</select><br />' .
					'<input type="checkbox" name="'.$admin_settings["settingname"].'_reapply" checked="checked" />' . $vbphrase['ll_forumdefault_reapply'] .
					'<input type="hidden" name="'.$admin_settings["settingname"].'_old" value="'.$admin_settings["setting"].'" />' .
					'</div>'
					;
			}
			break;

		case "forumselect":

			if (preg_match("/(<option value=\"\d.*?<.option>.*)<\/optgroup/is", $forumjump, $local_forumjump) == 1) {
				$local_forumjump[1] = '<option value="'.$DEFAULT_FORUMID.'" >' . $vbphrase['ll_none'] . '</option>' . $local_forumjump[1];
				$local_select = $admin_settings["setting"]>0 ? $admin_settings["setting"] : $DEFAULT_FORUMID;
				$local_forumjump[1] = preg_replace("/class=\".*?\"/", "", $local_forumjump[1]);
				$local_forumjump[1] = preg_replace("/option (value=\" *".$local_select." *\")/", "option selected=\"selected\" $1", $local_forumjump[1]);
				$setting =
					'<div class="smallfont">' .
					'<select class="select" name="'.$admin_settings["settingname"].'[]" style="width:200px">' . $local_forumjump[1] . '</select>' .
					'</div>';
			}
			break;

		case "category":

			$setting = construct_category_list(array($admin_settings["setting"]), 'links_addnewlink_catselect_one', 1, $admin_settings["settingname"].'[]', "catid", 0, "", 1);
			break;

		case "category_selection":

			$tcs = $admin_settings["setting"]=="links_addnewlink_catinput" ? '' : 'checked="checked"';
			$tci = $admin_settings["setting"]=="links_addnewlink_catinput" ? 'checked="checked"' : '';
			$setting = '<table width="250"><tr><td align="left"><span class="smallfont">' .
				'<input type="radio" name="template_category_selection[]" value="links_addnewlink_catselect" '.$tcs.' /> links_addnewlink_catselect<br />' .
				'<input type="radio" name="template_category_selection[]" value="links_addnewlink_catinput" '.$tci.' /> links_addnewlink_catinput' .
				'</span></td></tr></table>';
			break;

		case "catbit":

			$catbit = construct_bit_list($ldm_catbitcache, $admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $catbit . '</td></tr></table>';
			break;

		case "linkbit":

			$linkbit = construct_bit_list($ldm_linkbitcache, $admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $linkbit . '</td></tr></table>';
			break;

		case "profile":

			$setting = '<table width="250"><tr><td align="left"><span class="smallfont">';
			$fields = explode(',', $admin_settings["setting"]);

// Take care - VB version specific ==================================================
			if (VALID_VB_VERSION=="3.5") {
				$bsb = $vbulletin->db->query_read("
					SELECT *
					FROM ".TABLE_PREFIX."profilefield
					ORDER BY title
				");
				while ($myrow=$vbulletin->db->fetch_array($bsb)) {
					$chk = iif(in_array($myrow['profilefieldid'], $fields),'checked="checked"','');
					$setting .= '<input type="checkbox" name="'.$admin_settings["settingname"].'[]" value="'.$myrow['profilefieldid'].'" '.$chk.' /> '.$myrow['title'].'<br />';
				}
			}
			else {
				$bsb = $vbulletin->db->query_read("
					SELECT *
					FROM ".TABLE_PREFIX."phrase
					WHERE fieldname = 'cprofilefield'
					AND varname LIKE 'field%_title'
				");
				while ($myrow=$vbulletin->db->fetch_array($bsb)) {
					if ($id = preg_replace("/field(\d*)_title/", "$1", $myrow['varname'])) {
						$profilefieldname[$id] = $myrow['text'];
					}
				}
				$bsb = $vbulletin->db->query_read("
					SELECT *
					FROM ".TABLE_PREFIX."profilefield
				");
				while ($myrow=$vbulletin->db->fetch_array($bsb)) {
					$chk = iif(in_array($myrow['profilefieldid'], $fields),'checked="checked"','');
					$setting .= '<input type="checkbox" name="'.$admin_settings["settingname"].'[]" value="'.$myrow['profilefieldid'].'" '.$chk.' /> '.$profilefieldname[$myrow['profilefieldid']].'<br />';
				}
			}
// Take care - VB version specific ==================================================

			$setting .= '<input type="hidden" name="'.$admin_settings["settingname"].'[]" value="-1" /> ';
			$setting .= '</span></td></tr></table>';
			break;

		case "sort":

			$sortvar = $admin_settings["settingname"]."[]";
			$sortset = iif(trim($admin_settings["setting"]),$admin_settings["setting"],"");
			$sortdef = 0;
			$sortwidth = "300";
			eval("\$sortorderbit  = \"".fetch_template('links_catsortbit')."\";");
			$setting = '<table><tr><td align="left">' . $sortorderbit . '</td></tr></table>';
			break;

		case "style":

			$stylebit = construct_style_list($admin_settings["setting"], $admin_settings["settingname"]."[]");
			$setting = '<table><tr><td align="left">' . $stylebit . '</td></tr></table>';
			break;

		case "textbox":

			$setting = '<textarea class="bginput" name="' . $admin_settings["settingname"] .
				'[]" rows="4" cols="40">'.$admin_settings[setting].'</textarea>';
			break;

		case "usergroup_setting":

			$setting = "";
			cache_LDMusergroup();
			$array = preg_split("/[\s,]+/", $admin_settings['setting']);
			foreach ($ldm_usergroup_cache as $usergroupid => $title) {
				if (in_array($usergroupid, $array)) {
					$checked = 'checked="checked"';
				}
				else {
					$checked = '';
				}
				eval("\$setting .= \"".fetch_template('links_admin_oneperm')."\";");
			}
			break;

		case "username":
		case "username_one":

			$sn = $admin_settings["settingname"];
			$setting = '
	<table><tr><td align="left">
	<div id="ldmuser'.$sn.'">
	<input type="text" class="bginput" id="ldmuser'.$sn.'_txt" name="'.$admin_settings["settingname"].'[]" style="width:200px" value="'.$admin_settings["setting"].'" />
	</div>

	<div class="vbmenu_popup" id="ldmuser'.$sn.'_menu" style="display:none; z-index:50"></div>
	<script type="text/javascript" src="clientscript/vbulletin_ajax_namesugg.js"></script>
	<script type="text/javascript">
	<!--
	vbmenu_register(\'ldmuser'.$sn.'\', true);
	recip_sugg'.$sn.' = new vB_AJAX_NameSuggest(\'recip_sugg'.$sn.'\', \'ldmuser'.$sn.'_txt\', \'ldmuser'.$sn.'\');
	recip_sugg'.$sn.iif($admin_settings["rowtype"]=="username",'.allow_multiple = true;','.allow_multiple = false;').'
	//-->
	</script>
	</td></tr>
	</table>
						';
			break;

		case "yesno":

			$ly  = $admin_settings['setting'] ? 'checked="checked"' : '';
			$ln  = $admin_settings['setting'] ? '' : 'checked="checked"';
			$setting = '<span class="smallfont"><input type="radio" name="' . $admin_settings['settingname'] .
				'[]" value="1" '.$ly.' />&nbsp;' . $vbphrase['ll_yes'] . '&nbsp;' .
				'<input type="radio" name="' . $admin_settings['settingname'] . '[]" value="0" ' .
				$ln . ' />&nbsp;' . $vbphrase['ll_no'] . '</span>';
			break;

		default:

			$setting = '<input class="bginput" type="text" name="' . $admin_settings['settingname'] .
				'[]" value="'.htmlspecialchars($admin_settings['setting']).'" style="width:200px" />';
		}

		if ($admin_settings["rowtype"]=="usergroup_setting") {
			$linkssettings .= $setting;
			eval("\$linkssettings .= \"".fetch_template('links_admin_oneperm_end')."\";");
		}
		else {
			eval("\$linkssettings .= \"".fetch_template('links_admin_onesetting')."\";");
			eval("\$linkssettings .= \"".fetch_template('links_admin_onesetting_end')."\";");
		}
	}

	if ($open) {
		if ($open>=ADMIN_ADDON_START and $open<=ADMIN_ADDON_END and $thiscatid<0) {
			$addons .= '<span class="smallfont">
				<input type="hidden" name="remove_start[]" value="'.$open.'" />
				<input type="hidden" name="remove_end[]" value="'.$admin_settings["sequence"].'" />
				<input type="checkbox" name="remove_do[]" value="'.$open.'" />'.$vbphrase['ll_admin_delete_addonset'].
				'</span>';
		}
		eval("\$linkssettings .= \"".fetch_template('links_admin_setting_foot')."\";");
		$addons = "";
	}
	$open = 0;

	return $linkssettings;

}

/**
* Update settings for given category
*
* @param	int		Category parent
* @param	array	New settings array
* @param	&array	Returns array of errors
* @return	bool	Success/failure
*/

function update_settings($catid, $settings, &$errors) {
	global $vbulletin, $ldm_mimetype_cache, $links_defaults, $LDM_environment;

	$cache_settings = cache_LDMsettings($catid);

	$errors = array();
	$updates = array();
	$reverts = array();
	$retest = array();

	$new_local_file_root = "";
	$new_local_file_root_prefix = "";

// Check if local_file_root/prefix are changing since other settings need to know this
	if (isset($settings['local_file_root'])) {
		$new_local_file_root = trim(implode(',', $settings['local_file_root']));
		$retest['upload_dir'] = 1;
	}
	if (isset($settings['local_file_root_prefix'])) {
		$new_local_file_root_prefix = trim(implode(',', $settings['local_file_root_prefix']));
		$retest['upload_dir'] = 1;
	}

	foreach ($cache_settings as $settingname=>$currentvalue) {

		if (!isset($settings[$settingname])) continue;
		if (!is_array($settings[$settingname])) continue;

		if ($settings[$settingname."_revert"]) {
			$reverts[$settingname] = 1;
			continue;
		}

		$newsetting = trim(implode(',', $settings[$settingname]));
		if ($newsetting==$currentvalue and !$retest[$settingname]) continue;

		$error = 0;
		$errormessage = "";

		switch ($admin_settings['rowtype']) {

		case "forum":
		case "forumselect":
			if (!forumid_is_valid($newsetting)) {
				$error = 1;
				$errormessage = "Invalid forumid";
			}
			break;

		case "yesno":
			if ($newsetting) {
				$newsetting = 1;
			}
			else {
				$newsetting = 0;
			}
			break;

		}

		switch ($settingname) {

		case "force_redirect":
		case "protected_link":
		case "show_hit_parade":
			if ($newsetting != "0" and $newsetting != "1" and $newsetting != "2") {
				$error = 1;
				$errormessage = "Select 0/1/2 only";
			}
			break;

		case "default_search_all":
			if ($newsetting != "1" and $newsetting != "2" and $newsetting != "3") {
				$error = 1;
				$errormessage = "Select 1/2/3 only";
			}
			break;

		case "autocreate_username":
			if (!$newsetting) {
				$newsetting = "";
				$updates["autocreate_userid"]['setting'] = 0;
				break;
			}
			$row = $vbulletin->db->query_first("
				SELECT userid, username
				FROM ".TABLE_PREFIX."user AS user
				WHERE username = '".$vbulletin->db->escape_string($newsetting)."'
				LIMIT 1
				");
			if (isset($row['userid'])) {
				$newsetting = $row['username'];
				$updates["autocreate_userid"]['setting'] = $row['userid'];
			}
			else {
				$error = 1;
				$errormessage = "User $newsetting not recognised";
			}
			break;

		case "sync_username":
			if (!$newsetting) {
				$newsetting = "";
				$updates["sync_userid"]['setting'] = 0;
				break;
			}
			$row = $vbulletin->db->query_first("
				SELECT userid, username
				FROM ".TABLE_PREFIX."user AS user
				WHERE username = '".$vbulletin->db->escape_string($newsetting)."'
				LIMIT 1
				");
			if (isset($row['userid'])) {
				$newsetting = $row['username'];
				$updates["sync_userid"]['setting'] = $row['userid'];
			}
			else {
				$error = 1;
				$errormessage = "User $newsetting not recognised";
			}
			break;

		case "links_expiry_days":
			if (!is_valid_ldm_int($newsetting)) {
				$error = 1;
				$errormessage = "Select integer value only";
			}
			break;

		case "link_imagesize":
			if ($newsetting=='') {
				$newsetting = $vbulletin->options['attachthumbssize'];
			}
			if (!is_valid_ldm_int($newsetting, 0)) {
				$error = 1;
				$errormessage = "Select blank/0/positive value only";
			}
			break;

		case "cat_cols_display":
		case "cat_depth_indent":
		case "cat_sub_display":
		case "cat_sub_display_limit":
		case "cat_sub_display_perline":
		case "days_seen_on_portal":
		case "default_cat_dseq":
		case "default_link_dseq":
		case "dropdown_comment_and_rate":
		case "dropdown_rows_comment_and_rate":
		case "dropdown_width_comment_and_rate":
		case "featured_sites":
		case "inline_comment_and_rate":
		case "inline_rows_comment_and_rate":
		case "inline_width_comment_and_rate":
		case "link_cols_display":
		case "link_imagemagsize":
		case "link_review_freq":
		case "links_per_page":
		case "links_seen_on_portal":
		case "musicbox_files_seen":
		case "perpage_downloadtable":
		case "prune_downloadtable":
		case "search_like_favwt":
		case "search_like_hitwt":
		case "search_like_keywt":
		case "search_like_num":
		case "sync_depth":
		case "sync_freq":
		case "sync_maxcpu_allowed":
		case "sync_maxcpu_allowed_manual":
		case "timeout_hit_allow":
		case "timeout_hit_recording":
		case "word_wrap":
			if (!$newsetting) {
				$newsetting = 0;
			}
			if (!is_valid_ldm_int($newsetting, 0)) {
				$error = 1;
				$errormessage = "Select 0/positive value only";
			}
			break;

		case "cat_depth_display":
		case "musicbox_standalone_height":
		case "musicbox_standalone_width":
		case "musicbox_width":
			if (!is_valid_ldm_int($newsetting, 1)) {
				$error = 1;
				$errormessage = "Select positive value only";
			}
			break;

		case "max_textlength":
			if (!is_valid_ldm_int($newsetting, 0, 65536)) {
				$error = 1;
				$errormessage = "Select value in range 0-65536";
			}
			break;

		case "featured_linkbit":
		case "search_catbit":
		case "template_category_selection":
		case "template_altbit":
		case "template_catbit":
		case "template_linkbit":
			if (!preg_match("/^\w+$/", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid template choice";
			}
			break;

		case "default_sort_order":
			if (!preg_match("/^(N|H|D|R|30|7|1)$/i", $newsetting)) {
				$error = 1;
				$errormessage = "Not a valid sort order choice";
			}
			break;

		case "categories_seen_on_portal":
			if (!preg_match("/^[\d,]*$/", $newsetting)) {
				$error = 1;
				$errormessage = "Invalid category choice";
			}
			break;

		case "mod_rewrite":
			if ($newsetting != '') {
				$file = cleanto_fopen($newsetting);
				if ($fp = @fopen($file, "rb")) {
					fclose($fp);
				}
				else {
					$error = 1;
					$errormessage = $file." not found";
				}
			}
			break;

		case "file_icons_dir":
			if ($newsetting != '') {
				$newsetting = str_replace(DIRECTORY_SEPARATOR, "/", $newsetting);
				if (substr($newsetting, 0, 1) == '/') {
					$newsetting = substr($newsetting, 1);
				}
				if (substr($newsetting,-1, 1) != '/') {
					$newsetting .= '/';
				}
				$settings[$settingname] = array($newsetting);
				$can_access = ldm_can_accessdir($newsetting, 0);
				if (!$can_access) {
					$error = 1;
					$errormessage = "Cannot find/read directory ".$newsetting;
				}
			}
			break;

		case "thumbs_dir":
		case "upload_dir":
			if (preg_match("#http://#", $newsetting)) {
				$error = 1;
				$errormessage = "Setting must point to a local directory, not a full url";
				break;
			}
			if ($newsetting != '') {
				$newsetting = str_replace(DIRECTORY_SEPARATOR, "/", $newsetting);
				if (substr($newsetting, 0, 1) != '/') {
					$newsetting = '/'.$newsetting;
				}
				$this_dir = trim($newsetting);
				if ($settingname=="thumbs_dir") {
					$fullpath = local_filename($this_dir, 0);
				}
				if ($settingname=="upload_dir") {
					$fullpath = local_filename($this_dir, 1, $new_local_file_root, $new_local_file_root_prefix);
				}
				$check = create_test_file($fullpath);
				switch ($check) {
				case 1: // directory doesn't exist and can't create it...
					$error = 1;
					$errormessage = "Cannot access or create directory ".$this_dir;
					if (!ldm_can_openbasedir($fullpath)) {
						$errormessage .= " [".$fullpath." not within permitted <em>open_basedir</em> ".$LDM_environment['open_basedir']."]";
					}
					else {
						$errormessage .= " [".$fullpath."]";
					}
					break;
				case 2: // can't create file in directory
					$error = 1;
					$errormessage = "Cannot create a test file in ".$this_dir;
					if (!ldm_can_openbasedir($fullpath)) {
						$errormessage .= " [".$fullpath." not within permitted <em>open_basedir</em> ".$LDM_environment['open_basedir']."]";
					}
					else {
						$errormessage .= " [".$fullpath."]";
					}
					break;
				}
			}
			break;

		case "upload_maxspace":
			if (decode_bytes($newsetting)<0) {
				$error = 1;
				$errormessage = construct_phrase($vbphrase['ll_error_decodebytes'], $newsetting);
			}
			break;

		case "sync_filetypes":
		case "upload_filetypes":
			cache_mimetype();
			$limit_mimetypes = explode(',', preg_replace('/\s/','',$newsetting));
			foreach ($limit_mimetypes as $type) {
				if ($type and !isset($ldm_mimetype_cache[$type])) {
					$error = 1;
					$errormessage .= $type." ";
				}
			}
			if ($error) {
				$errormessage .= " not set in VB mimetype table";
			}
			break;
		}

// track error or flag for action
		if ($error) {
			$errors[$settingname]['value'] = $newsetting;
			$errors[$settingname]['message'] = $errormessage;
		}
		else {
			$updates[$settingname] = $admin_settings;
			$updates[$settingname]['old'] = $currentvalue;
			$updates[$settingname]['setting'] = $newsetting;
		}

	}

	if (count($errors)) {
		return 0;
	}

	if ($catid>0) {
		foreach ($reverts as $name=>$value) {
			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksadmin
				WHERE settingname = '".$name."'
				AND   catid='".$catid."'
				");
		}
	}
	else {
		foreach ($reverts as $name=>$value) {
			$vbulletin->db->query_write("
				DELETE FROM ".THIS_TABLE."linksadmin
				WHERE settingname = '".$name."'
				AND   catid>0
				");
		}
	}

	foreach ($updates as $name=>$value) {

		$bsb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksadmin
			WHERE settingname = '".$name."'
			AND catid IN ('".$catid."', -1)
		");

		unset($row);
		while ($rec = $vbulletin->db->fetch_array($bsb)) {
			$row[$rec['catid']] = $rec;
		}

		if (isset($row["$catid"])) {
			$query = "
				UPDATE ".THIS_TABLE."linksadmin
				SET
					setting='".$vbulletin->db->escape_string($value['setting'])."'
				WHERE settingname='".$name."'
				AND	catid='".$catid."'
				";
			$vbulletin->db->query_write($query);
		}
		elseif (isset($row["-1"])) {
			$query = "
				INSERT INTO ".THIS_TABLE."linksadmin
				SET
					settingname='". $vbulletin->db->escape_string($name). "',
					setting='". $vbulletin->db->escape_string($value['setting']). "',
					sequence='". $vbulletin->db->escape_string($row['-1']['sequence']). "',
					rowtype='". $vbulletin->db->escape_string($row['-1']['rowtype']). "',
					canoverride='". $vbulletin->db->escape_string($row['-1']['canoverride']). "',
					catid='". $catid. "'
				";
			$vbulletin->db->query_write($query);
		}
		else {
			ldm_general_failure("update_settings/$name");
		}

	}

	unset ($row);

	if ($updates['default_forumid'] and $settings['default_forumid_reapply']) {
		$query_cat = "
			UPDATE ".THIS_TABLE."linkscat
			SET catforum='".intval($updates['default_forumid']['setting'])."'
			WHERE catforum='".intval($updates['default_forumid']['old'])."'
		";
		$query_link = "
			UPDATE ".THIS_TABLE."linkslink
			SET linkforum='".intval($updates['default_forumid']['setting'])."'
			WHERE linkforum='".intval($updates['default_forumid']['old'])."'
		";
		$vbulletin->db->query_write($query_cat);
		$vbulletin->db->query_write($query_link);
	}

	if ($updates['profile_ldmactivity']) {
		patch_profile_dbtables($updates['profile_ldmactivity']['setting']);
	}

	if (is_array($settings['remove_do'])) {
		foreach ($settings['remove_do'] as $kval) {
			foreach ($settings['remove_start'] as $kset=>$kstart) {
				if ($kval==$settings['remove_start'][$kset]) {
					$query = "
						DELETE FROM ".THIS_TABLE."linksadmin
						WHERE sequence>= '".intval($settings['remove_start'][$kset])."'
						AND   sequence<= '".intval($settings['remove_end'][$kset])."'
					";
					$vbulletin->db->query_write($query);
					break;
				}
			}
		}
	}

	return 1;

}

/**
* Attempt to create test file, also creating directory tree if necessary
*
* @param	str		Full path to target directory
* @return	int		0=success, 1=fail at directory create/access stage, 2=fail at file create stage
*/

function create_test_file($fullpath) {
	global $LDM_environment;

	require_once(DIR . '/includes/functions_file.php');

	if (trim($LDM_environment['open_basedir'])) {
		$can_access = 0;
		foreach (explode(PATH_SEPARATOR, $LDM_environment['open_basedir']) as $thisdir) {
			$thisdir = trim($thisdir);
			if ($thisdir and preg_match("#^$thisdir#i", $fullpath)) {
				$can_access = 1;
				break;
			}
		}
		if (!$can_access) {
			return(1); // directory may exist but can't access it...
		}
	}


	if (!file_exists($fullpath)) {
		if (!vbmkdir($fullpath, 0777)) {
			return(1); // directory doesn't exist and can't create it...
		}
	}
	for ($k=0; $k<9; $k++) {
		$fullfile = mk_file_name($fullpath, rand(1000,9999).TIMENOW.rand(1000,9999).'.txt');
		if (!file_exists($fullfile)) break;
	}
	if (file_exists($fullfile)) {
		return(0); // assume ok
	}
	$fp = @fopen($fullfile, "w");
	if (!$fp) {
		return 2; // directory exists but can't create file
	}
	fclose($fp);
	@unlink($fullfile);
	return 0;
}

/**
* Build the permissions bit for given category parent list
*
* @param	int		Category parent
* @param	array	Category parents
* @param	int		All settings/over-ridable settings
* @param	int		Include an update button in the displayed form
* @param	int		Transpose permissions matrix to by-usergroup base
* @return	str		Form bit
*/

function build_permissions($thiscatid, $parentlist, $showall=0, $includeupdate=0, $transpose=0) {
	global $vbulletin, $stylevar, $vbphrase, $forumjump, $vbcollapse;
	global $linkscat, $ldm_usergroup_cache;
	global $DEFAULT_FORUMID, $LINKS_SCRIPT;
	global $UNKNOWN, $INHERIT, $CUSTOM, $STANDARD;
	global $ADMIN_SCRIPT;

	$doupdate = iif($includeupdate,"dopermissions","");
	cache_LDMusergroup();

	$cat_choice = explode(',', $thiscatid.','.$parentlist);

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE sequence<=".ADMIN_SETTINGS_END."
		".iif(!$showall,"AND canoverride='1'","")."
		ORDER BY sequence
	");

	$open = 0;
	$master_settings = array();
	while ($admin_settings = $vbulletin->db->fetch_array($asb)) {
		if ($admin_settings["rowtype"]=="title_perms") {
			$open = $admin_settings["sequence"];
		}
		if (!$open) {
			continue;
		}
		if (in_array($admin_settings["catid"], $cat_choice)) {
			$master_settings[$admin_settings["settingname"]][$admin_settings["catid"]] = $admin_settings;
		}
		if ($thiscatid<0 and $admin_settings["catid"]>0) {
			$master_settings[$admin_settings["settingname"]]['catconfig'][] = $admin_settings["catid"];
		}
		if ($admin_settings["rowtype"]=="close") {
			$open = 0;
		}
	}

	$open = 0;
	$linksperms = '';
	if ($thiscatid<0) {
		$showtranspose = $ADMIN_SCRIPT.".php?set=permissions&amp;transpose=".iif($transpose,'0','1');
	}
	else {
		$showtranspose = "";
	}
	$addons = "";
	$setting_remove = "";
	$dobreak = "";

	if ($transpose) {
// Ordered by usergroup
		$adminboxstyle = $UNKNOWN;
		$title = $vbphrase['ll_permissions'];
		$settingname = "transposed";
		eval("\$linksperms .= \"".fetch_template('links_admin_setting_title')."\";");
		$open = 1;
		foreach ($ldm_usergroup_cache as $usergroupid => $title) {
			eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_start')."\";");
			foreach ($master_settings as $this_set) {
				unset($admin_settings);
				foreach ($cat_choice as $catid) {
					if (isset($this_set[$catid])) {
						$admin_settings = $this_set[$catid];
						break;
					}
				}

				if (!isset($admin_settings)) { // should not happen
					ldm_general_failure($vbphrase['ll_error_critical_settings'].' '.$thiscatid.iif($parentlist,", ".$parentlist, ""));
					exit;
				}

				if ($admin_settings["rowtype"] == "usergroup_check") {

					if (!$admin_settings["rowtitle"]) {
						$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
					}
					else {
						$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
					}

					$array = preg_split("/[\s,]+/", $admin_settings['setting']);
					if (in_array($usergroupid, $array)) {
						$checked = 'checked="checked"';
					}
					else {
						$checked = '';
					}
					eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_perm')."\";");
				}

			}
			eval("\$linksperms .= \"".fetch_template('links_admin_onetranspose_end')."\";");
		}

	}
	else {
// Ordered by permission
		foreach ($master_settings as $this_set) {

			unset($admin_settings);
			$adminboxstyle = $UNKNOWN;
			$revert = "";

			foreach ($cat_choice as $catid) {
				if (isset($this_set[$catid])) {
					$admin_settings = $this_set[$catid];
					if ($thiscatid<0) {
						$adminboxstyle = $STANDARD;
						if ($admin_settings["canoverride"]) {
							$adminboxstyle = $CUSTOM;
							if (isset($this_set['catconfig'])) {
								$configs = array();
								foreach ($this_set['catconfig'] as $ts) {
									$configs[] = "<a href='".$LINKS_SCRIPT.".php?action=editcat&amp;catid=".
										$ts."' title='".$vbphrase['ll_editcat'].
										' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
								}
								$revert = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
									'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.
									$vbphrase['ll_revert_cats'];
							}
							else {
								$revert = construct_phrase($vbphrase['ll_admin_can_customise'],$vbphrase['ll_none']);
							}
						}
					}
					elseif ($catid==$thiscatid) {
						$adminboxstyle = $CUSTOM;
						$revert = $vbphrase['ll_customised'].'<br /><input type="checkbox" name="'.$admin_settings["settingname"].'_revert" value="1" /> '.$vbphrase['ll_revert'];
					}
					elseif ($catid<0) {
						$adminboxstyle = $STANDARD;
					}
					else {
						$adminboxstyle = $INHERIT;
						$revert = $vbphrase['ll_inherit'];
					}
					break;
				}
			}

			if (!isset($admin_settings)) { // should not happen
				ldm_general_failure($vbphrase['ll_error_critical_settings'].' '.$thiscatid.iif($parentlist,", ".$parentlist, ""));
				exit;
			}

			if ($admin_settings["rowtype"] == "title_perms") {
				if ($open) {
					eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");
				}
				$title = $vbphrase[$admin_settings["setting"]];
				$settingname = $admin_settings["settingname"];
				$help = "";
				if (isset($vbphrase['ll_HELP_'.$settingname])) {
					$help = $vbphrase['ll_HELP_'.$settingname];
				}
				$a_set = "adminset_".$settingname;
				eval("\$linksperms .= \"".fetch_template('links_admin_setting_title')."\";");
				$open = $admin_settings["sequence"];
				continue;
			}

			if ($admin_settings["rowtype"] == "close") {
				if ($open) {
					eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");
				}
				$open = 0;
				continue;
			}

			if (!$open) {
				continue;
			}

			if ($admin_settings["rowtype"] == "usergroup_check") {

				if (!$admin_settings["rowtitle"]) {
					$description = $vbphrase['ll_perms_'.$admin_settings['settingname']];
				}
				else {
					$description = isset($vbphrase[$admin_settings["rowtitle"]]) ? $vbphrase[$admin_settings["rowtitle"]] : $admin_settings["rowtitle"];
				}

				eval("\$linksperms .= \"".fetch_template('links_admin_onesetting_start')."\";");
				$array = preg_split("/[\s,]+/", $admin_settings['setting']);
				foreach ($ldm_usergroup_cache as $usergroupid => $title) {
					if (in_array($usergroupid, $array)) {
						$checked = 'checked="checked"';
					}
					else {
						$checked = '';
					}
					eval("\$linksperms .= \"".fetch_template('links_admin_oneperm')."\";");
				}
				eval("\$linksperms .= \"".fetch_template('links_admin_oneperm_end')."\";");
			}
		}

	}

	if ($open) eval("\$linksperms .= \"".fetch_template('links_admin_setting_foot')."\";");

	return $linksperms;

}

/**
* Update permissions for given category
*
* @param	int		Category parent
* @param	array	New settings array
*/

function update_permissions($catid, $settings) {
	global $vbulletin;

	$cache_settings = cache_LDMpermissions($catid);

	foreach ($cache_settings as $name=>$currentvalue) {

		if (!isset($settings[$name])) {
			continue;
		}

		$newset = $settings[$name];

// request to revert?
		if ($settings[$name."_revert"]) {
			if ($catid>0) {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid='".$catid."'
				");
			}
			else {
				$vbulletin->db->query_write("
					DELETE FROM ".THIS_TABLE."linksadmin
					WHERE settingname = '".$name."'
					AND   catid>0
				");
			}
			continue;
		}

// not reverting: sanitise old and new permission sets, in case any glitches have crept in, then
// check whether permissions have changed/differ from those inherited
		$mycurr = array();
		$mynew = array();
		$mymerge = array();
		$mycurr[-1] = $mynew[-1] = $mymerge[-1] = -1;
		foreach ($newset as $thisnew) {
			$mynew[$thisnew] = $mymerge[$thisnew] = $thisnew;
		}
		$currset = explode(",", $currentvalue);
		foreach ($currset as $thiscur) {
			$mycurr[$thiscur] = $thiscur;
			$mymerge[$thiscur] = $thiscur;
		}

		$cmerge = count($mymerge);
		$cnew = count($mynew);
		$ccurr = count($mycurr);

		if ($cmerge!=$cnew or $cmerge!=$ccurr) {
			$newsetting = implode(',', $mynew);

			$bsb = $vbulletin->db->query_read("
				SELECT *
				FROM ".THIS_TABLE."linksadmin
				WHERE settingname = '".$name."'
				AND catid IN ('".$catid."', -1)
			");

			unset($row);
			while ($rec = $vbulletin->db->fetch_array($bsb)) {
				$row[$rec['catid']] = $rec;
			}

			if (isset($row["$catid"])) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linksadmin
					SET
						setting='".$vbulletin->db->escape_string($newsetting)."'
					WHERE settingname='".$name."'
					AND	catid='".$catid."'
				");
			}
			elseif (isset($row["-1"])) {
				$vbulletin->db->query_write("
					INSERT INTO ".THIS_TABLE."linksadmin
					SET
						settingname='". $vbulletin->db->escape_string($name). "',
						setting='". $vbulletin->db->escape_string($newsetting). "',
						sequence='". $vbulletin->db->escape_string($row['-1']['sequence']). "',
						rowtype='". $vbulletin->db->escape_string($row['-1']['rowtype']). "',
						canoverride='". $vbulletin->db->escape_string($row['-1']['canoverride']). "',
						catid='". $catid. "'
				");
			}
			else {
				ldm_general_failure("update_permissions");
			}

		}
	}
}

/**
* Extend VB profiles table to add/remove LDM profile fields
*
* @param	int		Enable/disable
*/

// Take care - VB version specific
if (VALID_VB_VERSION=="3.5") {

function patch_profile_dbtables($enable) {
	global $vbulletin, $vbphrase;

	$asb = $vbulletin->db->query_read("
		SELECT profilefieldid, title
		FROM ".TABLE_PREFIX."profilefield
	");

	$gotprofile = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$gotprofile[$myrow['title']] = $myrow['profilefieldid'];
	}

	$to_patch = array($vbphrase['ldm_recent_hits'], $vbphrase['ldm_recent_entries']);

	foreach ($to_patch as $thispatch) {
		if (isset($gotprofile[$thispatch])) {
			$vbulletin->db->query_write("
				UPDATE ".TABLE_PREFIX."profilefield
				SET
					editable='".intval($enable)."'
				WHERE profilefieldid='".$gotprofile[$thispatch]."'
				");
		}
		else {
			$vbulletin->db->query_write("
				INSERT INTO ".TABLE_PREFIX."profilefield
				SET
					title='".$thispatch."',
					description='".$vbulletin->db->escape_string($vbphrase['ll_profile_showhits'])."',
					type='input',
					data='',
					def='0',
					searchable='0',
					memberlist='1',
					form='0',
					editable='".intval($enable)."'
				");
			$id = $vbulletin->db->insert_id();
			$vbulletin->db->query_write("ALTER TABLE " . TABLE_PREFIX . "userfield ADD field$id MEDIUMTEXT NOT NULL");
			$vbulletin->db->query_write("OPTIMIZE TABLE " . TABLE_PREFIX . "userfield");
		}
	}
}

}
else {

function patch_profile_dbtables($enable) {
	global $vbulletin, $vbphrase;

	$to_patch = array($vbphrase['ldm_recent_hits'], $vbphrase['ldm_recent_entries']);
	$txt_patch = array($vbphrase['ll_profile_showhits'], $vbphrase['ll_profile_showentries']);

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."phrase
		WHERE fieldname = 'cprofilefield'
		AND varname LIKE 'field%_title'
		AND text IN ('".implode("', '", $to_patch)."')
	");

	$gotprofile = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$profilefieldid[$myrow['text']] = preg_replace("/field(\d*)_title/", "$1", $myrow['varname']);
	}

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".TABLE_PREFIX."profilefield
	");

	$gotprofile = array();
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$profilefield[$myrow['profilefieldid']] = 1;
	}

	foreach ($to_patch as $thispatch) {
		if (isset($profilefieldid[$thispatch])) {
			if (!isset($profilefield[$profilefieldid[$thispatch]])) {
				$profilefieldid[$thispatch] = 0;
			}
		}
	}

	$rebuild = 0;
	$k = 0;
	while ($k<count($to_patch)) {
		if ($profilefieldid[$to_patch[$k]]) {
			$vbulletin->db->query_write("
				UPDATE ".TABLE_PREFIX."profilefield
				SET
					editable='".intval($enable)."'
				WHERE profilefieldid='".$profilefieldid[$to_patch[$k]]."'
				");
		}
		else {
			$vbulletin->db->query_write("
				INSERT INTO ".TABLE_PREFIX."profilefield
				SET
					type='input',
					data='',
					def='0',
					searchable='0',
					memberlist='1',
					form='0',
					editable='".intval($enable)."'
			");
			$id = $vbulletin->db->insert_id();
			$vbulletin->db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "userfield
				ADD field$id MEDIUMTEXT NOT NULL
				");
			$vbulletin->db->query_write("
				OPTIMIZE TABLE " . TABLE_PREFIX . "userfield
				");

			$vbulletin->db->query_write("
				REPLACE INTO " . TABLE_PREFIX . "phrase
					(languageid, fieldname, varname, text, product, username, dateline, version)
				VALUES
					(
						0,
						'cprofilefield',
						'field" . $id . "_title',
						'" . $vbulletin->db->escape_string($to_patch[$k]) .  "',
						'vbulletin',
						'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
						" . TIMENOW . ",
						'" . $vbulletin->db->escape_string($vbulletin->options['templateversion']) . "'
					),
					(
						0,
						'cprofilefield',
						'field" . $id . "_desc',
						'" . $vbulletin->db->escape_string($txt_patch[$k]) . "',
						'vbulletin',
						'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
						" . TIMENOW . ",
						'" . $vbulletin->db->escape_string($vbulletin->options['templateversion']) . "'
					)
			");
			$rebuild = 1;
		}
		$k++;
	}

	if ($rebuild) {
		require_once(DIR . '/includes/adminfunctions.php');
		require_once(DIR . '/includes/adminfunctions_language.php');
		require_once(DIR . '/includes/adminfunctions_profilefield.php');
		build_language();
		build_profilefield_cache();
	}

}

}
// Take care - VB version specific

/**
* Test for valid integer string in given range
*
* @param	str		String to test
* @param	int		Minimum value allowed
* @param	int		Maximum value allowed
* @return	bool	true/false
*/

function is_valid_ldm_int($value, $min=-999999999, $max=999999999) {
	if (preg_match("/[^\d]/", $value)) {
		return 0;
	}
	elseif ($value<$min or $value>$max) {
		return 0;
	}
	return 1;
}

/**
* Build a <select> list for linkbit/catbit template selection
*
* @param	array	Array of template choices
* @param	int		Index of pre-selected template
* @param	str		Name of variable in which selection choice is returned
* @return	str		<select> list html
*/

function construct_bit_list($bitcache, $bit_selected, $list_id) {
	global $vbphrase, $stylevar;

	$stylewidth = "width:300px";
	$selectsubmit = 0;
	$stylesize = 3;
	$select_stage = 1;
	$label = $vbphrase['ll_stylelabel'];
	eval("\$optbit = \"".fetch_template('links_listselect')."\";");

	$select_stage = 2;
	foreach ($bitcache as $styleid=>$bit) {
		$stylename  = $bit["name"];
		$stylesel = iif($styleid==$bit_selected, 1, 0);
		eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	}

	$select_stage = 3;
	eval("\$optbit .= \"".fetch_template('links_listselect')."\";");
	return $optbit;

}

/**
* Build a date/time selection bit, approximating the VB settings
*
* @param	int		Time stamp
* @return	str		Date and time bit
*/

function get_datetimebit($timestamp) {
	global $vbphrase, $vbulletin, $stylevar, $links_permissions, $links_defaults;

// approximate the site's date and time settings in the layout
	$df = iif(preg_match("/[mMn].*[Ddj]/", $vbulletin->options['dateformat']), 1, 2); // m-d or d-m
	$tf = iif(preg_match("/[hAa]/", $vbulletin->options['timeformat']), 1, 2); // 12hr or 24 hr

	$hourdiff = $vbulletin->options['hourdiff'];
	$timestamp_adjusted = max(0, $timestamp - $hourdiff);

	$year = date('Y', $timestamp_adjusted);
	$mon = date('n', $timestamp_adjusted);
	$month[$mon] = 'selected="selected"';
	$day = date('d', $timestamp_adjusted);
	$hour = iif($tf==1, date('h', $timestamp_adjusted), date('H', $timestamp_adjusted));
	$hour24 = date('H', $timestamp_adjusted);
	$min = date('i', $timestamp_adjusted);
	$ampm[date('A', $timestamp_adjusted)] = 'selected="selected"';

// select timezone and build timezone options
	require_once(DIR . '/includes/functions_misc.php');
	$timezones = fetch_timezone();
	$tzoffset = $vbulletin->userinfo['tzoffset']-$vbulletin->userinfo['dstonoff'];
	$tzoffset = (abs(round($tzoffset)-$tzoffset)<0.1) ? intval($tzoffset) : round($tzoffset, 1); 
	$timezonephrase = $timezones["$tzoffset"];
	$timezone = $vbphrase[$timezonephrase];

	$date = ldm_date($vbulletin->options['dateformat'], $timestamp);
	$time = ldm_date($vbulletin->options['timeformat'], $timestamp);
	$dateandtime = $date.' '.$time;

	eval("\$datetimebit .= \"".fetch_template('links_timebit')."\";");
	return $datetimebit;
}

/**
* Build a searchidbits select object for the saved searches
*
* @param	int		Selected search id
* @return	str		Search select bit
*/

function make_searchidbits($searchid) {
	global $vbulletin, $vbphrase;

	$vbulletin->db->query_write("
		DELETE
		FROM ".THIS_TABLE."linkssearch
		WHERE searchexpires<".TIMENOW
		);

	$asb = $vbulletin->db->query_read("
		SELECT *
		FROM ".THIS_TABLE."linkssearch
		WHERE searchusername LIKE ('".$vbulletin->db->escape_string($vbulletin->userinfo['username'])."')
		ORDER BY searchname ASC
		");
	$searchidbits = "";
	if ($vbulletin->db->num_rows($asb)) {
		$searchidbits = "<select class='select' name='searchid' size='1' style='width:300px'>";
		while ($rec = $vbulletin->db->fetch_array($asb)) {
			$searchidbits .= "<option value='".$rec['searchid']."' ".iif($searchid==$rec['searchid'],"selected='selected'","").">".
				'('.$rec['searchhits'].') '.
				$rec['searchname'].' '.
				ldm_date($vbulletin->options['dateformat'], $rec['searchtime']).
				' '.
				ldm_date($vbulletin->options['timeformat'], $rec['searchtime']).
				"</option>";
		}
		$searchidbits .= "</select>";
	}
	return $searchidbits;
}

/**
* Similar to the simple bits of the Apache mod_rewrite
* NB: no error checking at the moment. Rewrite file is assumed valid.
* Records that fail the required syntax are ignored without warning
*
* @param	str		Url to test
* @param	int		Category id
* @param	int		Entry id
* @return	mixed	Either patched url or an array of alternative urls
*/

function ldm_mod_rewrite($url, $catid="", $linkid="") {
	global $vbulletin, $vbphrase;
	global $links_defaults, $linkscat, $LDM_environment, $BASE_CAT;

	$rewrites = array();
	$rewrites_set = 0;

	if ($links_defaults['mod_rewrite']) {
		$file = cleanto_fopen($links_defaults['mod_rewrite']);
		if ($fp = @fopen($file, "rb")) {
			$contents = "";
			while (!feof($fp)) {
				$contents .= fread($fp, 8192);
			}
			fclose($fp);
			$rewrites = explode("\n", $contents);
			$rewrites_set = 1;
		}
	}

	if ($rewrites_set) {

// Set any category or entry variables
		foreach ($rewrites as $k=>$rewrite) {
			$search = array('/%\{catid\}/i', '/%\{linkid\}/i');
			$replace = array($catid, $linkid);
			$this_rewrite[$k] = preg_replace($search, $replace, $rewrites[$k]);
		}

// Process the rules
		foreach ($this_rewrite as $rewrite) {
			if (!preg_match("/RewriteRule\s+(\S+)\s+(\S+)(\s+|)(\[([^\]]+)\]|)/i", $rewrite, $matches)) {
				continue;
			}
			$flags = explode(',', preg_replace('/\s+/', '', $matches[5]));
			$lc = in_array("nocase", $flags) or in_array("NC", $flags) ? "i" : "";
			$url = preg_replace("|".$matches[1]."|".$lc, $matches[2], $url);
		}

	}

	($hook = vBulletinHook::fetch_hook('ldm_mod_rewrite_end')) ? eval($hook) : false;

	return $url;

}

/**
* Scan a directory and return list of filename and directory names with indicated filetypes
*
* @param	str		Directory to search
* @param	&str	Subdirectories found
* @param	&str	Files found
* @param	str		Filetypes
*/

function ldm_read_directory($directory, $filetypes, &$dir_list, &$fil_list) {

	$dir_list = array();
	$fil_list = array();
	$fulldir = cleanto_fopen($directory);

	if ($dir_handle = @opendir($fulldir)) {
		while (false !== ($file = readdir($dir_handle))) {
			$child_dir = mk_file_name($fulldir, $file);
			if (is_dir($child_dir)) {
				if ($file != '.' and $file != '..') {
					$dir_list[$file] = 0;
				}
			}
			else {
				if ($file{0} != '.') { // never show filenames that start '.'
					$type = strtolower(substr(strrchr($file, "."), 1));
					if (in_array($type, $filetypes)) {
						$fil_list[$file] = 0;
					}
				}
			}
		}
		closedir($dir_handle);
	}

}

/**
* Scan a directory and any subdirectories to see if there is at least one file of indicated type
*
* @param	str		Directory to search
* @param	str		Filetypes
* @return	bool	Found/not found
*/

function ldm_scan_directory($directory, $filetypes) {

	$fulldir = cleanto_fopen($directory);
	$result = 0;
	$dir_list = array();
	if ($dir_handle = @opendir($fulldir)) {
		while (!$result and false !== ($file = readdir($dir_handle))) {
			$child_dir = mk_file_name($fulldir, $file);
			if (is_dir($child_dir)) {
				if ($file != '.' and $file != '..') {
					$dir_list[] = $file;
				}
			}
			else {
				if ($file{0} != '.') { // never show filenames that start '.'
					$type = strtolower(substr(strrchr($file, "."), 1));
					if (in_array($type, $filetypes)) {
						$result = 1;
					}
				}
			}
		}
		closedir($dir_handle);
	}

	if ($result) {
		return 1;
	}
	elseif (!count($dir_list)) {
		return 0;
	}
	else {
		foreach ($dir_list as $dir) {
			if (ldm_scan_directory(mk_file_name($directory, $dir), $filetypes)) {
				return 1;
			}
		}
		return 0;
	}
}

// Synchronise category and directory according to settings
// sync_populate_categories, entries, etc. Limit maximum time spent.
// Main cost is in creating thumbnails (if enabled)
// but trawling a large directory tree is also costly

function synchronise_ldm_category($catid, $time_limit, $force_sync=0, $sync_depth=-1) {
	global $vbulletin, $links_defaults, $linkscat, $ldm_mimetype_cache;
	global $LINK_OK, $LINK_ACCEPTED;

	$directory = $linkscat[$catid]['catsyncdir'];

	if (!$directory) {
		return 1;
	}

	if (!$force_sync) {
		if ($links_defaults['sync_freq']<=0) {
			return $linkscat[$catid]['catsyncdone'];
		}
		if ($linkscat[$catid]['catsyncdone']
			and ($linkscat[$catid]['catsynctime']+$links_defaults['sync_freq'])>TIMENOW) {
			return $linkscat[$catid]['catsyncdone'];
		}
	}

	if ($time_limit<=0.5) {
		return $linkscat[$catid]['catsyncdone']; // always require at least half a second
	}

	require_once(DIR . '/includes/functions_misc.php');
	$start_time = microtime();

	($hook = vBulletinHook::fetch_hook('ldm_sync_begin')) ? eval($hook) : false;

	$linkuserid	= $links_defaults['sync_userid'] ? $links_defaults['sync_userid'] : $vbulletin->userinfo['userid'];
	$linkuser	= $links_defaults['sync_username'] ? $links_defaults['sync_username'] : $vbulletin->userinfo['username'];

	$continue = 1;
	$this_sync_depth = iif($sync_depth<0, $links_defaults['sync_depth'], $sync_depth);

	cache_mimetype();
	$def = preg_replace('/\s/','',$links_defaults['sync_filetypes']);
	$filetypes = iif($def,
		array_intersect(explode(',', strtolower($def)), array_keys($ldm_mimetype_cache)),
		array_keys($ldm_mimetype_cache));

	ldm_read_directory($directory, $filetypes, $dir_list, $fil_list);

	$cat_list = array();
	$lnk_list = array();

// Scan the category
	$query = "
		SELECT link.linkid AS linkid, link.linkurl AS linkurl, ltoc.catid AS linkcatid
			FROM ".THIS_TABLE."linkslink AS link
		LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
		ON link.linkid = ltoc.linkid
			WHERE ltoc.catid='".$catid."'
	";
	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$lnk_list[$myrow['linkurl']] = $myrow['linkid'];
	}

	foreach ($linkscat as $kcat=>$thiscat) {
		if ($thiscat['parentid']==$catid and $thiscat['catsyncdir']) {
			$cat_list[$thiscat['catsyncdir']]['catid'] = $thiscat['catid'];
			$cat_list[$thiscat['catsyncdir']]['exists'] = 0;
			$cat_list[$thiscat['catsyncdir']]['catsynctime'] = $thiscat['catsynctime'];
			if (!$thiscat['catsyncdone']) {
				$cat_list[$thiscat['catsyncdir']]['catsynctime'] -= 100;  // to give it a kick start
			}
		}
	}

// Create any new categories
	if ($links_defaults['sync_populate_categories'] and $continue) {
		foreach ($dir_list as $thisdir=>$kd) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			$subdirectory = trim(mk_file_name($directory, $thisdir));
			if (isset($cat_list[$subdirectory])) {
				$cat_list[$subdirectory]['exists'] = 1;
			}
			elseif (ldm_scan_directory($subdirectory, $filetypes)) {
				$pcatlist = "$catid,".$linkscat[$catid]['parentlist'];
				$pforum = $linkscat[$catid]['catforum'];
				$subcatid = create_ldm_category($linkuser, $linkuserid,
							$thisdir, '', '', $catid, $pcatlist, $pforum, 0, $subdirectory, 1);
				$cat_list[$subdirectory]['catid'] = $subcatid;
				$cat_list[$subdirectory]['exists'] = 1;
				$cat_list[$subdirectory]['catsynctime'] = 0;
				($hook = vBulletinHook::fetch_hook('ldm_sync_cat_inserted')) ? eval($hook) : false;
			}
		}
	}

// Remove obsolete categories and their entries
	if ($links_defaults['sync_populate_categories'] and $continue) {
		$cat_delete = array();
		foreach ($cat_list as $thiscat=>$kc) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			if (!$cat_list[$thiscat]['exists']) {
				$cat_delete[] = $cat_list[$thiscat]['catid'];
			}
			if (!ldm_scan_directory($thiscat, $filetypes)) {
				$cat_delete[] = $cat_list[$thiscat]['catid'];
			}
		}
		if (count($cat_delete)) {
			empty_ldm_category($cat_delete, 1);
			delete_ldm_category($cat_delete);
			foreach ($cat_delete as $thiscat) {
				unset($cat_list[$thiscat]);
			}
			($hook = vBulletinHook::fetch_hook('ldm_sync_cat_deleted')) ? eval($hook) : false;
		}
	}

// Add any new entries...
	if ($links_defaults['sync_populate_entries'] and $continue) {

		$auto_forumid = $links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $links_defaults['default_forumid'];
		$auto_username = $links_defaults['autocreate_username'] ? $links_defaults['autocreate_username'] :
			$links_defaults['sync_username'] ? $links_defaults['sync_username'] : $vbulletin->userinfo['username'];
		$auto_userid = $links_defaults['autocreate_userid']>0 ? $links_defaults['autocreate_userid'] :
			$links_defaults['sync_userid']>0 ? $links_defaults['sync_userid'] : $vbulletin->userinfo['userid'];

		foreach ($fil_list as $thisfil=>$thisentry) {
			if (($time_limit-fetch_microtime_difference($start_time))<0.5) {
				$continue = 0;
				break;
			}
			$linkurl = $fil_list[$thisfil] = mk_file_name($directory, $thisfil);
			if (isset($lnk_list[$linkurl])) {
				unset($lnk_list[$linkurl]);
			}
			else {
				$statuscheck = $LINK_OK;
				$filesize = size_url($linkurl);
				$file = array();
				get_file_info($linkurl, $file);
				$linkname = $file['linkname'];
				$linkdesc = $file['linkdesc'];
				$linkimg = $file['linkimg'];
				$linkimgthumb = $file['imgthumb'];
				$linkimgthumbsize = $file['imgthumbsize'];
				$linkfile = '';
				$linkdoi = '';
				$linkreviewfreq = 0;
				$linkdups = 1;
	 			$linkdate = time();
				$pforum = $links_defaults['default_forumid'];
				$imgstatuscheck = 0;
	 			$moderate = $LINK_ACCEPTED;

				($hook = vBulletinHook::fetch_hook('ldm_addlink_preinsert')) ? eval($hook) : false;

				list ($insert_status, $linkid) =
					create_ldm_entry($linkuser, $linkuserid, $linkname, $linkdoi, $linkurl, $linkfile, $linkimg,
						$linkdesc, $pforum, $filesize, $statuscheck, $imgstatuscheck,
						$linkimgthumb, $linkimgthumbsize, $moderate, $linkreviewfreq, $linkdate, $linkdups);

				if ($linkid) {
					insert_link_in_ldm_category($linkid, array($catid));
				}

// Be very careful about enabling this - it may run riot with your forums....
				if ($links_defaults['autocreate_active'] and
					$links_defaults['autocreate_active_sync'] and
					$auto_forumid>0) {

					require_once(DIR . '/includes/local_links_forumsinterface.php');
					list($error, $message) = ldm_announce_in_forum(
						$auto_forumid,
						$links_defaults['autocreate_both_ways'],
						$linkid,
						$catid,
						$linkname,
						$linkdesc,
						(in_array(strtolower(substr(strrchr(basename($linkimg), "."), 1)), array("jpg", "gif", "png")) ? $linkimg : ""),
						$auto_username,
						$auto_userid
						);
				}

				($hook = vBulletinHook::fetch_hook('ldm_sync_link_inserted')) ? eval($hook) : false;
			}
		}
	}

// Delete any entries which no longer exist...
	if ($links_defaults['sync_populate_entries'] and $continue) {
		if (count($lnk_list)) {
			delete_ldm_entry($lnk_list);
		}
		($hook = vBulletinHook::fetch_hook('ldm_sync_link_deleted')) ? eval($hook) : false;
	}

// Resynchronise children - least recently synchronised first...
	if (!function_exists('ldm_sync_cmp')) {
		function ldm_sync_cmp($a, $b) {
			global $cat_list;
			$icomp = strcmp($a['catsynctime'], $b['catsynctime']);
			if ($icomp) {
				return $icomp;
			}
			else {
				$icomp = rand(0, 2) - 1;
				return $icomp;
			}
		}
	}

	if ($links_defaults['sync_populate_categories'] and $continue) {
		usort($cat_list, "ldm_sync_cmp");
		foreach ($cat_list as $thiscat=>$kc) {
			$time_left = $time_limit-fetch_microtime_difference($start_time);
			$continue = synchronise_ldm_category($cat_list[$thiscat]['catid'], $time_left, $force_sync, $this_sync_depth-1);
			if (!$continue) {
				break;
			}
		}
	}

	if ($sync_depth<0) {
		get_linkscat();
		fix_cat_count();
	}

	$timenow = time();
	$linkscat[$catid]['catsynctime'] = $timenow;
	$linkscat[$catid]['catsyncdone'] = $continue;
	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linkscat
		SET
			catsynctime=".$timenow.",
			catsyncdone=".iif($continue,1,0)."
		WHERE catid='".intval($catid)."'
		LIMIT 1
		");

	($hook = vBulletinHook::fetch_hook('ldm_sync_end')) ? eval($hook) : false;
	return $continue;

}

// Return information on supplied file

function get_file_info($linkurl, &$file) {
	global $links_defaults;

	foreach ($file as $k=>$v) {
		unset($file[$k]);
	}

	if (!preg_match(":(.*)/([^/]*)\.(.*)$:", $linkurl, $matches)) {
		return;
	}

	$file['dir'] = $matches[1];
	$file['prefix'] = $matches[2];
	$file['type'] = $matches[3];

	($hook = vBulletinHook::fetch_hook('ldm_addlink_getfileinfo')) ? eval($hook) : false;

	if (!$file['linkname']) {
		$file['linkname'] = $file['prefix'];
	}

	if (!$file['linkdesc'] ) {
		eval('$linkdesc = "' . fetch_template($links_defaults['monitor_template'], 0, 0) . '";');
	}

	if (!$file['linkimg']) {
		set_autoimage($linkurl, $file['linkimg']);
	}

// potentially time consuming, so have the option to delay until first display
	$file['imgthumb'] = "";
	if ($file['linkimg'] and $links_defaults['thumbs_dir'] and $links_defaults['create_thumbs_oninsert']) {
		require_once(DIR . '/includes/local_links_resize.php');
		$thumb = make_thumbnail($file['linkimg'], $links_defaults['link_imagesize']);
		if ($thumb) {
			$file['imgthumb'] = save_thumbnail($thumb, $links_defaults['thumbs_dir']);
			$file['imgthumbsize'] = $links_defaults['link_imagesize'];
		}
		else {
			$file['imgthumb'] = "";
			$file['imgthumbsize'] = 0;
		}
		unset($thumb);
	}

}

function fetch_uploadinfo(&$maxupload, &$mimetypes, &$space_used, &$space_max, &$uploadinfo) {
	global $links_permissions, $links_defaults, $vbulletin, $ldm_mimetype_cache;
	global $ldm_icon_cache, $LINK_UPLOAD, $vbphrase, $stylevar, $LDM_environment;

	$maxupload = 0;
	$mimetypes = '';
	$space_max = decode_bytes($links_defaults['upload_maxspace']);
	$space_used = 0;
	$def = preg_replace('/\s/','',$links_defaults['upload_filetypes']);
	if ($def) {
		$limit_mimetypes = explode(',', $def);
	}
	else {
		$limit_mimetypes = array();
	}

	$uploadinfo = "";
	if ($links_permissions['can_upload_files'] and $links_defaults['upload_enabled']) {
		get_icons();

		if ($links_defaults['bandwidth_limit']) {
			$usergroupid = $vbulletin->userinfo['usergroupid'];
			$limit = unserialize($links_defaults['bandwidth_limit']);
			$allow_uploadenable = $limit[$usergroupid]['uploadenable'];
			$allow_uploadlimit = decode_bytes($limit[$usergroupid]['uploadlimit']);
		}

		if ($allow_uploadenable) {
			$rec = $vbulletin->db->query_first("
				SELECT SUM(linksize) AS spaceused
				FROM ".THIS_TABLE."linkslink
				WHERE linkuserid='".intval($vbulletin->userinfo['userid'])."'
				AND linkstatus=".$LINK_UPLOAD."
				");
			$space_used = iif($rec['spaceused'],$rec['spaceused'],0);
			if ($space_max) {
				$space_max = min($space_max, $allow_uploadlimit);
			}
			else {
				$space_max = $allow_uploadlimit;
			}
		}
		else {
			$rec = $vbulletin->db->query_first("
				SELECT SUM(linksize) AS spaceused
				FROM ".THIS_TABLE."linkslink
				WHERE linkstatus=".$LINK_UPLOAD."
			");
			$space_used = iif($rec['spaceused'],$rec['spaceused'],0);
		}

		if (!$space_max or $space_used<$space_max) {
			$post_max = min(decode_bytes(ini_get('upload_max_filesize')), decode_bytes(ini_get('post_max_size')));
			if ($space_max) {
				$post_max = min($space_max-$space_used, $post_max);
			}
			cache_mimetype();
			$mimes = array();
			foreach ($ldm_mimetype_cache as $type=>$mime) {
				if (count($limit_mimetypes)>0 and !in_array($type, $limit_mimetypes)) continue;
				$mimes[] = $type;
				$size = iif(!$mime['size'] or $LDM_environment['is_admin'], $post_max, $mime['size']);
				$icon = iif(isset($ldm_icon_cache[$type]), $ldm_icon_cache[$type], "");
				$maxupload = max($maxupload, $size);
				$size = format_bytes($size);
				eval("\$uploadinfo .= \"".fetch_template('links_uploadinfo')."\";");
			}
			$mimetypes = implode(', ', $mimes);
			$maxupload = min($maxupload, $post_max);
		}
	}

}

// Grab a web page, optionally recursing...
function ldm_fetchpage($url, $maxcycle=2, $grabheader=1) {
	global $READ_BUFFER_SIZE, $LDM_environment;

	$file = cleanto_fopen($url);
	$ch = 0;
	if ($LDM_environment['curl_available']) {
		$ch = @curl_init();
		@curl_setopt($ch, CURLOPT_URL, str_replace(" ", "%20", $url));
		@curl_setopt($ch, CURLOPT_TIMEOUT, 30);
		@curl_setopt($ch, CURLOPT_HEADER, $grabheader);
		@curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		@curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		@curl_setopt($ch, CURLOPT_MAXREDIRS, 5);
		@curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$contents = @curl_exec($ch);
		$error = @curl_error($ch);
		@curl_close($ch);
		if (preg_match('/<META HTTP-EQUIV=\"Refresh\" .*URL=([^\" ]*)\">/i', $contents, $matches) and $maxcycle) {
			return ldm_fetchpage($matches[1], $maxcycle-1);
		}
	}
	elseif ($LDM_environment['allow_url_fopen']) {
		$ch = @fopen($file, "rb");
		while ($contents .= fread ($ch, $READ_BUFFER_SIZE)) {
		}
		fclose($ch);
	}

	return $contents;
}

?>