<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

// fix a new set of players in the database
function dbset_ldm_players($ldm_players) {
	global $links_defaults, $vbulletin;

	require_once(DIR . '/includes/local_links_admininclude.php');

	$new_players = array();
	foreach ($ldm_players as $thisid=>$thisplayer) {
		if ($thisplayer['ismaster']) {
			$new_players['ldm_player_'.$thisplayer['name']] = serialize($thisplayer);
		}
	}

	$seq = locate_admin_space(count($new_players), ADMIN_PRIVATE_START, ADMIN_PRIVATE_END);

	foreach ($links_defaults as $thisname=>$thisdefault) {
		if (isset($new_players[$thisname])) {
			if ($new_players[$thisname]==$thisdefault) {
				unset($new_players[$thisname]);
				continue;
			}
			else {
				require_admin_row($seq++, $thisname, $new_players[$thisname], 'define_mediaplayer', 0, 1);
				$links_defaults[$thisname] = $new_players[$thisname];
				unset($new_players[$thisname]);
			}
		}
	}

	if (count($new_players)) {
		foreach ($new_players as $thisname=>$thisplayer) {
			require_admin_row($seq++, $thisname, $new_players[$thisname], 'define_mediaplayer', 0, 1);
		}
	}

}

// load local data structure from admin settings
function load_ldm_players() {
	global $ldm_players, $links_defaults, $master_settings;

	cache_LDMadmintable();

// Get the standard players
	if (!is_array($ldm_players)) {
		$ldm_players = array();

		foreach ($master_settings as $this_set) {
			if (isset($this_set[-1])) {
				if ($this_set[-1]['rowtype']=='define_mediaplayer') {
					$ldm_players[] = unserialize($this_set[-1]['setting']);
				}
			}
		}
	}

// Give people a chance to add some more...
	($hook = vBulletinHook::fetch_hook('ldm_playme_initplayers')) ? eval($hook) : false;

	usort($ldm_players, "sort_ldm_players");

}

// add a player into the local data structure
function add_ldm_player($player) {
	global $ldm_players;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	foreach ($ldm_players as $id=>$thisplayer) {
		if ($ldm_players[$id]["name"]==$player["name"]) {
			return;
		}
	}

	$ldm_players[] = $player;
	usort($ldm_players, "sort_ldm_players");

}

// sort players into current priority order
function sort_ldm_players($a, $b) {
   if ($a["priority"] == $b["priority"]) {
       return 0;
   }
   return ($a["priority"] < $b["priority"]) ? 1 : -1;
}

function edit_ldm_players() {
	global $ldm_players, $vbphrase, $stylevar;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	$playerbit = "";

	foreach ($ldm_players as $thisid=>$thisplayer) {
		$vars = "";
		foreach ($thisplayer['vars'] as $thisvar=>$thisval) {
			$vars .= $thisvar.'="'.$thisval.'", ';
		}
		eval("\$playerbit .= \"".fetch_template("links_admin_playerbit")."\";");
	}

	return $playerbit;

}

function update_ldm_players() {
	global $vbulletin, $ldm_players, $vbphrase, $stylevar;

	if (!is_array($ldm_players)) {
		load_ldm_players();
	}

	$new_players = $ldm_players;
	$vbulletin->input->clean_array_gpc('r', array(
		'bitfunc' => TYPE_ARRAY_STR,
		'enabled' => TYPE_ARRAY_INT,
		'filetypes_played' => TYPE_ARRAY_STR,
		'idfunc' => TYPE_ARRAY_STR,
		'linux' => TYPE_ARRAY_INT,
		'mac' => TYPE_ARRAY_INT,
		'playerbit' => TYPE_ARRAY_STR,
		'player_stream' => TYPE_ARRAY_STR,
		'priority' => TYPE_ARRAY_INT,
		'urlencode' => TYPE_ARRAY_INT,
		'vars' => TYPE_ARRAY_STR,
		'windows' => TYPE_ARRAY_INT,
	));

	foreach ($new_players as $thisid=>$thisplayer) {
		$new_players[$thisid]['enabled'] = iif($vbulletin->GPC['enabled'][$thisid],1,0);
		$new_players[$thisid]['filetypes_played'] = $vbulletin->GPC['filetypes_played'][$thisid];
		$new_players[$thisid]['opsys']['Windows'] = iif($vbulletin->GPC['windows'][$thisid],1,0);
		$new_players[$thisid]['opsys']['Linux'] = iif($vbulletin->GPC['linux'][$thisid],1,0);
		$new_players[$thisid]['opsys']['Mac'] = iif($vbulletin->GPC['mac'][$thisid],1,0);
		$new_players[$thisid]['playerbit'] = $vbulletin->GPC['playerbit'][$thisid];
		$new_players[$thisid]['playerbit_func'] = $vbulletin->GPC['bitfunc'][$thisid];
		$new_players[$thisid]['playerid_func'] = $vbulletin->GPC['idfunc'][$thisid];
		$new_players[$thisid]['player_stream'] = $vbulletin->GPC['player_stream'][$thisid];
		$new_players[$thisid]['priority'] = $vbulletin->GPC['priority'][$thisid];
		$new_players[$thisid]['urlencode'] = $vbulletin->GPC['urlencode'][$thisid];

		$vars = $vbulletin->GPC['vars'][$thisid];
		preg_match_all("#\s*([^=]+)\s*=\s*\"([^\"]*)\"\s*,#", $vars, $matches, PREG_SET_ORDER);
		$nvars = array();
		foreach ($matches as $m) {
			$nvars[$m[1]] = $m[2];
		}
		$new_players[$thisid]['vars'] = $nvars;
	}

	dbset_ldm_players($new_players);

}

// Select an appropriate player for given item.
// If $player is set, then that player is selected regardless of control settings
function get_playerid($linkid, $linkurl, $filetype, $player="") {
	global $ldm_players, $LDM_environment;

	load_ldm_players();

	unset($playerid);

	($hook = vBulletinHook::fetch_hook('ldm_playerid_begin')) ? eval($hook) : false;
	if (isset($playerid)) return;

	$playerid = -1;
	foreach ($ldm_players as $id=>$thisplayer) {

		$thisplayer_name = iif(isset($thisplayer['name']),$thisplayer['name'],"");
		if ($player) {
			if ($thisplayer_name==$player) {  // explicit choice of player over-rides all controls
				$playerid = $id;
				break;
			}
			else {
				continue;
			}
		}

		$thisplayer_enabled = isset($thisplayer['enabled']) ? $thisplayer['enabled'] : "";
		if (!$thisplayer_enabled) {
			continue;
		}

		if (!$thisplayer['opsys'][$LDM_environment['user_os']]) {
			continue;
		}

// id function takes precedence over filetype
		$thisplayer_idfunc = isset($thisplayer['playerid_func']) ? $thisplayer['playerid_func'] : "";
		if ($thisplayer_idfunc) {
			$playerid = $thisplayer_idfunc($id, $linkid, $linkurl, $filetype);
		}

		if ($playerid<0) {

			$link_known_mimetype = get_mimetype($filetype);

			$thisplayer_filetype = isset($thisplayer['filetypes_played']) ? $thisplayer['filetypes_played'] : "";
			if (in_array($filetype, explode(',', preg_replace("/ /", "", $thisplayer_filetype))) and $link_known_mimetype) {
				$playerid = $id;
				break;
			}
		}

	}

	return $playerid;
}

// Returns an appropriate player bit for use within LDM, with all settings pre-configured.
// If $player is set, then that player is selected regardless of control settings
function get_playerbit($linkid, $catid, $linkurl, $player="") {
	global $ldm_players, $protocol_schemes;
	global $STREAM_SCRIPT;

	load_ldm_players();

	$URLInfo = ldm_parse_url($linkurl);
	$fullurl = iif($URLInfo['host'], $linkurl, mk_file_name("http://".$_SERVER['HTTP_HOST'], $linkurl));
	$filetype = strtolower(substr(strrchr($URLInfo['path'], '.'), 1));
	$playerid = get_playerid($linkid, $linkurl, $filetype, $player);

	if (isset($ldm_players[$playerid])) {
		$thisplayer = $ldm_players[$playerid];
	}
	else {
		return "";
	}

// If a playerbit function is specified, use it to grab the player
	$thisplayer_bitfunc = iif(isset($thisplayer['playerbit_func']),$thisplayer['playerbit_func'],"");
	if ($thisplayer_bitfunc) {
		return $thisplayer_bitfunc($playerid, $linkid, $linkurl);
	}

// Otherwise, set up required environment
	$thisplayer_vars = iif(isset($thisplayer['vars']),$thisplayer['vars'],"");
	foreach ($thisplayer["vars"] as $thisvar=>$thisval) {
		${$thisvar} = $thisval;
	}

	$howtostream = iif(isset($thisplayer['player_stream']),$thisplayer['player_stream'],"url");

// *** This is a handover from 2.2.6, which should be re-done
// Does the protocol force a particular method of grabbing the bit stream?
	if (($URLInfo['scheme'] and $protocol_schemes[$URLInfo['scheme']]["musicbox"]==2)) {
		$howtostream = "url";
	}
// *** This is a handover from 2.2.6, which should be re-done

	switch ($howtostream) {
	case "url":
		$player_stream = $linkurl;
		break;
	case "fullurl":
		$player_stream = $fullurl;
		break;
	default:
		$player_stream = $STREAM_SCRIPT.".php?action=stream&linkid=".$linkid."&catid=".$catid;
	}

	$thisplayer_urlencode = iif(isset($thisplayer['urlencode']),$thisplayer['urlencode'],"");
	if ($thisplayer_urlencode) {
		$player_stream = urlencode($player_stream);
	}

	($hook = vBulletinHook::fetch_hook('ldm_playme_preplay')) ? eval($hook) : false;

	if (isset($thisplayer['playerbit'])) {
		eval("\$playerbit_player = \"".fetch_template($thisplayer['playerbit'])."\";");
		return $playerbit_player;
	}
	else {
		return "";
	}

}

?>