<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ---------------------------------------------------------------------------
	Creates a thumbnail image of the contents of an image file
	Used within LDM.
--------------------------------------------------------------------------- */

function make_thumbnail($pic, $size) {
	global $LDM_environment;

	$im = 0;
	$thumb = 0;
	unset($handle);
	unset($pic_type);
	$pic_info = ldm_parse_url($pic);

	($hook = vBulletinHook::fetch_hook('ldm_make_thumb')) ? eval($hook) : false;

	if ($thumb) {
		return $thumb;
	}

	if (!function_exists('imagecreatefromstring')) {
		ldm_debug("make_thumbnail:no imagecreatefromstring", array($pic, $size));
		return 0;
	}

	if (!in_array(strtolower(substr(strrchr(basename($pic_info['path']), "."), 1)), $LDM_environment['thumb_types'])) {
		ldm_debug("make_ldm_thumb:not pic type:", array($pic, $size));
		return make_clear_thumb();
	}

	if (!$pic_info['scheme'] and !$pic_info['host']) {

		$pic_clean = local_filename($pic);

		if (strtolower(substr(strrchr(basename($pic_info['path']), "."), 1))=='mp3') {
			$im = readID3_image($pic_clean);
			if (!$im) {
				return make_clear_thumb();
			}
			$pic_type = 'jpg';

		} else {

			$getimagesize = @getimagesize($pic_clean);
			if (!$getimagesize) {
			ldm_debug("make_ldm_thumb:getimagesize fails:", array($pic, $pic_clean));
				return make_clear_thumb();
			}

			$handle = @fopen($pic_clean, "rb");
			if (!$handle) {
				ldm_debug("make_thumbnail:local:fopen fail:", array($pic, $pic_clean));
				return make_clear_thumb();
			}
			$im = fread($handle, filesize($pic_clean));
			fclose($handle);

			if ($im and isset($getimagesize[2])) {
				switch ($getimagesize[2]) {
					case 1: $pic_type = 'gif'; break;
					case 2: $pic_type = 'jpg'; break;
					case 3: $pic_type = 'png'; break;
					default:
						ldm_debug("make_ldm_thumb:local:read but invalid getimagesize:", array($pic, $pic_clean));
						return make_clear_thumb();
				}
			}
		}

		if ($im) {
			$im = @imagecreatefromstring($im);
		}

		if (!$im) {
			ldm_debug("make_thumbnail:local:fail:drop through", array($pic, $pic_clean));
			return make_clear_thumb();
		}

	}
	elseif (in_array($pic_info['scheme'], array( "http", "https" )) and strtolower(substr(strrchr(basename($pic_info['path']), "."), 1))!='mp3') {

		$pic_clean = $pic_info['scheme'].'://'.$pic_info['host'].preg_replace("/ /", "%20", trim($pic_info['path']));
		$pic_type = strtolower(substr(strrchr(basename($pic_info['path']), "."), 1));

		if ($LDM_environment['curl_available']) {
			$conn = @curl_init();
			@curl_setopt($conn, CURLOPT_URL, $pic_clean);
			@curl_setopt($conn, CURLOPT_TIMEOUT, 30);
			@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
			@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
			@curl_setopt($conn, CURLOPT_HEADER, 0);
			@curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
			@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
			$im = @curl_exec($conn);
			$error = @curl_error($conn);
			@curl_close($conn);

		}
		elseif ($LDM_environment['allow_url_fopen']) {
			$conn = @fopen($pic_clean, "rb");
			if ($conn) {
				$im = "";
				while ($rec = fread($conn, READ_BUFFER)) {
					$im .= $rec;
				}
				fclose($conn);
			}
			$error = "fopen";

		}

		if ($im) {
			$im = @imagecreatefromstring($im);
		}

		if (!$im) {
			ldm_debug("make_thumbnail:$pic:$pic_clean:$pic_type:fail:$error");
			return make_clear_thumb();
		}

	}

	if ($im and $pic_type) {

		if ($size<=0) {
			return $im;
		}

		$old_x=imageSX($im);
		$old_y=imageSY($im);
		$thumb_w = iif ($old_x >= $old_y, (int) ($size), (int) ($size*$old_x/$old_y));
		if ($thumb_w>$old_x) {
			$thumb_w = $old_x;
		}
		$thumb_h = (int) ($thumb_w*($old_y/$old_x));
		$thumb = imagecreatetruecolor($thumb_w,$thumb_h);
		imagecopyresampled($thumb,$im,0,0,0,0,$thumb_w,$thumb_h,$old_x,$old_y);
		imagedestroy($im);
		if ($thumb) {
			return $thumb;
		}
	}

	ldm_debug("make_thumbnail:remote:fail:drop through:", array($pic, $pic_clean, $pic_type));
	return make_clear_thumb();

}

function readID3_image($FileName) {
	@include_once('getid3/getid3.php');
	if (defined('GETID3_VERSION')) {
		$getID3 = new getID3;
		$ThisFileInfo = $getID3->analyze($FileName);
		if (isset($ThisFileInfo['id3v2']['APIC'][0]['data'])) {
			return $ThisFileInfo['id3v2']['APIC'][0]['data'];
		}
	}
	return 0;
}

function save_thumbnail($thumb, $path) {

	require_once(DIR . '/includes/functions_file.php');

	if (!$thumb) return "";

	$fullpath = local_filename($path, 0);
	if (!file_exists($fullpath)) {
		if (!vbmkdir($fullpath, 0777)) {
			return ""; // can't create user directory
		}
	}

	$lfile = mk_file_name($path, rand(1000,9999).TIMENOW.'.jpg');
	$fullfile = local_filename($lfile, 0);

	$fp = @fopen($fullfile, "w");
	if (!$fp) return "";
	fclose($fp);
	imagejpeg($thumb, $fullfile);

	return $lfile;

}

function make_clear_thumb() {

	$conn = @fopen('clear.gif', "rb");
	if ($conn) {
		$thumb = "";
		while ($rec = fread($conn, READ_BUFFER)) {
			$thumb .= $rec;
		}
		fclose($conn);
		return @imagecreatefromstring($thumb);
	}

	return @imagecreatetruecolor(1,1);
}

function clear_thumbnails() {
	global $vbulletin;

	$asb = $vbulletin->db->query_read("
		SELECT linkimgthumb
		FROM ".THIS_TABLE."linkslink
		WHERE linkimgthumb!=''
	");

	while ($row=$vbulletin->db->fetch_array($asb)) {
		$lfile = $row['linkimgthumb'];
		delete_thumb($lfile);
	}

	$asb = $vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linkslink
		SET
			linkimgthumb='',
			linkimgthumbsize = '0'
		WHERE linkimgthumb!=''
	");

}

?>
