<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_admin');

if (isset($_REQUEST['set'])) {
	$_REQUEST['do'] = $_REQUEST['set'];
}

$phrasegroups = array(
	'local_links'
);

$globaltemplates = array(
	'links_addnewlink_catselect_one',
	'links_admin',
	'links_admin_bandwidth',
	'links_admin_bandwidthuploads',
	'links_admin_bandwidthuse',
	'links_admin_category',
	'links_admin_category_confirm',
	'links_admin_debugrow',
	'links_admin_environment',
	'links_admin_forum',
	'links_admin_onemimetype',
	'links_admin_oneperm',
	'links_admin_oneperm_end',
	'links_admin_onesetting',
	'links_admin_onesetting_start',
	'links_admin_onesetting_end',
	'links_admin_onetranspose_end',
	'links_admin_onetranspose_perm',
	'links_admin_onetranspose_start',
	'links_admin_options',
	'links_admin_scan_start',
	'links_admin_scan_end',
	'links_admin_scan_line',
	'links_admin_scan_one',
	'links_admin_setting_foot',
	'links_admin_setting_title',
	'links_catjump',
	'links_catsortbit',
	'links_footer',
	'links_header',
	'links_listselect',
	'links_massedit',
	'links_massedit_linkbit',
	'links_scantext',
	'links_selectkeyword',
	'navbar',
	'option'
);

$specialtemplates = array();

$actiontemplates = array(

	'linkbits' => array(
	'links_catbit',
	'links_catbit_brief',
	'links_linkbit',
	'links_linkbit_featured',
	'links_linkbit_greg',
	'links_linkbit_jukebox',
	'links_linkbit_mtop',
	'links_linkbit_photo',
	'links_linkbit_short',
	'links_linkbit_short_cent',
	'links_linkbit_short_direct',
	'links_linkbit_table',
	'links_linkbit_title',
	),

	'logjumps' => array(
	'links_admin_downloads',
	'links_admin_downloads_group',
	'links_admin_downloads_item',
	'links_admin_downloads_item_none',
	),

	'mirrors' => array(
	'links_admin_onemirror',
	),

	'players' => array(
	'links_admin_playerbit',
	),
);

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

// Administrators only

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'set' 		=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT,
));

$this_action = iif($vbulletin->GPC['action'], $vbulletin->GPC['action'], "admin");
$this_set = iif($vbulletin->GPC_exists['set'], $vbulletin->GPC['set'], "settings");

$adminset = "";
switch ($this_set) {
case "bandwidth":
case "categories":
case "debug":
case "importexport":
case "keywords":
case "linkbits":
case "logjumps":
case "mimetypes":
case "mirrors":
case "permissions":
case "players":
case "searches":
case "settings":
case "statistics":
	$adminset = $this_set;
	break;
}

$master_title = iif ($links_defaults['database_name'], $links_defaults['database_name'], $vbphrase['ll_links_database']);

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = iif($links_defaults['links_per_page']!=0, $links_defaults['links_per_page'], 25);
}

$pagenumber = iif($vbulletin->GPC_exists['page'],$vbulletin->GPC['page'],1);
$ADMIN_IMPEXP = 60; // cut-off time limit for import and export scripts
$LDM_environment['php_version'] = phpversion();

$ft = $vbulletin->db->query_read("
	SHOW VARIABLES
");
$LDM_environment['mysql_timeout'] = 0; // guess, in case not found
while ($row=$vbulletin->db->fetch_array($ft)) {
	if ($row['Variable_name'] ==  'wait_timeout') {
		$LDM_environment['mysql_timeout'] = $row['Value'];
	}
}

$myrow = $vbulletin->db->query_first("SELECT VERSION() AS version");
$LDM_environment['mysql_version'] = $myrow['version'];

function ldm_build_cat_children() {
	global $linkscat, $BASE_CAT;

	$linkscat[$BASE_CAT]['childlist'] = array();
	foreach ($linkscat as $k=>$thiscat) {
		$linkscat[$k]['childlist'] = array();
	}
	foreach ($linkscat as $k=>$thiscat) {
		if ($linkscat[$k]['parentid']) {
			$linkscat[$linkscat[$k]['parentid']]['childlist'][] = $linkscat[$k]['catid'];
		}
	}

}

function ldm_exportcattree($level) {
	global $linkscat;
	$keys = array_keys($linkscat);
	$tree = "";
	foreach ($keys as $thiskey) {
		$thiscat = $linkscat[$thiskey];
		if ($thiscat['parentid'] == $level) {
			$search = array ("'\r'", "'\n'", "'&amp;'", "'\"'");
			$replace = array ("\\\\r", "\\\\n", "&", "\"\"");
			$tree .= "category," . $thiscat["catid"] . ",\"" . preg_replace ($search, $replace, $thiscat["catname"]) . "\",\"" .
				preg_replace ($search, $replace, $thiscat["catdesc"]) . "\",\"" . $thiscat["parentlist"] . "\"\r\n";
			$tree .= ldm_exportcattree($thiscat['catid']);
		}
	}
	return $tree;
}

function ldm_dopagehead() {
	echo '<html><head><title>'.$master_title.'</title><style type="text/css">
		<!--
		body {
			background: #CCCCCC; color: #00476C; font: 10pt tahoma, arial, helvetica, sans-serif;
			margin: 5px 5px 10px 5px;
		}
		body a:link { color: #22229C; }
		body a:visited { color: #22229C; }
		body a:hover, body a:active { color: #FF4400; }
		-->
		</style>
		</head><body>';
	flush();
}

function ldm_dopagefoot() {
	echo '</body></html>';
	flush();
}

function ldm_doredirect($gotopage) {
	global $vbphrase;
	$gotopage = str_replace('&amp;', '&', $gotopage);
	echo "\n<script type=\"text/javascript\">\n";
	echo "window.location=\"$gotopage\";";
	echo "\n</script>\n";
	exit;
}

if ($links_defaults["prune_downloadtable"]>0) {
	$when = TIMENOW-24*60*60*intval($links_defaults["prune_downloadtable"]);
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksdownloads
		WHERE usertime<'".$when."'
	");
}

// Force construct_forum_jump to return a result even if user has turned off the forumjump menu
$vbulletin->options['useforumjump'] = 1;
construct_forum_jump();
if ($links_defaults['category_jump_menu']) {
	$catjumpbit = construct_category_list(array(0), "links_catjump", 0, "catid", "catid");
}

$config_warnings = array();

$asb = $vbulletin->db->query_read("
	SELECT forumid, title
	FROM ". TABLE_PREFIX . "forum
");
$forum[$DEFAULT_FORUMID] = $vbphrase['ll_forumdefault'];
while ($row=$vbulletin->db->fetch_array($asb)) {
	$forum[$row['forumid']] = $row['title'];
}

if ($LDM_environment['mysql_timeout'] and $LDM_environment['mysql_timeout']<10) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_mysql1'], $LDM_environment['mysql_timeout']);
}

if ($links_defaults['upload_enabled']) {
	if (!$links_defaults['upload_dir']) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm1'], 'upload_enabled', 'upload_dir');
	}
	if (!ldm_can_accessdir($links_defaults['upload_dir'], 1)) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'upload_dir', $links_defaults['upload_dir']);
	}
}

if (!$links_defaults['file_icons_dir']) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm2'], 'file_icons_dir');
}
elseif (!ldm_can_accessdir($links_defaults['file_icons_dir'], 0)) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'file_icons_dir', $links_defaults['file_icons_dir']);
}

if ($links_defaults['thumbs_dir']) {
	if ($links_defaults['link_imagesize']=='0') {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm1'], 'thumbs_dir', 'link_imagesize');
	}
	elseif (!ldm_can_accessdir($links_defaults['thumbs_dir'], 0)) {
		$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_ldm3'], 'thumbs_dir', $links_defaults['thumbs_dir']);
	}
}

if (!$LDM_environment['allow_url_fopen'] and !$LDM_environment['curl_available']) {
	$config_warnings[] = $vbphrase['ll_admin_vb_warning_php1'];
}

if (decode_bytes($LDM_environment['upload_max_filesize'])>decode_bytes($LDM_environment['post_max_size'])) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_php2'],$LDM_environment['upload_max_filesize'],$LDM_environment['post_max_size']);
}

if (!is_dir(LDM_DOCUMENT_ROOT)) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_server'],LDM_DOCUMENT_ROOT);
}

$myrow = $vbulletin->db->query_first("
	SELECT COUNT(*) AS hits
	FROM ". THIS_TABLE . "linksdownloads
");
$ldm_hits_recorded = $myrow['hits'];
if ($ldm_hits_recorded>10000) {
	$config_warnings[] = construct_phrase($vbphrase['ll_admin_vb_warning_downloads'],$ldm_hits_recorded);
}

$config_warnings = implode("\r\n<br />", $config_warnings);

// Check for inconsistencies between the VBulletin and LDM databases...

$vbsync_warnings = array();
cache_LDMusergroup();
$vb_usergroup = $ldm_usergroup_cache;

$ldm_usergroups = unserialize($links_defaults['bandwidth_limit']);
if (is_array($ldm_usergroups)) {
	foreach ($ldm_usergroups as $ldm_usergroupid=>$ldm_bandwidth) {
		if (isset($vb_usergroup[$ldm_usergroupid])) {
			$vb_usergroup[$ldm_usergroupid] = 0;
		}
	}
	foreach ($vb_usergroup as $vb_usergroup=>$value) {
		if ($value) {
			$vbsync_warnings[] = construct_phrase($vbphrase['ll_admin_vb_usergroup'], $value);
		}
	}
}

$vbsync_warnings = implode('<br />', $vbsync_warnings);

if (!function_exists('unhtmlentities')) {
	function unhtmlentities($string) {
	// replace numeric entities
	$string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
	$string = preg_replace('~&#([0-9]+);~e', 'chr(\\1)', $string);
	// replace literal entities
	$trans_tbl = get_html_translation_table(HTML_ENTITIES);
	$trans_tbl = array_flip($trans_tbl);
	return strtr($string, $trans_tbl);
	}
}

get_icons();

// Main Administration Functions

if ($this_action == "admin") {

	($hook = vBulletinHook::fetch_hook('ldm_start')) ? eval($hook) : false;
	($hook = vBulletinHook::fetch_hook('ldm_admin_start')) ? eval($hook) : false;

	$navbits = array();
	$navbits[$LINKS_SCRIPT.".php"] = $master_title;
	$this_navigation_title = $navbits[$ADMIN_SCRIPT.".php"] = $vbphrase['ll_links_administration'];

	eval('$adminoptions = "' . fetch_template('links_admin_options') . '";');
	eval('$adminenvinmt = "' . fetch_template('links_admin_environment') . '";');

	($hook = vBulletinHook::fetch_hook('ldm_admin_option')) ? eval($hook) : false;

// --------------------------------------------------------------------------------

	if ($adminset == "bandwidth") {
		require_once(DIR . '/includes/local_links_admin_bandwidth.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "categories") {
		require_once(DIR . '/includes/local_links_admin_categories.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "debug") {

		$vbulletin->input->clean_array_gpc('r', array(
			'highlight' => TYPE_INT,
		));

		$navbits[""] = $vbphrase['ll_debug'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$vbulletin->url = $debugscript = $ADMIN_SCRIPT.".php?set=debug";

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksdebug
			ORDER BY adminid
		");
		$nrec = 0;
		$line = array();
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$nrec++;
			if ($nrec>=$pagenumber*$perpage) {
				continue;
			}
			elseif ($nrec>($pagenumber-1)*$perpage) {
				$line[] = $myrow;
				$index = $myrow['adminid'];
			}
		}

		$vbulletin->db->free_result($asb);

		$pagenav = construct_page_nav($pagenumber, $perpage, $nrec, $debugscript,"&amp;pp=$perpage");

		if ($nrec) {

			foreach ($line as $thisline) {

				$command = $thisline['command'];
				$sep = '?';
				foreach (unserialize($thisline['get']) as $k=>$v) {
					$command .= $sep.$k.'='.$v;
					$sep = '&amp;';
				}

				$expansion = '';
				if ($vbulletin->GPC['highlight']==$thisline['adminid']) {
					$todo = array('get', 'post', 'files', 'cookie', 'settings');
					foreach ($todo as $thistodo) {
						$expansion .= '<tr>';
						$expansion .= '<td class="alt2" width="10%" valign="top">';
						$expansion .= '<span class="smallfont">'.$thistodo.'</span>';
						$expansion .= '</td><td class="alt2" valign="top" colspan="3">';
						$expansion .= '<span class="smallfont">';
						$thisunser = unserialize($thisline[$thistodo]);
						if (is_array($thisunser)) {
							ksort($thisunser);
							foreach ($thisunser as $kk=>$kv) {
								$expansion .= $kk.':'.$kv.'<br />';
							}
						}
						else {
							ob_start();
							var_dump(unserialize($thisline[$thistodo]));
							$expansion .=  ob_get_contents();
							ob_end_clean();
						}
						$expansion .= '</span></td>';
						$expansion .= '</tr>';
					}
				}

				$adminid = $thisline['adminid'];
				$message = $thisline['message'];
				$datetime = ldm_date($vbulletin->options['dateformat'], $thisline['settingtime']).' '.ldm_date($vbulletin->options['timeformat'], $thisline['settingtime']);
				eval('$debuginfo .= "' . fetch_template('links_admin_debugrow') . '";');
			}
		}

	}

// --------------------------------------------------------------------------------

	if ($adminset == "importexport") {

		$navbits[""] = $vbphrase['ll_menu_admimex'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

	}

// --------------------------------------------------------------------------------

	if ($adminset == "keywords") {

		$navbits[""] = $vbphrase['ll_menu_admkey'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$percols = 4;
		$perpage = $percols*$perpage;
		$ist = ($pagenumber-1)*$perpage;
		$ifn = $ist + $perpage;

		$keywords = "";
		$asb = $vbulletin->db->query_read("
			SELECT lkeys.keyid AS keyid, lkeys.keyword AS keyword, COUNT(ltok.linkid) as paired
			FROM ". THIS_TABLE . "linkskeys AS lkeys
			LEFT JOIN ". THIS_TABLE . "linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			GROUP BY lkeys.keyid
			ORDER BY keyword
			LIMIT ".$ist.", ".$perpage."
		");

		$selected = 0;
		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$keyword = $myrow['keyword'];
			$keyid = $myrow['keyid'];
			$keycount = $myrow['paired'] ? $myrow['paired']: 0;
			eval('$keys[] = "' . fetch_template('links_selectkeyword') . '";');
		}

		$rows = $vbulletin->db->query_first("
			SELECT COUNT(*) AS nrec
			FROM ". THIS_TABLE . "linkskeys AS lkeys
		");

		$pagenav = construct_page_nav($pagenumber, $perpage, $rows['nrec'], $ADMIN_SCRIPT.".php?set=keywords");
		$keywords = map_listbit_to_grid($keys, $percols);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "linkbits") {
		require_once(DIR . '/includes/local_links_admin_linkbits.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "logjumps") {
		require_once(DIR . '/includes/local_links_admin_logjumps.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "mimetypes") {

		$navbits[""] = $vbphrase['ll_menu_admmime'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		cache_mimetype();

		$myft = array();
		$mygaps = array();

		foreach ($ldm_mimetype_cache as $type=>$mime) {
			$myft[$type] = array('upload'=>0, 'media'=>array(), 'size'=>$mime['size'], 'mimetype'=>$mime['mimetype'], 'count'=>0);
		}

		if ($link_defaults['upload_filetypes']) {
			foreach (explode(',', preg_replace("/\s/","", $links_defaults['upload_filetypes'])) as $type) {
				$myft[$type]['upload'] = 1;
			}
		}
		else {
			foreach ($ldm_mimetype_cache as $type=>$mime) {
				$myft[$type]['upload'] = 1;
			}
		}

		require_once(DIR . '/includes/local_links_players.php');
		load_ldm_players();

		foreach ($ldm_players as $id=>$thisplayer) {
			foreach (explode(',', preg_replace("/\s/","", $thisplayer['filetypes_played'])) as $type) {
				if ($type) {
					if (isset($myft[$type])) {
						$myft[$type]['media'][] = $thisplayer;
					}
					else {
						$mygaps[$type]['media'][] = $thisplayer;
					}
				}
			}
		}

		$ldmft = array();
		$asb = $vbulletin->db->query_read("
			SELECT linkurl, linkfile
			FROM ".THIS_TABLE."linkslink
		");
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$urlInfo = ldm_parse_url($row['linkurl']);
			$linkfile = $row['linkfile'];
			$dfname   = iif($linkfile, $linkfile, basename($urlInfo['path']));
			$type	  = strtolower(substr(strrchr($dfname, "."), 1));
			if ($type) {
				$ldmft[$type]++;
			}
		}
		ksort($ldmft);

		foreach ($ldmft as $type=>$filecount) {
			if (isset($myft[$type])) {
				$myft[$type]['count'] = $filecount;
				unset($ldmft[$type]);
			}
			else if (isset($mygaps[$type])) {
				$mygaps[$type]['count'] = $filecount;
				unset($ldmft[$type]);
			}
		}

		$alt = 1;
		$mimetypeinfo = "";
		foreach ($myft as $type=>$mime) {
			$mimetype = "";
			if (isset($ldm_mimetype_cache[$type]['mimetype'])) {
				$mimetype = implode(',', $ldm_mimetype_cache[$type]['mimetype']);
			}
			$players = "";
			if (is_array($mime['media'])) {
				$ply = array();
				foreach ($mime['media'] as $thisplayer) {
					$ply[$thisplayer['name']] = -$thisplayer['priority'];
				}
				asort($ply);
				foreach ($ply as $k=>$p) {
					$p = -$p;
					$players .= iif($players, '<br />', '').$k.' ('.$p.')';
				}
			}
			$mimevalid = preg_match("/Content-type:/i", $mimetype);
			$mimecount = $mime['count'];
			$mimeupload = $mime['upload'];
			$mimesize = encode_bytes($mime['size']);
			eval("\$mimetypeinfo .= \"".fetch_template('links_admin_onemimetype')."\";");
		}

		foreach ($mygaps as $type=>$mime) {
			$mimetype = "";
			$players = "";
			if (is_array($mime['media'])) {
				$ply = array();
				foreach ($mime['media'] as $thisplayer) {
					$ply[$thisplayer['name']] = -$thisplayer['priority'];
				}
				asort($ply);
				foreach ($ply as $k=>$p) {
					$p = -$p;
					$players .= iif($players, '<br />', '').$k.' ('.$p.')';
				}
			}
			$mimecount = $mime[count];
			$mimeupload = "";
			$mimesize = "";
			eval("\$mimetypegaps .= \"".fetch_template('links_admin_onemimetype')."\";");
		}

		unset($mygaps);
		unset($myft);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "mirrors") {
		require_once(DIR . '/includes/local_links_admin_mirrors.php');
	}

// --------------------------------------------------------------------------------

	if ($adminset == "permissions") {

		$vbulletin->input->clean_array_gpc('r', array(
			'transpose' => TYPE_INT,
		));

		$navbits[""] = $vbphrase['ll_menu_admperm'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_misc.php');

		$linksperms = build_permissions("-1","", 1, 1, $vbulletin->GPC['transpose']);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "players") {

		require_once(DIR . '/includes/local_links_admininclude.php');

		$navbits[""] = $vbphrase['ll_menu_admplay'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_players.php');

		$linksplayers = edit_ldm_players();

	}

// --------------------------------------------------------------------------------

	if ($adminset == "searches") {

		$navbits[""] = $vbphrase['ll_menu_admsearch'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_misc.php');

		$linkssearch = make_searchidbits(-1);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "settings") {

		$navbits[""] = $vbphrase['ll_menu_admset'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		require_once(DIR . '/includes/local_links_misc.php');

		$linkssettings = build_settings("-1","", 1, 1);

	}

// --------------------------------------------------------------------------------

	if ($adminset == "statistics") {

		$vbulletin->input->clean_array_gpc('r', array(
			'users' => TYPE_INT,
		));

		$navbits[""] = $vbphrase['ll_menu_admstat'];
		$navbits = construct_navbits($navbits);
		eval('$navbar = "' . fetch_template('navbar') . '";');

		$linkstats['links'] = $linkstats['linksok'] = $linkstats['linksbroken'] = 0;
		$linkstats['linksinvalid'] = $linkstats['linksmod'] = $linkstats['linkshidden'] = 0;
		$linkstats['uploads'] = $linkstats['uploadspace'] = $linkstats['linksreview'] = 0;
		$linkstats['linkimg'] = $linkstats['linkimgthumb'] = 0;

		$asb = $vbulletin->db->query_read("
			SELECT linkstatus, linkmoderate, linkreviewfreq, linkmoddate, linksize, linkimg, linkimgthumb
			FROM ".THIS_TABLE."linkslink
		");
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$linkstats['links'] += 1;
			if ($row['linkstatus']>0) $linkstats['linksok'] += 1;
			if ($row['linkstatus']==$LINK_BROKEN) $linkstats['linksbroken'] += 1;
			if ($row['linkstatus']==$LINK_NO_ACCESS) $linkstats['linksinvalid'] += 1;
			if ($row['linkstatus']==$LINK_HIDDEN) $linkstats['linkshidden'] += 1;
			if ($row['linkstatus']==$LINK_UPLOAD) {
				$linkstats['uploads'] += 1;
				$linkstats['uploadspace'] += $row['linksize'];
			}
			if ($row['linkmoderate']==$LINK_TO_MODERATE) $linkstats['linksmod'] += 1;
			if ($row['linkreviewfreq'] and ($row['linkmoddate']+$row['linkreviewfreq']*24*60*60<TIMENOW)) $linkstats['linksreview'] += 1;
			if ($row['linkimg']) $linkstats['linkimg'] += 1;
			if ($row['linkimgthumb']) $linkstats['linkimgthumb'] += 1;
		}
		$linkstats['uploadspace'] = encode_bytes($linkstats['uploadspace']);

		$linkstats['categories'] = count($linkscat);
		$linkstats['catsmod'] = 0;
		foreach ($linkscat as $thiscat) {
			if ($thiscat['catmoderate']==$LINK_TO_MODERATE) $linkstats['catsmod'] += 1;
		}

		$linkstats['users'] = '';
		$count = $vbulletin->db->query_read("
			SELECT linkusername, linkuserid, COUNT(linkuserid) AS usercount
			FROM ".THIS_TABLE."linkslink
			GROUP BY linkuserid
			ORDER BY usercount DESC, linkusername ASC
		");
		$nusers = 0;
		$maxusers = iif($vbulletin->GPC_exists['users'], $vbulletin->GPC['users'], 50);
		while ($row = $vbulletin->db->fetch_array($count)) {
			$nusers++;
			if ($nusers<=$maxusers) {
				$linkstats['users'] .= '
					<a href="member.php?userid='.$row['linkuserid'].'" target="_blank">'.$row['linkusername'].'</a>
					['.$row['usercount'].' <a href="'.SEARCH_SCRIPT.'.php?action=show&amp;user='.
					$row['linkusername'].'">'.$vbphrase['ll_entrieslc'].'</a>]<br />
				';
			}
		}
		if ($nusers>=$maxusers) {
			$maxusers = 10*$maxusers;
			$linkstats['users'] .= "<a href='".$ADMIN_SCRIPT.".php?set=statistics&amp;users=".$maxusers."'>".$vbphrase['ll_more'].'</a><br />';
		}
		$linkstats['users'] .= construct_phrase($vbphrase['ll_admin_total_users'], $nusers);

		$count = $vbulletin->db->query_read("
			SELECT linkurl, COUNT(linkurl) AS cnt
			FROM ".THIS_TABLE."linkslink
			WHERE linkurl != ''
			GROUP BY linkurl
			ORDER BY cnt DESC
		");
		$dups = array();
		while ($row = $vbulletin->db->fetch_array($count)) {
			if ($row['cnt']<=1) break;
			$dups[] .= $row['linkurl'];
		}

		$vbulletin->input->clean_array_gpc('r', array(
			'dups' => TYPE_INT,
			));
		$showdups = $vbulletin->GPC['dups'];

		if ($showdups) {
			$linkstats['dups'] = '';
			foreach ($dups AS $dup) {
				$count = $vbulletin->db->query_read("
					SELECT link.linkname AS linkname, link.linkid AS linkid, link.linkurl AS linkurl,
					cat.catid AS catid, cat.catname AS catname
					FROM ".THIS_TABLE."linkslink AS link
					LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
					ON link.linkid = ltoc.linkid
					LEFT JOIN ".THIS_TABLE."linkscat AS cat
					ON ltoc.catid = cat.catid
					WHERE link.linkurl = '".$vbulletin->db->escape_string($dup)."'
					ORDER BY catname ASC
				");
				$n = 0;
				$stat = "";
				while ($row = $vbulletin->db->fetch_array($count)) {
					$n++;
					$url = $row['linkurl'];
					$stat .= '('.$n.') <a href="'.$LINKS_SCRIPT.'.php?catid='.$row['catid']
						. '&amp;linkid=' . $row['linkid']
						. '" target="_blank">' . $row['catname'] . '</a> ';
				}
				if ($stat) {
					$linkstats['dups'] .= $url . '<br />&nbsp;&nbsp;&nbsp;' . $stat . '<br />';
				}
			}
		}
		else {
			$linkstats['dups'] = count($dups);
		}

		$count = $vbulletin->db->query_first("
			SELECT COUNT(*) AS keywords
			FROM ".THIS_TABLE."linkskeys
		");
		$linkstats['keywords'] = $count['keywords'];

	}

// --------------------------------------------------------------------------------

	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_edit_category"] = 0;
	$viewcatid=-1;

	eval("\$output  = \"".fetch_template('links_header')."\";");
	eval("\$output .= \"".fetch_template('links_admin')."\";");
	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;

}

// #################### Mass Edits - By category, forumid or non-hits

if ($this_action == "massedit") {
	require_once(DIR . '/includes/local_links_admin_massedit.php');
}

// #################### Do (Mass Edit) Links

if ($this_action == "domassedit") {
	require_once(DIR . '/includes/local_links_admin_massedit.php');
}

// #################### Validate access to links/files in database

if ($this_action == "validate") {

	$vbulletin->input->clean_array_gpc('r', array(
		'status' => TYPE_INT,
		'at' => TYPE_INT
	));

	$lstatus = iif($vbulletin->GPC_exists['status'], $vbulletin->GPC['status'], $LINK_ALL);
	$startat = iif($vbulletin->GPC_exists['at'], $vbulletin->GPC['at'], 0);

	$where = "";
	$limit = 20;

	$where .= "AND linkid >= $startat ";

	if ($lstatus == $LINK_BROKEN) {
		$where .= "AND linkstatus = ".$LINK_BROKEN;
	}
	elseif ($lstatus == $LINK_NO_ACCESS) {
		$where .= "AND linkstatus = ".$LINK_NO_ACCESS;
	}

	$query = "
		SELECT linkid, linkurl, linkforum, linkstatus, linkdate, linksize
		FROM ".THIS_TABLE."linkslink
		WHERE (1)
		$where
		ORDER BY linkid
		LIMIT $limit
	";
	$asb = $vbulletin->db->query_read($query);

	$num = 0;
	ldm_dopagehead();
	echo '<b>'.$vbphrase['ll_validate'].'</b><br /><br />';
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		$time = TIMENOW;
		$linkid	= $myrow["linkid"];
		$linkforum = $myrow["linkforum"];
		$linkurl    = $myrow["linkurl"];
		$linkdate   = $myrow["linkdate"];
		$linkstatus = $myrow["linkstatus"];
		$linksize = $myrow["linksize"];
		$nextid	= $linkid + 1;
		echo '-- '.$linkid.' '.$linkurl;
		echo ' (<a href="'.$ADMIN_SCRIPT.'.php?action=validate&amp;status='.$status.'&amp;at='.$nextid.'">'.$vbphrase['ll_next'].'</a>, ';
		echo ' <a href="'.$ADMIN_SCRIPT.'.php?action=validate&amp;status='.$status.'&amp;at=999999">'.$vbphrase['ll_quit'].'</a>)';
		flush();
		if (!forumid_is_valid($linkforum)) {
			$status = $LINK_NO_ACCESS;
			echo ': <b>'.$vbphrase['ll_error_forum'].'</b><br />';
		}
		else {
			$status = check_ldm_url($linkurl);
			switch ($status) {
			case $LINK_NO_ACCESS:
				echo ': <b>'.$vbphrase['ll_invalid'].'</b><br />';
				break;
			case $LINK_BROKEN:
				echo ': <b>'.$vbphrase['ll_error_linkcheckfailed'].'</b><br />';
				break;
			default:
				$newsize = iif($status==$LINK_OK, size_url($linkurl), 0);
				$linksize = $newsize>0 ? $newsize : $linksize;
				if ($linkstatus == $LINK_UPLOAD and $status == $LINK_OK) $status = $LINK_UPLOAD;
				echo ": size ".$linksize."<br />";
			}
		}
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkslink
			SET
				linkstatus='".$status."',
				linkcheck='".$time."',
				linksize='".$linksize."'
			WHERE linkid='$linkid'
			LIMIT 1
		");
		$num++;
	}
	if ($num >= $limit) {
		$url = $ADMIN_SCRIPT.".php?action=validate&amp;status=".$lstatus."&at=$nextid";
		ldm_doredirect($url);
	}
	else {
		$url = $ADMIN_SCRIPT.".php?set=statistics";
		ldm_doredirect($url);
	}
	ldm_dopagefoot();

}

// #################### Download/Bandwidth

if ($this_action == "doadmin" and isset($_REQUEST["dobandwidth"])) {
	require_once(DIR . '/includes/local_links_admin_bandwidth.php');
}

// #################### Mass actions on categories

if ($this_action == "doadmin" and isset($_REQUEST["docategories"])) {
	require_once(DIR . '/includes/local_links_admin_categories.php');
}

// #################### Export and Clean Debug Table

if ($this_action == "doadmin" and isset($_REQUEST['dodebug'])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'save' => TYPE_INT,
	));

	if ($vbulletin->GPC['save']==1) {
		require_once(DIR . '/includes/class_xml.php');

// Take care - VB version specific
		if (VALID_VB_VERSION=="3.5") {
			$xml = new XMLexporter();
		}
		else {
			$xml = new XMLexporter($vbulletin);
		}
// Take care - VB version specific

		$xml->add_group('LDM', array('name' => 'Trace', 'version' => $links_defaults["this_version"],
			'date' => date('d-m-Y H:i:s', TIMENOW)));

		$asb = $vbulletin->db->query_read("
			SELECT *
			FROM ".THIS_TABLE."linksdebug
			ORDER BY adminid
		");

		while ($myrow = $vbulletin->db->fetch_array($asb)) {
			$xml->add_group(iif($myrow['message']=='TRACE', 'command', 'debug'), array('id'=>$myrow['adminid']));
			foreach ($myrow as $k=>$v) {
				$xml->add_tag($k, $v, array(), true);
			}
			$xml->close_group();
		}
		$xml->close_group();

		$doc = '<?xml version="1.0" encoding="ISO-8859-1"?>'. "\r\n";
		$doc .= $xml->output();
		$xml = null;

		$vbulletin->db->free_result($asb);

		$vbulletin->db->query_write("
			TRUNCATE TABLE
			".THIS_TABLE."linksdebug
		");

		require_once(DIR . '/includes/functions_file.php');
		file_download($doc, 'trace.xml', 'text/xml');
	}

	exit;

}

// #################### File Export

if ($this_action == "doadmin" and isset($_REQUEST['doexport'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### XML Export

if ($this_action == "doadmin" and isset($_REQUEST['doexportxml'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### CSV file import

if ($this_action == "doadmin" and isset($_REQUEST['doimport'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### XML Import

if ($this_action == "doadmin" and isset($_REQUEST['doimportxml'])) {
	require_once(DIR . '/includes/local_links_admin_impexp.php');
}

// #################### Mass edit keyword list

if ($this_action == "doadmin" and isset($_REQUEST['dokeywords'])) {

	$vbulletin->input->clean_array_gpc('p', array(
		'editkeys' => TYPE_INT,
		'keywords' => TYPE_ARRAY_INT,
		'mergekeyword' => TYPE_STR,
		'newkeywords' => TYPE_STR,
	));

	$list = implode("', '", $vbulletin->GPC['keywords']);

	switch ($vbulletin->GPC['editkeys']) {

	case 1: // Merge keywords

	$newkeyword = $vbulletin->GPC['mergekeyword'];
	if ($newkeyword) {
// add the new keyword
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linkskeys
			SET
				keyword='".$vbulletin->db->escape_string($newkeyword)."'
			");
		$newkeyid = $vbulletin->db->insert_id();
// find everything associated with existing keywords
		$asb = $vbulletin->db->query_read("
			SELECT linkid FROM ".THIS_TABLE."linksltok
			WHERE keyid IN ('-1', '".$list."')
			");
		$linkids = array();
		while ($row=$vbulletin->db->fetch_array($asb)) {
			$linkids[$row['linkid']] = 1;
		}
// associate these with the new keyword
		foreach (array_keys($linkids) as $thislinkid) {
			$vbulletin->db->query_write("
				INSERT INTO ".THIS_TABLE."linksltok
				SET
					linkid='".$thislinkid."',
					keyid='".$newkeyid."'
				");
		}
// get rid of old associations and keywords
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linkskeys
			WHERE keyid IN ('-1', '".$list."')
			");
		$vbulletin->db->query_write("
			DELETE FROM ".THIS_TABLE."linksltok
			WHERE keyid IN ('-1', '".$list."')
			");
	}
	break;

	case 2: // Delete keywords

	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linkskeys
		WHERE keyid IN ('-1', '".$list."')
		");
	$vbulletin->db->query_write("
		DELETE FROM ".THIS_TABLE."linksltok
		WHERE keyid IN ('-1', '".$list."')
		");
	break;

	}

	lookup_keywords(explode_keywords($vbulletin->GPC['newkeywords']));

	$vbulletin->url = $ADMIN_SCRIPT.".php?set=keywords&amp;page=$pagenumber";
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

// #################### Mirrors

if ($this_action == "doadmin" and isset($_REQUEST["domirrors"])) {
	require_once(DIR . '/includes/local_links_admin_mirrors.php');
}

// #################### Permissions

if ($this_action == "doadmin" and isset($_REQUEST["dopermissions"])) {

	require_once(DIR . '/includes/local_links_misc.php');
	update_permissions(-1, $_REQUEST);
	$url = $ADMIN_SCRIPT.".php?set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));
	exit;
}

// #################### Players

if ($this_action == "doadmin" and isset($_REQUEST["doplayers"])) {

	require_once(DIR . '/includes/local_links_players.php');

	update_ldm_players($_REQUEST);

	$url = $ADMIN_SCRIPT.".php?set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	exit;
}

// #################### Settings

if ($this_action == "doadmin" and isset($_REQUEST["dosettings"])) {

	require_once(DIR . '/includes/local_links_misc.php');
	update_settings(-1, $_REQUEST, $errors);
	$isok = 1;

	foreach ($errors as $k => $v) {
		if ($isok) {
			ldm_dopagehead();
			echo $vbphrase['ll_error_invalidsettings'].'<br />';
		}
		echo '<b>'.$k.'</b> : '.$v['value'].'<br />'.$v['message'].'<br />';
		$isok = 0;
	}

	if ($isok) {
		$url = $ADMIN_SCRIPT.".php?set=".$adminset;
		eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	}
	else {
		echo $vbphrase['ll_goback'];
		ldm_dopagefoot();
	}

	exit;
}

// #################### Rebuild thumbs
// [actually just reset them all, so that they get rebuilt the next time they are displayed]

if ($this_action == "doadmin" and isset($_REQUEST['dothumbs'])) {

	require_once(DIR . '/includes/local_links_resize.php');

	clear_thumbnails();
	$vbulletin->url = $ADMIN_SCRIPT.".php?set=statistics";
	eval(print_standard_redirect($vbphrase['ll_resetthumbs'],0));

	exit;

}

// #################### Directory scan

if ($this_action == "doadmin" and isset($_REQUEST["doscan"])) {
	require_once(DIR . '/includes/local_links_admin_scan.php');
}

// #################### Do (Synchronise) Links

if ($this_action == "doadmin" and isset($_REQUEST["dosync"])) {

	$url  = ADMIN_SCRIPT.".php?action=admin&amp;set=categories";

	$vbulletin->input->clean_array_gpc('g', array(
		'catid' => TYPE_INT,
		'set' => TYPE_STR,
		'expand' => TYPE_STR,
	));

	$catid = $vbulletin->GPC['catid'];

	ldm_dopagehead();
	echo '<p class="smallfont">';
	echo '<strong>'.$vbphrase['ll_resync'].'</strong>';
	echo '</p>';
	flush();

	require_once(DIR . '/includes/local_links_misc.php');
	$continue = synchronise_ldm_category($catid, $links_defaults['sync_maxcpu_allowed_manual'], 1);

	if (!$continue) {
		$url = $ADMIN_SCRIPT.".php?action=doadmin&dosync=1&set=".$vbulletin->GPC['set']."&catid=".$catid."&expand=".$vbulletin->GPC['expand'];
		echo '<p class="smallfont">' . $vbphrase['ll_resync_notcomplete'] . '</p>';
		echo '<p class="smallfont"><a href="' . $url . '">' . $vbphrase['ll_resync_continue'] . '</a></p>';
	}
	else {
		$url = $ADMIN_SCRIPT.".php?set=".$vbulletin->GPC['set']."&expand=".$vbulletin->GPC['expand'];
		echo '<p class="smallfont">' . $vbphrase['ll_resync_complete'] . '</p>';
		echo "\n<script type=\"text/javascript\">\n";
		echo "window.location=\"$url\";";
		echo "\n</script>\n";
	}
	$url = $ADMIN_SCRIPT.".php?set=".$vbulletin->GPC['set']."&expand=".$vbulletin->GPC['expand'];
	echo '<p class="smallfont"><a href="' . $url . '">' . $vbphrase['ll_return'] . '</a></p>';

	ldm_dopagefoot();
	flush();
	exit;

}

/* ===========================================================================*/
// Fall through
/* ===========================================================================*/

$vbulletin->url = $ADMIN_SCRIPT.'.php';
eval(print_standard_redirect('',0));
exit;

?>