<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/07
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.2.8, 01.07.2007
// For VB 3.5.x and 3.6.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT', 'local_links_ajax');
define('LOCATION_BYPASS', 1);
define('NOPMPOPUP', 1);

$phrasegroups = array('posting');
$specialtemplates = array('bbcodecache');
$globaltemplates = array();
$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

($hook = vBulletinHook::fetch_hook('ldm_ajax_start')) ? eval($hook) : false;

if (strtolower($vbulletin->userinfo['lang_charset']) == 'iso-8859-1') {
	$ajax_charset = 'windows-1252';
}
else {
	$ajax_charset = $vbulletin->userinfo['lang_charset'];
}

$vbulletin->input->clean_array_gpc('r',
	array(
		'do' => TYPE_STR,
		'fragment' => TYPE_STR
		)
);

$action = $vbulletin->GPC['do'];

/* ===========================================================================*/
// Keyword search
/* ===========================================================================*/

if ($_POST['do'] == 'keysearch') {

	($hook = vBulletinHook::fetch_hook('ldm_ajax_keysearch_begin')) ? eval($hook) : false;

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 1) {
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else {
		$fragment = '';
	}

	@header('Content-Type: text/xml' . iif($ajax_charset != '', '; charset=' . $ajax_charset));
	echo '<?xml version="1.0" encoding="' . $ajax_charset . '"?>' . "\r\n<keys>\r\n";

	if ($fragment != '') {
		$query = "
			SELECT lkeys.keyid AS keyid, lkeys.keyword AS keyword, COUNT(ltok.linkid) AS matches
			FROM " . THIS_TABLE . "linkskeys AS lkeys
			LEFT JOIN " . THIS_TABLE . "linksltok AS ltok
			ON lkeys.keyid=ltok.keyid
			WHERE lkeys.keyword LIKE('" . $vbulletin->db->escape_string_like($fragment) . "%')
			GROUP BY keyid
			ORDER BY keyword
			LIMIT 15
			";
		$keys = $vbulletin->db->query_read($query);
		while ($key = $vbulletin->db->fetch_array($keys)) {
			echo "\t<key keyid=\"$key[keyid]\">$key[keyword]: $key[matches]</key>\r\n";
		}
	}

	echo "</keys>";
}

/* ===========================================================================*/
// DOI search
/* ===========================================================================*/

if ($action == 'doisearch') {
	($hook = vBulletinHook::fetch_hook('ldm_ajax_doisearch_begin')) ? eval($hook) : false;

	$vbulletin->GPC['fragment'] = convert_urlencoded_unicode($vbulletin->GPC['fragment']);

	if ($vbulletin->GPC['fragment'] != '' AND strlen($vbulletin->GPC['fragment']) >= 1) {
		$fragment = htmlspecialchars_uni($vbulletin->GPC['fragment']);
	}
	else {
		$fragment = '';
	}

	@header('Content-Type: text/xml' . iif($ajax_charset != '', '; charset=' . $ajax_charset));
	echo '<?xml version="1.0" encoding="' . $ajax_charset . '"?>' . "\r\n<keys>\r\n";

	if ($fragment != '') {
		$query = "
			SELECT linkid, linkdoi
			FROM " . THIS_TABLE . "linkslink
			WHERE linkdoi LIKE('%" . $vbulletin->db->escape_string_like($fragment) . "%')
			ORDER BY linkdoi
			LIMIT 15
			";
		$keys = $vbulletin->db->query_read($query);
		while ($key = $vbulletin->db->fetch_array($keys)) {
			echo "\t<key keyid=\"$key[linkdoi]\">$key[linkdoi]</key>\r\n";
		}
	}

	echo "</keys>";
}

/* ===========================================================================*/
// Generalised fetch intended for use by plugins
/* ===========================================================================*/

if ($action == 'fetch') {

	$vbulletin->input->clean_array_gpc('r',
		array(
			'plugin' => TYPE_STR,
			'id' => TYPE_STR,
			'catid' => TYPE_INT,
			'linkid' => TYPE_INT,
			)
	);

	function ldm_clean_ajax_reply($reply) {
		$reply = str_replace('\\', '\\\\', $reply);
		$reply = str_replace("'", "\\'", $reply);
		$reply = str_replace("\r\n", "", $reply);
		$reply = str_replace("\n", "", $reply);
		return $reply;
	}

	unset($ldm_ajax_reply);

	($hook = vBulletinHook::fetch_hook('ldm_ajax_fetch')) ? eval($hook) : false;

	if (isset($ldm_ajax_reply)) {
		$ldm_ajax_reply = ldm_clean_ajax_reply($ldm_ajax_reply);
		$ldm_ajax_reply = "var ldm_newinfo = '$ldm_ajax_reply'; var doalert = '';";
		echo $ldm_ajax_reply;
		exit;
	}
}

?>