<?php
/*======================================================================*\
|| #################################################################### ||
|| #               stamps v 3.8                                # ||
|| #              for vBulletin Version 3.5 AND 3.6                   # ||
|| #              http://7beebi.com                          # ||
|| #              webmaster@7beebi.com                                # ||
|| #################################################################### ||
\*======================================================================*/
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: stamp.php,v $ - $Revision: 3.8 $');
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'stamp');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminthreads'))
{
        print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action($_REQUEST['do'] . iif($_REQUEST['stampid'] != 0, " stampid = $_REQUEST[stampid]"));

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['stamps_manager']);

if (empty($_REQUEST['do']))
{
        $_REQUEST['do'] = 'modify';
}
// ###################### Start add #######################
if ($_REQUEST['do'] =="add")
{
         print_form_header("stamp","insert",$vbphrase['stamps_manager']);
         print_table_header($vbphrase['add_stamp']);
         print_input_row($vbphrase['stamp_name'], "title", $vbphrase['stamp']);
         print_input_row($vbphrase['stamp_color'], "color", "black");
         print_input_row($vbphrase['stamp_icon'], "icon", "images/stamps/");
         print_input_row($vbphrase['stamp_pic_url'], "url", "images/stamps/");
         print_submit_row();
}

// ###################### Start insert #######################
if ($_POST['do'] =="insert")
{
        $vbulletin->input->clean_array_gpc('r', array(
               'title'     => TYPE_STR,
               'icon'      => TYPE_STR,
               'url'       => TYPE_STR,
               'color'     => TYPE_STR
        ));

        $db->query_write("INSERT INTO " . TABLE_PREFIX . "stamps
        (title, icon, url, color)
        VALUES
        (
        '" . $db->escape_string($vbulletin->GPC['title']) . "',
        '" . $db->escape_string($vbulletin->GPC['icon']) . "',
        '" . $db->escape_string($vbulletin->GPC['url']) . "',
        '" . $db->escape_string($vbulletin->GPC['color']) . "'
        )
        ");
        print_cp_message($vbphrase['stamp_added'], "stamp.php?do=modify");
}
// ###################### Start edit #######################
if ($_REQUEST['do'] == "edit")
{
          $vbulletin->input->clean_gpc('r', 'stampid', TYPE_INT);
          $stamps = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "stamps WHERE stampid=" . $vbulletin->GPC['stampid'] . "");

          print_form_header("stamp","doupdate",$vbphrase['stamps_manager']);
          construct_hidden_code("stampid", $vbulletin->GPC['stampid']);
          print_table_header($vbphrase['modify_stamps']);
          print_input_row($vbphrase['stamp_name'], "title", $stamps['title']);
          print_input_row($vbphrase['stamp_color'], "color", $stamps['color']);
          print_input_row($vbphrase['stamp_icon'], "icon", $stamps['icon']);
          print_input_row($vbphrase['stamp_pic_url'], "url", $stamps['url']);
          print_submit_row();
}

// ###################### Start do update #######################
if ($_POST['do'] == "doupdate")
{
        $vbulletin->input->clean_array_gpc('r', array(
               'title'     => TYPE_STR,
               'icon'      => TYPE_STR,
               'url'       => TYPE_STR,
               'color'     => TYPE_STR,
               'stampid'   => TYPE_INT
        ));

        $db->query_write("UPDATE " . TABLE_PREFIX . "stamps set title = '" . $db->escape_string($vbulletin->GPC['title']) . "',icon = '" . $db->escape_string($vbulletin->GPC['icon']) . "',url = '" . $db->escape_string($vbulletin->GPC['url']) . "', color = '" . $db->escape_string($vbulletin->GPC['color']) . "' WHERE stampid = " . $vbulletin->GPC['stampid'] . "");
        print_cp_message($vbphrase['stamp_updated'], "stamp.php?do=modify");
}
// ###################### Start Remove #######################
if ($_REQUEST['do'] == "remove")
{
    $vbulletin->input->clean_gpc('r', 'stampid', TYPE_INT);

    $item = $db->query_first("SELECT title as title FROM " . TABLE_PREFIX . "stamps WHERE stampid = " . $vbulletin->GPC['stampid']);
    echo "<p>&nbsp;</p><p>&nbsp;</p>";
    print_form_header("stamp","kill",$vbphrase['stamps_manager']);
    construct_hidden_code('stampid', $vbulletin->GPC['stampid']);
    print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $item['title']));
    print_description_row("
    <blockquote><br />
    " . construct_phrase($vbphrase['del_stamp'], $item['title'], $vbulletin->GPC['stampid'], '') . "
    <br /></blockquote>\n\t");
    print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// ###################### Start Kill #######################

if ($_REQUEST['do'] == "kill")
{
    $vbulletin->input->clean_gpc('r', 'stampid', TYPE_INT);

    $db->query_write("DELETE FROM " . TABLE_PREFIX . "stamps WHERE stampid = " . $vbulletin->GPC['stampid'] . "");
    $db->query_write("UPDATE " . TABLE_PREFIX . "thread SET stampid = 0 WHERE stampid = " . $vbulletin->GPC['stampid'] . "");
    print_cp_message($vbphrase['stamp_deleted'], "stamp.php?do=modify");
}

// ###################### Start modify #######################
if ($_REQUEST['do'] == "modify")
{

       $stamps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "stamps ORDER BY stampid");

       print_table_start();
       print_table_header($vbphrase['modify_stamps'],4);
       $header = array();
       $header[]=$vbphrase['stamp_name'];
       $header[]=$vbphrase['stamp_icon'];
       $header[]=$vbphrase['stamp_pic'];
       $header[]="";
       print_cells_row($header, 1, 0, 1);
       $cell = array();
       while ($stamp = $db->fetch_array($stamps))
       {
              $cell[] = '<font color="' . $stamp['color'] . '">' . $stamp['title'] . '</font>';
              $cell[] = '<img width="20" height="20" border="0" src="../images/stamps/thread' . $stamp['icon']. '.gif" alt="" />';
              $cell[] = '<img width="120" height="120" border="0" src="../' . $stamp['url']. '" alt="" />';
              $cell[] = iif($stamp['stampid'], construct_link_code($vbphrase['edit'], 'stamp.php?do=edit&amp;stampid=' . $stamp['stampid'])) .
              iif($stamp['stampid'] > 4, construct_link_code($vbphrase['delete'],'stamp.php?do=remove&stampid=' . $stamp['stampid']));
              print_cells_row($cell, 0, 0, 1);
              unset($cell);
              $cell = array();
       }
       print_table_footer();
}

###################### show ########################
if ($_REQUEST['do'] == "show")
{
        $stamps = $db->query_read("
                 SELECT thread.*, stamps.title AS stamptitle, stamps.stampid, stamps.url, stamps.icon
                 FROM " . TABLE_PREFIX . "thread AS thread
                 LEFT JOIN " . TABLE_PREFIX . "stamps AS stamps ON(stamps.stampid = thread.stampid)
                 WHERE thread.stampid > 0
                 ORDER BY stamps.stampid
        ");

        print_form_header('','');
        while ($stamp = $db->fetch_array($stamps))
        {
                if ($stamp['stampid'] != $prevgroup)
                {
                        if($prevgroup)
                        {
                                print_table_break();
                        }

                        $prevgroup = $stamp['stampid'];

                        print_table_header($stamp['stamptitle'], 8);
                        $header = array();
                        $header[] = $vbphrase['stamp_icon'];
                        $header[] = $vbphrase['thread'];
                        $header[] = $vbphrase['replies'];
                        $header[] = $vbphrase['views'];
                        $header[] = $vbphrase['last_post'];
                        $header[] = $vbphrase['info'];
                        $header[] = $vbphrase['controls'];
                        print_cells_row($header, 1, 0, 1);
                }

                $cell = array();
                $cell[] = '<img src="../images/stamps/thread' . $stamp['icon'] . '.gif" border="0" alt="" /></a>';
                $cell[] = '<a href="../showthread.php?t=' . $stamp['threadid'] . '" title="' . $vbphrase['thread_starter']. ':&nbsp;' . $stamp['postusername']. '" target="_blank">' . $stamp['title']. '</a>';
                $cell[] = $stamp['replycount'];
                $cell[] = $stamp['views'];
                $cell[] = vbdate($vbulletin->options['dateformat'], $stamp['lastpost'], 1).'&nbsp;'.vbdate($vbulletin->options['timeformat'], $stamp['lastpost']) .
                '
                <br />
                <a href="../member.php?find=lastposter&amp;t=' . $stamp['threadid'] . '" target="_blank">' . $stamp['lastposter'] . '</a>&nbsp;
                <a href="../showthread.php?goto=newpost&amp;t=' . $stamp['threadid'] . '" target="_blank"><img src="../images/buttons/lastpost.gif" title="' . $vbphrase['go_to_last_post'] . '" border="0" alt="" />
                ';
                $cell[] = construct_phrase($vbphrase[stamp_date_x_by_x],vbdate($vbulletin->options['dateformat'], $stamp['stamptime'],1).' '.vbdate($vbulletin->options['timeformat'], $stamp['stamptime']), $stamp['stampby']) . '&nbsp;' . iif($stamp['stampdays'], construct_phrase($vbphrase['to_x_days'], $stamp['stampdays']));

                $cell[] = '<a href="stamp.php?do=delstamp&amp;id=' . $stamp['threadid'] . '">' . $vbphrase['removestamp'] . '</a>';

                print_cells_row($cell, 0, 0, 1, 1, 0, 1);
                unset($cell);
        }
        print_table_footer();
        $db->free_result($stamps);
}

elseif ($_REQUEST['do'] == "delstamp")
{
     $vbulletin->input->clean_gpc('r', 'id', TYPE_INT);

     $db->query_write("
          UPDATE " . TABLE_PREFIX . "thread
          SET stampid = '0', stampdays = '0', stamptime = '0', stampby = '0'
          WHERE threadid = " . $vbulletin->GPC['id'] . "");

     print_cp_message($vbphrase['stamp_deleted'], "stamp.php?do=show");
}

print_cp_footer();

?>