<?php
// $Date: 2002/03/31 01:01:34 $
// $Revision: 1.3 $
//------------------------------------------------------------------------
//-- A few changes to some of the pop3 class methods
//------------------------------------------------------------------------
//-- Original class in POP3 folder
//------------------------------------------------------------------------

class kPOP3 extends POP3 {

	//-------------------------------------------
	//-- CONNECT GRABBED FROM ORIGINAL SOURCE
	//-------------------------------------------

	//-------------------------------------------
	//-- update_timer function
	//-------------------------------------------
	//-- changes:
	//-- allow timeout to be set from global file
	//-------------------------------------------
	function update_timer()
	{
		global $c;
		if ($c['time_limit'] != '') {
			set_time_limit($c['time_limit']);
		} else {
			set_time_limit($this->TIMEOUT);
		}

		return true;
	}

	//-------------------------------------------
	//-- CONNECT function
	//-------------------------------------------
	//-- changes:
	//-- set_socket_blocking() is deprecated
	//     changed to socket_set_blocking()
	//-- RFC check always failed for me, so
	//     I commented it out, you might want
	//     to uncomment it
	//-------------------------------------------

	function connect($server, $port=110)
	{
		//	Opens a socket to the specified server. Unless overridden,
		//	port defaults to 110. Returns true on success, false on fail

		// If MAILSERVER is set, override $server with it's value

		if(!empty($this->MAILSERVER))
		{
			$server = $this->MAILSERVER;
		}

		if(empty($server))
		{
			$this->ERROR = "POP3 connect: No server specified";  
			unset($this->FP);
			return false;
		}

		$fp = fsockopen("$server", $port, &$errno, &$errstr);

		if(!$fp)
		{
			$this->ERROR = "POP3 connect: Error [$errno] [$errstr]";
			unset($this->FP);
			return false;
		}

		socket_set_blocking($fp,-1);
		$this->update_timer();
		$reply = fgets($fp,$this->BUFFER);
		$reply = $this->strip_clf($reply);
		if($this->DEBUG) { error_log("POP3 SEND [connect: $server] GOT [$reply]",0); }
		if(!$this->is_ok($reply))
		{
			$this->ERROR = "POP3 connect: Error [$reply]";
			unset($this->FP);
			return false;
		}
		$this->FP = $fp;
		$this->BANNER = $this->parse_banner($reply);
		$this->RFC1939 = $this->noop();
		
		/*		
		if($this->RFC1939)
		{
			$this->ERROR = "POP3: premature NOOP OK, NOT an RFC 1939 Compliant server";
			$this->quit();
			return false;
		}
		*/
		return true;
	}


}

?>