<?php

/*
+--------------------------------------------------------------------------
|   Invision Board v1.2
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin functions library
|   > Script written by Matt Mecham
|   > Date started: 1st march 2002
|
+--------------------------------------------------------------------------
*/


class api_functions {

	var $img_url;
	var $page_title  = "";
	var $page_detail = "";
	var $html;
	var $errors = "";
	var $nav    = array();
	var $get_magic_quotes = 0;

	function api_functions()
	{
		global $this_script, $this_board;
		
		$this->base_url = $this_script;
		
		$this->img_url  = 'html/sys-img';
		
		$this->page_title = 'Welcome to the '.$this_board.' convertor';
		
		$this->get_magic_quotes = get_magic_quotes_gpc();
		
	}
	
	/*-------------------------------------------------------------------------*/
	// Safe Slashes - ensures slashes are saved correctly
	// ------------------
	// 
	/*-------------------------------------------------------------------------*/
	
	function txt_safeslashes($t="")
	{
		return str_replace( '\\', "\\\\", $this->txt_stripslashes($t));
	}
	
	
	/*-------------------------------------------------------------------------*/
	// txt_stripslashes
	// ------------------
	// Make Big5 safe - only strip if not already...
	/*-------------------------------------------------------------------------*/
	
	function txt_stripslashes($t)
	{
		if ( $this->get_magic_quotes )
		{
    		$t = stripslashes($t);
    	}
    	
    	return $t;
    }
	
	
	function scale_image($arg)
	{
		// max_width, max_height, cur_width, cur_height
		
		$ret = array(
					  'img_width'  => $arg['cur_width'],
					  'img_height' => $arg['cur_height']
					);
		
		if ( $arg['cur_width'] > $arg['max_width'] )
		{
			$ret['img_width']  = $arg['max_width'];
			$ret['img_height'] = ceil( ( $arg['cur_height'] * ( ( $arg['max_width'] * 100 ) / $arg['cur_width'] ) ) / 100 );
			$arg['cur_height'] = $ret['img_height'];
			$arg['cur_width']  = $ret['img_width'];
		}
		
		if ( $arg['cur_height'] > $arg['max_height'] )
		{
			$ret['img_height']  = $arg['max_height'];
			$ret['img_width']   = ceil( ( $arg['cur_width'] * ( ( $arg['max_height'] * 100 ) / $arg['cur_height'] ) ) / 100 );
		}
		
	
		return $ret;
	
	}
	
	
	function parse_incoming()
    {
    	global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_CLIENT_IP, $REQUEST_METHOD, $REMOTE_ADDR, $HTTP_PROXY_USER, $HTTP_X_FORWARDED_FOR;
    	$return = array();
    	
		if( is_array($HTTP_GET_VARS) )
		{
			while( list($k, $v) = each($HTTP_GET_VARS) )
			{
				//$k = $this->clean_key($k);
				if( is_array($HTTP_GET_VARS[$k]) )
				{
					while( list($k2, $v2) = each($HTTP_GET_VARS[$k]) )
					{
						$return[$k][ $this->clean_key($k2) ] = $this->clean_value($v2);
					}
				}
				else
				{
					$return[$k] = $this->clean_value($v);
				}
			}
		}
		
		// Overwrite GET data with post data
		
		if( is_array($HTTP_POST_VARS) )
		{
			while( list($k, $v) = each($HTTP_POST_VARS) )
			{
				//$k = $this->clean_key($k);
				if ( is_array($HTTP_POST_VARS[$k]) )
				{
					while( list($k2, $v2) = each($HTTP_POST_VARS[$k]) )
					{
						$return[$k][ $this->clean_key($k2) ] = $this->clean_value($v2);
					}
				}
				else
				{
					$return[$k] = $this->clean_value($v);
				}
			}
		}
		
		// Sort out the accessing IP
		
		$return['IP_ADDRESS'] = $this->select_var( array( 
														  1 => $HTTP_X_FORWARDED_FOR,
														  2 => $HTTP_PROXY_USER,
														  3 => $REMOTE_ADDR,
														  4 => $_SERVER['REMOTE_ADDR']
														)
												 );
												 
		// Make sure we take a valid IP address
		
		$return['IP_ADDRESS'] = preg_replace( "/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})/", "\\1.\\2.\\3.\\4", $return['IP_ADDRESS'] );
		
		$return['request_method'] = strtolower($REQUEST_METHOD);
		
		
		return $return;
	}
	
    /*-------------------------------------------------------------------------*/
    // Key Cleaner - ensures no funny business with form elements             
    /*-------------------------------------------------------------------------*/
    
    function clean_key($key) {
    
    	if ($key == "")
    	{
    		return "";
    	}
    	$key = preg_replace( "/\.\./"           , ""  , $key );
    	$key = preg_replace( "/\_\_(.+?)\_\_/"  , ""  , $key );
    	$key = preg_replace( "/^([\w\.\-\_]+)$/", "$1", $key );
    	return $key;
    }
    
    function clean_value($val) {
    
    	if ($val == "")
    	{
    		return "";
    	}
    	$val = preg_replace( "/&/"         , "&amp;"         , $val );
    	$val = preg_replace( "/<!--/"      , "&#60;&#33;--"  , $val );
    	$val = preg_replace( "/-->/"       , "--&#62;"       , $val );
    	$val = preg_replace( "/<script/i"  , "&#60;script"   , $val );
    	$val = preg_replace( "/>/"         , "&gt;"          , $val );
    	$val = preg_replace( "/</"         , "&lt;"          , $val );
    	$val = preg_replace( "/\"/"        , "&quot;"        , $val );
    	$val = preg_replace( "/\|/"        , "&#124;"        , $val );
    	$val = preg_replace( "/\n/"        , "<br>"          , $val ); // Convert literal newlines
    	$val = preg_replace( "/\\\$/"      , "&#036;"        , $val );
    	$val = preg_replace( "/\r/"        , ""              , $val ); // Remove literal carriage returns
    	$val = preg_replace( "/!/"         , "&#33;"         , $val );
    	$val = preg_replace( "/'/"         , "&#39;"         , $val ); // IMPORTANT: It helps to increase sql query safety.
    	$val = stripslashes($val);                                     // Swop PHP added backslashes
    	$val = preg_replace( "/\\\/"       , "&#092;"        , $val ); // Swop user inputted backslashes
    	return $val;
    }
    
    function select_var($array) {
    	
    	if ( !is_array($array) ) return -1;
    	
    	ksort($array);
    	
    	
    	$chosen = -1;  // Ensure that we return zero if nothing else is available
    	
    	foreach ($array as $k => $v)
    	{
    		if (isset($v))
    		{
    			$chosen = $v;
    			break;
    		}
    	}
    	
    	return $chosen;
    }
    
    
	//**********************************************/
	// copy_dir
	//
	// Copies to contents of a dir to a new dir, creating
	// destination dir if needed.
	//
	//**********************************************/
	
	function copy_dir($from_path, $to_path, $mode = 0777)
	{
	
		global $INFO;
		
		// Strip off trailing slashes...
		
		$from_path = preg_replace( "#/$#", "", $from_path);
		$to_path   = preg_replace( "#/$#", "", $to_path);
	
		if ( ! is_dir($from_path) )
		{
			$this->errors = "Could not locate directory '$from_path'";
			return FALSE;
		}
	
		if ( ! is_dir($to_path) )
		{
			if ( ! @mkdir($to_path, $mode) )
			{
				$this->errors = "Could not create directory '$to_path' please check the CHMOD permissions and re-try";
				return FALSE;
			}
			else
			{
				@chmod($to_path, $mode);
			}
		}
		
		$this_path = getcwd();
		
		if (is_dir($from_path))
		{
			chdir($from_path);
			$handle=opendir('.');
			while (($file = readdir($handle)) !== false)
			{
				if (($file != ".") && ($file != ".."))
				{
					if (is_dir($file))
					{
						
						$this->copy_dir($from_path."/".$file, $to_path."/".$file);
						
						chdir($from_path);
					}
					
					if ( is_file($file) )
					{
						copy($from_path."/".$file, $to_path."/".$file);
						@chmod($to_path."/".$file, 0777);
					} 
				}
			}
			closedir($handle); 
		}
		
		if ($this->errors == "")
		{
			return TRUE;
		}
	}
	
	//**********************************************/
	// rm_dir
	//
	// Removes directories, if non empty, removes
	// content and directories
	// (Code based on annotations from the php.net
	// manual by pal@degerstrom.com)
	//**********************************************/
	
	function rm_dir($file)
	{
		global $INFO;
		
		$errors = 0;
		
		// Remove trailing slashes..
		
		$file = preg_replace( "#/$#", "", $file );
		
		if ( file_exists($file) )
		{
			// Attempt CHMOD
			
			@chmod($file, 0777);
			
			if ( is_dir($file) )
			{
				$handle = opendir($file);
				
				while (($filename = readdir($handle)) !== false)
				{
					if (($filename != ".") && ($filename != ".."))
					{
						$this->rm_dir($file."/".$filename);
					}
				}
				
				closedir($handle);
				
				if ( ! @rmdir($file) )
				{
					$errors++;
				}
			}
			else
			{
				if ( ! @unlink($file) )
				{
					$errors++;
				}
			}
		}
		
		if ($errors == 0)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	//**********************************************/
	// rebuild_config:
	//
	// Er, rebuilds the config file
	//
	//**********************************************/
	
	function rebuild_config( $new = "", $name='conf_global.php', $var='INFO' )
	{
		global $IN, $std, $root_path;
		
		//-----------------------------------------
		// Check to make sure this is a valid array
		//-----------------------------------------
		
		if (! is_array($new) )
		{
			$this->error("Error whilst attempting to rebuild the board config file, attempt aborted");
		}
		
		//-----------------------------------------
		// Do we have anything to save out?
		//-----------------------------------------
		
		if ( count($new) < 1 )
		{
			return "";
		}
		
		//-----------------------------------------
		// Get an up to date copy of the config file
		// (Imports $INFO)
		//-----------------------------------------
		
		require $root_path.$name;
		
		//-----------------------------------------
		// Rebuild the $INFO hash
		//-----------------------------------------
		
		foreach( $new as $k => $v )
		{
			// Update the old...
			
			$v = preg_replace( "/'/", "\\'" , $v );
			$v = preg_replace( "/\r/", ""   , $v );
			
			$INFO[ $k ] = $v;
		}	
		
		//-----------------------------------------
		// Rename the old config file
		//-----------------------------------------
		
		@rename( $root_path.$name, $root_path.'bak-'.$name );
		@chmod( $root_path.'bak-'.$name, 0777);
		
		//-----------------------------------------
		// Rebuild the old file
		//-----------------------------------------
		
		$file_string = "<?php\n";
		
		foreach( $INFO as $k => $v )
		{
			if ($k == 'skin' or $k == 'languages')
			{
				// Protect serailized arrays..
				$v = stripslashes($v);
				$v = addslashes($v);
			}
			$file_string .= '$INFO['."'".$k."'".']'."\t\t\t=\t'".$v."';\n";
		}
		
		$file_string .= "\n".'?'.'>';   // Question mark + greater than together break syntax hi-lighting in BBEdit 6 :p
		
		if ( $fh = fopen( $root_path.$name, 'w' ) )
		{
			fputs ($fh, $file_string, strlen($file_string) );
			fclose($fh);
		}
		else
		{
			$this->error("Fatal Error: Could not open conf_global for writing - no changes applied. Try changing the CHMOD to 0777");
		}
		
		// Pass back the new $INFO array to anyone who cares...
		
		return $INFO;
		
	}
	
	
	
	//+------------------------------------------------
	//+------------------------------------------------
	// OUTPUT FUNCTIONS
	//+------------------------------------------------
	//+------------------------------------------------
	
	function print_popup() {
		global $IN, $INFO, $DB, $std, $SKIN, $use_gzip;
	
		$html = "<html>
		          <head><title>Remote</title>
		          <meta HTTP-EQUIV=\"Pragma\"  CONTENT=\"no-cache\">
				  <meta HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\">
				  <meta HTTP-EQUIV=\"Expires\" CONTENT=\"Mon, 06 May 1996 04:57:00 GMT\">";
		
		$html .= $SKIN->get_css();
		
		$html .= "</head>\n";
		
		$html .= "</head>
				  <body marginheight='0' marginwidth='0' leftmargin='0' topmargin='0' bgcolor='#E7E7E7'>
				  <table cellspacing='0' cellpadding='2' width='100%' align='center' border='0' bgcolor='#E7E7E7'>
				   <tr>
					<td>
					 <table cellspacing='3' cellpadding='2' width='100%' align='center' height='100%' border='0' bgcolor='#FFFFFF' style='border:thin solid black'>
						<tr>
						 <td valign='top' bgcolor='#FFFFFF'>
						 <table cellspacing='0' cellpadding='2' border='0' align='center' width='100%' height='100%' bgcolor='#FFFFFF'>";
						 
		$html .= $this->html;
		
		$html .= "</table></td></tr></table></td></tr></table></body></html>";
		
		print $html;
		
		exit();
	}
					   
		
	
	
	function output() {
		global $IN, $INFO, $DB, $HB, $std, $SKIN, $use_gzip;
	
		$html  = $SKIN->print_top($this->page_title, $this->page_detail);
		$html .= $this->html;
		$html .= $SKIN->print_foot();
		
		if ( $DB->connection_id )
		{
			$DB->close_db();
		}
		
		if ( $HB->connection_id )
		{
			$HB->close_db();
		}
		
		if ($use_gzip == 1)
		{
    		ob_start ('ob_gzhandler');
    	}
    	
    	//@header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		//@header("Cache-Control: no-cache, must-revalidate");
		//@header("Pragma: no-cache");
				
    	print $html;
    	
    	exit();
	
	}
	
	//**********************************************/
	// Error:
	//
	// Displays an error
	//
	//**********************************************/
	
	function error($error="", $is_popup=0) {
		global $IN, $INFO, $DB, $std, $SKIN, $HTTP_REFERER;
		
		$this->page_title  = "An Error Occured...";
		$this->page_detail = "The error message returned is displayed below.";
		
		$this->html .= "<tr><td><span style='font-size:14px'>$error</span><br><br><center><a href='$HTTP_REFERER'>Go Back</a></center></td></tr>";
		
		if ($is_popup == 0)
		{
			$this->output();
		}
		else
		{
			$this->print_popup();
		}
		
	}
	
	//**********************************************/
	// Done Screen:
	//
	// Displays the "done" screen. Really? Yes.
	//
	//**********************************************/
	
	function done_screen($title, $link_text="", $link_url="") {
		global $IN, $INFO, $DB, $std, $SKIN;
		
		$this->page_title  = $title;
		$this->page_detail = "The action was executed successfully";
		
		$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
		
		$this->html .= $SKIN->start_table("Result");
		
		$this->html .= $SKIN->add_td_basic( "<a href='{$this->base_url}&{$link_url}' target='body'>Go to: $link_text</a>", "center" );
		
		$this->html .= $SKIN->add_td_basic( "<a href='{$this->base_url}&act=index' target='body'>Go to: Administration Home</a>", "center" );
										 
		$this->html .= $SKIN->end_table();
			
		$this->output();
	
	}
	
	
	
	function redirect_screen($text="", $Url="") {
		global $SKIN, $std, $ibforums;
		
		$this->page_title  = "Conversion in progress...";
		$this->page_detail = "";
		
		$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
		
		$this->html .= "<meta http-equiv='refresh' content='1; url={$ibforums->vars['this_script']}$Url'>";
		
		$this->html .= $SKIN->start_table("Redirection...");
		
		$this->html .= $SKIN->add_td_basic( $text );
		
		$this->html .= $SKIN->add_td_basic( "<a href='{$ibforums->vars['this_script']}$Url'>Click here if you are not automatically redirected</a>", "center" );
										 
		$this->html .= $SKIN->end_table();
			
		$this->output();
	
	}
	
	
	
	
}





?>