<?php

/*
+--------------------------------------------------------------------------
|   Invision Board v1.2 - vBulletin 3 - Invision Board API
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Functions for converting vB2 data
|   > Script written by Matt Mecham
|   > Date started: 25th November 2002
|   > UPDATED: 9th July 2003 (+HiveMail ID +Group re-order)
+--------------------------------------------------------------------------
*/

//--------------------------------------------------
//
// ABOUT THIS API
// --------------
// This API is set up to enable convertor programmers
// to quicky re-use content that is centralized in the
// other libraries.
//
// $ibforums (CLASS) Contains Invision Board config info
// $std (CLASS) Contains re-usable global functions
// $SKIN (CLASS) Contains template & form HTML
// $DB (CLASS) Contains mySQL query information
// $IN (ARRAY) same as $ibforums->input / $_GET & $_POST data
//
//
// FUNCTIONS EXPECTED
// ------------------
// config_form()  Display a HTML form asking for config details
// get_host_rows() Return an array with results from various COUNT(*)
// _convert_*  Conversion routines
//--------------------------------------------------


class api_convertor
{
	// Change this section to suit you convertor module

	var $script  = 'conv_vb3.php';
	var $version = '3.0.0 B5';
	var $board   = 'vBulletin 3';
	var $board_copyright = 'vBulletin is a product of and copyright <a href="http://www.jelsoft.com" target="_blank">Jelsoft Enterprises, Ltd</a>';
	
	var $form_fields = array( 'hb_sql_host', 'hb_sql_database', 'hb_sql_user', 'hb_sql_pass', 'per_members', 'per_topics', 'per_posts', 'per_attach', 'upload_dir' );
	
	
	var $FORUMOPTIONS = array(
								'active'            => 1,
								'allowposting'      => 2,
								'cancontainthreads' => 4,
								'moderatenewpost'   => 8,
								'moderatenewthread' => 16,
								'moderateattach'    => 32,
								'allowbbcode'       => 64,
								'allowimages'       => 128,
								'allowhtml'         => 256,
								'allowsmilies'      => 512,
								'allowicons'        => 1024,
								'allowratings'      => 2048,
								'countposts'        => 4096,
								'canhavepassword'   => 8192,
								'indexposts'        => 16384,
								'styleoverride'     => 32768,
								'showonforumjump'   => 65536,
								'warnall'           => 131072
							);
							
	var $USER_FORUM = array(
								'canview'           => 1,
								'canviewothers'     => 2,
								'cansearch'         => 4,
								'canemail'          => 8,
								'canpostnew'        => 16,
								'canreplyown'       => 32,
								'canreplyothers'    => 64,
								'caneditpost'       => 128,
								'candeletepost'     => 256,
								'candeletethread'   => 512,
								'canopenclose'      => 1024,
								'canmove'           => 2048,
								'cangetattachment'  => 4096,
								'canpostattachment' => 8192,
								'canpostpoll'       => 16384,
								'canvote'           => 32768,
								'canthreadrate'     => 65536,
								'isalwaysmoderated' => 131072,
								'canseedelnotice'   => 262144
							);
							
	var $USER_PERM = array(
								'ismoderator'           => 1,
								'cancontrolpanel'       => 2,
								'canadminsettings'      => 4,
								'canadminstyles'        => 8,
								'canadminlanguages'     => 16,
								'canadminforums'        => 32,
								'canadminthreads'       => 64,
								'canadmincalendars'     => 128,
								'canadminusers'         => 256,
								'canadminpermissions'   => 512,
								'canadminfaq'           => 1024,
								'canadminimages'        => 2048,
								'canadminbbcodes'       => 4096,
								'canadmincron'          => 8192,
								'canadminmaintain'      => 16384,
								'canadminupgrade'       => 32768
							);
							
	var $MOD_PERM = array(
								'caneditposts'           => 1,
								'candeleteposts'         => 2,
								'canopenclose'           => 4,
								'caneditthreads'         => 8,
								'canmanagethreads'       => 16,
								'canannounce'            => 32,
								'canmoderateposts'       => 64,
								'canmoderateattachments' => 128,
								'canmassmove'            => 256,
								'canmassprune'           => 512,
								'canviewips'             => 1024,
								'canviewprofile'         => 2048,
								'canbanusers'            => 4096,
								'canunbanusers'          => 8192,
								'newthreademail'         => 16384,
								'newpostemail'           => 32768,
								'cansetpassword'         => 65536,
								'canremoveposts'         => 131072,
								'caneditsigs'            => 262144,
								'caneditavatar'          => 524288,
								'caneditpoll'            => 1048576,
								'caneditprofilepic'      => 2097152
						);

	//------------------------------------------------------------
	// Display the configuration form, such as original board
	// SQL log in and such.
	//------------------------------------------------------------
	
	function config_form($error="")
	{
		global $DB, $std, $SKIN, $IN, $INFO, $ibforums;
		
		$ibforums->vars['hb_sql_host'] = $ibforums->vars['hb_sql_host'] == "" ?	'localhost' : $ibforums->vars['hb_sql_host'];
		
		//+-------------------------------
		
		$std->page_detail = "This section will enable you to configure this convertor to your preference";
		$std->page_title  = $this->board." Convertor [ Configuration ]";
		
		//+-------------------------------
		
		if ($error != "")
		{
			$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
			$std->html .= $SKIN->start_table( "<span style='color:red'>An Error Occured</span>" );
			
			$std->html .= $SKIN->add_td_row( array( "The following error occured:<br>$error" ) );
			
			$std->html .= $SKIN->end_table();
		}
		
		//+-------------------------------
		
		$std->html .= $SKIN->start_form( array( 1 => array( 'a'     , 'configure' ),
												2 => array( 'set'   , '1'         ),
									   )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$std->html .= $SKIN->start_table( "Configuation" );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_basic( 'Your '.$this->board.' mySQL Information', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_row( array( "<b>Your {$this->board} mySQL <span style='color:red'>server location</span></b><br>This information is in your vB/admin/config.php file" ,
										  $SKIN->form_input( "hb_sql_host", $ibforums->vars['hb_sql_host'] )
								 )      );
									     
		$std->html .= $SKIN->add_td_row( array( "<b>Your {$this->board} mySQL <span style='color:red'>database name</span></b><br>This information is in your vB/admin/config.php file" ,
										  $SKIN->form_input( "hb_sql_database", $ibforums->vars['hb_sql_database'] == "" ? $_POST['hb_sql_database'] : $ibforums->vars['hb_sql_database'] )
								 )      );
 
		$std->html .= $SKIN->add_td_row( array( "<b>Your {$this->board} mySQL <span style='color:red'>database username</span></b><br>This information is in your vB/admin/config.php file" ,
										  $SKIN->form_input( "hb_sql_user", $ibforums->vars['hb_sql_user'] == "" ? $_POST['hb_sql_user'] : $ibforums->vars['hb_sql_user'] )
								 )      );
								 
		$std->html .= $SKIN->add_td_row( array( "<b>Your {$this->board} mySQL <span style='color:red'>database password</span></b><br>This information is in your vB/admin/config.php file" ,
										  $SKIN->form_input( "hb_sql_pass", $ibforums->vars['hb_sql_pass'] == "" ? $_POST['hb_sql_pass'] : $ibforums->vars['hb_sql_pass'], 'password' )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_basic( 'Convertor Preferences', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_row( array( "<b>How many MEMBERS to convert per rotation?</b><br>Low CPU intensive, about 2000 is good for most" ,
										  $SKIN->form_input( "per_members", $ibforums->vars['per_members'] == "" ? $_POST['per_members'] : $ibforums->vars['per_members'] )
								 )      );
								 
		$std->html .= $SKIN->add_td_row( array( "<b>How many TOPICS / POLLS to convert per rotation?</b><br>Low CPU intensive, about 2000 is good for most" ,
										  $SKIN->form_input( "per_topics", $ibforums->vars['per_topics'] == "" ? $_POST['per_topics'] : $ibforums->vars['per_topics'] )
								 )      );
								 
		$std->html .= $SKIN->add_td_row( array( "<b>How many POSTS to convert per rotation?</b><br>Medium CPU intensive, about 1500 is good for most" ,
										  $SKIN->form_input( "per_posts", $ibforums->vars['per_posts'] == "" ? $_POST['per_posts'] : $ibforums->vars['per_posts'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_basic( 'Attachment Conversion Set-up', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->add_td_row( array( "<b>Server path to the IPB <span style='color:red'>uploads</span> folder?</b><br>Example: /home/mydomain/public_html/forums" ,
										  $SKIN->form_input( "upload_dir", $ibforums->vars['upload_dir'] == "" ? $_POST['upload_dir'] : $ibforums->vars['upload_dir'] )
								 )      );
								 
		$std->html .= $SKIN->add_td_row( array( "<b>How many attachments / avatars to convert per rotation?</b><br>Medium CPU intensive, about 100 is good for most" ,
										  $SKIN->form_input( "per_attach", $ibforums->vars['per_attach'] == "" ? $_POST['per_attach'] : $ibforums->vars['per_attach'] )
								 )      );
								 
		
								 
		//-----------------------------------------------------------------------------------------------------------
		
		$std->html .= $SKIN->end_form('Save Configuration');
										 
		$std->html .= $SKIN->end_table();
		
		$std->output();
		
	}
	
	

	function get_host_rows()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums;
		
		// Get the number of users in the vB database
		
		$return = array();
		
		//-----------------------------------------------
		// Get the number of users in the vB database
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as users FROM ".$ibforums->vars['hb_sql_database'].".user");
		
		$a = $HB->fetch_row();
		
		$return['members'] = ( $a['users'] > 0 ) ? $a['users'] : 0;
		
		//-----------------------------------------------
		// Get number of Forums
		//-----------------------------------------------
		// vB3 forums are a little different o_O
		// We'll have to "guess" by choosing forums
		// from cats by 'cancontainthreads'
		
		$return['forums']     = 0;
		$return['categories'] = 0;
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".forum");
		
		while ( $b = $HB->fetch_row() )
		{
			if ( $b['options'] & $this->FORUMOPTIONS['cancontainthreads'] )
			{
				$return['forums']++;
			}
			else
			{
				$return['categories']++;
			}
		}
		
		//-----------------------------------------------
		// Member Groups
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as groups FROM ".$ibforums->vars['hb_sql_database'].".usergroup");
		
		$d = $HB->fetch_row();
		
		$return['groups'] = ( $d['groups'] > 0 ) ? $d['groups'] : 0;
		
		//-----------------------------------------------
		// Ranks
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as ranks FROM ".$ibforums->vars['hb_sql_database'].".usertitle");
		
		$e = $HB->fetch_row();
		
		$return['ranks'] = ( $e['ranks'] > 0 ) ? $e['ranks'] : 0;
		
		//-----------------------------------------------
		// Topics
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as threads FROM ".$ibforums->vars['hb_sql_database'].".thread");
		
		$f = $HB->fetch_row();
		
		$return['topics'] = ( $f['threads'] > 0 ) ? $f['threads'] : 0;
		
		//-----------------------------------------------
		// Posts
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as posts FROM ".$ibforums->vars['hb_sql_database'].".post");
		
		$g = $HB->fetch_row();
		
		$return['posts'] = ( $g['posts'] > 0 ) ? $g['posts'] : 0;
		
		//-----------------------------------------------
		// Personal Messages
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as pms FROM ".$ibforums->vars['hb_sql_database'].".pm");
		
		$h = $HB->fetch_row();
		
		$return['pms'] = ( $h['pms'] > 0 ) ? $h['pms'] : 0;
		
		//-----------------------------------------------
		// Poll Voters
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as polls FROM ".$ibforums->vars['hb_sql_database'].".poll");
		
		$i = $HB->fetch_row();
		
		$return['polls'] = ( $i['polls'] > 0 ) ? $i['polls'] : 0;
		
		//-----------------------------------------------
		// Moderators
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as mods FROM ".$ibforums->vars['hb_sql_database'].".moderator");
		
		$j = $HB->fetch_row();
		
		$return['moderators'] = ( $j['mods'] > 0 ) ? $j['mods'] : 0;
		
		//-----------------------------------------------
		// Attachments
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as attachment FROM ".$ibforums->vars['hb_sql_database'].".attachment");
		
		$j = $HB->fetch_row();
		
		$return['attachment'] = ( $j['attachment'] > 0 ) ? $j['attachment'] : 0;
		
		//-----------------------------------------------
		// Avatars
		//-----------------------------------------------
		
		$HB->query("SELECT COUNT(*) as avatar FROM ".$ibforums->vars['hb_sql_database'].".customavatar");
		
		$j = $HB->fetch_row();
		
		$return['avatars'] = ( $j['avatar'] > 0 ) ? $j['avatar'] : 0;
		
		return $return;
		
	}

	//-----------------------------------------------------
	// Returns intro text, such as what can't be converted,
	// etc
	//-----------------------------------------------------

	function get_intro($tbl)
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums;
		
		if ($tbl == 'members')
		{
			return "<b>Converting Members</b><br><br>Due to the different ways that the information is stored, not all member information can be converted cleanly. Avatars won't be converted as well as
			some other member preferences. Member names, posts and passwords will be converted successfully.<br><br>As with all conversion sections, running the convertor will empty your Invision Power
			Board Members table before inserting the new data. It is suggested that you ensure that you know your administrators account password before converting.
			<br />If you have HiveMail installed, this ID will be converted too.";
		}
		else if ($tbl == 'forums')
		{
			return "<b>Converting Forums</b><br><br>Due to the different forum access mask permissions, the forums will be converted to GLOBAL read permissions, meaning that all groups can read, write and reply
			into all your current forums regardless of the vBulletin permissions system.
			<br><br>
			After converting the forums, your Invision Power Board will be set into Offline mode to protect your private forums until you've had a chance to reset the forum permissions.
			<br><br>
			Embedded sub forums may also be converted to the category parent, you can edit the forums from the IPB Admin CP to correct this post-installation";
		}
		else if ($tbl == 'categories')
		{
			return "<b>Converting Categories</b><br><br>
			Due to the different ways categories are created, you may need to edit some information post-installation to ensure correct ordering";
		}
		else if ($tbl == 'groups')
		{
			return "<b>Converting Groups</b><br><br>
			Due to the different ways groups are used, you may have to re-enable some permissions post installation. After conversion, you can edit these via the IPB Admin CP to enable to extra features IPB has.";
		}
		else if ($tbl == 'ranks')
		{
			return "<b>Converting User Ranks</b><br><br>
			This will convert existing user rank tiers into the Invision Power Board Format. After conversion, you can edit these via the IPB Admin CP to enable to extra features IPB has.";
		}
		else if ($tbl == 'topics')
		{
			return "<b>Converting Topics</b><br><br>
			Topics that are just moved topics redirects will not be converted.";
		}
		else if ($tbl == 'posts')
		{
			return "<b>Converting Posts</b><br><br>
			Attachments must be converted separately - see the main convertor page for the attachment conversion link.";
		}
		else if ($tbl == 'pms')
		{
			return "<b>Converting Personal Messages</b><br><br>
			Please note that custom messenger folders cannot be converted and all messages will be moved into the users inbox.";
		}
		else if ($tbl == 'polls')
		{
			return "<b>Converting Polls</b><br><br>
			Please note that the poll voters will not be converted, allowing your members to vote again in an existing poll.";
		}
		else if ($tbl == 'moderators')
		{
			return "<b>Converting Moderators</b><br><br>
			You may need to edit the moderators post-installation to ensure that the extra features in IPB are activated.";
		}
		else if ($tbl == 'attachment')
		{
			return "<b>Converting Attachments</b><br><br>
			These vB attachments will be stored as files in IPB's upload directory. Note: <b>YOU MUST CONVERT POSTS BEFORE CONVERTING ATTACHMENTS!</b>";
		}
		else if ($tbl == 'avatars')
		{
			return "<b>Converting Avatars</b><br><br>
			These vB custom avatars will be stored as files in IPB's upload directory.";
		}
	}

	//-----------------------------------------------------
	// Returns done text,
	//-----------------------------------------------------

	function get_end($tbl)
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums;
		
		if ($tbl == 'members')
		{
			return "<b>Members Converted</b><br><br>All members have been converted.<br>The existing username and password should be able to be used without any problems.<br><br>There may
			be instances where unusual user names containing HTML entities (such as &gt;, &lt;, etc) may have trouble logging in, if this is the case, a simple member name change from the
			IPB Admin CP will fix the problem.";
		}
		else if ( $tbl == 'forums' )
		{
			return "<b>Forums Converted</b><br><br>After you have converted all the sections, it is advised that you re-set the forum permissions and edit any sub forums to ensure the
			correct forum structure.";
		}
		else if ( $tbl == 'categories' )
		{
			return "<b>Categories Converted</b>";
		}
		else if ( $tbl == 'groups' )
		{
			return "<b>Member Groups Converted</b><br><br>To ensure that your retain compatibility with third party applications (such as PhotoPost, etc) the member groups have been remapped.
				   This means that is very likely your new IPB has removed and condensed some groups resulting in fewer groups. This is normal. We strongly suggest that post-installation you
				   check each group in your IPB ACP to ensure that permissions have been set correctly.";
		}
		else if ( $tbl == 'ranks' )
		{
			return "<b>User Ranks Converted</b>";
		}
		else if ( $tbl == 'topics' )
		{
			return "<b>Topics Converted</b>";
		}
		else if ( $tbl == 'posts' )
		{
			return "<b>Posts Converted</b>";
		}
		else if ( $tbl == 'pms' )
		{
			return "<b>Personal Messages Converted</b>";
		}
		else if ( $tbl == 'polls' )
		{
			return "<b>Polls Converted</b>";
		}
		else if ( $tbl == 'moderators' )
		{
			return "<b>Moderators Converted</b>";
		}
		else if ($tbl == 'attachment')
		{
			return "<b>Attachments Converted</b>";
		}
		else if ($tbl == 'avatars')
		{
			return "<b>Avatars Converted</b>";
		}
	}
	
	
	//-----------------------------------------------------
	// Returns intro text, such as what can't be converted,
	// etc
	//-----------------------------------------------------

	function convert($tbl)
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums;
		
		switch($tbl)
		{
			case 'members':
				$this->_convert_members();
				break;
			case 'forums':
				$this->_convert_forums();
				break;
			case 'categories':
				$this->_convert_categories();
				break;
			case 'groups':
				$this->_convert_groups();
				break;
			case 'ranks':
				$this->_convert_ranks();
				break;
			case 'topics':
				$this->_convert_topics();
				break;
			case 'posts':
				$this->_convert_posts();
				break;
			case 'pms':
				$this->_convert_pms();
				break;
			case 'polls':
				$this->_convert_polls();
				break;
			case 'attachment':
				$this->_convert_attachments();
				break;
			case 'avatars':
				$this->_convert_avatars();
				break;
			case 'moderators':
				$this->_convert_moderators();
				break;
		}
	}
	
	//====================================================================
	//
	// CONVERT AVATARS
	//
	//====================================================================

	function _convert_avatars()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_attach']) > 0) ? intval($ibforums->vars['per_attach']) : 50000;
		$start = (intval($ibforums->input['st']) > 0)        ? intval($ibforums->input['st'])        : 0;
		
		
		//---------------------------
		// Check upload dir status
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			if ( ! @is_dir($ibforums->vars['upload_dir']) )
			{
				fatal_error("Cannot locate IPB upload directory - check your configuration!");
			}
		}
		
		// Remove trailing slash
		
		$ibforums->vars['upload_dir'] = preg_replace( "#/$#", "", $ibforums->vars['upload_dir'] );
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".customavatar LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Attachment conversion complete", "?a=convert&tbl=avatars&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['userid'] == "" OR $row['avatardata'] == "" OR $row['filename'] == "" )
			{
				continue;
			}
			
			//-------------------------------------------------
			// Step 1: Add it as a new file..
			//-------------------------------------------------
			
			$extension = strtolower( substr ( strrchr( $row['filename'],"." ),1 ) );
			
			$ext = '.ibf';
			
			switch($extension)
			{
				case 'gif':
					$ext = '.gif';
					$file_type = 'image/gif';
					break;
				case 'jpg':
					$ext = '.jpg';
					$file_type = 'image/jpeg';
					break;
				case 'jpeg':
					$ext = '.jpeg';
					$file_type = 'image/jpeg';
					break;
				case 'png':
					$ext = '.png';
					$file_type = 'image/x-png';
				default:
					$ext = '.gif';
					$file_type = 'image/gif';
					break;
			}
			
			$real_name = 'av-'.$row['userid'].$ext;
			
			//-------------------------------------------------
			// Step 2: Create file...
			//-------------------------------------------------
			
			if ( $FH = @fopen( $ibforums->vars['upload_dir']."/".$real_name, 'wb' ) )
			{
				@fwrite( $FH, $row['avatardata'], strlen($row['avatardata']) );
				@fclose( $FH );
			}

			@chmod( $ibforums->vars['upload_dir']."/".$real_name, 0777 );
			
			//-------------------------------------------------
			// Step 3: Update member..
			//-------------------------------------------------
			
			$ibforums->vars['avatar_dims'] = $ibforums->vars['avatar_dims'] == "" ? '80x80': $ibforums->vars['avatar_dims'];
			
			list($p_width, $p_height) = explode( "x", $ibforums->vars['avatar_dims'] );
			
			$im = array( 'img_width' => 80, 'img_height' => 80 );
			
			if ( USEGIS )
			{
				$img_size = GetImageSize( $ibforums->vars['upload_dir']."/".$real_name );
				
				$im = $std->scale_image( array(
												'max_width'  => $p_width,
												'max_height' => $p_height,
												'cur_width'  => $img_size[0],
												'cur_height' => $img_size[1]
									   )      );
			}
			else
			{	
				$w = intval($ibforums->input['man_width'])  ? intval($ibforums->input['man_width'])  : $p_width;
				$h = intval($ibforums->input['man_height']) ? intval($ibforums->input['man_height']) : $p_height;
				$im['img_width']  = $w > $p_width  ? $p_width  : $w;
				$im['img_height'] = $h > $p_height ? $p_height : $h;
			}
			
			// Set the "real" avatar..
				
			$real_choice = 'upload:'.$real_name;
			$real_dims   = $im['img_width'].'x'.$im['img_height'];
			
			$DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}members SET avatar='$real_choice', avatar_size='$real_dims' WHERE id='".$row['userid']."'");
			
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Avatars $start to $new_start converted....", "?a=convert&tbl=avatars&st=$new_start");
		
	}
	
	//====================================================================
	//
	// CONVERT ATTACHMENTS
	//
	//====================================================================

	function _convert_attachments()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_attach']) > 0) ? intval($ibforums->vars['per_attach']) : 50000;
		$start = (intval($ibforums->input['st']) > 0)        ? intval($ibforums->input['st'])        : 0;
		
		
		//---------------------------
		// Check upload dir status
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			if ( ! @is_dir($ibforums->vars['upload_dir']) )
			{
				fatal_error("Cannot locate IPB upload directory - check your configuration!");
			}
		}
		
		// Remove trailing slash
		
		$ibforums->vars['upload_dir'] = preg_replace( "#/$#", "", $ibforums->vars['upload_dir'] );
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT distinct(a.attachmentid), a.userid, a.dateline, a.filename, a.filedata, a.visible, a.counter, a.filesize, a.postid, a.filehash,
					 p.postid, p.dateline as postdate, p.threadid, t.forumid FROM ".$ibforums->vars['hb_sql_database'].".attachment a
		             LEFT JOIN ".$ibforums->vars['hb_sql_database'].".post p ON (p.attach=a.attachmentid)
		             LEFT JOIN ".$ibforums->vars['hb_sql_database'].".thread t ON (t.threadid=p.threadid)
		            GROUP BY p.postid
				    LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Attachment conversion complete", "?a=convert&tbl=attachment&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['filename'] == "" OR $row['filedata'] == "" OR $row['postid'] == "" )
			{
				continue;
			}
			
			//-------------------------------------------------
			// Step 1: Add it as a new file..
			//-------------------------------------------------
			
			$file_name = preg_replace( "/[^\w\.]/", "_", $row['filename'] );
		
			$real_file_name = "post-".$row['forumid']."-".$row['postdate'];
			
			if (preg_match( "/\.(cgi|pl|js|asp|php|html|htm|jsp|jar)/", $file_name ))
			{
				$file_type = 'text/plain';
				$extension = 'txt';
			}
			else
			{
				$extension = strtolower( substr ( strrchr( $row['filename'],"." ),1 ) );
			}
			
			$ext = '.ibf';
			
			switch($extension)
			{
				case 'gif':
					$ext = '.gif';
					$file_type = 'image/gif';
					break;
				case 'txt':
					$ext = '.txt';
					$file_type = 'text/plain';
					break;
				case 'jpg':
					$ext = '.jpg';
					$file_type = 'image/jpeg';
					break;
				case 'jpeg':
					$ext = '.jpeg';
					$file_type = 'image/jpeg';
					break;
				case 'png':
					$ext = '.png';
					$file_type = 'image/x-png';
					break;
				case 'pdf':
					$ext = '.pdf';
					$file_type = 'application/pdf';
					break;
				default:
					$ext = '.ibf';
					$file_type = 'unknown/unknown';
					break;
			}
			
			$real_file_name .= $ext;
			
			//-------------------------------------------------
			// Step 2: Create file...
			//-------------------------------------------------
			
			if ( $FH = @fopen( $ibforums->vars['upload_dir']."/".$real_file_name, 'wb' ) )
			{
				@fwrite( $FH, $row['filedata'], strlen($row['filedata']) );
				@fclose( $FH );
			}

			@chmod( $ibforums->vars['upload_dir']."/".$real_file_name, 0777 );
			
			//-------------------------------------------------
			// Step 3: Update file..
			//-------------------------------------------------
			
			$attach_data = array();
			
			$attach_data['attach_id']   = $real_file_name;
			$attach_data['attach_hits'] = 0;
			$attach_data['attach_type'] = $file_type;
			$attach_data['attach_file'] = $file_name;

			$db_string = $DB->compile_db_update_string($attach_data);
			
			$DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}posts SET $db_string WHERE pid={$row['postid']}");
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Attachments $start to $new_start converted....", "?a=convert&tbl=attachment&st=$new_start");
		
	}
	
	
	//====================================================================
	//
	// CONVERT MODERATORS
	//
	//====================================================================

	function _convert_moderators()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}moderators");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT m.*, mem.username
					  FROM ".$ibforums->vars['hb_sql_database'].".moderator m, ".$ibforums->vars['hb_sql_database'].".user mem
					WHERE m.userid=mem.userid");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Moderator conversion complete", "?a=convert&tbl=moderators&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['moderatorid'] == "" OR $row['userid'] == "" OR $row['forumid'] == "")
			{
				continue;
			}
			
			$db_array = array(
								'mid'		  => $row['moderatorid'],
								'forum_id'	  => $row['forumid'],
								'member_name' => $row['username'],
								'member_id'	  => $row['userid'],
								'edit_post'	  => $row['caneditposts'],
								'edit_topic'  => $row['caneditthreads'],
								'delete_post' => $row['candeleteposts'],
								'delete_topic'=> $row['canmanagethreads'],
								'view_ip'	  => $row['canviewips'],
								'open_topic'  => $row['canopenclose'],
								'close_topic' => $row['canopenclose'],
								'mass_move'   => $row['canmassmove'],
								'mass_prune'  => $row['canmassprune'],
								'move_topic'  => $row['canmanagethreads'],
								'pin_topic'   => $row['canmanagethreads'],
								'unpin_topic' => $row['canmanagethreads'],
								'post_q'      => $row['canmoderateposts'],
								'topic_q'     => $row['canmoderateposts'],
								'allow_warn'  => 0,
								'edit_user'   => $row['canviewprofile'],
								'is_group'    => 0,
								'split_merge' => $row['canmanagethreads'],
							);

			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}moderators (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		$std->redirect_screen("Moderators conversion complete", "?a=convert&tbl=moderators&end=1");
		
	}
	
	
	
	//====================================================================
	//
	// CONVERT POLLS
	//
	//====================================================================

	function _convert_polls()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_topics']) > 0) ? intval($ibforums->vars['per_topics']) : 50000;
		$start =      (intval($ibforums->input['st']) > 0)    ?      intval($ibforums->input['st'])    : 0;
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}polls");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT t.threadid, t.postuserid, t.forumid, p.pollid, p.dateline, p.options, p.votes
					 FROM ".$ibforums->vars['hb_sql_database'].".poll p
					 LEFT JOIN ".$ibforums->vars['hb_sql_database'].".thread t ON t.pollid=p.pollid
					LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Poll conversion complete", "?a=convert&tbl=polls&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['pollid'] == "" )
			{
				continue;
			}
			
			//---------------
			
			$options = explode("|||", $row['options']);
			$votes   = explode("|||", $row['votes']  );
		
			$choices = array();
			
			for($p = 0; $p < sizeof($options); $p++)
			{
				$choices[] = array($p, $std->clean_value($options[$p]), $votes[$p]);
			}
		
			$total_votes = 0;
			
			foreach($votes as $vote)
			{
				$total_votes += $vote;
			}
			
			//---------------
			
			$db_array = array(
								'pid'		=> $row['pollid'],
								'tid'		=> $row['threadid'],
								'start_date'=> $row['dateline'],
								'choices'   => addslashes(serialize($choices)),
								'starter_id'=> $row['postuserid'],
								'votes'     => $total_votes,
								'forum_id'  => $row['forumid']
							);
							
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}polls (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Polls $start to $new_start converted....", "?a=convert&tbl=polls&st=$new_start");
		
	}
	
	//====================================================================
	//
	// CONVERT PRIVATE MESSAGES
	//
	//====================================================================

	function _convert_pms()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_posts']) > 0) ? intval($ibforums->vars['per_posts']) : 50000;
		$start =      (intval($ibforums->input['st']) > 0)    ?      intval($ibforums->input['st'])    : 0;
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}messages");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT p.*, pt.* FROM ".$ibforums->vars['hb_sql_database'].".pm p
					 LEFT JOIN ".$ibforums->vars['hb_sql_database'].".pmtext pt ON (pt.pmtextid=p.pmtextid)
				    LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Personal message conversion complete", "?a=convert&tbl=pms&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['pmid'] == "" )
			{
				continue;
			}
			
			//$touserarray = unserialize(stripslashes($row['touserarray']));
			
			$touserid = array_flip(unserialize(stripslashes($row['touserarray'])));
			
			$db_array = array(
								'msg_id'		=> $row['pmid'],
								'msg_date'	    => $row['dateline'],
								'read_state'	=> $row['messageread'] ? 1 : 0,
								'title'			=> preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $row['title'] ),
								'message'		=> $PARSER->convert( array( 'TEXT'      => preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $row['message'] ),
																   		    'SMILIES'   => 1,
																   		    'CODE'      => 1,
																   		    'HTML'      => 0,
																  		    'SIGNATURE' => 0
														 		   )       ),
								'from_id'		=> $row['fromuserid'],
								'vid'			=> $row['folderid'] == '-1' ? 'sent' : 'in',
								'member_id'		=> $row['userid'],
								'recipient_id'	=> $touserid[0],
							);


			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}messages (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Personal Messages $start to $new_start converted....", "?a=convert&tbl=pms&st=$new_start");
		
	}
	
	//====================================================================
	//
	// CONVERT POSTS
	//
	//====================================================================

	function _convert_posts()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_posts']) > 0) ? intval($ibforums->vars['per_posts']) : 50000;
		$start =      (intval($ibforums->input['st']) > 0)    ?      intval($ibforums->input['st'])    : 0;
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}posts");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT post.*, t.forumid FROM ".$ibforums->vars['hb_sql_database'].".post
				    LEFT JOIN ".$ibforums->vars['hb_sql_database'].".thread AS t ON t.threadid=post.threadid
				    ORDER BY post.postid ASC
				    LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Post conversion complete", "?a=convert&tbl=posts&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['postid'] == "" )
			{
				continue;
			}
			
			$db_array = array(
								'pid'		  => $row['postid'],
								'author_id'   => $row['userid'],
								'author_name' => $std->txt_safeslashes($row['username']),
								'use_sig'     => $row['showsignature'],
								'use_emo'     => $row['allowsmilie'],
								'ip_address'  => $row['ipaddress'],
								'post_date'   => $row['dateline'],
								'icon_id'	  => 0,
								'post'		  => $PARSER->convert( array( 'TEXT'      => $std->txt_safeslashes($row['pagetext']),
																   		  'SMILIES'   => $row['allowsmilie'],
																   		  'CODE'      => 1,
																   		  'HTML'      => 0,
																  		  'SIGNATURE' => 0
														 		)       ),
								'queued'      => 0,
								'topic_id'    => $row['threadid'],
								'forum_id'    => $row['forumid'],
								'post_title'  => $row['title'],
								'new_topic'   => 0
							);
							
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}posts (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Posts $start to $new_start converted....", "?a=convert&tbl=posts&st=$new_start");
		
	}
	
	//====================================================================
	//
	// CONVERT TOPICS
	//
	//====================================================================

	function _convert_topics()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_topics']) > 0) ? intval($ibforums->vars['per_topics']) : 50000;
		$start =      (intval($ibforums->input['st']) > 0)    ?      intval($ibforums->input['st'])    : 0;
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}topics");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT u.username, u.userid, t.* FROM ".$ibforums->vars['hb_sql_database'].".thread t
					 LEFT JOIN ".$ibforums->vars['hb_sql_database'].".user u ON u.username=t.lastposter
				    GROUP BY t.threadid LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Topic conversion complete", "?a=convert&tbl=topics&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['threadid'] == "" OR $row['title'] == "" OR $row['open'] == 10 )
			{
				continue;
			}
			
			$db_array = array(
								'tid'		       => $row['threadid'],
								'title'		       => $std->txt_safeslashes($row['title']),
								'state'		       => $row['open'] == 1 ? 'open' : 'closed',
								'posts'		       => $row['replycount'],
								'starter_id'       => $row['postuserid'],
								'starter_name'     => $row['postusername'],
								'start_date'       => $row['dateline'],
								'last_post'        => $row['lastpost'],
								'icon_id'          => 0,
								'last_poster_id'   => $row['userid'],
								'last_poster_name' => $std->txt_safeslashes($row['lastposter']),
								'poll_state'	   => $row['pollid'] > 0 ? 'open' : 0,
								'last_vote'		   => 0,
								'views'			   => $row['views'],
								'forum_id'		   => $row['forumid'],
								'approved'		   => 1,
								'author_mode'	   => 1,
								'pinned'		   => $row['sticky']
								);
								
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}topics (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
			
			unset($row);
			unset($db_string);
			unset($db_array);
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Topics $start to $new_start converted....", "?a=convert&tbl=topics&st=$new_start");
		
	}
	
	//====================================================================
	//
	// CONVERT RANKS
	//
	//====================================================================

	function _convert_ranks()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}titles");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".usertitle");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("User Rank conversion complete", "?a=convert&tbl=ranks&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			$db_array = array(
								'id'	=> $row['usertitleid'],
								'posts' => $row['minposts'],
								'title' => $row['title'],
							);

			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}titles (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		$std->redirect_screen("User Ranks conversion complete", "?a=convert&tbl=ranks&end=1");
		
	}
	
	
	//====================================================================
	//
	// CONVERT GROUPS
	//
	//====================================================================

	function _convert_groups()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}groups");
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}groups (g_id, g_view_board, g_mem_info, g_other_topics, g_use_search, g_email_friend, g_invite_friend, g_edit_profile, g_post_new_topics, g_reply_own_topics, g_reply_other_topics, g_edit_posts, g_delete_own_posts, g_open_close_posts, g_delete_own_topics, g_post_polls, g_vote_polls, g_use_pm, g_is_supmod, g_access_cp, g_title, g_can_remove, g_append_edit, g_access_offline, g_avoid_q, g_avoid_flood, g_icon, g_attach_max, g_avatar_upload, g_calendar_post, prefix, suffix, g_max_messages, g_max_mass_pm, g_search_flood, g_edit_cutoff, g_promotion, g_hide_from_list, g_post_closed, g_perm_id) VALUES (4, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 'Admin', 0, 1, 1, 1, 1, '', 50000, 1, 1, '', '', 50, 6, 0, 5, '-1&-1', 0, 1, 4)");
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}groups (g_id, g_view_board, g_mem_info, g_other_topics, g_use_search, g_email_friend, g_invite_friend, g_edit_profile, g_post_new_topics, g_reply_own_topics, g_reply_other_topics, g_edit_posts, g_delete_own_posts, g_open_close_posts, g_delete_own_topics, g_post_polls, g_vote_polls, g_use_pm, g_is_supmod, g_access_cp, g_title, g_can_remove, g_append_edit, g_access_offline, g_avoid_q, g_avoid_flood, g_icon, g_attach_max, g_avatar_upload, g_calendar_post, prefix, suffix, g_max_messages, g_max_mass_pm, g_search_flood, g_edit_cutoff, g_promotion, g_hide_from_list, g_perm_id) VALUES (2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL, 'Guests', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL, NULL, 50, 0, 20, 0, '-1&-1', 0, 2)");
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}groups (g_id, g_view_board, g_mem_info, g_other_topics, g_use_search, g_email_friend, g_invite_friend, g_edit_profile, g_post_new_topics, g_reply_own_topics, g_reply_other_topics, g_edit_posts, g_delete_own_posts, g_open_close_posts, g_delete_own_topics, g_post_polls, g_vote_polls, g_use_pm, g_is_supmod, g_access_cp, g_title, g_can_remove, g_append_edit, g_access_offline, g_avoid_q, g_avoid_flood, g_icon, g_attach_max, g_avatar_upload, g_calendar_post, prefix, suffix, g_max_messages, g_max_mass_pm, g_search_flood, g_edit_cutoff, g_promotion, g_hide_from_list, g_perm_id) VALUES (3, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 'Members', 0, 1, 0, 0, 0, '', 0, 1, 0, '', '', 50, 0, 20, 0, '-1&-1', 0, 3)");
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}groups (g_id, g_view_board, g_mem_info, g_other_topics, g_use_search, g_email_friend, g_invite_friend, g_edit_profile, g_post_new_topics, g_reply_own_topics, g_reply_other_topics, g_edit_posts, g_delete_own_posts, g_open_close_posts, g_delete_own_topics, g_post_polls, g_vote_polls, g_use_pm, g_is_supmod, g_access_cp, g_title, g_can_remove, g_append_edit, g_access_offline, g_avoid_q, g_avoid_flood, g_icon, g_attach_max, g_avatar_upload, g_calendar_post, prefix, suffix, g_max_messages, g_max_mass_pm, g_search_flood, g_edit_cutoff, g_promotion, g_hide_from_list, g_perm_id) VALUES (1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'Validating', 0, 1, 0, 0, 0, NULL, 0, 0, 0, NULL, NULL, 50, 0, 20, 0, '-1&-1', 0, 1)");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".usergroup WHERE usergroupid NOT IN (1,2,3,4,6)");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Member Group conversion complete", "?a=convert&tbl=groups&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			foreach( $this->USER_FORUM as $name => $bit )
			{
				$row[ $name ] = ( $row['forumpermissions'] & $bit ) ? 1 : 0;
			}
			
			foreach( $this->USER_PERM as $name => $bit )
			{
				$row[ $name ] = ( $row['adminpermissions'] & $bit ) ? 1 : 0;
			}
			
			$db_array = array(
								'g_id'			     => $row['usergroupid'],
								'g_view_board'	     => $row['canview'],
								'g_mem_info'	     => 1,
								'g_other_topics'     => $row['canviewothers'],
								'g_use_search'	     => $row['cansearch'],
								'g_email_friend'     => 1,
								'g_invite_friend'    => 1,
								'g_edit_profile'     => 1,
								'g_post_new_topics'  => $row['canpostnew'],
								'g_reply_own_topics' => $row['canreplyothers'],
								'g_edit_posts'		 => $row['caneditpost'],
								'g_delete_own_posts' => $row['candeletepost'],
								'g_open_close_posts' => $row['canopenclose'],
								'g_delete_own_topics'=> $row['candeletethread'],
								'g_post_polls'		 => $row['canpostpoll'],
								'g_vote_polls'		 => $row['canvote'],
								'g_use_pm'			 => 1,
								'g_is_supmod'		 => $row['ismoderator'],
								'g_access_cp'		 => $row['cancontrolpanel'],
								'g_title'			 => $row['title'],
								'g_can_remove'		 => 0,
								'g_append_edit'      => 1,
								'g_access_offline'   => 0,
								'g_avoid_q'			 => $row['ismoderator'],
								'g_avoid_flood'		 => $row['ismoderator'],
								'g_calendar_post'	 => 0,
								
							);

			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}groups (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
							
		//---------------------------------------------
		// Sort out new forum masks
		//---------------------------------------------
		
		$oq = $DB->query("SELECT g_id, g_title FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}groups ORDER BY g_id");
	
		while( $r = $DB->fetch_row($oq) )
		{
			$nq = $DB->query("REPLACE INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}forum_perms SET perm_id={$r['g_id']}, perm_name='{$r['g_title']} Mask'");
			$bq = $DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}groups SET g_perm_id={$r['g_id']} WHERE g_id={$r['g_id']}");
		}
		
		//---------------------------------------------
		// Make sure only admins can see the board
		//---------------------------------------------
		
		$DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}groups SET g_access_offline=0");
		$DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}groups SET g_access_offline=1 WHERE g_id=4");
		
		$std->redirect_screen("Member Group conversion complete", "?a=convert&tbl=groups&end=1");
		
	}
	
	//====================================================================
	//
	// CONVERT CATEGORIES
	//
	//====================================================================

	function _convert_categories()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}categories");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".forum");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Category conversion complete", "?a=convert&tbl=categories&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			foreach( $this->FORUMOPTIONS as $name => $bit )
			{
				$row[ $name ] = ( $row['options'] & $bit ) ? 1 : 0;
			}
			
			if ( $row['cancontainthreads'] == 1 )
			{
				continue;
			}
			
			$db_array = array(
								'id'		  => $row['forumid'],
								'position'    => $row['displayorder'],
								'state'		  => $row['active'],
								'name'		  => $row['title'],
								'description' => $row['description'],
							);
							
							
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}categories (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		$std->redirect_screen("Category conversion complete", "?a=convert&tbl=categories&end=1");
		
	}
	
	//====================================================================
	//
	// CONVERT FORUMS
	//
	//====================================================================

	function _convert_forums()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}forums");
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT * FROM ".$ibforums->vars['hb_sql_database'].".forum");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Forums conversion complete", "?a=convert&tbl=forums&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			foreach( $this->FORUMOPTIONS as $name => $bit )
			{
				$row[ $name ] = ( $row['options'] & $bit ) ? 1 : 0;
			}
			
			if ( $row['cancontainthreads'] == 0 )
			{
				continue;
			}
			
			$db_array = array(
								'id'               => $row['forumid'],
								'topics'           => $row['threadcount'],
								'posts'            => $row['replycount'],
								'last_post'        => $row['lastpost'],
								'last_poster_id'   => 1,
								'last_poster_name' => $row['lastposter'],
								'name'             => $row['title'],
								'description'      => $row['description'],
								'position'         => $row['displayorder'],
								'use_ibc'          => $row['allowbbcode'],
								'use_html'         => $row['allowhtml'],
								'status'           => $row['active'],
								'reply_perms'      => '*',
								'start_perms'      => '*',
								'read_perms'       => '*',
								'category'         => $row['parentid'] < 1 ? 1 : $row['parentid'],
								'sort_key'         => 'last_post',
								'sort_order'       => 'Z-A',
								'prune'            => 30,
								'preview_posts'    => 0,
								'allow_poll'       => 1,
								'allow_pollbump'   => 0,
								'inc_postcount'    => 1,
							);
							
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}forums (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
	
		}
		
		// Turn board offline.
		
		$std->rebuild_config( array( 
										'offline_msg'       =>  "<b>Welcome!</b><br><br>We are in the process of upgrading our forums, please try again later!
															    <br><br>If you are the board administrator, you can log in below and begin setting up your new board",
										'board_offline'		=>  1,
						    )      );
		
		$std->redirect_screen("Forums conversion complete", "?a=convert&tbl=forums&end=1");
		
	}
	
	//====================================================================
	//
	// CONVERT MEMBERS
	//
	//====================================================================

	function _convert_members()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Limit rows
		//---------------------------
		
		$end   = (intval($ibforums->vars['per_members']) > 0) ? intval($ibforums->vars['per_members']) : 50000;
		$start =      (intval($ibforums->input['st']) > 0)    ?      intval($ibforums->input['st'])    : 0;
		
		//---------------------------
		// Did you drop one?
		//---------------------------
		
		if ( intval($ibforums->input['drop']) == 1 )
		{
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}members");
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}pfields_content");
			$DB->query("DELETE FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}member_extra");
			
			if ( ! $DB->field_exists( 'hiveuserid', $ibforums->vars['sql_database'].".{tbl.prefix}member_extra" ) )
			{
				$DB->query("ALTER TABLE ".$ibforums->vars['sql_database'].".{tbl.prefix}member_extra ADD hiveuserid mediumint(8) NOT NULL DEFAULT ''");
			}
		}
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT u.*, t.* FROM ".$ibforums->vars['hb_sql_database'].".user u
					  LEFT JOIN ".$ibforums->vars['hb_sql_database'].".usertextfield t ON (u.userid=t.userid)
		            LIMIT $start, $end");
					
		if ( ! $HB->get_num_rows() )
		{
			// We are done?
			$std->redirect_screen("Member conversion complete", "?a=convert&tbl=members&end=1");
		}
		
		while ( $row = $HB->fetch_row() )
		{
			$db_string = "";
			
			if ( $row['userid'] == "" OR $row['username'] == "" OR $row['password'] == "" )
			{
				continue;
			}
			
			$hive_id = intval($row['hiveuserid']);
			
			// Remap groups..
			
			define( 'ADMIN' , 4 );
			define( 'MEMBER', 3 );
			define( 'GUEST' , 2 );
			define( 'VALID' , 1 );
			define( 'MOD'   , 5 );
			
			$mgroup = "";
			$coppa  = 0;
			
			if ( $row['usergroupid'] > 6 )
			{
				$mgroup = $row['usergroupid'];
			}
			else if ( $row['usergroupid'] == 6 )
			{
				$mgroup = ADMIN;
			}
			else if ( $row['usergroupid'] == 5 )
			{
				$mgroup = MOD;
			}
			else if ( $row['usergroupid'] == 4 )
			{
				$mgroup = MEMBER;
				$coppa  = 1;
			}
			else if ( $row['usergroupid'] == 3 )
			{
				$mgroup = VALID;
			}
			else if ( $row['usergroupid'] == 2 )
			{
				$mgroup = MEMBER;
			}
			else if ( $row['usergroupid'] == 1 )
			{
				$mgroup = GUEST;
			}
			else
			{
				$mgroup = VALID;
			}
			
			list($month,$day,$year) = split("-",$row['birthday']);
			
			$db_array = array(
								'id'         => $row['userid'],
								'name'       => $row['username'],
								'mgroup'     => $mgroup,
								'password'   => $row['password'],
								'email'      => $row['email'],
								'joined'     => $row['joindate']  ? $row['joindate'] : time(),
								'ip_address' => $row['ipaddress'] ? $row['ipaddress'] : '127.0.0.1',
								'posts'      => $row['posts'],
								'aim_name'   => $std->txt_safeslashes($row['aim']),
								'icq_number' => intval($row['icq']),
								'location'   => $std->txt_safeslashes($row['location']),
								'signature'  => $PARSER->convert( array( 'TEXT'      => $std->txt_safeslashes($row['signature']),
																   		 'SMILIES'   => 0,
																   		 'CODE'      => $ibforums->vars['sig_allow_ibc'],
																   		 'HTML'      => $ibforums->vars['sig_allow_html'],
																  		 'SIGNATURE' => 1
														 		)       ),
								'website'	 => $std->txt_safeslashes($row['homepage']),
								'yahoo'      => $std->txt_safeslashes($row['yahoo']),
								'title'		 => "",
								'allow_admin_mails' => 1,
								'time_offset'=> 0,
								'interests'  => "",
								'hide_email' => 0,
								'language'   => 'en',
								'msnname'    => $row['msn'],
								'last_post'  => $row['lastpost'],
								'restrict_post' => 0,
								'bday_day'   => $day,
								'bday_month' => $month,
								'bday_year'  => $year,
								'last_visit' => $row['lastvisit'],
								'last_activity' => $row['lastactivity'],
								'vdirs'         => "in:Inbox|sent:Sent Items",
								'coppa_user'    => $coppa,
								'misc'          => $std->txt_safeslashes($row['salt']),
							);
							
			$db_string = $DB->compile_db_insert_string($db_array);
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}members (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}member_extra (id,hiveuserid) VALUES({$row['userid']}, $hive_id)");
			
			$DB->query("INSERT INTO ".$ibforums->vars['sql_database'].".{tbl.prefix}pfields_content (member_id) VALUES(".$row['userid'].")");
		}
		
		// Done?
		// Ok - redirect for the next batch
		
		$new_start = $start + $end;
		
		$std->redirect_screen("Members $start to $new_start converted....", "?a=convert&tbl=members&st=$new_start");
		
	}


	//====================================================================
	//
	// CONVERT PREFS
	//
	//====================================================================

	function _convert_prefs()
	{
		global $DB, $HB, $std, $SKIN, $IN, $INFO, $ibforums, $PARSER;
		
		//---------------------------
		// Convert...
		//---------------------------
		
		$HB->query("SELECT varname, value FROM ".$ibforums->vars['hb_sql_database'].".setting");
					
		while ( $row = $HB->fetch_row() )
		{
			$setting[ $row['varname'] ] = $row['value'];
		}
		
		$b_names   = explode( " ", trim($setting['illegalusernames']) );
		$ban_names = implode( "|", $b_names );
		
		$b_ip      = explode( " ", trim($setting['banip']) );
		$ban_ip    = implode( "|", $b_ip );
		
		$b_email   = explode( " ", trim($setting['banemail']) );
		$ban_email = implode( "|", $b_email );
		
		$std->rebuild_config( array( 
										'offline_msg'       =>  $std->clean_value($setting['bbclosedreason']),
										'board_name'		=>  $std->clean_value($setting['bbtitle']),
										'email_in'			=>  $setting['webmasteremail'],
										'email_out'			=>	$setting['webmasteremail'],
										'sig_allow_ibc'		=>	$setting['allowbbcode'],
										'max_images'		=>	$setting['maximages'],
										'emo_per_row'		=>  $setting['smcolumns'],
										'show_active'		=>  $setting['displayloggedin'],
										'show_birthdays'	=>	$setting['showbirthdays'],
										'use_mail_form'		=>	$setting['secureemail'],
										'allow_dup_email'	=>	$setting['requireuniqueemail'] ? 0 : 1,
										'ban_names'         =>  $ban_names,
										'ban_ip'            =>  $ban_ip,
										'ban_email'         =>  $ban_email,
										'no_reg'			=>  $setting['allowregistration'] ? 0 : 1,
										'allow_skins'		=>  $setting['allowchangestyles'],
										'display_max_posts' =>  $setting['maxposts'],
										'postpage_contents' =>  $setting['usermaxposts'],
										'display_max_topics'=>  $setting['maxthreads'],
										'show_user_posted'  =>  $setting['showdots'],
										'pre_moved'			=>  $setting['movedthreadprefix'],
										'pre_pinned'		=>  $setting['stickythreadprefix'],
										'pre_polls'			=>  $setting['pollthreadprefix'],
										'no_au_forum'		=>  $setting['showforumusers'] ? 0 : 1,
										'allow_search'		=>  $setting['enablesearches'],
										'min_search_word'	=>	$setting['minsearchlength'],
										'disable_gzip'		=>  $setting['gzipoutput'] ? 0 : 1,
										'load_limit'		=>	$setting['loadlimit'],
										
										
						    )      );

		
		$std->redirect_screen("Preferences Converted", "");
		
	}






}



?>