<?php

/*
+--------------------------------------------------------------------------
|   Invision Board v1.2 <- vBulletin 2.3 - Invision Board Convertor
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Convertor Script using Conv.API
|   > Script written by Matt Mecham
|   > Date started: 25th November 2002 (updated: 15th June 2003)
|
+--------------------------------------------------------------------------
*/

//-----------------------------------------------
// USER CONFIGURABLE ELEMENTS
//-----------------------------------------------
 
// Set your root path to this script if you encounter
// errors and such

$root_path = "./";

// Use GetImageSize to define avatar size?

define( 'USEGIS', 1 );


//-----------------------------------------------
// NO USER EDITABLE SECTIONS BELOW
//-----------------------------------------------

error_reporting  (E_ERROR | E_WARNING | E_PARSE);
set_magic_quotes_runtime(0);

class info {

	var $input      = array();

	function info() {
		global $sess, $std, $DB, $root_path, $INFO, $API;
		
		$this->vars = &$INFO;
		
		$this->table_array =  array(   'members'    => 'members',
									   'forums'     => 'forums',
									   'categories' => 'categories',
									   'groups'     => 'groups',
									   'ranks'      => 'titles',
									   'topics'     => 'topics',
									   'posts'      => 'posts',
									   'pms'        => 'messages',
									   'polls'      => 'polls',
									   'moderators' => 'moderators',
									   'attachment' => 'attachment',
									   'avatars'    => 'avatars',
								   );
		
		$this->vars['this_script']     = $API->script;
		$this->vars['this_version']    = $API->version;
		$this->vars['this_board']      = $API->board;
		
		$this->vars['TEAM_ICON_URL']   = $INFO['html_url'] . '/team_icons';
		$this->vars['AVATARS_URL']     = $INFO['html_url'] . '/avatars';
		$this->vars['EMOTICONS_URL']   = $INFO['html_url'] . '/emoticons';
		$this->vars['mime_img']        = $INFO['html_url'] . '/mime_types';

	}
}

//--------------------------------
// Do some tests.
//--------------------------------

if ( ! is_readable( $root_path."conf_global.php" ) )
{
	fatal_error("Cannot locate 'conf_global.php'", "Make sure the file exists in the same directory as this script");
}

if ( ! is_writeable( $root_path."conf_global.php" ) )
{
	fatal_error("Cannot write to 'conf_global.php'", "Make sure the file has suitable permissions to allow this script to write to it, try CHMOD 0777 if in doubt");
}

//--------------------------------
// Import InvB $INFO, now!
//--------------------------------

require $root_path."conf_global.php";

//--------------------------------
// Require our global functions
//--------------------------------

require $root_path."conv_api/api_vb2.php";
require $root_path."conv_api/api_functions.php";
require $root_path."conv_api/api_template.php";
require $root_path."conv_api/post_parser.php";
require $root_path."conv_api/api_mysql.php";


$std    = new api_functions();
$SKIN   = new api_template();
$PARSER = new post_parser();
$API    = new api_convertor();

//--------------------------------
//  Set up our vars
//--------------------------------

$ibforums        = new info();

$IN              = $std->parse_incoming();
$ibforums->input = &$IN;


//--------------------------------
// Load the DB driver and such
//--------------------------------

if ( $ibforums->vars['vb_configured'] == 1 )
{

	// Get an Invision Board DB connection
	
	$DB = new api_mysql();
	
	$DB->obj['sql_database']     = $INFO['sql_database'];
	$DB->obj['sql_user']         = $INFO['sql_user'];
	$DB->obj['sql_pass']         = $INFO['sql_pass'];
	$DB->obj['sql_host']         = $INFO['sql_host'];
	$DB->obj['sql_tbl_prefix']   = $INFO['sql_tbl_prefix'];
	
	$DB->connect();
	
	// Get a host connection
	
	$HB = new api_mysql();
	
	$HB->obj['sql_database']     = $INFO['hb_sql_database'];
	$HB->obj['sql_user']         = $INFO['hb_sql_user'];
	$HB->obj['sql_pass']         = $INFO['hb_sql_pass'];
	$HB->obj['sql_host']         = $INFO['hb_sql_host'];
	$HB->obj['sql_tbl_prefix']   = $INFO['hb_sql_tbl_prefix'];
	
	$HB->connect();
}

//===================================================
//
// SORT INCOMING DATA
//
//===================================================

switch( $ibforums->input['a'] )
{
	case 'configure':
		if ( $ibforums->input['set'] == 1 )
		{
			save_config();
		}
		else
		{
			$API->config_form();
		}
		break;
		
	case 'convert':
		do_convert();
		break;
		
	case 'resync':
		do_resync();
		break;
		
	case 'prefs':
		$API->_convert_prefs();
		break;
		
	default:
		welcome_screen();
		break;
}

//===================================================
//
// MAIN CONVERTOR DISPLAY
//
//===================================================

function welcome_screen()
{
	global $API, $ibforums, $HB, $DB, $SKIN, $std;
	
	$std->page_title = $API->board." Convertor";
	
	if ( $ibforums->vars['vb_configured'] != 1 )
	{
		$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
		$std->html .= $SKIN->start_table( "Before you proceed..." );
		
		$std->html .= $SKIN->add_td_row( array( "Before you can convert your {$API->board} to Invision Power Board, you must configure this convertor.<br><br>This information is required to connect to the {$API->board} database and also allows you to edit how many database rows are converted in one rotation<br><br>&raquo; <a href='{$API->script}?a=configure'>Configure Convertor</a>" ) );
		
		$std->html .= $SKIN->end_table();
		
		$std->output();
		
		// Script exits
	}
	
	$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
	$std->html .= $SKIN->start_table( "Configuration Status" );
	
	$std->html .= $SKIN->add_td_row( array( "This convertor has been configured correctly and a test indicates that the {$API->board} database has been found.<br><br>&raquo; <a href='{$API->script}?a=configure'>Configure Convertor Again?</a>" ) );
	
	$std->html .= $SKIN->end_table();
	
	//----------------------------------------------------
	// MAIN DISPLAY
	//----------------------------------------------------
	
	// Get host board counts
	
	$host = $API->get_host_rows();
	
	// Get local board rows
	
	$local = array();
	$done  = array();
	
	$SKIN->td_header[] = array( "Type"                , "30%" );
	$SKIN->td_header[] = array( "IPB Rows"            , "20%" );
	$SKIN->td_header[] = array( "{$API->board} Rows"  , "20%" );
	$SKIN->td_header[] = array( "Convert"             , "20%" );
	$SKIN->td_header[] = array( "Status"              , "10%" );
		
	$std->html .= $SKIN->start_table( "Convertor Status" );
	
	
	foreach( $ibforums->table_array as $arr => $table )
	{
		$r_count = 0;
		
		if ( $arr == 'attachment' )
		{
			if ( @is_dir($ibforums->vars['upload_dir']) )
			{
				$handle = @opendir($ibforums->vars['upload_dir']);
				
				while (($filename = @readdir($handle)) !== false)
				{
					if (($filename != ".") && ($filename != ".."))
					{
						if ( preg_match( "/^post-/i", $filename ) )
						{
							$r_count++;
						}
					}
				}
				@closedir($handle);
			}
			else
			{
				$r_count = 'UPLOAD DIR NOT FOUND';
			}
		}
		else if ( $arr == 'avatars' )
		{
			if ( @is_dir($ibforums->vars['upload_dir']) )
			{
				$handle = @opendir($ibforums->vars['upload_dir']);
				
				while (($filename = @readdir($handle)) !== false)
				{
					if (($filename != ".") && ($filename != ".."))
					{
						if ( preg_match( "/^av-/i", $filename ) )
						{
							$r_count++;
						}
					}
				}
				@closedir($handle);
			}
			else
			{
				$r_count = 'UPLOAD DIR NOT FOUND';
			}
		}
		else
		{
			$DB->query("SELECT COUNT(*) as cnt FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}$table");
			
			$cnt = $DB->fetch_row();
			
			$r_count = ( $cnt['cnt'] < 1 ) ? 0 : $cnt['cnt'];
		}
		
		//---------------
		
		if ( ! $ibforums->vars['conv_'.$arr] )
		{
			$status       = '-';
			$convert_text = 'Convert Now';
		}
		else
		{
			$status       = '<b>Converted<b>';
			$convert_text = 'Convert Again?';
		}
		
		//---------------
		
		$title = "";
		
		if ( $arr == 'pms' )
		{
			$title = 'Private Messages';
		}
		else if ( $arr == 'attachment' )
		{
			$title = 'Attachments';
		}
		else if ( $arr == 'avatars' )
		{
			$title = 'Uploaded Avatars';
		}
		else
		{
			$title = ucwords($arr);
		}
		
		//---------------
		
		$std->html .= $SKIN->add_td_row( array(
												$title,
												"<center>$r_count</center>",
												"<center>{$host[$arr]}</center>",
												"<center><a href='{$API->script}?a=convert&tbl=$arr&show=1'>$convert_text</a></center>",
												"<center>$status</center>",
								   		)      );
	}
					
								   
	$std->html .= $SKIN->end_table();
	
	//------------------------------
	
	$SKIN->td_header[] = array( "&nbsp;", "100%" );
		
	$std->html .= $SKIN->start_table( "Post Installation Options" );
	
	$std->html .= $SKIN->add_td_row( array("<br><b>Only use these tools once your conversion has taken place</b>
											<br><br>
											<b><a href='{$API->script}?a=resync'>Resynchronise Forums</a></b>
											<br>This will ensure that all the last poster, last post date and topic/post counts are correct on all the converted forums
											<br><br>
											<b><a href='{$API->script}?a=prefs'>Convert Preferences</a></b>
											<br>This will attempt to convert your current board preferences, such as admin email address, board name, etc
											"
								   )      );
	
	$std->html .= $SKIN->end_table();
	
	//------------------------------
	
	$std->output();
	
}

//===================================================
//
// RESYNCHRONISE FORUMS
//
//===================================================

function do_resync()
{
	global $API, $ibforums, $HB, $DB, $SKIN, $std, $PARSER;
	
	$get_forums = $DB->query("SELECT id FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}forums");
	
	while( $forum = $DB->fetch_row($get_forums) )
	{
		//--------------------------
		// Get the topics..
		//--------------------------
		
		$tq = $DB->query("SELECT COUNT(tid) as count FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}topics WHERE approved=1 and forum_id='".$forum['id']."'");
		$topics = $DB->fetch_row($tq);
		
		//--------------------------
		// Get the posts..
		//--------------------------
		
		$pq = $DB->query("SELECT COUNT(pid) as count FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}posts WHERE queued <> 1 and forum_id='".$forum['id']."'");
		$posts = $DB->fetch_row($pq);
		
		//--------------------------
		// Get the forum last poster..
		//--------------------------
		
		$lq = $DB->query("SELECT tid, title, last_poster_id, last_poster_name, last_post FROM ".$ibforums->vars['sql_database'].".{tbl.prefix}topics WHERE approved=1 and forum_id='".$forum['id']."' ORDER BY last_post DESC LIMIT 0,1");
		$last_post = $DB->fetch_row($lq);
		
		//--------------------------
		// Reset this forums stats
		//--------------------------
		
		$postc = $posts['count'] - $topics['count'];
		
		if ($postc < 0)
		{
			$postc = 0;
		}
		
		if ( $topics['count'] > 0 )
		{
			$db_string = $DB->compile_db_update_string( array (
																 'last_poster_id'   => $last_post['last_poster_id'],
																 'last_poster_name' => $last_post['last_poster_name'],
																 'last_post'        => $last_post['last_post'],
																 'last_title'       => $last_post['title'],
																 'last_id'          => $last_post['tid'],
																 'topics'           => $topics['count'],
																 'posts'            => $postc
													 )        );
													 
			$DB->query("UPDATE ".$ibforums->vars['sql_database'].".{tbl.prefix}forums SET $db_string WHERE id='".$forum['id']."'");
		}
	}
	
	$std->redirect_screen("Forums Resynchronised", "");
	
}

//===================================================
//
// CONVERSION HANDLER
//
//===================================================

function do_convert()
{
	global $API, $ibforums, $HB, $DB, $SKIN, $std, $PARSER;
	
	if ($ibforums->input['show'] == 1)
	{
		
		$std->page_title = $API->board." Convertor [ Converting ".ucwords($ibforums->table_array[ $ibforums->input['tbl'] ])." ]";
		
		$text = $API->get_intro($ibforums->input['tbl']);
	
		$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
		$std->html .= $SKIN->start_table( "Information" );
		
		$std->html .= $SKIN->add_td_row( array( $text."<br><br>&raquo; <a href='{$API->script}?a=convert&tbl={$ibforums->input['tbl']}&st=0&drop=1'>Start ".ucwords($ibforums->table_array[ $ibforums->input['tbl'] ])." Conversion</a>" ) );
		
		$std->html .= $SKIN->end_table();
		
		$std->output();
		
		// Script exits
	}
	else if ($ibforums->input['end'] == 1)
	{
		
		// Save config
		
		$std->rebuild_config( array( 'conv_'.$ibforums->input['tbl'] => 1 ) );
		
		$std->page_title = $API->board." Convertor [ Converted ".ucwords($ibforums->table_array[ $ibforums->input['tbl'] ])." ]";
		
		$text = $API->get_end($ibforums->input['tbl']);
	
		$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
		$std->html .= $SKIN->start_table( "Information" );
		
		$std->html .= $SKIN->add_td_row( array( $text."<br><br>&raquo; <a href='{$API->script}'>Continue...</a>" ) );
		
		$std->html .= $SKIN->end_table();
		
		$std->output();
		
		// Script exits
	}
	else
	{
		$API->convert($ibforums->input['tbl']);
	}
}

//===================================================
//
// DEFAULT ERROR HANDLER
//
//===================================================

function fatal_error($message="", $help="") {
	echo("$message<br><br>$help");
	exit;
}


//===================================================
//
// SAVE CONVERTOR PREFERENCES
//
//===================================================

function save_config()
{
	global $API, $IN, $root_path, $INFO, $DB, $SKIN, $std, $HTTP_POST_VARS;
	
	$new = $API->form_fields;

	// Check to ensure that all the required fields are completed
	
	foreach( $new as $test )
	{
		if ( $HTTP_POST_VARS[ $test ] == "" )
		{
			$API->config_form("<b>You must ensure that all the fields are completed fully</b>");
			exit();  // Not needed, but makes reading easier
		}
	}
	
	//-------------------------------------------------------------
	// Attempt a connection
	//-------------------------------------------------------------
	
	$HB = new api_mysql();
	
	$HB->return_die = 1;
	
	$HB->obj['sql_database']     = $HTTP_POST_VARS['hb_sql_database'];
	$HB->obj['sql_user']         = $HTTP_POST_VARS['hb_sql_user'];
	$HB->obj['sql_pass']         = $HTTP_POST_VARS['hb_sql_pass'];
	$HB->obj['sql_host']         = $HTTP_POST_VARS['hb_sql_host'];
	
	$HB->connect();
	
	if ( $HB->error != "")
	{
		if ( $HB->connection_id )
		{
			$HB->close_db();
		}
		
		$API->config_form("<b>mySQL Error: ".$HB->error."</b>");
		exit();  // Not needed, but makes reading easier
	}
	
	
	//-------------------------------------------------------------
	
	$master = array();
	
	if ( is_array($new) )
	{
		if ( count($new) > 0 )
		{
			foreach( $new as $field )
			{
				$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "&#39;", stripslashes($HTTP_POST_VARS[ $field ]) );
			
				$master[ $field ] = stripslashes($HTTP_POST_VARS[ $field ]);
			}
			
			$master['vb_configured'] = 1;
			
			$std->rebuild_config($master);
		}
	}
	
	if ( $HB->connection_id )
	{
		$HB->close_db();
	}
	
	$std->redirect_screen("Configuration Saved", "");
}

?>
