<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.0.7
|| # ---------------------------------------------------------------- # ||
|| # Copyright 20002005 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'index');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('holiday');

// get special data templates from the datastore
$specialtemplates = array(
        'userstats',
        'birthdaycache',
        'maxloggedin',
        'iconcache',
        'eventcache',
        'mailqueue'
);

// pre-cache templates used by all actions
$globaltemplates = array(
        'FORUMHOME',
        'forumhome_event',
        'forumhome_forumbit_level1_nopost',
        'forumhome_forumbit_level1_post',
        'forumhome_forumbit_level2_nopost',
        'forumhome_forumbit_level2_post',
        'forumhome_lastpostby',
        'forumhome_loggedinuser',
        'forumhome_moderator',
        'forumhome_pmloggedin',
        'forumhome_subforumbit_nopost',
        'forumhome_subforumbit_post',
        'forumhome_subforumseparator_nopost',
        'forumhome_subforumseparator_post',
        'forumhome_stats_poster',
        'forumhome_stats_member',
        'forumhome_stats_thread',
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_bigthree.php');
require_once('./includes/functions_forumlist.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// get permissions to view forumhome
if (!($permissions['forumpermissions'] & CANVIEW))
{
        print_no_permission();
}

// get forumid if set, otherwise set to -1
globalize($_REQUEST, array('forumid' => INT));

if (! is_array($foruminfo))
{
        $forumid = -1;
}
else
{
        // draw nav bar
        $navbits = array();
        $parentlist = array_reverse(explode(',', substr($foruminfo['parentlist'], 0, -3)));
        foreach ($parentlist AS $forumID)
        {
                $forumTitle = $forumcache["$forumID"]['title'];
                $navbits["forumdisplay.php?$session[sessionurl]f=$forumID"] = $forumTitle;
        }

        // pop the last element off the end of the $nav array so that we can show it without a link
        array_pop($navbits);

        $navbits[''] = $foruminfo['title'];
        $navbits = construct_navbits($navbits);
}

// ### WELCOME MESSAGE #################################################
if ($bbuserinfo['userid'])
{        // registered user
        $showmemberwelcome = true;
}
else
{        // guest
        $showmemberwelcome = false;
}

$today = vbdate('Y-m-d', TIMENOW, false, false);

// ### TODAY'S BIRTHDAYS #################################################
if ($vboptions['showbirthdays'])
{
        $birthdaystore = unserialize($datastore['birthdaycache']);
        if (!is_array($birthdaystore) OR ($today != $birthdaystore['day1'] AND $today != $birthdaystore['day2']))
        {
                // Need to update!
                require_once('./includes/functions_databuild.php');
                $birthdaystore = build_birthdays();
                DEVDEBUG('Updated Birthdays');
        }
        switch($today)
        {
                case $birthdaystore['day1']:
                        $birthdays = $birthdaystore['users1'];
                        break;

                case $birthdaystore['day2'];
                        $birthdays = $birthdaystore['users2'];
                        break;
        }
        // memory saving
        unset($birthdaystore);

        $show['birthdays'] = iif ($birthdays, true, false);
}
else
{
        $show['birthdays'] = false;
}

// ### TODAY'S EVENTS #################################################
if ($vboptions['showevents'])
{
        require_once('./includes/functions_calendar.php');

        $future = gmdate('n-j-Y' , TIMENOW + 43200 + (86400 * ($vboptions['showevents'] - 1)));
        $eventstore = unserialize($datastore['eventcache']);

        if (!is_array($eventstore) OR $future != $eventstore['date'])
        {
                // Need to update!
                require_once('./includes/functions_databuild.php');
                $eventstore = build_events();
                DEVDEBUG('Updated Events');
        }

        unset($eventstore['date']);
        $events = array();
        $eventcount = 0;
        foreach ($eventstore AS $eventid => $eventinfo)
        {
                $offset = iif (!$eventinfo['utc'], $bbuserinfo['tzoffset'], $bbuserinfo['timezoneoffset']);
                $eventinfo['dateline_from_user'] = $eventinfo['dateline_from'] + $offset * 3600;
                $eventinfo['dateline_to_user'] = $eventinfo['dateline_to'] + $offset * 3600;
                $gettime = TIMENOW - $vboptions['hourdiff'];
                $iterations = 0;

                if ($bbuserinfo['calendarpermissions']["$eventinfo[calendarid]"] & CANVIEWCALENDAR OR ($eventinfo['holidayid'] AND $vboptions['showholidays']))
                {
                        if ($eventinfo['userid'] == $bbuserinfo['userid'] OR $bbuserinfo['calendarpermissions']["$eventinfo[calendarid]"] & CANVIEWOTHERSEVENT OR ($eventinfo['holidayid'] AND $vboptions['showholidays']))
                        {
                                while ($iterations < $vboptions['showevents'])
                                {
                                        $addcache = false;

                                        $todaydate = getdate($gettime);
                                        if ($eventinfo['holidayid'] AND $eventinfo['recurring'] == 6)
                                        {
                                                if ($eventinfo['recuroption'] == "$todaydate[mon]|$todaydate[mday]")
                                                {
                                                        $addcache = true;
                                                }
                                        }
                                        else if (cache_event_info($eventinfo, $todaydate['mon'], $todaydate['mday'], $todaydate['year']))
                                        {
                                                $addcache = true;
                                        }

                                        if ($addcache)
                                        {
                                                if (!$vboptions['showeventtype'])
                                                {
                                                        $events["$eventinfo[eventid]"][] = $gettime;
                                                }
                                                else
                                                {
                                                        $events["$gettime"][] = $eventinfo['eventid'];
                                                }
                                                $eventcount++;
                                        }

                                        $iterations++;
                                        $gettime += 86400;
                                }
                        }
                }
        }

        if (!empty($events))
        {
                ksort($events, SORT_NUMERIC);
                foreach($events AS $index => $value)
                {
                        $pastevent = 0;
                        $pastcount = 0;
                        unset($eventdates, $comma, $daysevents);
                        if (!$vboptions['showeventtype'])
                        {        // Group by Event // $index = $eventid
                                unset($day);
                                foreach($value AS $key => $dateline)
                                {
                                        if (($dateline - 86400) == $pastevent AND !$eventinfo['holidayid'])
                                        {
                                                $pastevent = $dateline;
                                                $pastcount++;
                                                continue;
                                        }
                                        else
                                        {
                                                if ($pastcount)
                                                {
                                                        $eventdates = construct_phrase($vbphrase['event_x_to_y'], $eventdates, vbdate($vboptions['dateformat'], $pastevent, false, true, false));
                                                }
                                                $pastcount = 0;
                                                $pastevent = $dateline;
                                        }
                                        if (!$day)
                                        {
                                                $day = vbdate('Y-n-j', $dateline, false, false, false);
                                        }
                                        $eventdates .= $comma . vbdate($vboptions['dateformat'], $dateline, false, true, false);
                                        $comma = ', ';
                                        $eventinfo = $eventstore["$index"];
                                }
                                if ($pastcount)
                                {
                                        $eventdates = construct_phrase($vbphrase['event_x_to_y'], $eventdates, vbdate($vboptions['dateformat'], $pastevent, false, true, false));
                                }

                                if ($eventinfo['holidayid'])
                                {
                                        $callink = "<a href=\"calendar.php?$session[sessionurl]do=getinfo&amp;day=$day\">" . $vbphrase['holiday_title_' . $eventinfo['varname']] . "</a>";
                                }
                                else
                                {
                                        $callink = "<a href=\"calendar.php?$session[sessionurl]do=getinfo&amp;day=$day&amp;e=$eventinfo[eventid]&amp;c=$eventinfo[calendarid]\">$eventinfo[title]</a>";
                                }
                        }
                        else
                        {        // Group by Date
                                $eventdate = vbdate($vboptions['dateformat'], $index, false, true, false);
                                $day = vbdate('Y-n-j', $index, false, false);
                                foreach($value AS $key => $eventid)
                                {
                                        $eventinfo = $eventstore["$eventid"];
                                        if ($eventinfo['holidayid'])
                                        {
                                                $daysevents .= $comma . "<a href=\"calendar.php?$session[sessionurl]do=getinfo&amp;day=$day\">" . $vbphrase['holiday_title_' . $eventinfo['varname']] . "</a>";
                                        }
                                        else
                                        {
                                                $daysevents .= $comma . "<a href=\"calendar.php?$session[sessionurl]do=getinfo&amp;day=$day&amp;e=$eventinfo[eventid]&amp;c=$eventinfo[calendarid]\">$eventinfo[title]</a>";
                                        }
                                        $comma = ', ';
                                }
                        }
                        eval('$upcomingevents .= "' . fetch_template('forumhome_event') . '";');
                }
                // memory saving
                unset($events, $eventstore);
        }
        $show['upcomingevents'] = iif ($upcomingevents, true, false);
        $show['todaysevents'] = iif ($vboptions['showevents'] == 1, true, false);
}
else
{
        $show['upcomingevents'] = false;
}

// ### LOGGED IN USERS #################################################
$activeusers = '';
if ($vboptions['displayloggedin'])
{
        $datecut = TIMENOW - $vboptions['cookietimeout'];
        $numbervisible = 0;
        $numberregistered = 0;
        $numberguest = 0;

        $forumusers = $DB_site->query("
                SELECT
                        user.username, (user.options & $_USEROPTIONS[invisible]) AS invisible, user.usergroupid,
                        session.userid, session.inforum, session.lastactivity,
                        IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid
                FROM " . TABLE_PREFIX . "session AS session
                LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
                WHERE session.lastactivity > $datecut
                ORDER BY " . iif($permissions['genericpermissions'] & CANSEEHIDDEN, 'invisible ASC, ') . "username ASC, lastactivity DESC
        ");

        if ($bbuserinfo['userid'])
        {
                // fakes the user being online for an initial page view of index.php
                $bbuserinfo['joingroupid'] = iif($bbuserinfo['displaygroupid'], $bbuserinfo['displaygroupid'], $bbuserinfo['usergroupid']);
                $userinfos = array
                (
                        $bbuserinfo['userid'] => array
                        (
                                'userid' => $bbuserinfo['userid'],
                                'username' => $bbuserinfo['username'],
                //--------------------------------tmuz.com----------------------------------//
                'usergroupid' => $bbuserinfo['usergroupid'],
                //--------------------------------tmuz.com----------------------------------//
                                'invisible' => $bbuserinfo['invisible'],
                                'inforum' => 0,
                                'lastactivity' => TIMENOW,
                                'musername' => fetch_musername($bbuserinfo, 'joingroupid')
                        )
                );

                $numberregistered = 1;
                $numbervisible = 1;
                fetch_online_status($userinfos["$bbuserinfo[userid]"]);
                $loggedin = $userinfos["$bbuserinfo[userid]"];
    //--------------------------------tmuz.com----------------------------------//
    if($loggedin['usergroupid']==7){
    $ltodaymusername ="<a  href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenb\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\">";
    }
    elseif($loggedin['usergroupid']==6){
    $ltodaymusername ="<a  href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahena\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\">";
    }
    elseif($loggedin['usergroupid']==2){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==3){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==4){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==5){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahend\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
        $activeusers .="".$ltodaymusername."&nbsp;";
    //--------------------------------tmuz.com-----------------------------//
        }
        else
        {
                $userinfos = array();
        }
        $inforum = array();

        while ($loggedin = $DB_site->fetch_array($forumusers))
        {
                $userid = $loggedin['userid'];
                if (!$userid)
                {        // Guest
                        $numberguest++;
                        $inforum["$loggedin[inforum]"]++;
                }
                else if (empty($userinfos["$userid"]['lastactivity']) OR ($userinfos["$userid"]['lastactivity'] < $loggedin['lastactivity']))
                {
                        $userinfos["$userid"] = $loggedin;
                        $numberregistered++;
                        if ($userid != $bbuserinfo['userid'])
                        {
                                $inforum["$loggedin[inforum]"]++;
                        }
                        $loggedin['musername'] = fetch_musername($loggedin);

                        if (fetch_online_status($loggedin))
                        {
                                $numbervisible++;
    //--------------------------------tmuz.com------------------------------//
    if($loggedin['usergroupid']==7){
    $ltodaymusername ="<a  href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenb\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\">";
    }
    elseif($loggedin['usergroupid']==6){
    $ltodaymusername ="<a  href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahena\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\">";
    }
    elseif($loggedin['usergroupid']==2){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==3){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==4){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }
    elseif($loggedin['usergroupid']==5){
    $ltodaymusername ="<a href=\"member.php?u=$loggedin[userid]\"><input class=\"alshahend\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$loggedin[musername]\"></a>";
    }

        $activeusers .="".$ltodaymusername."&nbsp;";
    //--------------------------------tmuz.com-----------------------------//

                        }
                }
        }

        // memory saving
        unset($userinfos, $loggedin);

        ////

        $DB_site->free_result($loggedins);

        $totalonline = $numberregistered + $numberguest;
        $numberinvisible = $numberregistered - $numbervisible;

        // ### MAX LOGGEDIN USERS ################################
        $maxusers = unserialize($datastore['maxloggedin']);
        if (intval($maxusers['maxonline']) <= $totalonline)
        {
                $maxusers['maxonline'] = $totalonline;
                $maxusers['maxonlinedate'] = TIMENOW;
                build_datastore('maxloggedin', serialize($maxusers));
        }

        $recordusers = $maxusers['maxonline'];
        $recorddate = vbdate($vboptions['dateformat'], $maxusers['maxonlinedate'], true);
        $recordtime = vbdate($vboptions['timeformat'], $maxusers['maxonlinedate']);

        $show['loggedinusers'] = true;
}
else
{
        $show['loggedinusers'] = false;
}

// ### GET FORUMS & MODERATOR iCACHES ########################
cache_ordered_forums(1);
if ($vboptions['showmoderatorcolumn'])
{
        cache_moderators();
}
else
{
        $imodcache = array();
        $mod = array();
}

// define max depth for forums display based on $vboptions[forumhomedepth]
define('MAXFORUMDEPTH', $vboptions['forumhomedepth']);

$forumbits = construct_forum_bit($forumid);

// ### BOARD STATISTICS #################################################

// get total threads & posts from the forumcache
$totalthreads = 0;
$totalposts = 0;
if (is_array($forumcache))
{
        foreach ($forumcache AS $forum)
        {
                $totalthreads += $forum['threadcount'];
                $totalposts += $forum['replycount'];
        }
}
$totalthreads = vb_number_format($totalthreads);
$totalposts = vb_number_format($totalposts);

// get total members and newest member from template
$userstats = unserialize($datastore['userstats']);
$numbermembers = vb_number_format($userstats['numbermembers']);
$newusername = $userstats['newusername'];
$newuserid = $userstats['newuserid'];

// ### TODAY ONLINE USERS BY ANIMEWEBBY ###########################################
$todayactiveusers = '';
$todaystarttime = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
$acount=0;
$todaynumbervisible = 0;
$todaynumberregistered = 0;

$todayforumusers = $DB_site->query("SELECT
        user.userid, user.username, (user.options & $_USEROPTIONS[invisible]) AS invisible, user.usergroupid, user.lastactivity,
        IF(displaygroupid=0, user.usergroupid, user.displaygroupid) AS displaygroupid
        FROM " . TABLE_PREFIX . "user
        WHERE user.lastactivity >= $todaystarttime
        ORDER BY " . iif($permissions['genericpermissions'] & CANSEEHIDDEN, 'invisible ASC, ') . "username ASC, lastactivity DESC
");

if ($bbuserinfo['userid'])
{
        // fakes the user being online for an initial page view of index.php
        $bbuserinfo['joingroupid'] = iif($bbuserinfo['displaygroupid'], $bbuserinfo['displaygroupid'], $bbuserinfo['usergroupid']);
        $todayuserinfos = array
        (
                $bbuserinfo['userid'] => array
                (
                        'userid' => $bbuserinfo['userid'],
                        'username' => $bbuserinfo['username'],

                        'usergroupid' => $bbuserinfo['usergroupid'],

                        'invisible' => $bbuserinfo['invisible'],
                        'lastactivity' => TIMENOW,
                        'musername' => fetch_musername($bbuserinfo, 'joingroupid')
                )
        );
        $todaynumberregistered = 1;
        $todaynumbervisible = 1;
        fetch_online_status($todayuserinfos[$bbuserinfo['userid']]);
        $todayloggedin = $todayuserinfos[$bbuserinfo['userid']];

    $acount++;
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    if($todayloggedin['usergroupid']==7){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenb\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";
    }
    elseif($todayloggedin['usergroupid']==6){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahena\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";

    }
    elseif($todayloggedin['usergroupid']==2){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==3){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";
    }
    elseif($todayloggedin['usergroupid']==4){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==5){
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahend\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";
    }
    if($acount==7){
    $todayactiveusers .= "<br>";
    $acount=0;
    }
    $todayactiveusers .="".$todaymusername."&nbsp;";




}
else
{
        $todayuserinfos = array();
}
$count=0;
$ccount=0;

while ($todayloggedin = $DB_site->fetch_array($todayforumusers))
{
        $todayuserid = $todayloggedin[userid];
        if (!$todayuserid)
        {        // Guest
                $todaynumberguest++;
        }
        else if (empty($todayuserinfos["$todayuserid"]['lastactivity']) OR ($todayuserinfos["$todayuserid"]['lastactivity'] < $todayloggedin['lastactivity']))
        {
                $todayuserinfos["$todayuserid"] = $todayloggedin;
                $todaynumberregistered++;
                $todayloggedin['musername'] = fetch_musername($todayloggedin);

                if ($todayloggedin['invisible'])
                {
                        if (($permissions['genericpermissions'] & CANSEEHIDDEN) OR $todayloggedin['userid'] == $bbuserinfo['userid'])
                        {
                                // user is online and invisible BUT bbuser can see them
                                $todayloggedin['invisiblemark'] = '*';
                                $todaynumbervisible++;


    $count++;
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    if($todayloggedin['usergroupid']==7){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenb\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";

    }
    elseif($todayloggedin['usergroupid']==6){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahena\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";

    }
    elseif($todayloggedin['usergroupid']==2){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }

    elseif($todayloggedin['usergroupid']==3){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==4){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==5){
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahend\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    if($count==7){
    $todayactiveusers .= "<br>";
    $count=0;
    }
    $todayactiveusers .="".$todaymusername."&nbsp;";

          }
        }
        else
        {
        $todaynumbervisible++;
    $ccount++;

    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    if($todayloggedin['usergroupid']==7){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenb\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";

    }
    if($todayloggedin['usergroupid']==6){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a  title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahena\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\">";

    }
    elseif($todayloggedin['usergroupid']==2){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==3){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[musername], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==4){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahenc\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    elseif($todayloggedin['usergroupid']==5){
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $ALSHdates =vbdate($vboptions['dateformat'], $todayloggedin[lastactivity], false, true, false);
    $todaymusername ="<a title=\"** $ALSHdates **\" href=\"member.php?u=$todayloggedin[userid]\"><input class=\"alshahend\" type=\"text\" name=\"oline\" size=\"15\" dir=\"rtl\" value=\"$todayloggedin[musername]\"></a>";

    }
    if($ccount==7){
    $todayactiveusers .= "<br>";
    $ccount=0;
    }
    $todayactiveusers .="".$todaymusername."&nbsp;";

    //--------------------------------tmuz.com---------------------------//
                }

                //if (fetch_online_status($todayloggedin))
                //{
                //        $todaynumbervisible++;
                //        eval('$todayactiveusers .= ", ' . fetch_template('forumhome_todayloggedinuser') . '";');
                //}
        }
}

// memory saving
unset($todayuserinfos, $todayloggedin);

$todayactiveusers; // get rid of initial comma



$DB_site->free_result($todayloggedins);

$todaynumberinvisible = $todaynumberregistered - $todaynumbervisible;

$todaytotalonline = $todaynumberregistered - $todaynumberinvisible;


// ### MAX LOGGEDIN USERS ################################
$todaymaxusers = unserialize($datastore['todaymaxonline']);
if (intval($todaymaxusers['todaymaxonline']) <= $todaynumberregistered)
{
        $todaymaxusers['todaymaxonline'] = $todaynumberregistered;
        $todaymaxusers['todaymaxonlinedate'] = TIMENOW;
        $DB_site->query("REPLACE INTO " . TABLE_PREFIX . "datastore (title, data) VALUES ('todaymaxonline', '" . addslashes(serialize($todaymaxusers)) . "')");
}

$todayrecordusers = $todaymaxusers['todaymaxonline'];
$todayrecorddate = vbdate($vboptions['dateformat'], $todaymaxusers['todaymaxonlinedate'], 1);
// ### ALL DONE! SPIT OUT THE HTML AND LET'S GET OUTA HERE... ###
// ### TOP 5 STATS BY ANIMEWEBBY ###########################################
$displayrecords = "10"; // how many records should we show?
$excludedforums = "13"; // forums to be excluded from latest threads. Format "0,5,7"
$threadchars = "30"; // number of characters in thread title before '...' is added

$getstats_posters = $DB_site->query("SELECT userid, username, posts FROM " . TABLE_PREFIX . "user ORDER BY posts DESC LIMIT 0, $displayrecords");
while ($getstats_poster = $DB_site->fetch_array($getstats_posters))
{
                eval('$stats_posters .= "' . fetch_template('forumhome_stats_poster') . '";');
}

$getstats_members = $DB_site->query("SELECT userid, username, posts, joindate FROM " . TABLE_PREFIX . "user ORDER BY joindate DESC LIMIT 0, $displayrecords");
while ($getstats_member = $DB_site->fetch_array($getstats_members))
{
                eval('$stats_members .= "' . fetch_template('forumhome_stats_member') . '";');
}

// filter out deletion notices if can't be seen
$forumperms = fetch_permissions($forumid);
if (!($permissions['forumpermissions'] & CANSEEDELNOTICE))
{
        $delquery = ", NOT ISNULL(deletionlog.primaryid) AS isdeleted, deletionlog.userid AS del_userid, deletionlog.username AS del_username, deletionlog.reason AS del_reason";
        $delthreadlimit = "AND deletionlog.primaryid IS NULL";
        $deljoin = "LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(thread.threadid = deletionlog.primaryid AND type = 'thread')";
}
else
{
        $delquery = ", NOT ISNULL(deletionlog.primaryid) AS isdeleted, deletionlog.userid AS del_userid, deletionlog.username AS del_username, deletionlog.reason AS del_reason";
        $delthreadlimit = "";
        $deljoin = "LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(thread.threadid = deletionlog.primaryid AND type = 'thread')";
}

$getstats_threads = $DB_site->query("
SELECT thread.threadid, thread.title, thread.lastpost, thread.forumid, thread.replycount, thread.lastposter, thread.dateline, IF(views<=replycount, replycount+1, views) AS views, thread.visible, user.username, user.userid
$delquery
                FROM " . TABLE_PREFIX . "thread AS thread
                LEFT JOIN  " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
$deljoin
WHERE thread.forumid NOT IN ($excludedforums)
$delthreadlimit
ORDER BY thread.lastpost DESC LIMIT 0, $displayrecords");

while ($getstats_thread = $DB_site->fetch_array($getstats_threads))
{
        $getstats_thread[title] = unhtmlspecialchars($getstats_thread[title]);
        if (strlen($getstats_thread[title]) > $threadchars)
        {
                $getstats_thread[titletrimmed] = substr($getstats_thread[title], 0, strrpos(substr($getstats_thread[title], 0, $threadchars), ' ')) . '...';
        }
        else
        {
                $getstats_thread[titletrimmed] = $getstats_thread[title];
        }
        if ($getstats_thread[lastpost] > $bbuserinfo[lastvisit])
        {
                $getstats_thread[newpost] = true;
        }
        if ($getstats_thread[isdeleted])
        {
                $getstats_thread[isdeleted] = true;
        }
        eval('$stats_threads .= "' . fetch_template('forumhome_stats_thread') . '";');
}

eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('FORUMHOME') . '");');

/*======================================================================*\
|| ####################################################################
|| #
|| # CVS: $RCSfile: index.php,v $ - $Revision: 1.132.2.2 $
|| ####################################################################
\*======================================================================*/
?>
