#/************************************************************************/
#/* 4nAlbum Version 0.92 -mySQL Tables Installationsscripts-             */
#/* ==================================================================== */
#/* By WarpSpeed (Marco Wiesler) (warpspeed@4thDimension.de) @ Nov/2oo3  */
#/* http://www.warp-speed.de @ 4thDimension.de Networking                */
#/* ==================================================================== */
#/* This program is free software. You can redistribute it and/or modify */
#/* it under the terms of the GNU General Public License as published by */
#/* the Free Software Foundation; either version 2 of the License.       */
#/************************************************************************/

# If you have another mySQL prefix like nuke, then just replace all nuke_
# strings in this file with the one matching to your mySQL prefix, before
# you execute/use it. Note: CASE SENSITIVE and don't forget the ending _

CREATE TABLE nuke_4nalbum_categories (
   gallid int(3) NOT NULL auto_increment,
   gallname varchar(30) NOT NULL,
   gallimg varchar(50) NOT NULL,
   galloc longtext,
   description text NOT NULL,
   parent int(3) DEFAULT '-1' NOT NULL,
   visible tinyint(3) unsigned DEFAULT '0' NOT NULL,
   template int(10) unsigned DEFAULT '2' NOT NULL,
   thumbwidth int(2) unsigned DEFAULT '70' NOT NULL,
   numcol tinyint(3) unsigned DEFAULT '3' NOT NULL,
   total int(10) unsigned DEFAULT '0' NOT NULL,
   lastadd date DEFAULT '0000-00-00' NOT NULL,
   PRIMARY KEY (gallid),
   KEY gallid (gallid)
);

INSERT INTO nuke_4nalbum_categories VALUES ( '1', 'Album -1-', 'gallery.gif', 'album1', 'Test-Album -1-
(Public)', '-1', '2', '2', '70', '2', '0', '2002-08-24');
INSERT INTO nuke_4nalbum_categories VALUES ( '2', 'Album -2-', 'gallery.gif', 'album2', 'Test-Album -2-
(Members)', '-1', '1', '2', '70', '3', '0', '0000-00-00');

CREATE TABLE nuke_4nalbum_comments (
   cid int(11) NOT NULL auto_increment,
   pid int(4) DEFAULT '0' NOT NULL,
   comment text NOT NULL,
   date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   name varchar(255),
   member int(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (cid)
);

CREATE TABLE nuke_4nalbum_media_class (
   id int(2) DEFAULT '0' NOT NULL,
   class varchar(10) NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id (id)
);

INSERT INTO nuke_4nalbum_media_class VALUES ( '1', 'Image');
INSERT INTO nuke_4nalbum_media_class VALUES ( '2', 'Audio');
INSERT INTO nuke_4nalbum_media_class VALUES ( '3', 'Video');

CREATE TABLE nuke_4nalbum_media_types (
   extension varchar(10) NOT NULL,
   description text NOT NULL,
   filetype varchar(20) NOT NULL,
   displaytag text NOT NULL,
   thumbnail varchar(255) NOT NULL,
   PRIMARY KEY (extension)
);

INSERT INTO nuke_4nalbum_media_types VALUES ( 'bmp', 'Image/BMP', '1', '<img src=\"<:FILENAME:>\" border=\"0\" alt=\"<:DESCRIPTION:>\">', 'image_gif.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'gif', 'Image/GIF', '1', '<img src=\"<:FILENAME:>\" border=\"0\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" alt=\"<:DESCRIPTION:>\">', 'image_gif.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'jpg', 'Image/JPG', '1', '<img src=\"<:FILENAME:>\" border=\"0\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" alt=\"<:DESCRIPTION:>\">', 'image_jpg.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'png', 'Image/PNG', '1', '<img src=\"<:FILENAME:>\" border=\"0\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" alt=\"<:DESCRIPTION:>\">', 'image_png.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'mov', 'Video/Quicktime', '3', '<embed controller=\"true\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" src=\"<:FILENAME:>\" border=\"0\" pluginspage=\"http://www.apple.com/quicktime/download/indext.html\"></embed>', 'video_mov.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'avi', 'Video/AVI', '3', '<embed src=\"<:FILENAME:>\" border=\"0\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" type=\"application/x-mplayer2\"></embed>', 'video_avi.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'mpg', 'Video/MPEG', '3', '<embed src=\"<:FILENAME:>\" border=\"0\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" type=\"application/x-mplayer2\"></embed>', 'video_mpg.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'mp3', 'Audio/MP3', '2', '<embed controller=\"true\" width=\"200\" height=\"20\" src=\"<:FILENAME:>\" border=\"0\" pluginspage=\"http://www.apple.com/quicktime/download/indext.html\"></embed>', 'audio_mp3.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'mid', 'Audio/MIDI', '2', '<embed src=\"<:FILENAME:>\" type=\"audio/midi\" hidden=\"false\" autostart=\"true\" loop=\"true\" height=\"20\" width=\"200\"></embed>', 'audio_mid.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'swf', 'Video/Flash', '3', '<embed src=\"<:FILENAME:>\" pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=\"<:WIDTH:>\" height=\"<:HEIGHT:>\" play=\"true\" loop=\"true\" quality=\"high\" scale=\"showall\" menu=\"true\"></embed>', 'video_swf.gif');
INSERT INTO nuke_4nalbum_media_types VALUES ( 'rm', 'Video/RealMedia', '3', '<OBJECT height=\"<:HEIGHT:>\">
<PARAM NAME=\"CONTROLS\" VALUE=\"ImageWindow\">
<PARAM NAME=\"AUTOSTART\" Value=\"true\">
<PARAM NAME=\"SRC\" VALUE=\"<:FILENAME:>\">
<embed height=\"<:HEIGHT:>\" width=\"<:WIDTH:>\" controls=\"ImageWindow\" src=\"<:FILENAME:>?embed\" type=\"audio/x-pn-realaudio-plugin\" autostart=\"true\" nolabels=\"0\" autogotourl=\"-1\"></OBJECT>', 'video_realmedia.gif');

CREATE TABLE nuke_4nalbum_pictures (
   pid int(10) unsigned NOT NULL auto_increment,
   gid int(3) DEFAULT '0' NOT NULL,
   img varchar(255) NOT NULL,
   counter int(10) unsigned DEFAULT '0' NOT NULL,
   submitter varchar(24) DEFAULT 'Webmaster' NOT NULL,
   date datetime,
   name varchar(255) NOT NULL,
   description text NOT NULL,
   votes int(10) unsigned DEFAULT '0' NOT NULL,
   rate float DEFAULT '0' NOT NULL,
   extension varchar(10) DEFAULT 'image' NOT NULL,
   width smallint(5) unsigned DEFAULT '0' NOT NULL,
   height smallint(5) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (pid),
   KEY pid (pid)
);

CREATE TABLE nuke_4nalbum_pictures_newpicture (
   pid int(10) unsigned NOT NULL auto_increment,
   gid int(3) DEFAULT '0' NOT NULL,
   img varchar(255) NOT NULL,
   counter int(10) unsigned DEFAULT '0' NOT NULL,
   submitter varchar(24) DEFAULT 'Webmaster' NOT NULL,
   date datetime,
   name varchar(255) NOT NULL,
   description text NOT NULL,
   votes int(10) unsigned DEFAULT '0' NOT NULL,
   rate float DEFAULT '0' NOT NULL,
   extension varchar(10) DEFAULT 'image' NOT NULL,
   width smallint(5) unsigned DEFAULT '0' NOT NULL,
   height smallint(5) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (pid),
   KEY pid (pid)
);

CREATE TABLE nuke_4nalbum_rate_check (
   ip varchar(20) NOT NULL,
   time varchar(14) NOT NULL,
   pid int(10) unsigned DEFAULT '0' NOT NULL
);

CREATE TABLE nuke_4nalbum_template_types (
   id int(10) unsigned NOT NULL auto_increment,
   title varchar(255) NOT NULL,
   type tinyint(3) unsigned DEFAULT '2' NOT NULL,
   templateCategory longtext NOT NULL,
   templatePictures longtext NOT NULL,
   templateCSS longtext,
   PRIMARY KEY (id)
);

INSERT INTO nuke_4nalbum_template_types VALUES ( '1', 'Default Main Page Template', '1', '<table align=\"center\">
<tr>
        <td colspan=\"2\">
                <:GALLNAME:>
        </td>
</tr>
<tr>
        <td>
                <:IMAGE:>
        </td>
        <td valign=\"top\" align=\"left\">
                <:DESCRIPTION:>
        </td>
</tr>
</table>', '2', '.common_text_black {text-color:#000000}
.common_text_white {text-color:#ffffff}');
INSERT INTO nuke_4nalbum_template_types VALUES ( '2', 'Default', '2', '<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
<tr>
        <td>
                <:IMAGE:>
        </td>
        <td valign=\"top\">
                <p>
                                <table>
                                <tr>
                                        <td align=\"center\">
                                                <:DATE:>
                                        </td>
                                        <td align=\"center\">
                                                <:RATE:>
                                        </td>
                                        <td align=\"center\">
                                                <:HITS:>
                                        </td>
                                        <td align=\"center\">
                                                <:NEW:>
                                        </td>
                                </tr>
                                </table>
                </p>
                <p>
                                <:DESCRIPTION:>
                </p>
                <p>
                                <:NBCOMMENTS:> <br> <:FORMAT:> <br> <:SIZE:>
                </p>
        </td>
</tr>
</table>', '<table>
<tr>
        <td valign=\"top\" align=\"center\">
                <:NAMESIZE:>
                <br><br>
                <TABLE CellPadding=\"0\" CellSpacing=\"0\">
                <TR>
                        <TD valign=\"top\">
                                <:SUBMITTER:>
                                <:DATE:>
                                <:HITS:>
                                <:RATE:>
                        </TD>
                </TR>
                </table><br>
                <:RATINGBAR:><br>
                <:POSTCARD:><br>
                <:DOWNLOAD:><br>
                <:PRINT:>
        </td>
        <td width=\"80%\" align=\"center\">
                <:IMAGE:>
        </td>
</tr>
<tr>
        <td colspan=\"2\"><:DESCRIPTION:></td>
</tr>
<tr>
        <td colspan=\"2\">
                <:COMMENTS:>
        </td>
</tr>
</table>', '.common_text_black {text-color:#000000}
.common_text_white {text-color:#ffffff}');