<?php
    include("include/db_mysql.php");
    include("include/settings.php");
    include("include/global.php");
    
    /* Include the language file */
    $lang_file = "lang/" . $language . ".php";
    include($lang_file);
    
    $guest_login = 1;
	
	
	/* check if cookies are around */
	if ($clogin && $cpass) {
		/* this will initialize $login and $pass to cookie values */
		open_session(1, $clogin, $cpass);
	} else {
		/* this will only open session */
		open_session(0, "", "");
	}		
		
	if ($logout) {
		/* User has logged out, display login screen ($guest_login = 1) */
		$guest_login = 1;
		$login = "";
		$pass = "";
		
		/* Delete cookies */
		setcookie("clogin");
		setcookie("cpass");
    } else {
	    if ($login && $pass) {
			/* login and password are set. Check them */
	    	$guest_login = !login($login, $pass);	/* Check the login and password */
	    } else
	    	$guest_login = 1;	/* login and password are not set. */
	}
    
    if ($guest_login) {
    	session_destroy();
    } else {
    	/* logged in, set cookies if wished, triggered by the remember formbox */
    	if ($f_cookies) {
			setcookie("clogin", $login, time() + $cookie_remember_time);
			setcookie("cpass", $pass, time() + $cookie_remember_time);		
    	}
    }
    	
	/* Autoexpire old threads */
	if ($auto_expire && $threads_expire_days)
		$deleted = delete_old_threads($threads_expire_days, "all");
    	
?>
<html>

<head>
    <title><?php echo $forum_title ?></title>
    <link rel="stylesheet" type="text/css" href="cyphor.css">
</head>

<body>
<?php
    $db = new DB_Cyphor;
    $db->connect();

	/* log this ip address; Use timestamp and remote IP */
	self_count_page(time(), getenv(REMOTE_ADDR));

	/* some statistics */
    $query = "SELECT id FROM $tbl_prefix" . "users";
    $db->query($query);
    $num_users = $db->num_rows();
    $query = "SELECT nick, total_posts FROM $tbl_prefix" . "users ORDER BY total_posts DESC LIMIT 0,1";
    $db->query($query);
    $db->next_record();
    $num_posts = $db->f("total_posts");
    $num_nick = $db->f("nick");
?>


<?php	
	// Surrounding table for nice border effect
	print "<table border=0 cellspacing=0 cellpadding=1 width=100%>";
	
	print "<tr><td class=border>";
		
		// Header
		print "<table width=100% border=0 cellspacing=0 cellpadding=2><tr><td class=title width=50%>";
		print "<span class=bigh>$forum_title</span>";
		print "</td><td class=title width=50% align=right><span class=t>";
		printf($t_overview_upper_right, $num_users, $num_nick, $num_posts, num_users_online());
		print "</span></td></tr></table>";
			
	print "</td></tr><tr><td class=border>";
	
	// Get the welcome message
	$query = "SELECT * FROM $tbl_prefix" . "forum_settings WHERE field='welcome_msg'";
	$db->query($query);
	$db->next_record();
	if ($db->f("value")) {
		print "<table width=100% border=0 cellspacing=0 cellpadding=2><tr><td class=title width=50%><span class=bigh>";
		print $t_welcome;
		print "</span></td></tr><tr><td class=standard><span class=t>";
		print StripSlashes($db->f("value"));
		print "</span></td></tr></table>";

		print "</td></tr>";
		print "<tr><td class=border>";
	}
			
		// Login
		print "<table width=100% border=0 cellspacing=0 cellpadding=2>";
		
		if ($guest_login) {
			// Guest access
			print "<tr><td class=title><span class=h>" . $t_login . "</span></td></tr>";			
			print "<tr><td class=standard><span class=t>";
			print $t_guest_access;
			print("</span></td></tr><tr><td class=standard>");			
			print "<form action=\"$PHP_SELF\" method=POST><span class=t>$t_username:</span>";
			print " <input class=formbox type=\"text\" name=\"login\" maxlength=15 size=10> <span class=t>";
			print "$t_password:";
			print "</span> <input class=formbox type=\"password\" name=\"pass\" maxlength=50 size=10>";
        	print " <input type=\"submit\" class=button name=\"submit\" value=\"Login\">";
        	print " <input type=checkbox class=formbox name=\"f_cookies\" checked value=\"1\">";
        	print "<span class=t>" . $t_cookie_remember_box . "</span>";
        	print "</form><br></td></tr>";
		} else {
			// Registered user
			print "<tr><td class=title><span class=h>" . $t_logged_in . "</span></td></tr><tr><td class=standard><span class=t>";
			// Options
			printf($t_reguser_welcome_phrase, $login);
			print " <span class=t>";
	        if ($admin)	$rights = "admin";
	        else if ($moderator) $rights = "moderator";
	        else $rights = "normal";			
			printf($t_reguser_rights, $rights);
			print " [ ";
	        print "<a href=\"profile.php\">" . $t_edit_profile . "</a> | <a href=\"" . $PHP_SELF . "?logout=logout\">" . $t_logout . "</a>";
	        if ($admin) print " | <a href=\"admin/index.php\">$t_administration</a>";
	        print " ]</span><br><br></td></tr>";
		}
		
		print("</table>");

	print "</td></tr><tr><td class=border>";
	
		// Search
		print "<table border=0 width=100% cellspacing=0 cellpadding=2>";
		print "<tr><td class=title><span class=h>" . $t_search . "</span></td></tr>";
		print "<tr><td class=standard>";
		print "<form action=\"search.php\" method=POST><span class=t>" . $t_find . "</span> <input class=formbox type=text name=\"query_str\" size=10>";
		print " <span class=t>" . $t_infield . "</span> <select class=formbox name=\"query_field\" size=1><option value=\"title\"> Subject</option><option value=\"data\" selected> Text</option></select>";
		print " <span class=t>" . $t_indiscussion . "</span> <select class=formbox name=\"query_discussion\" size=1>";
		$query = "SELECT * FROM $tbl_prefix" . "forums ORDER BY id ASC";
		$db->query($query);
		while ($db->next_record())
			print "<option value=\"" . $db->f("id") . "\"> " . $db->f("name") . "</option>";
		
		print "</select>";
		print " <input class=button type=\"submit\" name=\"submit\" value=\"$t_btnsearch\"></form><br>";
		print "</td></tr></table>";
		
	print "</td></tr><tr><td class=border>";
		
		// Column headers

		print "<table width=100% border=0 cellspacing=0 cellpadding=2>";
	    print "<tr><td width=100% colspan=5 class=title><span class=h>" . $t_forums . "</span></td></tr>";
	    
	    print "<tr><td class=forumheader width=\"20%\" valign=top><span class=fhead>$t_forumname</span></td><td class=forumheader width=\"5%\" valign=top><span class=fhead>$t_new</span></td><td class=forumheader width=\"5%\" valign=top><span class=fhead>$t_total</span></td><td class=forumheader width=\"20%\" valign=top><span class=fhead>$t_lastpost</span></td><td class=forumheader width=\"50%\" valign=top><span class=fhead>$t_fdesc</span></td></tr>";

		$now = time();
		$day = $how_long_is_new * 24 * 3600;

        $query = "SELECT * FROM $tbl_prefix" . "forums ORDER BY id ASC";
        $db->query($query);

		$db2 = new DB_Cyphor;
		$db2->connect();

		if (!$db->num_rows()) {
			// No forums available
			print "<tr><td class=standard align=center colspan=5><span class=i>(no forums yet)</span></td></tr>";
		} else {
			// Loop through forums
	        while ($db->next_record()) {
	            $table_name = $db->f("db_table_name");
				$table_name = $tbl_prefix . $table_name;
				
				// Extract some info
	            $query = "SELECT id FROM $table_name";
	            $db2->query($query);
	            $msg_count = $db2->num_rows(); // number of messages in forum
	
	            $query = "SELECT id FROM $table_name WHERE (date>$now-$day)"; 
	            $db2->query($query);
	            $new_msg_count = $db2->num_rows(); // number of messages that are less than $how_long_is_new days old
	
	            $query = "SELECT date FROM $table_name ORDER BY date DESC LIMIT 0,1"; // date of last post
	            $db2->query($query);
	            $db2->next_record();
				if ($db2->f("date"))
	            	$last_post = nice_short_date($db2->f("date"));
	            else
	            	$last_post = "N/A";
	                        
	            printf("<tr><td valign=top class=standard><span class=b><a class=msg href=\"show.php?fid=%s\">%s</a></span></td>", $db->f("id"), StripSlashes($db->f("name")));
	            printf("<td valign=top class=standard><span class=redb>%s</span></td>", $new_msg_count);
	            printf("<td valign=top class=standard><span class=b>%s</span></td>", $msg_count);
	            printf("<td valign=top class=standard><span class=s>%s</span></td>", $last_post);
	            printf("<td valign=top class=standard><span class=s>%s</span></td></tr>", StripSlashes($db->f("short_desc")));
	        }
	    }
    
		printf("</table>");
				
	printf("</td></tr>");
	
						
	printf("<tr><td class=border>");

		// Footer
		include("include/footer.php"); 

	printf("</td></tr>");

	// close surrounding table
	printf("</table>");
	
?>
</body>

</html>
