<?
# search.php
#
# Parameters:
#
#   query_str: The query string, like "world"
#
#   query_field: The field the user is searching in.
#                    "title": Subject
#                    "data": Text
#
#   query_discussion: The discussion the user is searching in
#                   1: ... forums where id=1
#                   2: ... forums where id=2
#                   etc.
#
    include("include/db_mysql.php");
    include("include/settings.php");
    include("include/global.php");

    /* Include the language file */
    $lang_file = "lang/" . $language . ".php";
    include($lang_file);

    function print_header() {
        global $forum_title;
        ?>
        <html>

        <head>
            <title><? echo $forum_title ?> | <? echo $t_search ?></title>
            <link rel="stylesheet" type="text/css" href="cyphor.css">
        </head>

        <body bgcolor="#FFFFFF" text="#000000">
        <?
    }

    function print_footer() {

    }

	open_session();
	
	if (!$submit)
		exit(); // exit if no query string has been sent
    
    if ((!isset($query_str)) || (!isset($query_field)) || (!isset($query_discussion))) {
        exit_page_with_msg($t_invalid_query, "javascript:history.back()", $t_back_link);
        exit();
    }
        
	print_header();

	$db = new DB_Cyphor;
	$db->connect();
	$db_a = new DB_Cyphor;
	$db_a->connect();
	$query = "SELECT id, db_table_name, name FROM $tbl_prefix" . "forums WHERE id=$query_discussion";
    $db->query($query);
    $db->next_record();
 
 	$discussion_name = $db->f("name");   
    $table = $tbl_prefix . $db->f("db_table_name");
    $fid = $db->f("id");
    
	$query_str = trim($query_str);    
    $arr = split(" ", $query_str);
    $count = count($arr); 	# NUMBER OF WORDS IN QUERY

	// Assemble AND query
	$query = "SELECT * FROM $table WHERE ";
    $query = $query . "($query_field LIKE '%$arr[0]%') ";
    for ($i=1; $i < $count; $i++) {
        $query = $query . "AND (data LIKE '%" . $arr[$i] . "%') ";
    }
    $query = $query . "ORDER BY date DESC";


	// Go!
    $db->query($query);

	if ($db->num_rows()) { # FOUND SOMETHING
		print "<span class=h>";
		printf($t_results, $db->num_rows(), "<a href=\"show.php?fid=$fid\">" . htmlspecialchars(StripSlashes($discussion_name)) . "</a>");
		print "</span><br><br>";

		while ($db->next_record()) { # LOOP THROUGH RESULTS
			$a_q = "SELECT nick, email FROM $tbl_prefix" . "users WHERE (id=" . $db->f("author_id") . ")";
			$db_a->query($a_q);
			$db_a->next_record();
			printf("<span class=b>. <a class=msg href=\"show.php?fid=%s&id=%s\">%s</a></span> - <span class=t>%s</span> (<span class=i>%s</span>)<br>", $fid,
			$db->f("id"), htmlspecialchars(StripSlashes($db->f("title"))), nice_short_date($db->f("date")), htmlspecialchars(StripSlashes($db_a->f("nick"))));
			$data = htmlspecialchars(StripSlashes($db->f("data")));
			$data = substr($data, 0, 200);
			$data = $data . " ...";
			print "<span class=s>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $data . "</span><br><br>";				
		}
	} else { // FOUND NOTHING	
		print "<span class=h>";
		printf($t_found_nothing, "<a href=\"show.php?fid=$fid\">" . $discussion_name . "</a>");
		print "</span><br><br>";
	}

	
	print "<form action=\"" . $PHP_SELF . "\" method=POST><input type=\"hidden\" name=\"query_discussion\" value=\"$fid\"><input type=\"hidden\" name=\"query_field\" value=\"$query_field\">";
	print "<span class=t>" . $t_search_again . "</span><br>";
	print "<input class=formbox type=\"text\" name=\"query_str\"> <input class=button type=\"submit\" name=\"submit\" value=\"Search\"></form><br><br>";


    include("include/footer.php");
?>

</body>

</html>
