<?
    include("include/db_mysql.php");
    include("include/settings.php");
    include("include/global.php");

    /* Include the language file */
    $lang_file = "lang/" . $language . ".php";
    include($lang_file);

    open_session();
    if (isset($collapsed))
    	$collapse = $collapsed;
	
	$msg_counter = 0;
    
    if (!$fid) {
        exit_page_with_msg($terr_no_forum, "index.php", $t_forums_overview);
        exit();
    }

    $db = new DB_Cyphor;
    $db->connect();

	# COUNT THIS PAGE
	self_count_page(time(), getenv(REMOTE_ADDR)); # TIME = UNIX TIMESTAMP; IP

	# DEFAULT THREADS PER PAGE
	$threads_per_page = 20;

	if ($login && $pass) {
		if (login($login, $pass)) {
			$query = "SELECT id FROM $tbl_prefix" . "users WHERE nick='$login'";
	        $db->query($query);
	        $db->next_record();
	        $authid = $db->f("id");
	        $query = "SELECT threads_per_page FROM $tbl_prefix" . "user_settings WHERE id='$authid'";
	        $db->query($query);
	        $db->next_record();
	        $threads_per_page = $db->f("threads_per_page");
		}
	}

    # page = displays threads_per_page messages, from (page - 1) * tpp - (page) * tpp
    if (!$page) { $page = 1; }
    $page_offset = ($page - 1) * $threads_per_page;   # this is for LIMIT in the SQL-SELECT query

    $query = "SELECT * FROM $tbl_prefix" . "forums WHERE id=$fid";
    $db->query($query);
    $db->next_record();
    $forumname = $db->f("name");
    $db_table_name = $tbl_prefix . $db->f("db_table_name");
    $query = "SELECT id FROM $db_table_name WHERE parent_id=0";
    $db->query($query);
    $num_threads_in_forum = $db->num_rows();
    $query = "SELECT id FROM $db_table_name";
    $db->query($query);
    $num_messages_in_forum = $db->num_rows();

    if ($id) {
        // a message with id=$id will be displayed
        $message_mode = 1;
        $query = "SELECT * FROM $db_table_name WHERE id=$id";
        $db->query($query);
        $db->next_record();

        $msg_title = StripSlashes($db->f("title"));
        $msg_data = StripSlashes($db->f("data"));
                
        $author_id = $db->f("author_id");
        $parent_id = $db->f("parent_id");
        $thread_id = $db->f("thread_id");
        $id = $db->f("id");
        $mail_reply = $db->f("mail_reply");
        $date = $db->f("date");
        if ($display_hostname)
        	$hostname = $db->f("hostname");
        else
        	$hostname = "N/A";        
        
        $num_read = $db->f("num_read") + 1;
        // Increment num_read
        
        $query = "UPDATE $db_table_name SET num_read=num_read+1 WHERE id=$id";
        $db->query($query);

        $query = "SELECT * FROM $tbl_prefix" . "users WHERE id=$author_id";
        $db->query($query);
        $db->next_record();

        $author_name = $db->f("nick");
        $author_email = $db->f("email");
        $author_total_posts = $db->f("total_posts");
        $author_last_post = $db->f("last_post");
    } else {
        // forum treeview
        $message_mode = 0;
    }
?>
<html>

<head>
    <title>
    	<?
    		if ($message_mode)
    			echo htmlspecialchars(StripSlashes($msg_title));
    		else
    			echo htmlspecialchars(StripSlashes($forumname));
    	?>
    </title>
    <link rel="stylesheet" type="text/css" href="cyphor.css">
</head>

<body>
<?
    function get_nested_level($item_id) {
        global $db_table_name;
        global $fid;
        $count = 0;

        $db = new DB_Cyphor;
        $db->connect();
        $query = "SELECT parent_id FROM $db_table_name WHERE id=$item_id";
        $db->query($query);
        $db->next_record();

        while ($db->f("parent_id")) {
            $query = "SELECT parent_id FROM $db_table_name WHERE id=" . $db->f("parent_id");
            $db->query($query);
            $db->next_record();
            $count = $count + 1;
        }

        return $count;
    }

	function printOpenUL($num) {
		for ($i=1; $i<=$num; $i++) echo "<ul>";
	}
	
	function printCloseUL($num) {
		for ($i=1; $i<=$num; $i++) echo "</ul>";
	}

    function has_subitems($root_id) {
        global $db_table_name;
        $db = new DB_Cyphor;
        $db->connect();
        $query = "SELECT id FROM $db_table_name WHERE parent_id=$root_id";
        $db->query($query);
        return $db->num_rows();
    }

    function num_subitems($root_id) {
        global $num_replies;
        global $db_table_name;
        $db = new DB_Cyphor;
        $db->connect();
        $query = "SELECT id FROM $db_table_name WHERE parent_id=$root_id ORDER BY date DESC";
        $db->query($query);
        if ($db->num_rows()) {
            while ($db->next_record()) {
                $num_replies += 1;
                num_subitems($db->f("id"));
            }
        }
    }    

    function get_subitems($root_id, $offset) {
        global $db_table_name;
        global $fid;
        global $db_author;
        global $msg_counter;
        global $how_long_is_new;
		global $max_subject_length;
		global $max_subject_length_decrement;
		global $tbl_prefix;

        $db = new DB_Cyphor;
        $db->connect();
        $query = "SELECT * FROM $db_table_name WHERE parent_id=$root_id ORDER BY date DESC";
        $db->query($query);

        if ($db->num_rows()) {
            while ($db->next_record()) {            	
                $author_query = "SELECT * FROM $tbl_prefix" . "users WHERE id=" . $db->f("author_id");
                $db_author->query($author_query);
                $db_author->next_record();
                
                $msg_counter++; # INCREMENT COUNTER FOR SWITCHING COLORS
                
				# ALTERNATING COLORS, SET TD CLASS
				if ($msg_counter % 2) $td_class = "msgstd";
				else $td_class = "msgalt";
                
                print "<tr valign=middle><td class=" . $td_class . " nowrap>";                
                printOpenUL(get_nested_level($db->f("id")) - $offset);
				
				/* truncate long subject lines, compute maxlen according to nesting level */
				$title = $db->f("title");
				$level = get_nested_level($db->f("id"));
				$maxlen = $max_subject_length - ($level * $max_subject_length_decrement);
				if (strlen($title) > $maxlen) {
					$title = substr($db->f("title"), 0, $maxlen);
					$title .= "...";
				}
				print "<li><span class=b><a class=msg href=\"show.php?fid=" . $fid . "&id=" . $db->f("id") . "\">" . htmlspecialchars(StripSlashes($title)) . "</a></span></li>";
				printCloseUL(get_nested_level($db->f("id")) - $offset);

				$day = $how_long_is_new * 24 * 3600;
				if ($db->f("date") > (time() - $day)) // message is "new"
					$post_date = "<span class=redb>" . nice_short_date($db->f("date")) . "</span>";
				else // message is "old"
					$post_date = "<span class=t>" . nice_short_date($db->f("date")) . "</span>";
				
				print "</td><td nowrap class=" . $td_class . "><span class=t>" . htmlspecialchars(StripSlashes($db_author->f("nick"))) . "</span></td><td
				align=right class=" . $td_class . " nowrap>" . $post_date . "</td></tr>\n\n";
                get_subitems($db->f("id"), $offset);
            }
        } else {
            # No more subitems
        }
    }

    $db_author = new DB_Cyphor;
    $db_author->connect();

    if (!$message_mode) {
       	// ***************************************************************************************************
    	// Show a forum
    	// ***************************************************************************************************    
    	// Surrounding table for nice border effect
    	print "<table border=0 cellspacing=0 cellpadding=1 width=100%><tr><td class=border>";

			// Header    	
			print "<table border=0 width=100% cellspacing=0 cellpadding=2>";
				print "<tr><td width=70% class=title>";
					print "<span class=bigh><a class=controls href=\"index.php\">" . $forum_title . "</a> &gt; " . StripSlashes($forumname) . "</span> <span class=t>";
					printf($t_foruminfo, $num_threads_in_forum, $num_messages_in_forum);
		        print "</span></td><td width=30% align=right class=title><span class=b>";
		        printf($t_usersonline, num_users_online());		        				
	        print "</span></td></tr></table>";
         
        print "</td></tr><tr><td class=border>";
        
			// Controls
			print "<table border=0 width=100% cellspacing=0 cellpadding=2>";
				print "<tr><td width=80% class=controls><span class=b><a class=controls href=\"newmsg.php?fid=" . $fid . "\">" . $t_post_new_topic . "</a> | ";
		        if ($collapse)
		        	print "<a class=controls href=\"" . $PHP_SELF . "?fid=" . $fid . "&collapsed=0\">" . $t_expand_threads . "</a>";
		        else
		        	print "<a class=controls href=\"". $PHP_SELF . "?fid=" . $fid . "&collapsed=1\">" . $t_collapse_threads . "</a>";
		        print "</span></td>";
	
		        print "<td width=20% class=controls align=right><span class=b>&nbsp;";
				// Next/Prev links
		        if ($page > 1) {
		        	print "<a class=controls href=\"show.php?fid=" . $fid . "&page=" . ($page-1) . "\">" . $t_previous_page . "</a> ";
		        }
		        
		        if (($page > 1) && (($page * $threads_per_page) < $num_threads_in_forum))
		        	print "|";
		        
		        if (($page * $threads_per_page) < $num_threads_in_forum) {
		        	print " <a class=controls href=\"" . $PHP_SELF . "?fid=" . $fid . "&page=" . ($page+1) . "\">" . $t_next_page . "</a>";
		        }
		        print "</span></td></tr>";
	        print "</table>";
	    
	    print "</td></tr><tr><td class=border>";

			// Column headers
			print "<table border=0 width=100% cellspacing=0 cellpadding=2>";
	        print "<tr><td class=forumheader width=65%><span class=fhead>" . $t_subject_field . "</span></td><td class=forumheader width=15%><span class=fhead>" . $t_author_field . "</span></td><td class=forumheader align=right width=20%><span class=fhead>" . $t_date_field . "</span></td></tr>";
			
			if (!$db->num_rows()) // forum is empty
	            print "<tr><td class=standard colspan=3 align=center><span class=i>(emtpy forum)</span></td></tr>";
	
			// Show root items
	        $query = "SELECT * FROM $db_table_name WHERE (parent_id=0) ORDER BY date DESC LIMIT $page_offset, $threads_per_page";
	        $db->query($query);
	        $dbc = new DB_Cyphor;
	        $dbc->connect();
	        $i = 1;
	
	        while ($db->next_record() && ($i <= $threads_per_page)) { # LOOP THROUGH ROOT ITEMS
	        	$msg_counter++;
	            $aid = $db->f("author_id");
	            $query = "SELECT * FROM $tbl_prefix" . "users WHERE (id=$aid)";
	            $db_author->query($query);
	            $db_author->next_record();
	            
	            $cquery = "SELECT COUNT(id) AS cnt FROM $db_table_name WHERE thread_id=" . $db->f("thread_id");
	            $dbc->query($cquery);
	            $dbc->next_record();
	
				// alternating colors, set td class
				if ($msg_counter % 2) 	$td_class = "msgstd";
				else 					$td_class = "msgalt";
				
				/* truncate long subject lines */
				$title = $db->f("title");
				if (strlen($db->f("title")) > $max_subject_length) {
					$title = substr($db->f("title"), 0, $max_subject_length);
					$title .= "...";
				}
				
				print "<tr valign=middle><td nowrap class=" . $td_class . "><span class=b>&nbsp;<a class=msg href=\"show.php?fid=" . $fid . "&id=" . $db->f("id") . "\">" . htmlspecialchars(StripSlashes($title)) . "</a></span>";
	            if ($collapse) { 
	            	print " <span class=i>";
	            	if (($dbc->f("cnt") -1) == 1)
	            		print $t_one_reply;
	            	else
	            		printf($t_many_replies, $dbc->f("cnt")-1);
	            	print "</span>";
	            }
	
				// moderator/admin controls
				if ($admin || $moderator) {
					print "&nbsp;&nbsp;&nbsp;<span class=b><a href=\"admin/delete-thread.php?fid=" . $fid . "&id=" . $db->f("thread_id") . "\">" . $t_delete_thread . "</a></span>";
				}

				$day = $how_long_is_new * 24 * 3600;
				if ($db->f("date") > (time() - $day)) // message is "new"
					$post_date = "<span class=redb>" . nice_short_date($db->f("date")) . "</span>";
				else // message is "old"
					$post_date = "<span class=t>" . nice_short_date($db->f("date")) . "</span>";

				print "</td><td nowrap class=" . $td_class . "><span class=t>" . htmlspecialchars(StripSlashes($db_author->f("nick"))) . "</span></td><td nowrap align=right class=" . $td_class . ">" . $post_date . "</td></tr>\n\n";
		        
				if (!$collapse)
	            	get_subitems($db->f("id"), 0);
	            $i = $i + 1;
	        }
	        
	        print "</table>";

		print "</td></tr><tr><td class=border>";

			// Controls
			print "<table border=0 width=100% cellspacing=0 cellpadding=2>";
				print "<tr><td width=80% class=controls><span class=b><a class=controls href=\"newmsg.php?fid=" . $fid . "\">" . $t_post_new_topic . "</a> | ";
		        if ($collapse)
		        	print "<a class=controls href=\"" . $PHP_SELF . "?fid=" . $fid . "&collapsed=0\">" . $t_expand_threads . "</a>";
		        else
		        	print "<a class=controls href=\"". $PHP_SELF . "?fid=" . $fid . "&collapsed=1\">" . $t_collapse_threads . "</a>";
		        print "</span></td>";
	
		        print "<td width=20% class=controls align=right><span class=b>&nbsp;";
				// Next/Prev links
		        if ($page > 1) {
		        	print "<a class=controls href=\"show.php?fid=" . $fid . "&page=" . ($page-1) . "\">" . $t_previous_page . "</a> ";
		        }
				
		        if (($page > 1) && (($page * $threads_per_page) < $num_threads_in_forum))
		        	print "|";
				
		        if (($page * $threads_per_page) < $num_threads_in_forum) {
		        	print " <a class=controls href=\"" . $PHP_SELF . "?fid=" . $fid . "&page=" . ($page+1) . "\">" . $t_next_page . "</a>";
		        }
		        print "</span></td></tr>";
	        print "</table>";
                
        print "</td></tr><tr><td class=border>";
        
     		print "<table width=100% border=0 cellspacing=0 cellpadding=2>";
     		print "<tr><td class=controls align=right>";
     		jump_control();
     		print "</td></tr></table>";
        
        print "</td></tr>";
                
    } else {
       	// ***************************************************************************************************
    	// SHOW A MESSAGE
    	// ***************************************************************************************************
    	
    	// Surrounding table for nice border effect
    	print "<table border=0 cellspacing=0 cellpadding=1 width=100%><tr><td class=border>";
    	    	
    		// Header
	        print "<table border=0 cellspacing=0 cellpadding=2 width=100%>";
	        print "<tr><td class=title>";
			/* truncate long subject lines */
			
			if (strlen($msg_title) > $max_subject_length) {
				$msg_title = substr($msg_title, 0, $max_subject_length);
				$msg_title .= "...";
			}
	        print "<span class=bigh>" . htmlspecialchars(StripSlashes($msg_title)) . "</span><span class=t>";
	        printf($t_postinfo, htmlspecialchars(StripSlashes($author_name)), $hostname, nice_short_date($date), $num_read);
			print "</span></td></tr></table>";
			
		print "</td></tr><tr><td class=border>";
        	
        	// Column headers	 
	        print "<table border=0 cellspacing=0 cellpadding=2 width=100%>";
	        print "<tr><td width=15% valign=top class=forumheader><span class=fhead>" . $t_user_info . "</span></td><td width=85% class=forumheader valign=top><span class=fhead>" . $t_text . "</span></td></tr>";
	
	        // User info, message text
	        if ($author_last_post)
	        	$last_post = nice_short_date($author_last_post);
	        else
	        	$last_post = "N/A";
	        
			$msg_data = htmlspecialchars($msg_data);
			$msg_data = nl2br($msg_data);
	        $msg_data = HighlightURLS($msg_data);
			
			// $msg_data = formatCode($msg_data);

	        print "<tr><td valign=top class=userinfo><span class=s>" . $author_name . "<br>";
	        printf($t_user_posts, $author_total_posts, $last_post);
			
			/* Show message */
	        print "</span></td><td valign=top class=message><span class=message>" . $msg_data . "</span></td></tr>";
	        print "</table>";
	      
		print "</td></tr>";

						
	        // SHOW NEXT MESSAGES IN THREAD
	        if (has_subitems($id)) {        	
	        	print "<tr><td class=border>";
		        	print "<table width=100% border=0 cellspacing=0 cellpadding=2>";
		        	print "<tr><td valign=top colspan=3 class=forumheader><span class=fhead>" . $t_replies_to_this_msg . "</span></td></tr>";
		        	// Display info for this item
					
		        	print "<tr valign=middle><td class=msgalt width=65%><span class=b>" . $msg_title . "</span></td><td class=msgalt width=15%><span class=b>" . $author_name . "</span></td><td class=msgalt width=20% align=right><span class=b>" . nice_short_date($date) . "</span></td></tr>";
		        	$offset = get_nested_level($id);
		            get_subitems($id, $offset);
		            print "</table>";
	            print "</td></tr>";
	        }

		print "<tr><td class=border>";
       
			print "<table width=100% border=0 cellspacing=0 cellpadding=2>";
			print "<tr><td class=controls><span class=b><a class=controls href=\"newmsg.php?fid=" . $fid . "&pid=" . $id . "\">" . $t_reply_to_msg . "</a> | <a class=controls href=\"show.php?fid=" . $fid . "\">" . $t_back_to_forum . "</a> | <a class=controls href=\"index.php\">" . $t_forums_overview . "</a></span></td></tr>";
			print "</table>";
        
        print "</td></tr>";
    }	

	print "<tr><td class=border>";

		// Footer
		include("include/footer.php"); 

	print "</td></tr>";

	// close surrounding table
	print "</table>";
?>

</body>

</html>
