<?php

/**
 * YouTubeParser class for PHP version 4.3.0 and higher.
 * (c) 2008 Vagharshak Tozalakyan
 *
 * This is a simple class which may be used to extract direct links to video
 * files from YouTube.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @version  0.1
 * @author   Vagharshak Tozalakyan <vagh@tozalakyan.com>
 * @license  http://www.opensource.org/licenses/mit-license.php
 */

class YouTubeParser
{
    var $_urlOut = 'http://www.youtube.com/get_video?video_id=%s&t=%s';
    var $errMsg = '';

    // $url - the location of video at YouTube, something like http://youtube.com/watch?v=XXX
    function getVideoLink($url)
    {
        $hash = '';
        if (!preg_match('/(\?|&)v=([0-9a-z_-]+)(&|$)/si', $url, $m)) {
            $this->errMsg = 'Incorrect YouTube video URL.';
            return false;
        }
        $v = $m[2];
        if (!($response = file_get_contents($url))) {
            $this->errMsg = 'Unable to read the page from YouTube.';
            return false;
        }
        if (preg_match('/var swfArgs( *)=( *)\{(.*?)\}/si', $response, $m)) {
            if (preg_match('/"t"( *):( *)"(.*?)"/si', $m[3], $mm)) {
                $hash = $mm[3];
            }
        }
        if (empty($hash)) {
            $this->errMsg = 'Unable to extract the link.';
            return false;
        }
        return sprintf($this->_urlOut, $v, $hash);
    }

}

?>