<?php

/*======================================================================*\
|| GUESTBOOK SYSTEM v2.2 BY HASANN powered by www.vbulletin-turkey.com  ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'guestbook');
define('THIS_SCRIPT', 'foobar');
define('CSRF_PROTECTION', true);
define('CSRF_SKIP_LIST', 'foo,bar'); 
define('CSRF_SKIP_LIST', 'guestbook'); 

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('cpglobal', 'global', 'user', 'messaging', 'posting', 'postbit');

// get special data templates from the datastore
$specialtemplates = array(
                          'smiliecache',
                          'bbcodecache',
                          'humanverify',
                          'newpost_errormessage'
                          );

// on met en cache les templates
$globaltemplates = array(
                         'guestbook',
                         'guestbook_bit',
                         'guestbook_edit',
                         'guestbook_inactive_warning',
                         'guestbook_new',
	                       'humanverify'
                         );

// pre-cache templates used by specific actions
$actiontemplates = array(
        'hasann' => array(
                        'guestbook',
                        'guestbook_bit',
                        'guestbook_edit',
                        'guestbook_inactive_warning',
                        'guestbook_new',
	                      'humanverify',
		                    'imagereg'
		                    )
                        );

$version = '2.2';

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_user.php');
require_once('./includes/functions_newpost.php');
require_once('./includes/functions_editor.php');
require_once('./includes/functions_bigthree.php');
require_once('./includes/class_postbit.php');
require_once('./includes/class_bbcode.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ############## DETECT IF USERGROUPS IS ALLOWED TO VIEW GUESTBOOK ##############
$groups = explode(',',$vbulletin->options['guestbook_system_allowed_usergroups']);  
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0)) 
{
	print_no_permission();
}

// #################### DETECT IF GUESTBOOK IS ENABLED ##################### 
if (!$vbulletin->options['enable_guestbook_system'])
{
$groups = explode(',',$vbulletin->options['usergroups_cannot_disabled_view_guestbook']);   
if (is_member_of($vbulletin->userinfo, $groups) OR $vbulletin->userinfo['usergroupid'] == 6)

	{
		eval('$warning = "' . fetch_template('guestbook_inactive_warning') . '";');
		$header = $warning . $header;
		$footer .= $warning;	
	}
	else
	{
		eval('standard_error("' . str_replace("\'", "'", addslashes($vbulletin->options['guestbook_disabled_message'])) . '");');
	}
}


// sanity checks...
if (empty($_REQUEST['hasann']))
{
  $_REQUEST['hasann'] = 'index';
}

// ##########################" MAIN SCRIPT ################################

if ($_REQUEST['hasann'] == "index")
{
  $pagenumber = $_REQUEST['page'];

  if ($pagenumber == '') {
    $pagenumber = '1';
  }
  $page_start = ($pagenumber - 1) * $vbulletin->options['guestbook_per_page'];

  $result = $db->query_first("SELECT COUNT(id) AS nb FROM " . TABLE_PREFIX . "guestbook WHERE status = '1'");

  // total pages
  $perpage = $vbulletin->options['guestbook_per_page'];
  $totalpages = ceil(($result['nb']) / $vbulletin->options['guestbook_per_page']);

  if ($totalpages == '0') {
    $totalpages = '1';
  }

  $alt = '1';
  $show['first'] = '1';
  $show['prev'] = '1';
  $show['next'] = '1';
  $show['last'] = '1';
  $pagenumbers['first'] = '1';
  $pagenumbers['last'] = $totalpages;
  $total = $totalpages;
  $address = "guestbook.php?$session[sessionurl]do=index";

  if ($pagenumber == '1') {
    $show['prev'] = '0';
    $show['first'] = '0';
  }
  else {
    $prevpage = $pagenumber - 1;
  }
  if ($pagenumber == $total) {
    $show['next'] = '0';
    $show['last'] = '0';
  }
  else {
    $nextpage = $pagenumber + 1;
  }
  for($i=0; $i<$totalpages; $i++) {
    $curpage = $i+1;
    if ($pagenumber == $curpage) {
      eval("\$pagenav .= \"" . fetch_template('pagenav_curpage') . "\";");
    }
    else {
      eval("\$pagenav .= \"" . fetch_template('pagenav_pagelink') . "\";");
    }
  }

  eval("\$navigation = \"" . fetch_template('pagenav') . "\";");

  if ($result['nb'] > 0) {
    $cmp = '0';
    $perpage = $vbulletin->options['guestbook_per_page'];
    $messages = $db->query_read_slave("
    SELECT guestbook.id, guestbook.userid, guestbook.yazan, 
    guestbook.sehir, guestbook.site, guestbook.message, 
    guestbook.not, guestbook.tarih, guestbook.baslik, 
    user.avatarid, user.avatarrevision, avatarpath, 
    NOT ISNULL( customavatar.userid ) AS hascustomavatar, customavatar.dateline
    FROM " . TABLE_PREFIX . "guestbook AS guestbook
    LEFT JOIN " . TABLE_PREFIX . "user AS user ON user.userid = guestbook.userid
    LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON avatar.avatarid = user.avatarid
    LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON customavatar.userid = user.userid 
    WHERE guestbook.status = '1'
    ORDER BY id
    DESC LIMIT $page_start, " . intval($vbulletin->options['guestbook_per_page']) . "
    ");

    while ($mesaj = $db->fetch_array($messages)) {
      // ## AVATAR

      if (!empty($mesaj['avatarpath'])) {
        $avatar = "<img src=\"$mesaj[avatarpath]\">";
      }
      else if ($mesaj['hascustomavatar']) {
        if ($vbulletin->options['usefileavatar']) {
          $avatar = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $mesaj['userid'] . '"><img src="' . $vbulletin->options['avatarurl'] . '/avatar' . $mesaj['userid'] . '_' . $mesaj['avatarrevision'] . '.gif" alt="'
            . construct_phrase($vbphrase['xs_avatar'], $mesaj['yazan']) . '" border="0" /></a>';
        }
        else {
          $avatar = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $mesaj['userid'] . '"><img src="image.php?u=' . $mesaj['userid'] . '&amp;dateline=' . $mesaj['dateline'] . '" alt="'
            . construct_phrase($vbphrase['xs_avatar'], $$mesaj['yazan']) . '" border="0" /></a>';
        }
      }
      else {
        $avatar = '<img src="images/misc/unknown.gif" width="100" height="100" alt="' . $vbphrase['unregistered'] . '" />';
      }
      // ## AVATAR
	
      if ($cmp > 1) {
        $cmp = 0;
      }

      if ($mesaj['sehir'] == '') {
        $mesaj['sehir'] = '';
      }
      else {
        $mesaj['sehir'] = '<strong>' . $vbphrase['guestbook_sehir'] . '</strong>:  ' . $mesaj['sehir'];
      }
      if ($mesaj['site'] == '') {
        $mesaj['site'] = '';
      }
      else {

		$mesaj['site'] = '<strong>' . $vbphrase['guestbook_site'] . '</strong>:  <a href="http://' . $mesaj['site'] . '" target="_blank">'. $mesaj['site'] . '</a>';

      
            }
      
      require_once(DIR . '/includes/class_bbcode.php');
      $bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
      $mesaj['baslik'] = stripslashes($mesaj['baslik']);
      $mesaj['yazan'] = stripslashes($mesaj['yazan']);
      $mesaj['sehir'] = stripslashes($mesaj['sehir']);
      $mesaj['tarih'] = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $mesaj['tarih']);
      $mesaj['not'] = intval($mesaj['not']);
      $mesaj['message'] = $bbcode_parser->do_parse($mesaj['message'], $vbulletin->options['guestbook_allowhtml'], $vbulletin->options['guestbook_allow_smilies'], $vbulletin->options['guestbook_allow_bbcode'], $vbulletin->options['guestbook_imgcode'], 1, 0);

      if ($cmp == 0) {
        $alt = 'alt1';
      }
      else {
        $alt = 'alt2';
      }
      if ($mesaj['not']) {
        $mesaj['not'] = '<strong>' . $vbphrase['guestbook_rating'] . '</strong>:  <img src="' . $stylevar['imgdir_rating'] . '/rating_' . $mesaj['not'] . '.gif" alt="" />';
      }
      else {
        $mesaj['not'] = '';
      }
      eval("\$guestbookbit .= \"" . fetch_template('guestbook_bit') . "\";");
      $cmp = $cmp + 1;
    }
  }
  else {
    $guestbookbit = "<center>" . $vbphrase['guestbook_mesaj_yok'] . "</center>";
  }
  construct_forum_jump(); // get forum jump
  $pagenumber = $nbpages;
  $navbits["guestbook.php?$session[sessionurl]"] = $vbphrase['guestbook'];
  $navbits = construct_navbits($navbits);
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('print_output("' . fetch_template('guestbook') . '");');
}

// ################# ADDING MESSAGES ##########################

// initialize errors array
$errors = array();

if ($_POST['hasann'] == 'add')

{

$vbulletin->input->clean_array_gpc('p', array(
	  'id'		    => TYPE_STR,
	  'yazan'	    => TYPE_STR,
	  'sehir'	    => TYPE_STR,
		'site'      => TYPE_STR,
		'message'   => TYPE_STR,
		'tarih'     => TYPE_STR,
		'not'       => TYPE_STR,
		'baslik'    => TYPE_NOHTML,
		'ip'        => TYPE_STR,
		'wysiwyg'   => TYPE_BOOL,
		'humanverify'   => TYPE_ARRAY
	));


// ############## DETECT IF USERGROUPS IS ALLOWED TO POST INTO GUESTBOOK ##############
$groups = explode(',',$vbulletin->options['guestbook_post_allowed_usergroups']);   
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0)) 
{
	print_no_permission();
}	

//part 1

	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_STR);
  $yazan = $vbulletin->input->clean_gpc('p', 'yazan', TYPE_STR);
	$sehir = $vbulletin->input->clean_gpc('p', 'sehir', TYPE_STR);
	$site = $vbulletin->input->clean_gpc('p', 'site', TYPE_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$tarih = $vbulletin->input->clean_gpc('p', 'tarih', TYPE_STR);
	$not = $vbulletin->input->clean_gpc('p', 'not', TYPE_STR);
	$baslik = $vbulletin->input->clean_gpc('p', 'baslik', TYPE_STR);
  $ip = $vbulletin->input->clean_gpc('p', 'ip', TYPE_STR);
  
	// set messages status
  if (!$vbulletin->options['guestbook_required_moderation'])
	{
		$status = 1;
		$vbulletin->options['guestbook_required_moderation'] = TRUE;
	}
	else
	{
		$status = 2;
		$vbulletin->options['guestbook_required_moderation'] = FALSE;
	}
	
	// sanitize inputs
	if(!$vbulletin->userinfo['userid'])
	{
		$vbulletin->userinfo['userid'] = '0';
		$vbulletin->userinfo['username'] = 'Guest';
	}
 
	$yazan =  $vbulletin->userinfo['username']; 
  $userid = $vbulletin->userinfo['userid'];   
  $sehir = $_REQUEST['sehir'];
  $site = $_REQUEST['site'];
  $tarih = $_REQUEST['tarih'];
  $not = $_REQUEST['not'];
  $baslik = $_REQUEST['baslik'];
  $ip = $_REQUEST['ip'];
  
  if ($not == "$stylevar[imgdir_rating]/rating_1.gif") {
    $not = '1';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_2.gif") {
    $not = '2';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_3.gif") {
    $not = '3';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_4.gif") {
    $not = '4';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_5.gif") {
    $not = '5';
  }
  
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else
	{
		$message =& $vbulletin->GPC['message'];
	}
	
  $message = addslashes(strip_tags($message));
  $yazan = addslashes(strip_tags($yazan));
  $sehir = addslashes(strip_tags($sehir));
  $site = addslashes(strip_tags($site));
  $baslik = addslashes(strip_tags($baslik));
  $not = intval($not);

	// check we have a message and a subject
	if ($message == '' OR $baslik == '' OR $sehir == '')
	{
		$errors[] = fetch_error('guestbook_hata');
	}
	
	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['guestbook_image_verification'] AND $vbulletin->options['allow_unregistered_post'] AND $vbulletin->options['hv_type'] AND $vbulletin->options['regimagetype'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($vbulletin->GPC['humanverify']))
		{
	  		$errors[] = fetch_error($verify->fetch_error());
	  	}
	}
	
	if (empty($errors))
	{
		$languageid = -1;
	

	// insert message	
	$db->query("INSERT INTO `" . TABLE_PREFIX . "guestbook` ( `id` , `yazan` , `sehir` , `site` , `message` , `not` , `tarih` , `baslik` , `ip` , `userid`, `status` ) 
			VALUES ('', '$yazan', '$sehir', '$site', '$message', '$not', '" . TIMENOW . "', '$baslik', '$ip', '$userid', '$status')
		");
	$id = $db->insert_id();
	
	
  $vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl']; 
  eval(print_standard_redirect('message_posted_successfully', true, true)); 

}
	// there are errors!
	else
	{
		$show['errors'] = true;

		$_REQUEST['hasann'] = 'addnew';
	}
//part 2

if ($userid == '')
{ 
eval(print_standard_redirect('redirect_nologged'));  
}
else
{     

	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_STR);
  $yazan = $vbulletin->input->clean_gpc('p', 'yazan', TYPE_STR);
	$sehir = $vbulletin->input->clean_gpc('p', 'sehir', TYPE_STR);
	$site = $vbulletin->input->clean_gpc('p', 'site', TYPE_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$tarih = $vbulletin->input->clean_gpc('p', 'tarih', TYPE_STR);
	$not = $vbulletin->input->clean_gpc('p', 'not', TYPE_STR);
	$baslik = $vbulletin->input->clean_gpc('p', 'baslik', TYPE_STR);
  $ip = $vbulletin->input->clean_gpc('p', 'ip', TYPE_STR);
	
	// set messages status
  if (!$vbulletin->options['guestbook_required_moderation'])
	{
		$status = 1;
		$vbulletin->options['guestbook_required_moderation'] = TRUE;
	}
	else
	{
		$status = 2;
		$vbulletin->options['guestbook_required_moderation'] = FALSE;
	}
	
	// sanitize inputs
	if(!$vbulletin->userinfo['userid'])
	{
		$vbulletin->userinfo['userid'] = '0';
		$vbulletin->userinfo['username'] = 'Guest';
	}
 
	$yazan =  $vbulletin->userinfo['username']; 
  $userid = $vbulletin->userinfo['userid'];   
  $sehir = $_REQUEST['sehir'];
  $site = $_REQUEST['site'];
  $tarih = $_REQUEST['tarih'];
  $not = $_REQUEST['not'];
  $baslik = $_REQUEST['baslik'];
  $ip = $_REQUEST['ip'];
  
  if ($not == "$stylevar[imgdir_rating]/rating_1.gif") {
    $not = '1';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_2.gif") {
    $not = '2';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_3.gif") {
    $not = '3';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_4.gif") {
    $not = '4';
  }
  if ($not == "$stylevar[imgdir_rating]/rating_5.gif") {
    $not = '5';
  }
  
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else
	{
		$message =& $vbulletin->GPC['message'];
	}
	
  $message = addslashes(strip_tags($message));
  $yazan = addslashes(strip_tags($yazan));
  $sehir = addslashes(strip_tags($sehir));
  $site = addslashes(strip_tags($site));
  $baslik = addslashes(strip_tags($baslik));
  $not = intval($not);
  
	
	if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['guestbook_image_verification'] AND $vbulletin->options['allow_unregistered_post'] AND $vbulletin->options['hv_type'] AND $vbulletin->options['regimagetype'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verify =& vB_HumanVerify::fetch_library($vbulletin);
		if (!$verify->verify_token($vbulletin->GPC['humanverify']))
		{
	  		$errors[] = fetch_error($verify->fetch_error());
	  }
	}

	if (empty($errors))
	{
		$languageid = -1;
		
	// insert message	
	$db->query("INSERT INTO `" . TABLE_PREFIX . "guestbook` ( `id` , `yazan` , `sehir` , `site` , `message` , `not` , `tarih` , `baslik` , `ip` , `userid`, `status` ) 
			VALUES ('', '$yazan', '$sehir', '$site', '$message', '$not', '" . TIMENOW . "', '$baslik', '$ip', '$userid', '$status')
		");
	$id = $db->insert_id();
	
	
  $vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl']; 
  eval(print_standard_redirect('message_posted_successfully', true, true)); 

}
	// there are errors!
	else
	{
		$show['errors'] = true;
		foreach ($errors AS $errormessage)
		{
			eval('$errormessages .= "' . fetch_template('newpost_errormessage') . '";');
		}

		$_REQUEST['hasann'] = 'addnew';
	}
	
}

}

// ############################# SIGN NEW MESSAGE #############################

if ($_REQUEST['hasann'] == 'addnew')
{

$vbulletin->input->clean_array_gpc('r', array(
	  'id'		    => TYPE_STR,
	  'yazan'	    => TYPE_STR,
	  'sehir'	    => TYPE_STR,
		'site'      => TYPE_STR,
		'message'   => TYPE_STR,
		'tarih'     => TYPE_STR,
		'not'       => TYPE_STR,
		'baslik'    => TYPE_NOHTML,
		'ip'        => TYPE_STR,
		'wysiwyg'   => TYPE_BOOL,
		'humanverify'   => TYPE_ARRAY
	));

// ############## DETECT IF USERGROUPS IS ALLOWED TO POST INTO GUESTBOOK ##############
$groups = explode(',',$vbulletin->options['guestbook_post_allowed_usergroups']);   
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0)) 
{
	print_no_permission();
}

// Editor & message area
	require_once(DIR . '/includes/functions_editor.php');
	$editorid = construct_edit_toolbar('', 0, 0, 'nonforum', 1, 1, false);

  // get username code
  $currentpage = urlencode("newthread.php?f=$foruminfo[forumid]");
  eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

  $ip2 = gethostbyaddr(IPADDRESS);
  $ip1 = IPADDRESS;
  $ip = "$ip1 $ip2";
  
  if (!$vbulletin->userinfo['userid'] AND $vbulletin->options['guestbook_image_verification'] AND $vbulletin->options['allow_unregistered_post'] AND $vbulletin->options['hv_type'] AND $vbulletin->options['regimagetype'])
	{
		require_once(DIR . '/includes/class_humanverify.php');
		$verification =& vB_HumanVerify::fetch_library($vbulletin);
		$human_verify = $verification->output_token();
	}
	else
	{
		$human_verify = '';
	}

  // draw nav bar
  $navbits = array();
  $navbits["guestbook.php?$session[sessionurl]"] = $vbphrase['guestbook'];
  $navbits[''] = $vbphrase['guestbook_mesaj_birak'];

  $navbits = construct_navbits($navbits);
  eval('$navbar = "' . fetch_template('navbar') . '";');
  eval('print_output("' . fetch_template('guestbook_new') . '");');
}
// ################# DELETE MESSAGES ##########################

if ($_REQUEST['hasann'] == 'delete')
{
 
  $id = $_REQUEST['id'];
 
// ############## DETECT IF USERGROUPS IS ALLOWED TO DELETE MESSAGES ##############
$groups = explode(',',$vbulletin->options['guestbook_delete_allowed_usergroups']);   
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0)) 
{
	print_no_permission();
}
else
{
  $db->query("DELETE FROM " . TABLE_PREFIX . "guestbook WHERE id = '" . $id . "'");
  $vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl']; 
  eval(print_standard_redirect('message_deleted_successfully', true, true)); 
}
}

// ################### MODIFY MESSAGE #################### \\
if($_REQUEST['hasann'] == 'edit')

{

	$id = $vbulletin->input->clean_gpc('r', 'id', TYPE_INT);
	
// ############## DETECT IF USERGROUPS IS ALLOWED TO EDIT MESSAGES ##############
$groups = explode(',',$vbulletin->options['guestbook_edit_allowed_usergroups']);   
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0)) 
{
	print_no_permission();
}

	if (empty($id))
    {
    eval(standard_error(fetch_error('invalidid', $vbphrase['forum'], $vbulletin->options['contactuslink'])));
    }
	else
	{

	$getpost = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "guestbook WHERE id = '$id'");
	if (empty($getpost[id]))
    {
    eval(standard_error(fetch_error('invalidid', $vbphrase['forum'], $vbulletin->options['contactuslink'])));
    }
	else
	{

	// Editor & message area
	require_once(DIR . '/includes/functions_editor.php');
  $editorid = construct_edit_toolbar($getpost['message'], 0, 'nonforum', 1, 1, false);

  $getpost['postdate'] = vbdate($vbulletin->options['dateformat'], $getpost['tarih']);
	$getpost['posttime'] = vbdate($vbulletin->options['timeformat'], $getpost['tarih']);
	
	$currentpage = urlencode("guestbook.php?" . $vbulletin->session->vars['sessionurl'] . "hasann=edit&amp;id=$getpost[id]");
	eval('$usernamecode = "' . fetch_template('newpost_usernamecode') . '";');

	$navbits = array();
	$navbits["guestbook.php"] = $vbphrase['guestbook'];
	$navbits[''] = $vbphrase['guestbook_edit'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('guestbook_edit') . '");');
	}
	}
}

// ################### INSERT MESSAGE TO DATABASE #################### \\
if ($_REQUEST['hasann'] == "update") 

{

$vbulletin->input->clean_array_gpc('r', array(
	  'id'		=> TYPE_STR,
	  'sehir'	=> TYPE_STR,
		'site'      => TYPE_STR,
		'message'   => TYPE_STR,
		'tarih'     => TYPE_STR,
		'not'       => TYPE_STR,
		'baslik'    => TYPE_STR,
		'ip'        => TYPE_STR,
		'wysiwyg'   => TYPE_BOOL
	));

// ############## DETECT IF USERGROUPS IS ALLOWED TO EDIT MESSAGES ##############
$groups = explode(',',$vbulletin->options['guestbook_edit_allowed_usergroups']);   
if (!(is_member_of($vbulletin->userinfo,$groups) OR $vbulletin->userinfo['usergroupid'] == 6 OR $groups[0] == 0))  
{
	print_no_permission();
}

	if ($vbulletin->GPC['loggedinuser'] != 0 AND $vbulletin->userinfo['userid'] == 0)
	{
		// User was logged in when writing post but isn't now. If we got this
		// far, guest posts are allowed, but they didn't enter a username so
		// they'll get an error. Force them to log back in.
		standard_error(fetch_error('session_timed_out_login'), '', false, 'STANDARD_ERROR_LOGIN');
	}

	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_INT);
	$sehir = $vbulletin->input->clean_gpc('p', 'sehir', TYPE_STR);
	$site = $vbulletin->input->clean_gpc('p', 'site', TYPE_STR);
	$mesaj = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$tarih = $vbulletin->input->clean_gpc('p', 'tarih', TYPE_STR);
	$not = $vbulletin->input->clean_gpc('p', 'not', TYPE_STR);
	$baslik = $vbulletin->input->clean_gpc('p', 'baslik', TYPE_STR);
  $ip = $vbulletin->input->clean_gpc('p', 'ip', TYPE_STR);
  
	$message['message'] = htmlspecialchars_uni($message['message']);
	
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], false);
	}
	else
	{
		$message =& $vbulletin->GPC['message'];
	}

	// if it's all good... update message to database
		$db->query_write("UPDATE " . TABLE_PREFIX . "guestbook
				                      SET 
				                      sehir = '" . $db->escape_string($sehir) . "',
					                    site = '" . $db->escape_string($site) . "',
                              message = '" . $db->escape_string($message) . "',
                              baslik = '" . $db->escape_string($baslik) . "'
                              WHERE id = '" . intval($id) . "'
			                        ");	
    $vbulletin->url = 'guestbook.php?' . $vbulletin->session->vars['sessionurl']; 
    eval(print_standard_redirect('message_edited_successfully', true, true)); 
}

?>