<?php

require_once('includes/config.php');
require_once('includes/functions/func.global.php');
if($config['usedigg'])
{
	require_once('includes/functions/func.digg.php');
}
require_once('includes/classes/class.template_engine.php');
require_once('includes/lang/lang_'.$config['lang'].'.php');

// Start the session
session_start();

// Connect to the database
db_connect($config);

// Check if the user has a remember cookie set
checkremember($config);

// If no page is specified set to first page
if(!isset($_GET['page']))
{
	$_GET['page'] = 1;
}
else
{
	$_GET['page'] = makeInt($_GET['page']);
}

if(isset($_GET['id']))
{
	$_GET['i'] = $_GET['id'];
}
elseif(isset($_GET['i']))
{
	$_GET['id'] = $_GET['i'];
}

// Get site categories
$cats = get_cats($config);

// Check to see if digg.com mode is enabled
if($config['usedigg'])
{
	// Check if the category exists
	if(isset($cats[$_GET['i']]))
	{
		// Get the category title from the cats array
		$cat_info['cat_title'] = $cats[$_GET['i']]['cat_title'];
	}
	else
	{
		// Category was not found
		exit('Category not found');
	}
	
	// Retreive stories from digg api
	$content = getdiggstories($_GET['i'],$_GET['page']);
	$stories = $content['stories'];
	
	$total[0] = $content['total'];
}
else
{
	// Check if the category exists
	if(isset($cats[$_GET['i']]))
	{
		// Get the category title from the cats array
		$cat_info['cat_title'] = $cats[$_GET['i']]['cat_title'];
	}
	else
	{
		// Category was not found
		exit('Category not found');
	}

	// Initiate stories array
	$stories = array();
	$avatars = array();
	
	// Retreive stories from the database
	if($config['rating_mode'] == '0')
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['i'])."' ORDER BY story_rating ASC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	else
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['i'])."' AND story_prom='1' ORDER BY story_rating ASC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
	while ($info = @mysql_fetch_array($query_result))
	{
		$info['story_title'] = stripslashes($info['story_title']);
		$info['story_desc'] = stripslashes($info['story_desc']);
	
		$stories[$info['story_id']] = $info;
		$stories[$info['story_id']]['dugg'] = 0;
		$stories[$info['story_id']]['buried'] = 0;
		$stories[$info['story_id']]['cat_title'] = $cats[$info['story_cat']]['cat_title'];
		$stories[$info['story_id']]['cat_id'] = $info['story_cat'];
		$stories[$info['story_id']]['ago'] = time_taken((time()-$info['story_time']));
		$stories[$info['story_id']]['domain'] = getDomain($info['story_url']);
		
		$avatars[$info['user_id']] = $info['user_id'];
		
		if($config['mod_rewrite'] == 1)
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'stories/'.$info['story_id'].'/'.modrewriteurl($info['story_title']).'.html';
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'view/'.$info['story_cat'].'/'.modrewriteurl($cats[$info['story_cat']]['cat_title']).'/1.html';
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'users/'.$info['user_id'].'/'.$info['user_name'].'/1.html';
		}
		else
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'story.php?id='.$info['story_id'];
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'cat.php?i='.$info['story_cat'];
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'profile.php?id='.$info['user_id'];
		}
		
		// Construct where string for looking up digs
		if(!isset($_SESSION['dugg'][$info['story_id']]))
		{
			if(isset($story_where))
			{
				$story_where.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where = "story_id='".$info['story_id']."'";
			}
		}
		
		if(!isset($_SESSION['bury'][$info['story_id']]))
		{
			if(isset($story_where2))
			{
				$story_where2.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where2 = "story_id='".$info['story_id']."'";
			}
		}
	}
	
	$av_count = count($avatars);
	
	if($av_count > 0)
	{
		foreach ($avatars as $key => $info) 
		{
			if(isset($avatar_where))
			{
				$avatar_where.= " OR user_id='".$key."'";
			}
			else
			{
				$avatar_where = "user_id='".$key."'";
			}
		}
		$avatar_where.= "LIMIT ".$av_count;
		
		$query = "SELECT user_id,avatar FROM ".$config['db']['pre']."users WHERE ".$avatar_where;
		$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
		while ($info = @mysql_fetch_array($query_result))
		{
			$avatars[$info['user_id']] = getUserAvatar($info['user_id'],$config,false,$info['avatar']);
		}
	}
	
	// Get total number of stories in this category
	if($config['rating_mode'] == 0)
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['i'])."'"));
	}
	else
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['i'])."' AND story_prom='1'"));
	}
	
	// Check that user is logged in
	if(isset($_SESSION['duser']['id']))
	{
		// Check that there are stories to look for
		if(isset($story_where))
		{
			// Check for digs in the database
			$query = "SELECT story_id FROM ".$config['db']['pre']."digs WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(isset($story_where2))
		{
			if(isset($_SESSION['duser']['id']))
			{
				$query = "SELECT story_id FROM ".$config['db']['pre']."buries WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where2."))";
				$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
				while ($info = @mysql_fetch_array($query_result))
				{
					$stories[$info['story_id']]['buried'] = 1;
				}
			}
		}
	}
	
	// Check if user has dugg 
	foreach ($stories as $key => $info) 
	{
		if(!$stories[$info['story_id']]['dugg'])
		{
			if(isset($_SESSION['dugg'][$info['story_id']]))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(!$stories[$info['story_id']]['buried'])
		{
			if(isset($_SESSION['bury'][$info['story_id']]))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
		
		$stories[$info['story_id']]['avatar'] = $avatars[$info['user_id']];
	}
}

// Output info to cat.html template
if($total[0])
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/cat.html");
}
else
{
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/cat_noresults.html");
}
if($config['mod_rewrite'])
{
	$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming/'.$_GET['id'].'/'.modrewriteurl($cat_info['cat_title']).'/1.html');
	$page->SetParameter ('POPULAR_LINK',$config['site_url'].'view/'.$_GET['id'].'/'.modrewriteurl($cat_info['cat_title']).'/1.html');
}
else
{
	$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming.php?id='.$_GET['id']);
	$page->SetParameter ('POPULAR_LINK',$config['site_url'].'index.php');
}
$page->SetParameter ('XML_URL', $config['site_url'].'xmlfeeds.php?cmd=popular&id='.$_GET['id']);
$page->SetParameter ('CAT_ID', $_GET['i']);
$page->SetParameter ('CAT_TITLE',$cat_info['cat_title']);
$page->SetParameter ('MODE','popular');
$page->SetLoop ('CATS', $cats);
$page->SetLoop ('STORIES', $stories);
$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats,$cat_info['cat_title']));
$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
if(isset($_SESSION['duser']['id']))
{
	$page->SetParameter ('LOGGEDIN', 1);
}
else
{
	$page->SetParameter ('LOGGEDIN', 0);
}
if($config['mod_rewrite'])
{
	$page->SetLoop ('PAGES', pagenav2($total[0],$_GET['page'],10,'cat.php',1,$_GET['i'],$config,$cats[$info['story_cat']]['cat_title']));
}
else
{
	$page->SetLoop ('PAGES', pagenav($total[0],$_GET['page'],10,$config['site_url'].'cat.php?i='.$_GET['i'],1));
}
$page->CreatePageEcho($lang,$config);
?>