<?php

function getdiggstories($cat,$page,$status='popular')
{
	GLOBAL $details;

	if($cat)
	{
		$url='http://services.digg.com/stories/container/'.$cat.'/'.$status.'?offset='.(($page-1)*10);
	}
	else
	{
		$url = 'http://services.digg.com/stories/'.$status.'?offset='.(($page-1)*10);
	}

    $xml_parser = xml_parser_create();
    xml_set_element_handler($xml_parser, "StoryNodeSearchStart", "StoryNodeSearchEnd");
    xml_set_character_data_handler($xml_parser, "StoryNodeSearchData");
    IF (!($fp = fopen($url, "r")))
    {
        die("File I/O error: $xml_filename");
    }
    while ($data = fread($fp, 4096))
    {
        if (!xml_parse($xml_parser, $data, feof($fp)))
        {
            die ("XML parser error: " . xml_error_string(xml_get_error_code($xml_parser)));
        }
    }
    xml_parser_free($xml_parser);
	
	$stories = array();
	$stories['total'] = $details['TOTAL'];
	$stories['stories'] = array();
	
	foreach ($details['STORIES'] as $story_info) 
	{
		$stories['stories'][$story_info['ID']]['story_id'] = $story_info['ID'];
		$stories['stories'][$story_info['ID']]['story_title'] = $story_info['TITLE'];
		$stories['stories'][$story_info['ID']]['story_url'] = $story_info['LINK'];
		$stories['stories'][$story_info['ID']]['story_diggurl'] = $story_info['HREF'];
		$stories['stories'][$story_info['ID']]['story_digs'] = $story_info['DIGS'];
		$stories['stories'][$story_info['ID']]['story_desc'] = $story_info['DESCRIPTION'];
		$stories['stories'][$story_info['ID']]['story_comments'] = $story_info['COMMENTS'];
		$stories['stories'][$story_info['ID']]['user_name'] = $story_info['USERNAME'];
		$stories['stories'][$story_info['ID']]['user_id'] = $story_info['USERNAME'];
		$stories['stories'][$story_info['ID']]['dugg'] = 0;
	}
	
	return $stories;
}

function getdiggstory($id)
{
	GLOBAL $details;

	$url = 'http://services.digg.com/stories/'.$id;

    $xml_parser = xml_parser_create();
    xml_set_element_handler($xml_parser, "Story2NodeSearchStart", "Story2NodeSearchEnd");
    xml_set_character_data_handler($xml_parser, "Story2NodeSearchData");
    IF (!($fp = fopen($url, "r")))
    {
        die("File I/O error: $xml_filename");
    }
    while ($data = fread($fp, 4096))
    {
        if (!xml_parse($xml_parser, $data, feof($fp)))
        {
            die ("XML parser error: " . xml_error_string(xml_get_error_code($xml_parser)));
        }
    }
    xml_parser_free($xml_parser);
	
	$story = array();
	
	$story['story_id'] = $id;
	$story['story_title'] = $details['TITLE'];
	$story['story_desc'] = $details['DESCRIPTION'];
	$story['story_url'] = $details['LINK'];
	$story['user_name'] = $details['USERNAME'];
	$story['user_id'] = $details['USERNAME'];
	$story['story_digs'] = $details['DIGS'];
	$story['story_comments'] = $details['COMMENTS'];
	$story['story_diggurl'] = $details['HREF'];
	
	return $story;
}

function StoryNodeSearchStart($parser, $name, $attributes)
{
	GLOBAL $open_tags,$current_tag,$details,$story_id;
	
	$open_tags[$name] = 1;
	$current_tag = $name;
	
	if($name == 'STORIES')
	{
		$details = $attributes;
	}
	elseif($name == 'STORY')
	{
		$details['STORIES'][$attributes['ID']] = $attributes;
		$story_id = $attributes['ID'];
	}
	elseif($name == 'USER')
	{
		//print_r($attributes);
		$details['STORIES'][$story_id]['USERNAME'] = $attributes['NAME'];
	}
}

function StoryNodeSearchEnd($parser, $name)
{
	GLOBAL $open_tags,$current_tag;
	
	unset($current_tag);
	unset($open_tags[$name]);
}

function StoryNodeSearchData($parser, $cdata)
{
	GLOBAL $open_tags,$current_tag,$details,$story_id;
	
	if($current_tag == 'TITLE')
	{
		if(isset($details['STORIES'][$story_id]['TITLE']))
		{
			$details['STORIES'][$story_id]['TITLE'].= $cdata;
		}
		else
		{
			$details['STORIES'][$story_id]['TITLE'] = $cdata;
		}
	}
	elseif($current_tag == 'DESCRIPTION')
	{
		if(isset($details['STORIES'][$story_id]['DESCRIPTION']))
		{
			$details['STORIES'][$story_id]['DESCRIPTION'].= $cdata;
		}
		else
		{
			$details['STORIES'][$story_id]['DESCRIPTION'] = $cdata;
		}
	}
}



function Story2NodeSearchStart($parser, $name, $attributes)
{
	GLOBAL $open_tags,$current_tag,$details,$story_id;
	
	$open_tags[$name] = 1;
	$current_tag = $name;
	
	if($name == 'STORY')
	{
		$details = $attributes;
	}
	elseif($name == 'USER')
	{
		//print_r($attributes);
		$details['USERNAME'] = $attributes['NAME'];
	}
}

function Story2NodeSearchEnd($parser, $name)
{
	GLOBAL $open_tags,$current_tag;
	
	unset($current_tag);
	unset($open_tags[$name]);
}

function Story2NodeSearchData($parser, $cdata)
{
	GLOBAL $open_tags,$current_tag,$details,$story_id;
	
	if($current_tag == 'TITLE')
	{
		if(isset($details['TITLE']))
		{
			$details['TITLE'].= $cdata;
		}
		else
		{
			$details['TITLE'] = $cdata;
		}
	}
	elseif($current_tag == 'DESCRIPTION')
	{
		if(isset($details['DESCRIPTION']))
		{
			$details['DESCRIPTION'].= $cdata;
		}
		else
		{
			$details['DESCRIPTION'] = $cdata;
		}
	}
}

?>