<?php

require_once('../includes/config.php');

function install_error($error)
{
	if(!isset($_GET['ignore_errors']))
	{
		exit($error);
	}
}

$install_version = '0.8.1';

// Check to see if the script is already installed
if(isset($config['installed']))
{
	if($config['version'] == $install_version)
	{
		// Exit the script
		exit('PHPDug is already installed.');
	}
}

if($config['version'] < 0.6)
{
	exit('Upgrading is only available as of v0.6, you are running v'.$config['version']);
}

if(!isset($_GET['install']))
{
	echo 'Before you run an upgrade it is recomended that you backup your PHPDug database<br><Br>Are you sure you want to upgrade your PHPDug installation from '.$config['version'].' to '.$install_version.'?<br><br><a href="upgrade_0.8.php?install=1">Yes do it</a>';
}
else
{
	ignore_user_abort(1);

	echo '<pre>';
	
	// Start updating the config file with new variables
	echo "Writting config.php updates.. \t";
	// Content that will be written to the config file
	$content = "<?php\n";
	$content.= "\$config['db']['host'] = '".addslashes($config['db']['host'])."';\n";
	$content.= "\$config['db']['name'] = '".addslashes($config['db']['name'])."';\n";
	$content.= "\$config['db']['user'] = '".addslashes($config['db']['user'])."';\n";
	$content.= "\$config['db']['pass'] = '".addslashes($config['db']['pass'])."';\n";
	$content.= "\$config['db']['pre'] = '".addslashes($config['db']['pre'])."';\n";
	$content.= "\n";
	$content.= "\$config['site_title'] = '".addslashes(stripslashes($config['site_title']))."';\n";
	$content.= "\$config['site_url'] = '".addslashes(stripslashes($config['site_url']))."';\n";
	$content.= "\$config['site_path'] = '".addslashes(stripslashes($config['site_path']))."';\n";
	$content.= "\$config['admin_email'] = '".addslashes(stripslashes($config['admin_email']))."';\n";
	$content.= "\$config['upcomtime'] = '".addslashes(stripslashes($config['upcomtime']))."';\n";
	$content.= "\$config['usedigg'] = '".addslashes(stripslashes($config['usedigg']))."';\n";
	$content.= "\$config['vidthumb'] = '".addslashes(stripslashes($config['vidthumb']))."';\n";
	$content.= "\$config['mod_rewrite'] = '".addslashes(stripslashes($config['mod_rewrite']))."';\n";
	$content.= "\$config['anounce_en'] = '".addslashes(stripslashes($config['anounce_en']))."';\n";
	$content.= "\$config['anounce_txt'] = '".addslashes(stripslashes($config['anounce_txt']))."';\n";
	$content.= "\$config['safe'] = '".addslashes(stripslashes($config['safe']))."';\n";
	$content.= "\$config['security'] = '".addslashes(stripslashes($config['security']))."';\n";
	$content.= "\$config['rating_mode'] = '".addslashes(stripslashes($config['rating_mode']))."';\n";
	$content.= "\$config['rating_digs'] = '".addslashes(stripslashes($config['rating_digs']))."';\n";
	$content.= "\$config['rating_days'] = '".addslashes(stripslashes($config['rating_days']))."';\n";
	$content.= "\$config['cron_type'] = '".addslashes(stripslashes($config['cron_type']))."';\n";
	$content.= "\$config['cron_time'] = '".addslashes(stripslashes($config['cron_time']))."';\n";
	$content.= "\$config['search_type'] = '".addslashes(stripslashes($config['search_type']))."';\n";
	$content.= "\n";
	$content.= "\$config['cookie_time'] = '".addslashes(stripslashes($config['cookie_time']))."';\n";
	$content.= "\$config['cookie_name'] = '".addslashes(stripslashes($config['cookie_name']))."';\n";
	$content.= "\n";
	$content.= "\$config['email']['type'] = '".addslashes(stripslashes($config['email']['type']))."';\n";
	$content.= "\$config['email']['smtp']['host'] = '".addslashes(stripslashes($config['email']['smtp']['host']))."';\n";
	$content.= "\$config['email']['smtp']['user'] = '".addslashes(stripslashes($config['email']['smtp']['user']))."';\n";
	$content.= "\$config['email']['smtp']['pass'] = '".addslashes(stripslashes($config['email']['smtp']['pass']))."';\n";
	$content.= "\n";
	$content.= "\$config['tpl_name'] = '".addslashes(stripslashes($config['tpl_name']))."';\n";
	$content.= "\$config['version'] = '".addslashes(stripslashes($install_version))."';\n";
	$content.= "\$config['lang'] = '".addslashes(stripslashes($config['lang']))."';\n";
	$content.= "\$config['installed'] = '1';\n";
	$content.= "?>";
	
	// Open the includes/config.php for writting
	$handle = fopen('../includes/config.php', 'w');
	// Write the config file
	fwrite($handle, $content);
	// Close the file
	fclose($handle);
	echo "success<br>";
	
	echo "<br><Br><Br>Thank You! for upgrading PHPDug, Please <a href=\"../index.php\">click here</a> to access your site";

	echo '</pre>';
}
?>