<?php

require_once('includes/config.php');
require_once('includes/functions/func.global.php');
if($config['usedigg'])
{
	require_once('includes/functions/func.digg.php');
}
require_once('includes/classes/class.template_engine.php');
require_once('includes/lang/lang_'.$config['lang'].'.php');

// Start the session
session_start();

// Connect to the database
db_connect($config);

// Check if the user has a remember cookie set
checkremember($config);

// If no page is specified set to first page
if(!isset($_GET['page']))
{
	$_GET['page'] = 1;
}

if(!isset($_GET['q']))
{
	exit('No Search Query');
}

// Get site categories
$cats = get_cats($config);

// Check to see if digg.com mode is enabled
if($config['usedigg'])
{
	header("Location: index.php");
	exit;
}
else
{
	// Initiate stories array
	$stories = array();
	$avatars = array();
	
	$_GET['q'] = urldecode($_GET['q']);
	
	// Retreive stories from the database
	if($config['search_type'] == '0')
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time FROM ".$config['db']['pre']."stories WHERE story_title LIKE '%".addslashes($_GET['q'])."%' or story_desc LIKE '%".addslashes($_GET['q'])."%' ORDER BY story_rating ASC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	elseif($config['search_type'] == '1')
	{
		$query = "SELECT story_id,story_title,story_desc,story_cat,story_digs,story_url,story_comments,user_name,user_id,story_thumb,story_time, MATCH (story_title,story_desc) AGAINST ('+".addslashes($_GET['q'])."' IN BOOLEAN MODE) AS Relevance FROM ".$config['db']['pre']."stories WHERE MATCH (story_title,story_desc) AGAINST ('+".addslashes($_GET['q'])."' IN BOOLEAN MODE) HAVING Relevance > 0.2 ORDER BY Relevance DESC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	
	$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
	while ($info = @mysql_fetch_array($query_result))
	{
		$stories[$info['story_id']] = $info;
		$stories[$info['story_id']]['dugg'] = 0;
		$stories[$info['story_id']]['buried'] = 0;
		$stories[$info['story_id']]['cat_title'] = $cats[$info['story_cat']]['cat_title'];
		$stories[$info['story_id']]['cat_id'] = $info['story_cat'];
		$stories[$info['story_id']]['ago'] = time_taken((time()-$info['story_time']));
		$stories[$info['story_id']]['domain'] = getDomain($info['story_url']);
		
		$avatars[$info['user_id']] = $info['user_id'];
		
		if($config['mod_rewrite'] == 1)
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'stories/'.$info['story_id'].'/'.modrewriteurl($info['story_title']).'.html';
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'view/'.$info['story_cat'].'/'.modrewriteurl($cats[$info['story_cat']]['cat_title']).'/1.html';
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'users/'.$info['user_id'].'/'.$info['user_name'].'/1.html';
		}
		else
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'story.php?id='.$info['story_id'];
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'cat.php?i='.$info['story_cat'];
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'profile.php?id='.$info['user_id'];
		}
		
		// Construct where string for looking up digs
		if(!isset($_SESSION['dugg'][$info['story_id']]))
		{
			if(isset($story_where))
			{
				$story_where.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where = "story_id='".$info['story_id']."'";
			}
		}
		
		if(!isset($_SESSION['bury'][$info['story_id']]))
		{
			if(isset($story_where2))
			{
				$story_where2.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where2 = "story_id='".$info['story_id']."'";
			}
		}
	}
	
	$av_count = count($avatars);
	
	if($av_count > 0)
	{
		foreach ($avatars as $key => $info) 
		{
			if(isset($avatar_where))
			{
				$avatar_where.= " OR user_id='".$key."'";
			}
			else
			{
				$avatar_where = "user_id='".$key."'";
			}
		}
		$avatar_where.= "LIMIT ".$av_count;
		
		$query = "SELECT user_id,avatar FROM ".$config['db']['pre']."users WHERE ".$avatar_where;
		$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
		while ($info = @mysql_fetch_array($query_result))
		{
			$avatars[$info['user_id']] = getUserAvatar($info['user_id'],$config,false,$info['avatar']);
		}
	}
	
	// Get total number of stories in this category
	if($config['search_type'] == '0')
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_title LIKE '%".addslashes($_GET['q'])."%' or story_desc LIKE '%".addslashes($_GET['q'])."%'"));
	}
	elseif($config['search_type'] == '1')
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1, MATCH (story_title,story_desc) AGAINST ('+".addslashes($_GET['q'])."' IN BOOLEAN MODE) AS Relevance FROM ".$config['db']['pre']."stories WHERE MATCH (story_title,story_desc) AGAINST ('+".addslashes($_GET['q'])."' IN BOOLEAN MODE) HAVING Relevance > 0.2 ORDER BY Relevance DESC"));
	}
	
	// Check that user is logged in
	if(isset($_SESSION['duser']['id']))
	{
		// Check that there are stories to look for
		if(isset($story_where))
		{
			// Check for digs in the database
			$query = "SELECT story_id FROM ".$config['db']['pre']."digs WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(isset($story_where2))
		{
			if(isset($_SESSION['duser']['id']))
			{
				$query = "SELECT story_id FROM ".$config['db']['pre']."buries WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where2."))";
				$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
				while ($info = @mysql_fetch_array($query_result))
				{
					$stories[$info['story_id']]['buried'] = 1;
				}
			}
		}
	}

	// Check if user has dugg 
	foreach ($stories as $key => $info) 
	{
		if(!$stories[$info['story_id']]['dugg'])
		{
			if(isset($_SESSION['dugg'][$info['story_id']]))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(!$stories[$info['story_id']]['buried'])
		{
			if(isset($_SESSION['bury'][$info['story_id']]))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
		
		$stories[$info['story_id']]['avatar'] = $avatars[$info['user_id']];
	}
}

if($total[0])
{
	// Output info to cat.html template
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/search.html");
	$page->SetLoop ('CATS', $cats);
	$page->SetLoop ('STORIES', $stories);
	$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats,'Search'));
	$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
	if(isset($_SESSION['duser']['id']))
	{
		$page->SetParameter ('LOGGEDIN', 1);
	}
	else
	{
		$page->SetParameter ('LOGGEDIN', 0);
	}
	$page->SetLoop ('PAGES', pagenav($total[0],$_GET['page'],10,$config['site_url'].'search.php?q='.$_GET['q'],1));
	$page->CreatePageEcho($lang,$config);
}
else
{
	// Output info to cat.html template
	$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/search_noresults.html");
	$page->SetLoop ('CATS', $cats);
	$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats,'Search'));
	$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
	if(isset($_SESSION['duser']['id']))
	{
		$page->SetParameter ('LOGGEDIN', 1);
	}
	else
	{
		$page->SetParameter ('LOGGEDIN', 0);
	}
	$page->CreatePageEcho($lang,$config);
}
?>