<?php
require_once('includes/config.php');
require_once('includes/functions/func.global.php');
require_once('includes/classes/class.template_engine.php');
require_once('includes/lang/lang_'.$config['lang'].'.php');

// Start the session
session_start();

// Connect to the database
db_connect($config);

// Check if the user has a remember cookie set
checkremember($config);

// Get site categories
$cats = get_cats($config);

$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/spy.html");
$page->SetLoop ('CATS', $cats);
$page->SetParameter ('SITE_TITLE',$config['site_title']);
$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats));
$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
if(isset($_SESSION['duser']['id']))
{
	$page->SetParameter ('LOGGEDIN', 1);
}
else
{
	$page->SetParameter ('LOGGEDIN', 0);
}
$page->CreatePageEcho($lang,$config);
?>