<?php

require_once('includes/config.php');
require_once('includes/functions/func.global.php');
if($config['usedigg'])
{
	require_once('includes/functions/func.digg.php');
}
require_once('includes/classes/class.template_engine.php');
require_once('includes/lang/lang_'.$config['lang'].'.php');

// Connect to database
db_connect($config);

// Start session
session_start();

// Check if the user has a remember cookie set
checkremember($config);

// Check if a page is specified
if(!isset($_GET['page']))
{
	// Set page to 1 if no page specified
	$_GET['page'] = 1;
}
else
{
	// Make sure the page number is an integar
	$_GET['page'] = makeInt($_GET['page']);
}

// Check if they have given id instead of i
// Fix for older versions
if(isset($_GET['id']))
{
	$_GET['i'] = $_GET['id'];
}
elseif(isset($_GET['i']))
{
	$_GET['id'] = $_GET['i'];
}

// Get site categories
$cats = get_cats($config);

// Initiate arrays/vars
$stories = array();
$avatars = array();
$backtime = (time()-$config['upcomtime']);
$story_count = 0;

// Check if they have digg.com api mode enabled
if($config['usedigg'])
{
	// Get the stories from digg.com api
	$content = getdiggstories(0,$_GET['page'],'upcoming');
	$stories = $content['stories'];
	
	$total[0] = $content['total'];
	
	if($_GET['i'])
	{
		// Set the category title from the $cats array
		$cat_info['cat_title'] = $cats[$_GET['i']]['cat_title'];
	}
}
else
{
	// If an id is specified lookup those stories
	if($_GET['i'])
	{
		$query = "SELECT story_id,story_title,story_desc,story_digs,story_url,story_comments,user_id,user_name,story_thumb,story_time,story_cat FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['id'])."' AND story_time>".$backtime." ORDER BY story_time DESC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	// No id specified, lookup all upcoming stories
	else
	{
		$query = "SELECT story_id,story_title,story_desc,story_digs,story_url,story_comments,user_id,user_name,story_thumb,story_time,story_cat FROM ".$config['db']['pre']."stories WHERE story_time>".$backtime." ORDER BY story_time DESC LIMIT ".addslashes(($_GET['page']-1)*10).",10";
	}
	$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
	while ($info = @mysql_fetch_array($query_result))
	{
		$info['story_title'] = stripslashes($info['story_title']);
		$info['story_desc'] = stripslashes($info['story_desc']);
	
		$stories[$info['story_id']] = $info;
		$stories[$info['story_id']]['dugg'] = 0;
		$stories[$info['story_id']]['buried'] = 0;
		$stories[$info['story_id']]['cat_title'] = $cats[$info['story_cat']]['cat_title'];
		$stories[$info['story_id']]['cat_id'] = $info['story_cat'];
		$stories[$info['story_id']]['ago'] = time_taken((time()-$info['story_time']));
		$stories[$info['story_id']]['domain'] = getDomain($info['story_url']);
		
		$avatars[$info['user_id']] = $info['user_id'];
		
		if($config['mod_rewrite'] == 1)
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'stories/'.$info['story_id'].'/'.modrewriteurl($info['story_title']).'.html';
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'view/'.$info['story_cat'].'/'.modrewriteurl($cats[$info['story_cat']]['cat_title']).'/1.html';
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'users/'.$info['user_id'].'/'.$info['user_name'].'/1.html';
		}
		else
		{
			$stories[$info['story_id']]['story_link'] = $config['site_url'].'story.php?id='.$info['story_id'];
			$stories[$info['story_id']]['cat_link'] = $config['site_url'].'cat.php?id='.$info['story_cat'];
			$stories[$info['story_id']]['user_link'] = $config['site_url'].'profile.php?id='.$info['user_id'];
		}
		
		if(!isset($_SESSION['dugg'][$info['story_id']]))
		{
			if(isset($story_where))
			{
				$story_where.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where = "story_id='".$info['story_id']."'";
			}
		}
		
		if(!isset($_SESSION['bury'][$info['story_id']]))
		{
			if(isset($story_where2))
			{
				$story_where2.= " OR story_id='".$info['story_id']."'";
			}
			else
			{
				$story_where2 = "story_id='".$info['story_id']."'";
			}
		}
		
		$story_count++;
	}
	
	// Get how many users there are
	$av_count = count($avatars);
	
	// If there are any stories lookup avatars
	if($av_count > 0)
	{
		// Run through and create a where statement
		foreach ($avatars as $key => $info) 
		{
			if(isset($avatar_where))
			{
				$avatar_where.= " OR user_id='".$key."'";
			}
			else
			{
				$avatar_where = "user_id='".$key."'";
			}
		}
		$avatar_where.= "LIMIT ".$av_count;
		
		// Lookup users avatars
		$query = "SELECT user_id,avatar FROM ".$config['db']['pre']."users WHERE ".$avatar_where;
		$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
		while ($info = @mysql_fetch_array($query_result))
		{
			// Get correct path to avatar
			$avatars[$info['user_id']] = getUserAvatar($info['user_id'],$config,false,$info['avatar']);
		}
	}
	
	// Get page count
	if($_GET['i'])
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_cat='".addslashes($_GET['i'])."' AND story_time>".$backtime));
	}
	else
	{
		$total[0] = mysql_num_rows(mysql_query("SELECT 1 FROM ".$config['db']['pre']."stories WHERE story_time>".$backtime));
	}
	
	// Check that user is logged in
	if(isset($_SESSION['duser']['id']))
	{
		// Check that there are stories to look for
		if(isset($story_where))
		{
			// Check for digs in the database
			$query = "SELECT story_id FROM ".$config['db']['pre']."digs WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		// Check that there are buries to look for
		if(isset($story_where2))
		{
			// Check for buries in the database
			$query = "SELECT story_id FROM ".$config['db']['pre']."buries WHERE (user_id='".$_SESSION['duser']['id']."' AND (".$story_where2."))";
			$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
			while ($info = @mysql_fetch_array($query_result))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
	}
	
	// Check if user has dugg 
	foreach ($stories as $key => $info) 
	{
		if(!$stories[$info['story_id']]['dugg'])
		{
			if(isset($_SESSION['dugg'][$info['story_id']]))
			{
				$stories[$info['story_id']]['dugg'] = 1;
			}
		}
		
		if(!$stories[$info['story_id']]['buried'])
		{
			if(isset($_SESSION['bury'][$info['story_id']]))
			{
				$stories[$info['story_id']]['buried'] = 1;
			}
		}
		
		$stories[$info['story_id']]['avatar'] = $avatars[$info['user_id']];
	}
	
	$query = "SELECT cat_title FROM ".$config['db']['pre']."cats WHERE cat_id='".addslashes($_GET['i'])."' LIMIT 1";
	$query_result = @mysql_query ($query) OR error(mysql_error(), __LINE__, __FILE__, 0, '', '');
	$cat_info = @mysql_fetch_array($query_result);
}

// Check if they are looking at a category
if($_GET['i'])
{
	// Check that there are any stories to show
	if($total[0])
	{
		// Load Category Template
		$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/cat.html");
	}
	else
	{
		// Load empty category template
		$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/cat_noresults.html");
	}
	// Output category title
	$page->SetParameter ('CAT_TITLE',$cat_info['cat_title']);
	
	$cat_title = $cat_info['cat_title'];
}
else
{
	// Check that there are any stories to show
	if($total[0])
	{
		// Load index template
		$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/index.html");
	}
	else
	{
		// Load empty index template
		$page = new HtmlTemplate ("templates/" . $config['tpl_name'] . "/index_noresults.html");
	}
	// Set category name for mod_rewrite links
	$cat_info[0] = 'viewall';
	
	$cat_title = 'View All';
}
$page->SetParameter ('CAT_ID', $_GET['i']);
$page->SetParameter ('MODE','upcoming');
$page->SetLoop ('CATS', $cats);
$page->SetLoop ('STORIES', $stories);
if($config['mod_rewrite'])
{
	if($_GET['id'])
	{
		$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming/'.$_GET['id'].'/'.$cat_info[0].'/1.html');
		$page->SetParameter ('POPULAR_LINK',$config['site_url'].'view/'.$_GET['id'].'/'.$cat_info[0].'/1.html');
	}
	else
	{
		$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming/0/viewall/1.html');
		$page->SetParameter ('POPULAR_LINK',$config['site_url'].'viewall/1.html');
	}
}
else
{
	$page->SetParameter ('UPCOMING_LINK',$config['site_url'].'upcoming.php?id='.$_GET['id']);
	$page->SetParameter ('POPULAR_LINK',$config['site_url'].'index.php');
}
$page->SetParameter ('XML_URL', $config['site_url'].'xmlfeeds.php?cmd=upcoming&id='.$_GET['id']);
$page->SetParameter ('STORY_COUNT', $story_count);
$page->SetParameter ('OVERALL_HEADER', create_header($config,$lang,$cats,$cat_title));
$page->SetParameter ('OVERALL_FOOTER', create_footer($config,$lang));
// Output where the user is logged in or not
if(isset($_SESSION['duser']['id']))
{
	$page->SetParameter ('LOGGEDIN', 1);
}
else
{
	$page->SetParameter ('LOGGEDIN', 0);
}
// Check if mod_rewrite urls are turned on
if($config['mod_rewrite'])
{
	$page->SetLoop ('PAGES', pagenav2($total[0],$_GET['page'],10,'upcoming.php',1,$_GET['i'],$config,$cat_info[0]));
}
else
{
	$page->SetLoop ('PAGES', pagenav($total[0],$_GET['page'],10,'upcoming.php?i='.$_GET['i'],1));
}
// echo the template
$page->CreatePageEcho($lang,$config);
?>