﻿<?php
/**
 * @package WordPress
 * @subpackage On the Wall
 */

get_header();
?>
  <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

		<div class="post" id="post-<?php the_ID(); ?>">
			<h2  class="headline"><a href="<?php echo get_permalink($post->post_parent); ?>" rev="attachment"><?php echo get_the_title($post->post_parent); ?></a> &raquo; <?php the_title(); ?></h2>
            <h4 class="date"><?php the_time('j F, Y') ?></h4>
			<div class="entry">
				<p class="attachment"><a href="<?php echo wp_get_attachment_url($post->ID); ?>"><?php echo wp_get_attachment_image( $post->ID, 'medium' ); ?></a></p>
				<div class="caption"><?php if ( !empty($post->post_excerpt) ) the_excerpt(); // this is the "caption" ?></div>

				<?php the_content('<p class="serif">اقراء المزيد &raquo;</p>'); ?>

				<div class="navigation">
					<div class="alignleft"><?php previous_image_link() ?></div>
					<div class="alignright"><?php next_image_link() ?></div>
				</div>
				<br class="clear" />

				<p class="postmetadata alt">
					<small>
						هذا الموضوع كتب <?php the_time('l, j F, Y') ?> الساعة <?php the_time() ?>
						ويندرج تحت <?php the_category(', ') ?>.
						<?php the_taxonomies(); ?>
						يمكنك متابعة الردود على هذا الموضوع من خلال <?php post_comments_feed_link('الخلاصات'); ?> .

						<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Both Comments and Pings are open ?>
							تستطيع <a href="#respond">التعليق</a>, او <a href="<?php trackback_url(); ?>" rel="trackback">العودة</a> للبداية.

						<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Only Pings are Open ?>
							الردود حليآ مغلقة ولكن يمكنك <a href="<?php trackback_url(); ?> " rel="trackback">العودة</a> للبداية.

						<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Comments are open, Pings are not ?>
							يمكن الذهاب للتعليق مباشرة.

						<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Neither Comments, nor Pings are open ?>
							كل التعليقات حاليآ مغلقة.

						<?php } edit_post_link('تعديل.','',''); ?>

					</small>
				</p>

			</div>
            
            </div>

	<?php comments_template(); ?>

	<?php endwhile; else: ?>

		<p>عذرا ، لم تتطابق الملحقات معاييرك.</p>

<?php endif; ?>

<?php get_footer(); ?>
