<?php
// Get the user configuration
require config.php';

// Function to send a file to a particular email address
function email_file($file_to_send, $email_subject, $text_message) {
    global $to_email;
    global $from_email;
    global $reply_email;
    $file_type = filetype($file_to_send);
    // Read the file to be attached ('rb' = read binary)
    $file = fopen($file_to_send, 'rb');
    $data = fread($file, filesize($file_to_send));
    fclose($file);
    // base64 encode the file data
    $data = chunk_split(base64_encode($data));

    // Generate a MIME boundary string
    $mime_boundary = "<<<--==+X[" . md5(time()) . "]";

    // Create the headers
    $headers = "From: $from_email\n";
    $headers .= "Reply-To: $reply_email\n";
    $headers .= "To: $to_email\n";
    $headers .= "X-Mailer: Php/" . phpversion() . "\n";
    $headers .= "MIME-Version: 1.0\n";
    $headers .= "Content-Type: multipart/mixed;\n";
    $headers .= " boundary=\"" . $mime_boundary . "\"";
    
    // Start the multipart message
    $message = "This is a multi-part message in MIME format.\n\n";
    $message .= "--" . $mime_boundary . "\n";

    // Add the plain text part of the message
    $message .= "Content-Type: text/plain; charset=\"iso-8859-1\"\n";
    $message .= "Content-Transfer-Encoding: 7bit\n\n";
    $message .= "$text_message\n\n";
    $message .= "--" . $mime_boundary . "\n";
    
    // Add file attachment to the message
    $message .= "Content-Type: $file_type;\n";
    $message .= " name=\"$file_to_send\"\n";
    $message .= "Content-Disposition: attachment;\n";
    $message .= " filename=\"$file_to_send\"\n";
    $message .= "Content-Transfer-Encoding: base64\n\n";
    $message .= $data;
    $message .= "\n\n";
    $message .= "--" . $mime_boundary . "\n";

    // Send the message
    return mail($to_email, $email_subject, $message, $headers);
}

// Keep track of the files we're creating so we can put them in the tarball
// email them, and/or delete them if those options are selected
$sql_filenames = array();
// Iterate through the database names
foreach($dbnames as $value) {
    $date = date("mdy-hia");
    $sql_filename = "$value-$date.sql";
    $sql_filenames[] = $sql_filename;
    // passthru is used in place of shell_exec because we want the raw output
    // of the mysqldump to be redirected to the file $sql_filename
    passthru("mysqldump --opt -h$dbhost -u$dbuser -p$dbpass $value >$sql_filename");
}

// Should we create a tarball?
if($use_gzip) {
    $created = false;
    $tar_filename = "backup-" . $date . "_sql.tar";
    $gzip_filename = $tar_filename . ".gz";
    // Iterate through the sql filenames
    foreach($sql_filenames as $value) {	
	// If the archive has already been created, we apppend (-r option)
	// The current file to the archive.  Otherwise, we need to create
	// the archive.
	if($created) {
	    $zipline = "tar -rf $working_path/$tar_filename $value";
	} else {
	    $zipline = "tar -cf $working_path/$tar_filename $value";
	    $created = true;
	}
	shell_exec($zipline);
    } 
    exec("gzip -9 $working_path/$tar_filename");
}

$files_to_send = array();
if($use_gzip) {
    $files_to_send[] = "$gzip_filename";
} else {
    $files_to_send = $sql_filenames;
}

if($send_email) {
    foreach($files_to_send as $value) {
	if (($max_attachment > 0) && ((filesize("$working_path/$value") / 1024) > $max_attachment)) {
	    // Split the oversize attachment into smaller files and
	    // Email each of them individually
	    $splitline = sprintf("split -b %sk %s %s_",
		$max_attachment, $value, $value);
	    exec($splitline);

	    // Get a list of the sub-files to send via email
	    $pattern = $value . "_*";
	    $sub_files = array();
	    foreach(glob($pattern) as $current_file) {
		$sub_files[] = $current_file;
	    }
	    $current = 1;
	    $total = count($sub_files);
	    foreach($sub_files as $file) {
		$email_subject = "MySQL database backup: $value - $current of $total";
		$current++;
		$email_text = "See attached MySQL database file.\n";
		if($total > 1) {
		    $email_text = "To re-generate the original file, place all sub-files in the same directory and use the UNIX cat command\n";
		}
		$ok = email_file($file, $email_subject, $email_text);
		if($ok) {
		    exec("rm -rf $file");
		} else {
		    echo("Error sending file $file.\n");
		}
	    }
	} else {
	    $email_subject = "MySQL database backup: $value - 1 of 1";
	    $email_text = "See attached MySQL database file.";
	    $ok = email_file($value, $email_subject, $email_text);
	    if(!$ok) {
		echo("Error sending file $value.\n");
	    }
	}
    }
}

if($ftp_send) {
    if($use_gzip) {
	$mode = FTP_BINARY;
    } else {
	$mode = FTP_ASCII;
    }
    $ftp_id = ftp_connect($ftp_server);
    $login_result = ftp_login($ftp_id, $ftp_user, $ftp_password);
    if($login_result) {
	ftp_chdir($ftp_id, $ftp_path);
	foreach($files_to_send as $file) {
	    $current_filename = "$working_path/$file";
	    $uploaded = ftp_put($ftp_id, $file, $current_filename, $mode);
	    if(!$uploaded) {
		echo("Error uploading file $file to $ftp_server\n");
	    }
	}
	ftp_close($ftp_id);
    } else {
	echo("Error connecting to FTP server.  Check server name and credentials.\n");
    }
}

if($remove_sql_files)
{
    foreach($sql_filenames as $value) {
	exec("rm -rf $value");
    }
}

if($remove_gzip_file) {
    exec("rm -rf $gzip_filename");
}

?>