<?
	/*****  ServiceFootprint::get  ***************************************
	 *
	 *  $Id: get.php,v 1.5 2002/03/13 11:41:59 Exp $
	 *
	 ****************************************************************/

	if ( ISSET( $_OFFICE_GET_ServiceFootprint_LOADED ) == true )
		return ;

	$_OFFICE_GET_ServiceFootprint_LOADED = true ;
	$__MODULE_TRACE__         = $__MODULE_TRACE__ .
	                            "->ServiceFootprint::get" ;

	/*****

	   Internal Dependencies

	*****/
	include( "$DOCUMENT_ROOT/API/Users/get.php" ) ;

	/*****

	   Module Specifics

	*****/

	/*****

	   Module Functions

	*****/

	/*****  ServiceFootprint_get_AreAnyAdminOnline  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$deptid
	 *	$idle
	 *	$aspid
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	true ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Nate Lee				Dec 27, 2001
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_AreAnyAdminOnline( &$dbh,
								$deptid,
								$idle,
								$aspid )
	{
		if ( ( $idle == "" ) || ( $aspid == "" ) )
		{
			return false ;
		}

		// if $deptid is passed, then let's check ONLY admins of that department
		if ( $deptid )
			$query = "SELECT count(*) AS total FROM chat_admin, chatuserdeptlist WHERE chat_admin.userID = chatuserdeptlist.userID AND chatuserdeptlist.deptID = $deptid AND chat_admin.available_status = 1 AND chat_admin.last_active_time > $idle AND chat_admin.aspID = $aspid" ;
		else
			$query = "SELECT count(*) AS total FROM chat_admin WHERE available_status = 1 AND last_active_time > $idle AND aspID = $aspid" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			$data = database_mysql_fetchrow( $dbh ) ;
			return $data[total] ;
		}
		return false ;
	}

	/*****  ServiceFootprint_get_DayFootprint  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$ip
	 *	$begin
	 *	$end
	 *	$limit
	 *	$aspid
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	$footprints ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Nate Lee				Dec 27, 2001
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_DayFootprint( &$dbh,
								$ip,
								$begin,
								$end,
								$limit,
								$aspid )
	{
		if ( ( $begin == "" ) || ( $end == "" ) 
			|| ( $aspid == "" ) )
		{
			return false ;
		}

		if ( $ip )
			$ip_string = "ip = '$ip' AND" ;
		if ( $limit )
			$limit_string = "LIMIT $limit" ;

		$query = "SELECT url, count(*) AS total FROM chatfootprints WHERE $ip_string created > $begin AND created <= $end AND aspID = $aspid GROUP BY url ORDER BY total DESC $limit_string" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			while ( $data = database_mysql_fetchrow( $dbh ) )
			{
				$footprints[] = $data ;
			}
			return $footprints ;
		}
		return false ;
	}

	/*****  ServiceFootprint_get_TotalDayFootprint  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$begin
	 *	$end
	 *	$aspid
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	$total ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Nate Lee				Dec 27, 2001
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_TotalDayFootprint( &$dbh,
								$begin,
								$end,
								$aspid )
	{
		if ( ( $begin == "" ) || ( $end == "" ) 
			|| ( $aspid == "" ) )
		{
			return false ;
		}

		$query = "SELECT count(*) AS total FROM chatfootprints WHERE created > $begin AND created <= $end AND aspID = $aspid" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			$data = database_mysql_fetchrow( $dbh ) ;
			return $data[total] ;
		}
		return false ;
	}

	/*****  ServiceFootprint_get_TotalUniqueDayVisits  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$begin
	 *	$end
	 *	$aspid
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	$total ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Nate Lee				Dec 27, 2001
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_TotalUniqueDayVisits( &$dbh,
								$begin,
								$end,
								$aspid )
	{
		if ( ( $begin == "" ) || ( $end == "" )
			|| ( $aspid == "" ) )
		{
			return false ;
		}

		$query = "SELECT count(DISTINCT(ip)) AS total FROM chatfootprints WHERE created > $begin AND created <= $end AND aspID = $aspid" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			$data = database_mysql_fetchrow( $dbh ) ;
			return $data[total] ;
		}
		return false ;
	}

	/*****  ServiceFootprint_get_TotalUniqueURLDayVisits  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$begin
	 *	$end
	 *	$aspid
	 *	$url
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	$total ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Kyle Hicks				Feb 26, 2002
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_TotalUniqueURLDayVisits( &$dbh,
								$begin,
								$end,
								$aspid,
								$url )
	{
		if ( ( $begin == "" ) || ( $end == "" )
			|| ( $aspid == "" ) || ( $url == "" ) )
		{
			return false ;
		}

		$query = "SELECT count(DISTINCT(ip)) AS total FROM chatfootprints WHERE created > $begin AND created <= $end AND aspID = $aspid AND url = '$url'" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			$data = database_mysql_fetchrow( $dbh ) ;
			return $data[total] ;
		}
		return false ;
	}

	/*****  ServiceFootprint_get_BeforeDayFootprint  *********************
	 *
	 *  Parameters:
	 *	&$dbh
	 *		Database connection.
	 *	$ip
	 *	$begin
	 *	$limit
	 *	$aspid
	 *
	 *  Description:
	 *	[DESCRIPTION HERE]
	 *
	 *  Returns:
	 *	$footprints ( success )
	 *	false ( failure )
	 *
	 *  History:
	 *	Nate Lee				Dec 27, 2001
	 *
	 *****************************************************************/
	FUNCTION ServiceFootprint_get_BeforeDayFootprint( &$dbh,
								$ip,
								$begin,
								$limit,
								$aspid )
	{
		if ( ( $begin == "" ) || ( $aspid == "" ) )
		{
			return false ;
		}

		if ( $limit )
			$limit_string = "LIMIT $limit" ;

		$query = "SELECT url, count(*) AS total FROM chatfootprints WHERE ip = '$ip' AND created < $begin AND aspID = $aspid GROUP BY url ORDER BY total DESC $limit_string" ;
		database_mysql_query( $dbh, $query ) ;
		
		if ( $dbh[ 'ok' ] )
		{
			while ( $data = database_mysql_fetchrow( $dbh ) )
			{
				$footprints[] = $data ;
			}
			return $footprints ;
		}
		return false ;
	}
?>