<?
	/*******************************************************
	* PHP Live!
	*******************************************************/
	session_start() ;
	if ( !file_exists( "../web/$l/$l-conf-init.php" ) || !file_exists( "../web/conf-init.php" ) )
	{
		HEADER( "location: index.php" ) ;
		exit ;
	}
	include("../web/conf-init.php") ;
	include("../web/$l/$l-conf-init.php") ;
	include("$DOCUMENT_ROOT/system.php") ;
	include("$DOCUMENT_ROOT/lang_packs/$LANG_PACK.php") ;
	include("$DOCUMENT_ROOT/API/sql.php" ) ;
	include("$DOCUMENT_ROOT/API/Chat/Util.php" ) ;
	include("$DOCUMENT_ROOT/API/Chat/get.php") ;
	include("$DOCUMENT_ROOT/API/Chat/put.php") ;
	include("$DOCUMENT_ROOT/API/Chat/remove.php") ;
	include("$DOCUMENT_ROOT/API/Chat/update.php") ;
	include("$DOCUMENT_ROOT/API/Users/get.php") ;
	include("$DOCUMENT_ROOT/API/Users/update.php") ;
?>
<?
	// make sure they have access to this page
	// if admin session is set, then they have access
	if ( !$session_chat[$sid][admin_id] )
	{
		HEADER( "location: ../index.php" ) ;
		exit ;
	}

	// initialize

	$sound_file = "cellular.wav" ;

	// reset this to ZERO when they login so it starts the tracking of request process
	$session_chat[$sid][requests_reload] = 0 ;

	// we use $rand to prevent loading from cached pages
	mt_srand ((double) microtime() * 1000000);
	$rand = mt_rand() ;

	$focus_window = 0 ;	// flag to tell JavaScript to focus the window or not (1=yes, 0=no)
	$close_window = 0 ;
	$do_pull = 1 ;
	$do_countdown = 0 ;
	$admin = AdminUsers_get_UserInfo( $dbh, $session_chat[$sid][admin_id], $session_chat[$sid][aspID] ) ;

	// if there is a kill signal, then let's close this window
	if ( $admin[signal] == 9 )
	{
		// set the close window var, then put admin status back to normal
		$close_window = 1 ;
		// set the last activity time back so it is offline status instantly
		AdminUsers_update_LastActiveTime( $dbh, $admin[userID], time() - 60, $sid ) ;
		AdminUsers_update_Status( $dbh, $admin[userID], 0 ) ;
		AdminUsers_update_Signal( $dbh, $admin[userID], 0, $session_chat[$sid][aspID] ) ;
	}
	else if ( ( $admin[last_active_time] > $admin_idle ) && $start && ( $admin[session_sid] != $sid ) )
	{
		// go ahead and login if activity time has been idel.
		// why?  this prevents so multiple login at various places... only check when
		// $start variable is passed ($start = first loading of console)
		$error = "You are logged in at another location!" ;
		$do_pull = 0 ;
	}
	else if ( $start )
	{
		// the $start variable comes from the admin page.  it passes this variable
		// so the admin console (this) knows to update status to Active on
		// initial start of console.  make sure there is no error.
		AdminUsers_update_LastActiveTime( $dbh, $admin[userID], time(), $sid ) ;
		AdminUsers_update_Status( $dbh, $admin[userID], 1 ) ;
		AdminUsers_update_Signal( $dbh, $admin[userID], 0, $session_chat[$sid][aspID] ) ;
	}
?>
<?
	// functions
?>
<?
	// conditions

	if ( $action == "reject" )
	{
		$requestinfo = ServiceChat_get_ChatRequestInfo( $dbh, $requestid ) ;
		$sessioninfo = ServiceChat_get_ChatSessionInfo( $dbh, $sessionid ) ;

		// create a flag to indicate that it has been rejected
		$fp = fopen ("$DOCUMENT_ROOT/web/chatpolling/$sessionid.txt", "wb+") ;
		fclose( $fp ) ;
		// put a big number as new admin ID for now... it will be updated by visitor
		// pulling script phplive/pull/chat.php
		ServiceChat_update_TransferCall( $dbh, $requestid, 999999999, $requestinfo[deptID] ) ;
	}
	else if ( $action == "status" )
	{
		AdminUsers_update_Status( $dbh, $admin[userID], $status ) ;
		$session_chat[$sid][close_timer] = time() ;
	}
	else if ( $action == "kill" )
	{
		// in UNIX -9 is kill... so let's use 9 as kill signal
		AdminUsers_update_Signal( $dbh, $admin[userID], 9, $session_chat[$sid][aspID] ) ;
		$do_pull = 0 ;
		$do_countdown = 1 ;
	}

	// call admin again here just incase the status is set from above
	// action == "status"... so we want the latest admin information
	$admin = AdminUsers_get_UserInfo( $dbh, $admin[userID], $session_chat[$sid][aspID] ) ;

	// do chat request session adding so we know when to ring alarm
	if ( !$error )
	{
		$chat_requests = ServiceChat_get_UserChatRequests( $dbh, $admin[userID] ) ;
		$total_requests = count( $chat_requests ) ;
		if ( ( $total_requests != $session_chat[$sid][requests] ) && ( $total_requests > 0 ) )
			$focus_window = 1 ;
		$session_chat[$sid][requests] = $total_requests ;

		// set this to equal so it does not trigger the reload while calling the pull image
		$session_chat[$sid][requests_reload] = $session_chat[$sid][requests] ;
	}

	// check to see if status if offline and window has been idel for a while
	// .. if offline and idel, let's close it (just incase they left the window open)
	$time_to_close = time() - ( 60 * $admin[console_close_min] ) ;
	$minutes_left = round( ( $session_chat[$sid][close_timer] - $time_to_close )/60 ) ;
	if ( ( $admin[available_status] == 0 ) && ( $session_chat[$sid][close_timer] < $time_to_close ) )
		$close_window = 1 ;
?>
<html>
<head>
<html dir="rtl">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1256">
<title> Operator [ request monitor ] </title>
<link rel="Stylesheet" href="../css/base.css">

<script language="JavaScript">
<!--
	function do_countdown( counter )
	{
		document.form.ticker.value = counter ;
		if ( counter == 0 )
			location.href = "admin_requests.php?sid=<? echo $sid ?>&start=1&l=<? echo $l ?>&x=<? echo $x ?>&reload_tracker=1" ;
		--counter ;
		setTimeout("do_countdown("+counter+")",1000) ;
	}

	function do_focus()
	{
		if ( <? echo $focus_window ?> )
			parent.window.focus() ;
		if ( <? echo $close_window ?> )
			parent.window.close() ;
		else if ( <? echo $do_countdown ?> )
			do_countdown( <? echo $admin_idle_value ?> ) ;
		else if ( <? echo $do_pull ?> )
			parent.window.do_pull() ;

		<? if ( $reload_tracker ): ?>
			parent.window.admin_puller.location.href = "admin_puller.php?sid=<? echo $sid ?>&start=1&l=<? echo $l ?>&x=<? echo $x ?>" ;
		<? endif ; ?>
	}

	// if status is Offline (0), then let's refresh this window every minute to
	// activate auto close if left idle
	<? if ( $admin[available_status] == 0 ): ?>
	setTimeout("location.href='admin_requests.php?sid=<? echo $sid ?>&l=<? echo $l ?>&x=<? echo $x ?>'",60000) ;
	<? endif ; ?>

//-->
</script>

</head>
<body bgColor="#FFFFFF" text="#000000" link="#35356A" vlink="#35356A" alink="#35356A" marginheight="0" marginwidth="0" topmargin="0" leftmargin="2" OnLoad="do_focus()">
<?
	if ( file_exists( "../web/$l/$LOGO" ) && $LOGO )
		$logo = "../web/$l/$LOGO" ;
	else if ( file_exists( "../web/$LOGO_ASP" ) && $LOGO_ASP )
		$logo = "../web/$LOGO_ASP" ;
	else
		$logo = "../pics/phplive_logo.gif" ;
?>
<img src="<? echo $logo ?>">

<? if ( $error ): ?>
<table cellspacing=1 cellpadding=2 border=0 width="100%">
<tr>
	<td><span class="basetxt">
	<b><big><? echo $error ?></big></b>
	<p>
	To Kill the window at the other location, <a href="JavaScript:parent.window.do_kill()">Click Here</a>.
	<p>
	To cancel <a href="JavaScript:parent.window.close()">click here</a>.
	</span>
	</td>
</tr>
</table>

<? elseif ( $action == "kill" ): ?>
<table cellspacing=1 cellpadding=2 border=0 width="100%">
<tr>
	<td><span class="basetxt">
	<b><big>Sending kill command ...</big></b>
	<p>
	<form name="form">
	Please hold while sending kill command and closing remote console...<br>
	Re-logging in <input type="text" name="ticker" size=2 maxlength=3 disabled class="input"> second(s).
	<p>
	To cancel <a href="JavaScript:parent.window.close()">click here</a>.
	</form>
	</span>
	</td>
</tr>
</table>


<? else: ?>
<?
	// embed sound if new request
	if ( $focus_window )
		print "<EMBED src=\"../sounds/$sound_file\" width=0 height=0 autostart=true loop=false>" ;
?>
<font face="Tahoma">
<br>
<font color="#707070">
: <b><? echo $admin[name] ?></b> &nbsp;|&nbsp;
:
<?
	if ( $admin[available_status] == 1 )
		print "<font color=\"#0000FF\"><b></b></font>  [<a href=\"JavaScript:parent.window.update_status(0)\"> </a>] &nbsp; <span class=\"smalltxt\"><font color=\"#FF0000\">   . </font></span></font>" ;
	else
		print "<font color=\"#FF0000\"><b> </b></font> [<a href=\"JavaScript:parent.window.update_status(1)\"></a>]    $minutes_left " ;
?>
</font>
<br>
<table cellspacing=1 cellpadding=2 border=0 width="100%">
<tr bgColor="#000000">
	<td width="50"><font face="Tahoma"><font color="#FFFFFF"></td>
	<td width="100"><font face="Tahoma"><font color="#FFFFFF"></td>
	<td><font face="Tahoma"><font color="#FFFFFF"></td>
	<td width="40"><font face="Tahoma">&nbsp;</td>
</tr>
<?
	for ( $c = 0; $c < count( $chat_requests ); ++$c )
	{
		$request = $chat_requests[$c] ;
		$department = AdminUsers_get_DeptInfo( $dbh, $request[deptID], $session_chat[$sid][aspID] ) ;
		$question = stripslashes( $request[question] ) ;
		$date = date( "D m/d/y h:i", $request[created] ) ;

		$bgcolor = "#DDDDDD" ;
		if ( $c % 2 )
			$bgcolor = "#E6E6E6" ;

		print "
		<tr bgcolor=\"$bgcolor\">
			<td><span class=\"smalltxt\">$request[from_screen_name]</td>
			<td><span class=\"smalltxt\">$department[name]</td>
			<td><span class=\"smalltxt\">$question</td>
			<td nowrap><span class=\"smalltxt\">[<a href=\"JavaScript:parent.window.open_chat($request[requestID], $request[sessionID])\"></a>] - [<a href=\"JavaScript:parent.window.do_reject($request[requestID], $request[sessionID])\"></a>]</td>
		</tr>
		" ;
	}
?>
</table>
<? endif ; ?>


</body>
</html>
<?
	mysql_close( $dbh[con] ) ;
?>
