<?php

Class Page
{
    // Description for meta tag
    var $description = "Administer your e-cards with ease using sendcard's delightful administration interface";
    // Keywords for meta tag
    var $keywords = "administration, area, for, sendcard";
    // Title for title tag
    var $title;
    // Extra content to go in the <head>...</head> section
    var $head_content = '';
    // Template to be used
    var $template;
    
    // Keep track of if header and footer have been shown
    var $footer_shown = false;
    var $header_shown = false;
    
    function Page()
    {
        register_shutdown_function(array(&$this, 'showFooter'));
        return true;
    }
    
    /**
     *
     * @access public
     * @return void 
     */
    function addHeadContent($stuff)
    {
    	$this->head_content .= $stuff;
    }
    
    /**
     *
     * @access public
     * @return void 
     */
    function setDescription($description)
    {
        $this->description = $description;
    }
    
    /**
     *
     * @access public
     * @return void 
     */
    function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }
    
    /**
     *
     * @access public
     * @return void 
     */
    function setTemplate($template)
    {
        $this->template = $template;
    }
    
    
    function setTitle($title)
    {
        $this->title = $title;
    }

    function showHeader()
    {
        if ($this->header_shown === true) {
            return;
        }
        $this->header_shown = true;
?>
<html>
<head>
<title>sendcard Administration - <?php echo $this->title; ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<meta name="Description" content="<?php echo $this->description; ?>" />
<meta name="Keywords" content="<?php echo $this->keywords; ?>" />
<?php echo $this->head_content; ?> 
<link rel="stylesheet" type="text/css" href="<?php echo dirname($_SERVER['PHP_SELF']); ?>/style.css" />
</head>
<body bgcolor="#FFFFFF">
<?php
    } // End function showHeader()
    
    function showFooter()
    {
        global $Page_footer_shown;
        if ($Page_footer_shown === true) {
            exit();
        }
        $Page_footer_shown = true;
?>
</body>
</html>
<?php
    } // End function showFooter()
    
    
}
?>
