<?php
/**
 * Language file editing page
 * Currently only works with one language file, but will give you the option to select one...
 *
 * $Id: mod_language.php,v 1.6 2004/11/08 20:57:27 reywob Exp $
 */


include("prepend.php");
include(DOCROOT . 'sendcard_setup.php');
include(DOCROOT . "include/".$dbfile);
include(DOCROOT . "include/template.inc");
include(DOCROOT . 'functions.php');

$sc_language = isset($sc_language) ? $sc_language : 'en';
$current_lang = isset($_REQUEST['current_lang']) ? $_REQUEST['current_lang'] : $sc_language;
?>

<html>
<head>
<title>Langauge strings</title>
</head>
<body bgcolor="#FFFFFF">
<?php

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $current_lang = $_POST['current_lang'];
    unset($_POST['current_lang']);
    unset($_POST['submit']);
    $_POST['month_names'] = explode("\n", $_POST['month_names']);
    // Include the current language file and merge into this array - in case 
    // anyone's added extra strings
    include(DOCROOT . 'include/lang/' . $current_lang . '/sendcard.lang.php');
    array_to_file(array_merge($sc_lang, $_POST), 'sc_lang', DOCROOT . 'include/lang/' . $current_lang . '/sendcard.lang.php');

    echo('<h2 align="center">Settings updated.</h2>');
}

#print "Including " . DOCROOT . 'include/lang/' . $current_lang . '.php';
include(DOCROOT . 'include/lang/' . $current_lang . '/sendcard.lang.php');
stripslashes_array($sc_lang);

?> <!-- BEGIN content_block --> 
<form name="form1" id="form1" method="GET" action="mod_language.php">
Please select the language to edit:<br />
<select name="current_lang">
<?php
$files = read_directory(DOCROOT . 'include/lang');
for($i = 0, $j = count($files); $i < $j; $i++){
	if (is_dir(DOCROOT . 'include/lang/' . $files[$i])) {
	    print '<option value="' . $files[$i] . '"';
    	if ($files[$i] == $current_lang) {
    	    print ' selected="selected"';
    	}
		print '>' . $files[$i] . "</option>\n";
	}
} // for
?>
</select>
<input type="submit" name="submit" value="Go" />
</form>
<hr>
<form method="post" action="mod_language.php">
  <h2>Locale Settings</h2>
  <p>The locale of this language, in the format xy_AB, where xy is the two letter
    code defined in <a href="http://userpage.chemie.fu-berlin.de/diverse/doc/ISO_639.html" target="_blank">ISO
    639-1</a> and AB is the country/territory as defined in <a href="http://www.iso.ch/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1.html" target="_blank">ISO
    3166</a>. If this field is left blank, the default value for your server
    will be used instead:<br>
    <input name="locale" type="text" id="locale" value="<?php echo $sc_lang['locale']; ?>" size="10">
  </p>
<!--	<p>Please select your timezone.  This will affect the date shown in the 
	notification email, as it will be displayed formatted for this time zone (Not yet implemented):<br />
	<select name='timezone'>
<option value='-12'>(GMT - 12:00 hours) Enitwetok, Kwajalien</option>
<option value='-11'>(GMT - 11:00 hours) Midway Island, Samoa</option>
<option value='-10'>(GMT - 10:00 hours) Hawaii</option>
<option value='-9'>(GMT - 9:00 hours) Alaska</option>
<option value='-8'>(GMT - 8:00 hours) Pacific Time (US &amp; Canada)</option>
<option value='-7'>(GMT - 7:00 hours) Mountain Time (US &amp; Canada)</option>
<option value='-6'>(GMT - 6:00 hours) Central Time (US &amp; Canada), Mexico City</option>
<option value='-5'>(GMT - 5:00 hours) Eastern Time (US &amp; Canada), Bogota, Lima, Quito</option>
<option value='-4'>(GMT - 4:00 hours) Atlantic Time (Canada), Caracas, La Paz</option>
<option value='-3.5'>(GMT - 3:30 hours) Newfoundland</option>
<option value='-3'>(GMT - 3:00 hours) Brazil, Buenos Aires, Georgetown, Falkland Is.</option>
<option value='-2'>(GMT - 2:00 hours) Mid-Atlantic, Ascention Is., St Helena</option>
<option value='-1'>(GMT - 1:00 hours) Azores, Cape Verde Islands</option>
<option value='0' selected>(GMT) Casablanca, Dublin, Edinburgh, London, Lisbon, Monrovia</option>
<option value='1'>(GMT + 1:00 hours) Berlin, Brussels, Copenhagen, Madrid, Paris, Rome</option>
<option value='2'>(GMT + 2:00 hours) Kaliningrad, South Africa, Warsaw</option>
<option value='3'>(GMT + 3:00 hours) Baghdad, Riyadh, Moscow, Nairobi</option>
<option value='3.5'>(GMT + 3:30 hours) Tehran</option>
<option value='4'>(GMT + 4:00 hours) Adu Dhabi, Baku, Muscat, Tbilisi</option>
<option value='4.5'>(GMT + 4:30 hours) Kabul</option>
<option value='5'>(GMT + 5:00 hours) Ekaterinburg, Islamabad, Karachi, Tashkent</option>
<option value='5.5'>(GMT + 5:30 hours) Bombay, Calcutta, Madras, New Delhi</option>
<option value='6'>(GMT + 6:00 hours) Almaty, Colomba, Dhakra</option>
<option value='7'>(GMT + 7:00 hours) Bangkok, Hanoi, Jakarta</option>
<option value='8'>(GMT + 8:00 hours) Beijing, Hong Kong, Perth, Singapore, Taipei</option>
<option value='9'>(GMT + 9:00 hours) Osaka, Sapporo, Seoul, Tokyo, Yakutsk</option>
<option value='9.5'>(GMT + 9:30 hours) Adelaide, Darwin</option>
<option value='10'>(GMT + 10:00 hours) Melbourne, Papua New Guinea, Sydney, Vladivostok</option>
<option value='11'>(GMT + 11:00 hours) Magadan, New Caledonia, Solomon Islands</option>
<option value='12'>(GMT + 12:00 hours) Auckland, Wellington, Fiji, Marshall Island</option>
</select></p> -->
  <p>Date format to use in the email. Placeholders are described on the <a href="http://uk.php.net/manual/en/function.strftime.php" target="_blank">PHP.net</a>    site:<br>
    <input name="date_format" type="text" id="date_format" value="<?php echo $sc_lang['date_format']; ?>" size="25">
</p>
  <p>Month names, used in the &quot;Send at a later date&quot; box in form.tpl.
    Put one month name per line:<br>
    <textarea name="month_names" cols="40" rows="12" id="month_names"><?php echo implode("\n", $sc_lang['month_names']); ?></textarea>
</p>
  <p>&nbsp;</p>
  <h2>Language Strings  </h2>
  <p>Modify the messages given in the script:<br>
	These variables can be used: <br>
	[to] : Name of recipient<br>
	[to_email] : Recipient's email address<br>
	[from] : Name of sender<br>
	[from_email] : Sender's email address<br>
	[message] : The card's message <br>
	[date] : Date when the postcard was viewed<br>
	[card_id] : The id number of the card<br>
	[card_url] : The URL for the recipient to pick up the card.<br>
	[sender_card_url] : Put in the sender's card. Allows them to view the card 
	without sending notification to themselves.
	<br>
	[print_card_url] : Displays the card using the print.tpl template - ideal for printing</p>
  <p>Modify the email sent to the recipient:<br>
            subject:
            <input type="text" name="youhavecard_subject" value="<?php echo $sc_lang['youhavecard_subject']; ?>" size="70" class="inputs">
            <br>
	Message:<br>
            <textarea name="youhavecard" cols="60" rows="10" class="inputs"><?php echo $sc_lang['youhavecard']; ?></textarea>
  </p>
          <p>&nbsp;</p>
          <p>Modify the email sent to the sender when the card has been viewed:<br>
            subject:
            <input type="text" name="cardreceived_subject" value="<?php echo $sc_lang['cardreceived_subject']; ?>" size="70" class="inputs">
            <br>
            Message:<br>
            <textarea name="cardreceived" cols="60" rows="10" class="inputs"><?php echo $sc_lang['cardreceived']; ?></textarea>
          </p>
          <p>The message shown when the card has been sent:<br>
            <textarea name="thankyou" cols="70" class="inputs" wrap="VIRTUAL"><?php echo $sc_lang['thankyou']; ?></textarea>
          </p>
          
  <p>Message to appear at bottom of received card.
    <br>
    <textarea name="view_message" cols="70" rows="5" class="inputs"><?php echo $sc_lang['view_message']; ?></textarea>
  </p>
          
  <p>The message that appears if the card cannot be found<br>
    <textarea name="no_card_msg" cols="60" rows="4">
<?php echo $sc_lang['no_card_msg']; ?>
</textarea>
  </p>
          
  <p>The error message if one of the email addresses is wrong. The current message 
	looks like:</p>
  <p><table><?php echo $sc_lang['email_error']; ?></table><br>
	<textarea name="email_error" cols="60" rows="4">
<?php echo $sc_lang['email_error']; ?>
</textarea>

  <p>The label to appear on the submit button on the preview screen<br>
    <input type="text" name="send_button_label" value="<?php echo $sc_lang['send_button_label']; ?>">
  </p>

<p>If your site uses frames, so you want the link in the email to point to a page
that opens sendcard within the frameset, supply the page name here<br />
<input type="text" name="frame_file" value="<?php echo $sc_lang['frame_file']; ?>" /></p>

 <p> 
 		<input type="hidden" name="current_lang" value="<?php echo $current_lang; ?>">
    <input type="submit" name="submit" value="Save my settings" class="buttons">
    <br>
  </p>
</form>
    <!-- END content_block -->
</body>
</html>
