<?php
/*
 * This file contains functions that you, the user, may wish to modify.  They
 * have been put in a separate file so that when you upgrade sendcard you don't
 * have to make any modifications to the core files - much easier for you!
 * 
 */


function make_card_id($pw_length = 12)
{ 
	// set ASCII range for random character generation 
	$lower_ascii_bound = 50;          // "2" 
	$upper_ascii_bound = 122;       // "z" 
            
	// Exclude special characters and some confusing alphanumerics 
	// o,O,0,I,1,l 
	$notuse = array (58,59,60,61,62,63,64,73,79,91,92,93,94,95,96,108,111); 

	while ($i < $pw_length) { 
		//  mt_srand ((double)microtime() * 1000000); 
		// random limits within ASCII table 
		$randnum = mt_rand ($lower_ascii_bound, $upper_ascii_bound); 
		if (!in_array ($randnum, $notuse)) { 
			$password = $password . chr($randnum); 
			$i++; 
		} 
	} 
	return $password; 
} 
/*
  This function will make a less random id than the above, but is better to use
  if you have a box on the front page of your site for the people to enter the
  id in, as its strings are more memorable.
  
  Before using, remove the space in "* /" (just under @return) to make that 
  comment work.
*/
/**
 * make_card_id()
 * Creates a random ID for the card to a given length.
 * 
 * @param $length
 * @return $password string the id for the card.
 */
 /*
function make_card_id($length = 12)
{
	
	$vowels = array("a", "e", "i", "o", "u");
	$cons = array("b", "c", "d", "g", "h", "j", "k", "l", "m", "n", "p", "r", 
	"s", "t", "u", "v", "w", "tr", "cr", "br", "fr", "th", "dr", "ch", "ph", 
	"wr", "st", "sp", "sw", "pr", "sl", "cl");
	
	$num_vowels = count($vowels);
	$num_cons = count($cons);
	
	for($i = 0; $i < $length; $i++){
		$password .= $cons[mt_rand(0, $num_cons - 1)] . $vowels[mt_rand(0, $num_vowels - 1)];
	}
	
	return substr($password, 0, $length);
}
*/

/**
 * Placeholder function for eventual changes, which will allow you to embed
 * bbcode in the messages if you want it etc...
 * 
 * @access public
 * @return void 
 */
function format_message($msg)
{
	return $msg;
}


?>