<?php

/*===========================================================================================*\
|| ######################################################################################### ||
|| #                                                                                       # ||
|| # MySmilies vB 3.8.003 (for vBulletin v3.8.0 Gold and higher)                           # ||
|| #                                                                                       # ||
|| # Copyright (c) 2007 - 2009:                                                            # ||
|| # 	v3.8.x by: Eric Sizemore   (http://www.vbulletin.org/forum/member.php?u=142777)    # ||
|| # 	v3.7.x by: Mosh Shigdar    (http://www.vbulletin.org/forum/member.php?u=62814)     # ||
|| # 	v3.6.x by: Rigel Kentaurus (CemZoo.com)                                            # ||
|| #                                                                                       # ||
|| # For distribution in vBulletin.org only.                                               # ||
|| #                                                                                       # ||
|| # Info for hackers / developers:                                                        # ||
|| # 	You may modify, improve, upgrade, redistribute this hack, include it in another    # ||
|| # 	hack or yours or translate it provided you do it free of charge and you distribute # ||
|| # 	it in www.vbulletin.org at least, there is no need to pm asking for permission.    # ||
|| # 	Some portions of the code are (c) Jelsoft Enterprises Ltd.                         # ||
|| #                                                                                       # ||
|| ######################################################################################### ||
\*===========================================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'mysmiliesvb');
define('CSRF_PROTECTION', true);
define('CSRF_SKIP_LIST', '');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'user',
	'mysmiliesvb'
);

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'USERCP_SHELL',
	'mysmilies_main',
	'mysmilies_smilielistbit',
	'mysmilies_imagebit',
	'usercpmenu',
	'usercpnav',
	'usercp_nav_folderbit'
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/class_image.php');
require_once(DIR . '/includes/class_dm_mysmiliesvb.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
if (!$vbulletin->options['mysmiliesvb_option_masterswitch'])
{
	eval(standard_error(fetch_error('error_mysmiliesvb_disabled')));		
}

// we need a chmoded directory, if it is not writable, exit
if (!is_writable($vbulletin->options['mysmiliesvb_option_filepath']))
{
	eval(standard_error(fetch_error('error_mysmiliesvb_directory_not_writable', $vbulletin->options['mysmiliesvb_option_filepath'])));
}

// must be a logged in user to use this page
if (!$vbulletin->userinfo['userid'] OR !($permissions['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']))
{
	print_no_permission();
}

// user must have permissions
$vbulletin->userinfo['cansmilies'] = $permissions['mysmiliesvb_permissions'] & $vbulletin->bf_ugp['mysmiliesvb_permissions']['mysmiliesvb_cansmilies'];

if (!$vbulletin->userinfo['cansmilies'])
{
	eval(standard_error(fetch_error('error_mysmiliesvb_no_permission')));		
}

// the "do" variable is used in all the script, get it to global now
$vbulletin->input->clean_array_gpc('r', array(
	'do' => TYPE_STR
));

$do =& $vbulletin->GPC['do'];

if (empty($do))
{
	$do = 'main';
}

// #############################################################################
// delete a smilie prompt
if ($do == 'delete')
{
	$smilieid = $vbulletin->input->clean_gpc('r', 'id', TYPE_UINT);

	$smilie = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE mysmiliesvbid='$smilieid'
			AND userid='{$vbulletin->userinfo['userid']}'
	");

	if (!$smilie)
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_smilie_not_found')));
	}

	$smiliesurlbase = $vbulletin->options['mysmiliesvb_option_smiliesurl'];

	eval('$smilie[\'image\'] = "' . fetch_template('mysmilies_imagebit') . '";');
	eval('$HTML = "' . fetch_template('mysmilies_delete') . '";');

	$navbits = array(
		'mysmiliesvb.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['mysmiliesvb_navbits_name'],
		'' => $vbphrase['mysmiliesvb_deletesmilie']
	);
	$navbits = construct_navbits($navbits);
}

// #############################################################################
// really delete a smilie
if ($do == 'dodelete')
{
	$smilieid = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);

	$smilie = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE mysmiliesvbid='$smilieid'
			AND userid='{$vbulletin->userinfo['userid']}'
	");

	if (!$smilie)
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_smilie_not_found')));
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE mysmiliesvbid='$smilieid'
		LIMIT 1
	");

	if ($vbulletin->options['mysmiliesvb_option_harddelete'])
	{
		@unlink($vbulletin->options['mysmiliesvb_option_filepath'] . "/mysmilie_$smilieid.gif");
	}

	if ($vbulletin->options['mysmiliesvb_option_clearcache'])
	{
		$db->shutdown_query("
			DELETE FROM " . TABLE_PREFIX . "postparsed
			WHERE postid IN(
				SELECT postid
				FROM " . TABLE_PREFIX . "post
				WHERE userid='{$vbulletin->userinfo['userid']}'
			)
		");
	}

	$vbulletin->url = 'mysmiliesvb.php';
	eval(print_standard_redirect('mysmiliesvb_deleted', true, true));
}

// #############################################################################
// add a smilie
if ($do == 'doaddsmilie')
{
	$smilieurl = $vbulletin->input->clean_gpc('p', 'smilieurl', TYPE_STR);
	$smilietext = $vbulletin->input->clean_gpc('p', 'smilietext', TYPE_STR);
	$vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);

	// first error check, input
	if (!$vbulletin->GPC['upload']['name'] AND !$smilieurl)
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_please_enter_upload')));		
	}

	if (empty($smilietext))
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_please_enter_smilietext')));
	}

	if (strlen($smilietext) < $vbulletin->options['mysmiliesvb_option_minreplacechars'])
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_smilietext_atleast_nchars', $vbulletin->options['mysmiliesvb_option_minreplacechars'])));
	}

	// check for replacement text existence
	$smilieexists = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE userid='{$vbulletin->userinfo['userid']}'
			AND smilietext='" . $db->escape_string($smilietext) . "'
	");

	if ($smilieexists['mysmiliesvbid'])
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_smilietext_exists')));
	}

	// check for replacement text existence
	$smilieexists = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "smilie
		WHERE smilietext='" . $db->escape_string($smilietext) . "'
	");

	if ($smilieexists['smilieid'])
	{
		if (empty($smilieexists['title']))
		{
			$smilieexists['title'] = $smilieexists['smilietext'];
		}
		eval(standard_error(fetch_error('error_mysmiliesvb_smilietext_forum_exists', $smilieexists['title'])));
	}

	// check for max number of smilies exceeded
	$totalsmilies = $db->query_first("
		SELECT COUNT(*) totalsmilies, SUM(filesize) AS totalsize
		FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE userid='{$vbulletin->userinfo['userid']}'
	");

	if ($totalsmilies['totalsmilies'] >= $permissions['mysmiliesvb_totalsmilies'])
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_toomany_smilies', $permissions['mysmiliesvb_totalsmilies'])));
	}

	if ($totalsmilies['totalsize'] >= $permissions['mysmiliesvb_totalsize'])
	{
		eval(standard_error(fetch_error('error_mysmiliesvb_quota_exceeded', $permissions['mysmiliesvb_totalsize'])));
	}

	// do the upload
	$upload = new vB_Upload_MySmiliesVbImage($vbulletin);
	$upload->data =& datamanager_init('MySmiliesVbImage', $vbulletin, ERRTYPE_STANDARD, 'mysmiliesvb');
	$upload->userid = $vbulletin->userinfo['userid'];
	$upload->image =& vB_Image::fetch_library($vbulletin);
	$upload->maxwidth = $permissions['mysmiliesvb_maxwidth'];
	$upload->maxheight = $permissions['mysmiliesvb_maxheight'];
	$upload->maxuploadsize = $permissions['mysmiliesvb_maxsize'];
	$upload->allowanimation = true;
	$upload->smilietext = $smilietext;

	$smilietext_parsed = preg_quote($smilietext, '@');
	$upload->smilietext_parsed = $smilietext_parsed;

	if (!$upload->process_upload(($vbulletin->GPC['upload']['name'] != '' ? $vbulletin->GPC['upload'] : $smilieurl)))
	{
		eval(standard_error($upload->fetch_error()));
	}

	if ($vbulletin->options['mysmiliesvb_option_clearcache'])
	{
		$db->shutdown_query("
			DELETE FROM " . TABLE_PREFIX . "postparsed
			WHERE postid IN(
				SELECT postid
				FROM " . TABLE_PREFIX . "post
				WHERE userid='{$vbulletin->userinfo['userid']}'
			)
		");
	}

	// everything ok, jump to main
	$do = 'main';
}

// #############################################################################
// print the main screen with all the smilies
if ($do == 'main')
{
	// set flags for which MySmilies upload option(s) to display to the end user
	if ($vbulletin->options['mysmiliesvb_add_smilies_boxes'] == 1)
	{
		$show['mysmiliesvb_uploadbox'] = true;
		$show['mysmiliesvb_urlbox'] = false;
	}
	else if ($vbulletin->options['mysmiliesvb_add_smilies_boxes'] == 2)
	{
		$show['mysmiliesvb_uploadbox'] = false;
		$show['mysmiliesvb_urlbox'] = true;
	}
	else
	{
		$show['mysmiliesvb_uploadbox'] = true;
		$show['mysmiliesvb_urlbox'] = true;
	}

	$smiliesurlbase = $vbulletin->options['mysmiliesvb_option_smiliesurl'];
	$smilies = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "mysmiliesvb
		WHERE userid='{$vbulletin->userinfo['userid']}'
	");

	while ($smilie = $db->fetch_array($smilies))
	{
		$bgclass = ($bgclass == 'alt1') ? 'alt2' : 'alt1';
		eval('$smilie[\'image\'] = "' . fetch_template('mysmilies_imagebit') . '";');

		$smilie['filesize'] = vb_number_format($smilie['filesize']);
		eval('$smilielist .= "' . fetch_template('mysmilies_smilielistbit') . '";');
	}

	$show['smilielist'] = !empty($smilielist);
	eval('$HTML = "' . fetch_template('mysmilies_main') . '";');

	$navbits[''] = $vbphrase['mysmiliesvb_navbits_name'];
	$navbits = construct_navbits($navbits);
}

// #############################################################################
// spit out final HTML if we have got this far

// build the cp nav
construct_usercp_nav('mysmiliesvb');

// navbar & shell template
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('USERCP_SHELL') . '");');

?>