#################################################################
#       PicoStreamer 2.2                                        #
#       Input/Output library 1.1                                #
#       Vinz486 (c) 2006                                        #
#################################################################
$libio = 1;

# enable autoflush
$|=1;
use IO::Handle;
STDOUT->autoflush();

# for windows :-)
binmode(STDIN);
binmode(STDOUT);

# return this file ver
sub io_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# header sent?
$io_hsent = 0;

# CLength flag
$io_clen = 0;

#pre buffer
$io_prebuffer = 0;
$io_buffer = '';
$io_buffered = '';

#psamf data
$io_sync = 0;
$io_remainder = '';
$io_timestamp = 0;
$io_prevsize = 0;
$io_lastsize = 0;
$io_nexth = '';

sub mlog {
	
	open(MMM,">>log.log");
	print MMM $_[0];
	close(MMM);
}

# set Content-Length header
# [0] length
sub io_set_clen {
	
	&logger($T,"io_set_clen",$_[0]);
	$io_clen = $_[0];
}

sub io_amfsync {
	
	if($_[0] =~m/PsA/gs) {
		
		return substr($_[0],(pos($_[0]))-3);
		
	} else {

		return '';
	}
}



sub io_amfset {
	
	my $adat = $io_remainder.$_[0];
	
	$io_remainder = '';
	
	if($io_sync == 0) {
		
		if(length($adat) > 9) {
			
			my $sdat = &io_amfsync($adat);
			
			if(length($sdat) == 0) {
				
				$io_remainder .= $adat;
				return '';
				
			} else {

				$adat = $sdat;
				$io_sync = 1;
			}
		
		} else {
			
			$io_remainder .= $adat;
			return '';
		}

	}
	
	
	my $lp = '';
	while($adat =~m/PsA..(.).../gs) {
		
		my $tn = ord($1);
		
		if(($tn ne "8") && ($tn ne "9")) {
			
			#&logger($E,"io_amfset","Very unlucky packet");
			next;
		}

		$lp = pos($adat);
	}
	
	if($lp != '') {
			
		$io_remainder .= substr($adat,$lp);
		$adat = substr($adat,0,$lp);
		
	} else {
		
		$io_remainder .= $adat;
		return '';
	}
	
	my $fdat = '';	

	my $pmat = 0;
	my $onef = 0;

	while($adat =~m/PsA..(.).../gs) {
		
		my $tn = ord($1);
		
		if(($tn ne "8") && ($tn ne "9")) {
			
			&logger($E,"io_amfset","Very unlucky packet");
			next;
		}
		
		my $pt = pos($adat);

		my $bb = substr($adat,$pmat,$pt-$pmat-9);
		
		my $resync = 0;

		if($onef == 0) {
			

			$io_pcount = length($bb);
                              
			if($io_pcount != $io_lastsize) {
			
				&logger($D,"io_amfset","underrun","Exp: ".sprintf("%d",$io_lastsize)." Got: ".sprintf("%d",$io_pcount));

				$io_sync = 0;
				$io_lastsize = 0;
				$io_remainder = '';
				$io_nexth = '';

				return '';

			}
		}
		
		$fdat .= $io_nexth;

		$onef = 1;
		
			
		$fdat .= $bb;
		
		$pmat = $pt;
		
		$pt -= 6;
		
		my $toff = unpack("S",substr($adat,$pt,2));

		if($io_timestamp == 0) {
			
			$io_timestamp += $toff;
			$toff = 0;
			
		} else {
			
			$io_timestamp += $toff;
			$toff = $io_timestamp;
		}
		
		my $fl = substr($adat,$pt+2,1);
		
		my $nsize = pack("C",'\0').substr($adat,$pt+3,3);
		
		my $bsize = unpack("N",$nsize);
		$io_lastsize = $bsize;

		my $prv = pack("N",$io_prevsize);
		

		$io_nexth = $prv.$fl.substr(pack("N",$bsize),1).substr(pack("N",$toff),1)."\0\0\0\0";
		
		$io_prevsize = $bsize+11;
	
	}
	
	if($onef == 0) {
		
		$fdat.= $adat;
	
	}

	return $fdat;
}

# set file header
sub io_setheader {
	
	if($_[0] eq "application/x-psamf") {
			
		return pack("CCCCCCCCC",ord('F'),ord('L'),ord('V'),0x01,0x05,0x00,0x00,0x00,0x09);
	
	} else {
		
		return '';
	}	

}

# change ctype
sub io_ctype {

	if($_[0] eq "application/x-psamf") {
	
		return "video/x-flv";

	} else {
	
		return $_[0];
	}
}

# raw write to STDOUT
# [0] data
# return byte written
# undef on error
sub io_stdwrite {
	
	&logger($T,"io_stdwrite",length($_[0]));

	my $data = $_[0];
	
	my $pct = &ps_get_ctype();
	
	if($io_hsent == 0) {
		
		my $preheader = &io_setheader($pct);
				
		my $_info = &ps_get_info();
		
		if($reader_b_info ne "") {
			
			$_info = $reader_b_info;
		}
		
		syswrite(STDOUT, "Content-Type: " . &io_ctype($pct) . "\n");
				
		if($io_clen > 0) {		
			
			syswrite(STDOUT, "Content-Length: " . $io_clen . "\n");
		}
		
		syswrite(STDOUT, "Cache-Control: no-cache\n");
		syswrite(STDOUT, "Connection: close\n");
		syswrite(STDOUT, "Expires: Sat, 22 Apr 2000 22:22:22 GMT\n");
		syswrite(STDOUT, "icy-name:" . $_info . "\n");
		syswrite(STDOUT, "icy-genre:" . &ps_get_genre() . "\n");
		syswrite(STDOUT, "icy-url:http://" . $ENV{"HTTP_HOST"} . "\n");
		syswrite(STDOUT, "icy-pub:1\n");
		syswrite(STDOUT, "icy-br:" . &ps_get_bitrate() . "\n");	
		syswrite(STDOUT, "\n");
		
		if(length($preheader) > 0) {
			syswrite(STDOUT, $preheader);
		}
		
		$io_hsent = 1;
	}	
	
	if($pct eq "application/x-psamf") {
		
		my $samf = &io_amfset($data);
		
		if(length($samf) == 0) {
			
			return 2;
		}
		
		$data = $samf;
		
	}
	
	if($io_prebuffer > 0) {
		
		if(($io_buffered/1024) < $io_prebuffer) {
		
			$io_buffer .= $data;
			$io_buffered += length($data);
			return 2;
		
		} else {
			
			$data = $io_buffer.$data;
			$io_prebuffer = 0;
		}	
	}
	
	return syswrite(STDOUT, $data);
}

# raw read from STDIN
# [0] buffer], [1] length 
# return 0 or undef on eof
sub io_stdread {
	
	&logger($T,"io_stdread",$_[1]);
	return sysread(STDIN, $_[0], $_[1]);
}

# parse the query string
# and set %f with values
sub io_get_query { 
	
	&logger($T,"io_get_query");
	
	my @doubles = split(/&/, $ENV{'QUERY_STRING'});
	
	my $gkv;
	
	foreach $gkv (@doubles) {
		
		my ($gkey, $gvalue) = split(/=/, $gkv);
		
		$gkey =~ tr/+/ /;
		$gkey =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$gvalue =~ tr/+/ /;
		$gvalue =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		
		$f{$gkey} = $gvalue;
		
		&logger($T,"io_get_query",$gkey,$gvalue);
	
	}
}

# get a parameter from header or query string
# [0] param
# return param value
# or undef on not found
sub io_get_param {
	
	&logger($T,"io_get_param",$_[0]);
	
	# get the from header
	my $f_parm = $ENV{"HTTP_PICO_STREAMER_" . uc($_[0])}; 
	
	# otherwise from query string
	if($f_parm eq "") {
		
		&logger($T,"io_get_param","f",$f{$_[0]});
		return $f{$_[0]};
	
	} else {
		
		&logger($T,"io_get_param","HTTP_PICO_STREAMER_" . uc($_[0]),$f_parm);	
		return $f_parm;
	}
}

# print data and exit
# [0] message ([1] content-type)
sub io_printout {
	
	&logger($T,"io_printout");
	
	my $cotype = "text/html";
	
	if($_[1] ne "") {
	
		$cotype = $_[1];
	}
	
	print "Content-Type: " . $cotype . "\n\n";
	print  $_[0] . "\n";
	exit;
}

# print exit status and exit
# [0] errocode ([1] extended error)
sub io_err {

	&logger($T,"io_err",$_[0]);
	
	my $ec = $_[0];
	my $es = $c_errcode{$ec};
	
	if(!defined($es)) {
		
		$es = "UnknownError";
		$ec = "999";
	}
	
	my $exe = $_[1];
	
	if($exe ne "") {
		
		$exe .= "\n";
	}
	
	print "Content-Type: text/html\n\n" . $ec . " " . $es . "\n" . $exe;
	exit;
}

# get user and password from http headers
# or from GET params
sub io_get_user {

	&logger($T,"io_get_user");
	
	# get user and pass from header
	($f_user, $f_pass) = split(/:/,$ENV{"HTTP_PICO_STREAMER_ID"}); 

	# otherwise from GET
	if($f_user eq "") {
	
		$f_user = $f{'user'};
		$f_pass = $f{'pass'};
		
	}
}

1;
