#################################################################
#	PicoStreamer 2.0                                        	#
#	Logging library 1.0                                         #
#	Vinz486 (c) 2004	                                		#
#################################################################
$liblog = 1;

$E = 0; # error 
$W = 1; # warning
$I = 2; # info
$D = 3; # detail
$T = 4; # trace

$loglevel = $I;

$strl[$E] = "E";
$strl[$W] = "W";
$strl[$I] = "I";
$strl[$D] = "D";
$strl[$T] = "T";

$numl{"E"} = $E;
$numl{"W"} = $W;
$numl{"I"} = $I;
$numl{"D"} = $D;
$numl{"T"} = $T;

# return this file ver
sub log_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

$c_loglevel = uc($c_loglevel);

if($c_loglevel ne "") {

	if($numl{$c_loglevel} ne "") {
		
		$loglevel = $numl{$c_loglevel};
	}
}

$back = 0;

# set log level
# [0] new level
sub log_set_level {
	
	if($_[0] ne "") {
		
		if($strl[$_[0]] ne "") {
			
			$loglevel = $_[0];
		}
	}
}

# return loglevel
sub log_get_level {
	
	return $loglevel;
}

# log a line
# [0] loglevel, [1] text, ([2] param1, [3] param2)
sub logger {
	
	# avoid re-entrant calls
	if($back == 1) {return;}
	
	$back = 1;
	
	my $lsep = "|";
	
	if(($_[0] eq "") || ($_[1] eq "")) {
		
		$back = 0;
		return;
	}
	
	my $msg = $_[1];
	my $p1  = $_[2];
	my $p2  = $_[3];
	
	$msg =~s/\|//g;
	$p1  =~s/\|//g;
	$p2  =~s/\|//g;
	
	$p1 = &ut_strip_carriage($p1);
	$p2 = &ut_strip_carriage($p2);
	
	if($loglevel >= $_[0]) {
		
		my $own = "unknow";

		if($source == 1) {
			
			$own = "source";
		}
		
		if($reader == 1) {
			
			$own = "reader";
		}
		
		if($relay == 1) {
			
			$own = "relay";
		}
		
		if($ypages == 1) {
			
			$own = "ypages";
		}
		
		if(!(open(LG, ">>" . $ps_logfile))) { $back = 0; return; }
		&ut_lokf(LG);
		
		my $ltm = time();
		my $line = &log_pad(scalar localtime($ltm), 24) . $lsep . &log_pad($ltm,10) . $lsep . &log_pad($ENV{'REMOTE_ADDR'}.":".$ENV{'REMOTE_PORT'},21) . $lsep . $strl[$loglevel].$strl[$_[0]] . $lsep . &log_pad($own,6) . $lsep . &log_pad($$,5) . $lsep . $msg . $lsep . $p1 . $lsep . $p2 . $lsep . $ENV{'HTTP_USER_AGENT'} . "\n";
		print LG $line;
		
		&ut_unlokf(LG);
		close(LG);
	
	}
	
	$back = 0;
}

# pad to fix length
# [0] string, [1] padlen
sub log_pad {
	
	if(length($_[0]) > $_[1]) {
		
		return substr($_[0],0,$_[1]);
	
	} else {
		
		return $_[0] . (" " x ($_[1] - length($_[0])));
	}
}

1;