#################################################################
#	PicoStreamer 2.0                                        	#
#	Yellow Pages library 1.0                                    #
#	Vinz486 (c) 2004	                                		#
#################################################################
$libyp = 1;


# return this file ver
sub yp_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# fork a yp process    
sub yp_start {
	
	&ut_install_sig('CHLD','IGNORE');
	&ut_install_sig('CLD','IGNORE');
	
	if (!defined($pid = fork())) {

		&logger($E,"yp","cannot_fork",$!);
		return 0;
	
	} elsif ($pid == 0) {
		
		&yp_child();
		exit;
		
	} else {
		
		return 1;
	}
}

sub yp_child {
	
	$source = 0;
	$ypages = 1;

	&ut_timer_clear();
	
	&ut_remove_sig('QUIT');
	&ut_remove_sig('TERM');
	&ut_remove_sig('PIPE');

	&udp_close($u_sock);
	
	close(STDIN);
	open(STDIN, "/dev/null");
	
	close(STDOUT);
	open(STDOUT, ">/dev/null");
	
	close(STDERR);
	open(STDERR, ">/dev/null");
	
	
	my $yec = &yp_run();
	
	if($yec ne "") {
	
		&logger($E,"yp_run","error",$yec);
	
	} else {
	
		&logger($I,"yp_run","ok");
	
	}
	
	exit;
}

# # # # # # # #
# CHILD code  #
# # # # # # # #
 
sub yp_run {
	
	use MIME::Base64;
	
	$yp_host = decode_base64($c_yp_host);
	$yp_api = decode_base64($c_yp_api);

	&logger($D,"yp connecting",$yp_host);
	
	$YSO = &tcp_connect($yp_host,80);
	
	if($YSO eq "") {
		
		return "no_connection";
	}
	
	print $YSO &yp_header($yp_host,$yp_api."?host=".&ut_url_encode(&ut_this_host())."&user=".&ut_url_encode($f_user)."&rhost=".&ut_url_encode($s_relay_host)."&ruser=".&ut_url_encode($s_relay_user)."&cgi=".&ut_url_encode($c_cgi_name)) or return "io_error";
	
	&yp_skip_head($YSO);	
	
	my $yre = <$YSO>;
	
	&tcp_close($YSO);
	
	if($yre =~m/^OK/i) {
		
		return "";
	}
	
	return $yre;
}

sub yp_skip_head {
	
	
	my $lv = 0;
	my $han = $_[0];
	
	while($lv == 0) {
		
		my $line = <$han>;
		
		$line = &ut_strip_carriage($line);
		
		if($line eq "") {
			
			$lv = 1;
		}
	}
	
	return;
}

sub yp_header {
	
	my $rhead;
	
		$rhead  = "GET " . $_[1] . " HTTP/1.0\n";
		$rhead .= "Host: " . $_[0] . "\n";
		$rhead .= "Connection: close\n\n";
    
    return $rhead;
}

1;