<?php

function validate() {
		
	global $L,$C;
	
	$ret['n'] = "";
	$ret['e'] = "";
	
	//username
	if($_REQUEST['nuser'] == "") {
				
		$ret["n"] = "nuser";
		$ret["e"] = $L['noempty'];
	
		return $ret;
	}
	
	if(strlen($_REQUEST['nuser']) < $C['username_min']) {
				
		$ret["n"] = "nuser";
		$ret["e"] = $L['vshort']. " (min ".$C['username_min'].")";
	
		return $ret;
	}
	
	if(strlen($_REQUEST['nuser']) > $C['username_max']) {
				
		$ret["n"] = "nuser";
		$ret["e"] = $L['vlong']. " (max ".$C['username_max'].")";
	
		return $ret;
	}
	
	$usr = strtoupper($_REQUEST['nuser']);
	$match = "/^([A-Z0-9]|\.|\_|\-)+$/";
	
	if(!preg_match($match,$usr)) {
		
		$ret["n"] = "nuser";
		$ret["e"] = $L['cinvalid'];
	
		return $ret;
	}
	
	//password
	if($_REQUEST['npass'] == "") {
				
		$ret["n"] = "npass";
		$ret["e"] = $L['noempty'];
	
		return $ret;
	}
	
	if(strlen($_REQUEST['npass']) < $C['password_min']) {
				
		$ret["n"] = "npass";
		$ret["e"] = $L['vshort'] . " (min ".$C['password_min'].")";
	
		return $ret;
	}
	
	//maxusers
	if(($_REQUEST['maxusers']*1) == 0) {
	
		$ret["n"] = "maxusers";
		$ret["e"] = $L['only_num'];
	
	}
	
	//info
	if(strlen($_REQUEST['info']) > $C['info_max']) {
				
		$ret["n"] = "info";
		$ret["e"] = $L['vlong'] . " (max ".$C['info_max'].")";
	
		return $ret;
	}
	
	//genre
	if(strlen($_REQUEST['genre']) > $C['genre_max']) {
				
		$ret["n"] = "genre";
		$ret["e"] = $L['vlong'] . " (max ".$C['genre_max'].")";
	
		return $ret;
	}
	
	return $ret;
}

function create() {

	global $L;

	if(!file_exists("./users/".$_REQUEST['nuser'])) {	
		
		if(!@mkdir("./users/".$_REQUEST['nuser'],0777)) {
		
			return $L['werror']."<br>".$L['whelp'];		
		}
	}
	
	if(!@chmod("./users/".$_REQUEST['nuser'],0777)) {
		
		return $L['werror']."<br>".$L['whelp'];		
	}
	
	if(!file_exists("./users/".$_REQUEST['nuser']."/ports")) {	
		
		if(!@mkdir("./users/".$_REQUEST['nuser']."/ports",0777)) {
		
			return $L['werror']."<br>".$L['whelp'];		
		}
	}
	
	if(!@chmod("./users/".$_REQUEST['nuser']."/ports",0777)) {
		
		return $L['werror']."<br>".$L['whelp'];		
	}
	
	if(!$fd = @fopen("./users/".$_REQUEST['nuser']."/desc.txt","w")) {
		
		return $L['werror']."<br>".$L['whelp'];		
	}
	
	if(fputs($fd,"password=".$_REQUEST['npass']."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"maxusers=".$_REQUEST['maxusers']."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"bitrate=32\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"ctype=audio/mpeg\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"info=".$_REQUEST['info']."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"desc=".$_REQUEST['desc']."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"genre=".$_REQUEST['genre']."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"public=1\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"intro=0\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"banner=0\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"rhost=norelay\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($fd,"ruser=norelay\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	$ar = "0";
	if($_REQUEST['arelay'] == "yes") {
		$ar = "1";
	}
	
	if(fputs($fd,"arelay=".$ar."\n") == -1) {
		
		fclose($fd);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	fclose($fd);
	
	if(!@chmod("./users/".$_REQUEST['nuser']."/desc.txt",0666)) {
		
		return $L['werror']."<br>".$L['whelp'];		
	}
	
	if(!$fp = @fopen("./users/".$_REQUEST['nuser']."/peak.txt","w")) {
	
		return $L['werror']."<br>".$L['whelp'];		
		
	}
	
	if(fputs($fp,"0\n".time()."\n") == -1) {
		
		fclose($fp);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	fclose($fp);
	
	if(!@chmod("./users/".$_REQUEST['nuser']."/peak.txt",0666)) {
		
		return $L['werror']."<br>".$L['whelp'];		
	}
	
}

function rollback() {
	
	@unlink("./users/".$_REQUEST['nuser']."/desc.txt");
	@unlink("./users/".$_REQUEST['nuser']."/peak.txt");
	@rmdir("./users/".$_REQUEST['nuser']."/ports");
	@rmdir("./users/".$_REQUEST['nuser']);
	
}

function main() {
	
	global $L,$C;
	
	$err = "";
	$msg = "";
	$out = "";
	
	if($_REQUEST['save'] != "") {
		
		$vv = validate();
		
		if($vv['e'] != "") {
			
			$err = $L['einf']." \"<b>".$L[$vv['n']]."</b>\"<br>&nbsp;<br>".$vv['e'].": ".$_REQUEST[$vv['n']];
		
		} else {
		
			$users = listusers();
		
			if(in_array($_REQUEST['nuser'],$users)) {
		
				$err = $_REQUEST['nuser']." ".$L['exists'];
		
			} else {
				
				$err = create();
				
				if($err == "") {
					
					$msg = $_REQUEST['nuser']." ".$L['created'];
				
				} else {
					
					rollback();
				}
			}
		}
	}

	
	if($msg != "") {
	
		$out = "<span style=\"color: green\">".$msg."</span>";
	
	}
	
	if($err != "") {
		
		$out = "<span style=\"color: red\">".$err."</span>";
	}
	
	
?>	
<form action="<?php echo getme(); ?>" method="post">
<?php frame_start("80%","","center"); echo $out."<br>&nbsp;<br>"; ?>
<table border="0" cellpadding="8" cellspacing="0" align="center" width="100%">

<!-- user name -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['nuser']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="30" name="nuser" value=""></td>
<td valign="middle" class="help" width="50%"><?php echo $L['nuser_help']; ?></td></tr>

<!-- password -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['npass']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="30" name="npass" value=""></td>
<td valign="middle" class="help" width="50%"><?php echo $L['npass_help']; ?></td></tr>

<!-- desc -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['desc']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="30" name="desc" value=""></td>
<td valign="middle" class="help" width="50%"><?php echo $L['desc_help']; ?></td></tr>

<!-- maxusers -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['maxusers']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="3" name="maxusers" value="32"></td>
<td valign="middle" class="help" width="50%"><?php echo $L['maxusers_help']; ?></td></tr>

<!-- info -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['uinfo']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="30" name="info" value="PicoStreamer powered radio!"></td>
<td valign="middle" class="help" width="50%"><?php echo $L['uinfo_help']; ?></td></tr>

<!-- genre -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['genre']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%"><input type="text" size="30" name="genre" value="Various"></td>
<td valign="middle" class="help" width="50%"><?php echo $L['genre_help']; ?></td></tr>

<!-- allow relay -->
<tr><td valign="middle" align="right" width="50%" class="settings"><?php echo $L['arelay']; ?>&nbsp;</td>
<td valign="middle" align="center" class="settings" width="0%">
<input type="checkbox" name="arelay" value="yes" checked="yes"></td>
<td valign="middle" class="help" width="50%"><?php echo $L['arelay_help']; ?></td></tr>

<tr><td colspan="3" align="right" class="save"><input type="submit" name="save" value="<?php echo $L['create']; ?>"></td></tr>
</table>
<?php frame_end(); ?>
</form>

<?php
}

function get_title() {
	
	global $L;
	
	return $L['newuser_title'];
}

?>

